/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import netP5.NetAddress;
import oscP5.OscMessage;
import oscP5.OscP5;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PVector;
import processing.data.IntList;
import processing.data.Table;
import processing.data.TableRow;
import processing.sound.SoundFile;

public class LDQR_Monitoring_noCache
extends PApplet {
    OscP5 oscP5;
    NetAddress myRemoteLocation;
    int hallPage1;
    int hallPage2;
    int hallPage3;
    int hallPage4;
    int hallPage5;
    int hallPage6;
    int[] hallArray = new int[6];
    int[] page1OSC = new int[16];
    int[] page2OSC = new int[4];
    int[] page2OSC_computed = new int[2];
    int[] page3OSC = new int[4];
    int[] page3OSC_computed = new int[2];
    int[] page4OSC = new int[3];
    int[] page5OSC = new int[3];
    int[] page6OSC = new int[13];
    int[] page6OSC_computed = new int[42];
    int[] Page6_rows = new int[7];
    int[] Page6_cols = new int[6];
    PFont f;
    final int LINEAR = 0;
    final int QUADRATIC = 1;
    final int CUBIC = 2;
    final int QUARTIC = 3;
    final int QUINTIC = 4;
    final int SINUSOIDAL = 5;
    final int EXPONENTIAL = 6;
    final int CIRCULAR = 7;
    final int SQRT = 8;
    final int EASE_IN = 0;
    final int EASE_OUT = 1;
    final int EASE_IN_OUT = 2;
    int state = 0;
    Page1 page1;
    Page2 page2;
    Page3 page3;
    Page4 page4;
    Page5 page5;
    Page6 page6;
    int lastPageChange;
    int recordStart;
    boolean hideOSC = false;
    boolean listenHallEffect = true;
    boolean record = false;
    boolean lastRecordState = false;
    Table table;
    File fileMy = new File("record.csv");

    public void setup() {
        this.oscP5 = new OscP5((Object)this, 12000);
        this.hallPage1 = 3;
        this.hallPage2 = 3;
        this.hallPage3 = 3;
        this.hallPage4 = 3;
        this.hallPage5 = 3;
        this.hallPage6 = 3;
        this.f = this.createFont("SourceCodePro-Regular.ttf", 12.0f);
        this.textFont(this.f);
        this.background(255.0f, 248.0f, 196.0f);
        this.page1 = new Page1(this);
        this.page2 = new Page2(this);
        this.page3 = new Page3(this);
        this.page4 = new Page4(this);
        this.page5 = new Page5(this);
        this.page6 = new Page6(this);
        this.table = new Table();
        this.table.addColumn("time");
        this.table.addColumn("page");
        this.table.addColumn("sensor");
    }

    public void drawOSC() {
        this.textAlign(37);
        this.stroke(255);
        this.fill(this.fillHall(this.hallPage1));
        this.rect(20.0f, 20.0f, 10.0f, 10.0f);
        this.fill(this.fillHall(this.hallPage2));
        this.rect(40.0f, 20.0f, 10.0f, 10.0f);
        this.fill(this.fillHall(this.hallPage3));
        this.rect(60.0f, 20.0f, 10.0f, 10.0f);
        this.fill(this.fillHall(this.hallPage4));
        this.rect(80.0f, 20.0f, 10.0f, 10.0f);
        this.fill(this.fillHall(this.hallPage5));
        this.rect(100.0f, 20.0f, 10.0f, 10.0f);
        this.fill(this.fillHall(this.hallPage6));
        this.rect(120.0f, 20.0f, 10.0f, 10.0f);
        this.fill(255);
        this.text("Capteurs effet hall", 140.0f, 30.0f);
        String sensorsPage1 = "";
        int i = 0;
        while (i < this.page1OSC.length) {
            sensorsPage1 = String.valueOf(sensorsPage1) + this.page1OSC[i];
            sensorsPage1 = String.valueOf(sensorsPage1) + " ";
            ++i;
        }
        this.text("Page 1: " + sensorsPage1, 20.0f, 60.0f);
        String sensorsPage2 = "";
        int i2 = 0;
        while (i2 < this.page2OSC.length) {
            sensorsPage2 = String.valueOf(sensorsPage2) + this.page2OSC[i2];
            sensorsPage2 = String.valueOf(sensorsPage2) + " ";
            ++i2;
        }
        this.text("Page 2: " + sensorsPage2, 20.0f, 90.0f);
        String sensorsPage3 = "";
        int i3 = 0;
        while (i3 < this.page3OSC.length) {
            sensorsPage3 = String.valueOf(sensorsPage3) + this.page3OSC[i3];
            sensorsPage3 = String.valueOf(sensorsPage3) + " ";
            ++i3;
        }
        this.text("Page 3: " + sensorsPage3, 20.0f, 120.0f);
        String sensorsPage4 = "";
        int i4 = 0;
        while (i4 < this.page4OSC.length) {
            sensorsPage4 = String.valueOf(sensorsPage4) + this.page4OSC[i4];
            sensorsPage4 = String.valueOf(sensorsPage4) + " ";
            ++i4;
        }
        this.text("Page 4: " + sensorsPage4, 20.0f, 150.0f);
        String sensorsPage5 = "";
        int i5 = 0;
        while (i5 < this.page5OSC.length) {
            sensorsPage5 = String.valueOf(sensorsPage5) + this.page5OSC[i5];
            sensorsPage5 = String.valueOf(sensorsPage5) + " ";
            ++i5;
        }
        this.text("Page 5: " + sensorsPage5, 20.0f, 180.0f);
        String sensorsPage6 = "";
        int i6 = 0;
        while (i6 < this.page6OSC.length) {
            sensorsPage6 = String.valueOf(sensorsPage6) + this.page6OSC[i6];
            sensorsPage6 = String.valueOf(sensorsPage6) + " ";
            ++i6;
        }
        this.text("Page 6: " + sensorsPage6, 20.0f, 210.0f);
        this.text("---------------------------", 20.0f, 240.0f);
        this.text("[H] pour afficher / masquer", 20.0f, 270.0f);
    }

    public void drawText() {
        this.fill(0);
        this.noStroke();
        this.rect(10.0f, 320.0f, this.width - 20, 310.0f);
        this.textAlign(37);
        this.fill(255);
        this.text("-------------------------------------------------------", 20.0f, 330.0f);
        this.text("Les Doigts qui r\u00eavent - Kapi Capitaine - v0.1 - 03/2021", 20.0f, 360.0f);
        this.text("-------------------------------------------------------", 20.0f, 390.0f);
        this.text("Pour lier le livre \u00e0 l'application, connecter l'ordinateur", 20.0f, 410.0f);
        this.text("au r\u00e9seau KAPI_WIFI avec le mot de passe KAPI_WIFI.", 20.0f, 440.0f);
        this.text("Branchez les enceintes \u00e0 l'ordinateur et activez le son.", 20.0f, 470.0f);
        this.text("Les \u00e9v\u00e9nements du livre peuvent \u00eatre d\u00e9clench\u00e9s en parall\u00e8le avec la souris en survolant ", 20.0f, 500.0f);
        this.text("les zones interactives \u00e0 l'\u00e9cran.", 20.0f, 530.0f);
        this.text(" ", 20.0f, 560.0f);
        this.text("[C] Activer/d\u00e9sactiver la naivigation dans les pages (avec les touches de [1] \u00e0 [6]", 20.0f, 590.0f);
        this.text("[R] Enregistrer les \u00e9v\u00e9nements dans un tableau en CSV.", 20.0f, 620.0f);
    }

    public void draw() {
        this.background(50);
        if (this.listenHallEffect) {
            int numHallEffects = 0;
            int i = 0;
            while (i < 6) {
                numHallEffects += this.hallArray[i];
                ++i;
            }
            if (numHallEffects == 1) {
                i = 0;
                while (i < 6) {
                    if (this.hallArray[i] == 1) {
                        this.state = (i + 1) * 10;
                    }
                    ++i;
                }
            }
        }
        switch (this.state) {
            case 0: {
                this.drawText();
                break;
            }
            case 10: {
                this.page1.draw(false);
                this.page2.draw(true);
                this.page3.draw(true);
                this.page4.draw(true);
                this.page5.draw(true);
                this.page6.draw(true);
                break;
            }
            case 20: {
                this.page1.draw(true);
                this.page2.draw(false);
                this.page3.draw(true);
                this.page4.draw(true);
                this.page5.draw(true);
                this.page6.draw(true);
                break;
            }
            case 30: {
                this.page1.draw(true);
                this.page2.draw(true);
                this.page3.draw(false);
                this.page4.draw(true);
                this.page5.draw(true);
                this.page6.draw(true);
                break;
            }
            case 40: {
                this.page1.draw(true);
                this.page2.draw(true);
                this.page3.draw(true);
                this.page4.draw(false);
                this.page5.draw(true);
                this.page6.draw(true);
                break;
            }
            case 50: {
                this.page1.draw(true);
                this.page2.draw(true);
                this.page3.draw(true);
                this.page4.draw(true);
                this.page5.draw(false);
                this.page6.draw(true);
                break;
            }
            case 60: {
                this.page1.draw(true);
                this.page2.draw(true);
                this.page3.draw(true);
                this.page4.draw(true);
                this.page5.draw(true);
                this.page6.draw(false);
            }
        }
        if (!this.hideOSC) {
            this.drawOSC();
        }
        this.fill(255);
        this.textAlign(37);
        if (this.listenHallEffect) {
            this.text("[ D\u00e9tection de la page ouverte du livre ] [C]   Navigation manuelle, touches [1] \u00e0 [6]  ", 20.0f, this.height - 20);
        } else {
            this.text("  D\u00e9tection de la page ouverte du livre   [C] [ Navigation manuelle, touches [1] \u00e0 [6] ]", 20.0f, this.height - 20);
        }
        if (!this.record) {
            this.fill(0);
            this.rect(20.0f, this.height - 65, 20.0f, 20.0f);
            this.fill(255);
            this.text("[R] - Pour commencer l'enregistrement", 50.0f, this.height - 50);
        } else {
            this.fill(255.0f, 0.0f, 0.0f);
            this.rect(20.0f, this.height - 65, 20.0f, 20.0f);
            this.fill(255);
            this.text("[R] - Pour stopper l'enregistrement", 50.0f, this.height - 50);
        }
    }

    public void keyPressed() {
        this.lastPageChange = this.millis();
        if (!this.listenHallEffect) {
            switch (PApplet.parseInt((char)this.key) - 48) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 10;
                    break;
                }
                case 2: {
                    this.state = 20;
                    break;
                }
                case 3: {
                    this.state = 30;
                    break;
                }
                case 4: {
                    this.state = 40;
                    break;
                }
                case 5: {
                    this.state = 50;
                    break;
                }
                case 6: {
                    this.state = 60;
                }
            }
        }
        if (this.key == 'h' || this.key == 'H') {
            boolean bl = this.hideOSC = !this.hideOSC;
        }
        if (this.key == 'c' || this.key == 'C') {
            boolean bl = this.listenHallEffect = !this.listenHallEffect;
        }
        if (this.key == 'r' || this.key == 'R') {
            if (!this.record) {
                this.record = true;
                this.recordStart = this.millis();
                this.lastRecordState = true;
            } else if (this.record) {
                this.record = false;
                this.lastRecordState = true;
            }
            if (this.lastRecordState && !this.record) {
                this.selectOutput("Select a file to write to:", "fileSelected", this.fileMy);
            }
        }
    }

    public void fileSelected(File selection) {
        if (selection != null) {
            this.saveTable(this.table, selection.getAbsolutePath());
        }
    }

    public int fillHall(int hallState) {
        int theColor = 0;
        switch (hallState) {
            case 0: {
                theColor = 255;
                break;
            }
            case 1: {
                theColor = 125;
                break;
            }
            default: {
                theColor = 0;
            }
        }
        return theColor;
    }

    public void oscEvent(OscMessage theOscMessage) {
        if (theOscMessage.checkAddrPattern("/page1")) {
            this.hallArray[0] = this.hallPage1 = theOscMessage.get(0).intValue();
            int i = 0;
            while (i < this.page1OSC.length) {
                this.page1OSC[i] = theOscMessage.get(i + 1).intValue();
                ++i;
            }
            return;
        }
        if (theOscMessage.checkAddrPattern("/page2")) {
            int i = 0;
            while (i < this.page2OSC.length) {
                this.page2OSC[i] = theOscMessage.get(i + 1).intValue();
                ++i;
            }
            this.page2OSC_computed[0] = LDQR_Monitoring_noCache.min((int)this.page2OSC[0], (int)this.page2OSC[1]);
            this.page2OSC_computed[1] = LDQR_Monitoring_noCache.min((int)this.page2OSC[2], (int)this.page2OSC[3]);
            this.hallArray[1] = this.hallPage2 = theOscMessage.get(0).intValue();
            return;
        }
        if (theOscMessage.checkAddrPattern("/page3")) {
            this.hallArray[2] = this.hallPage3 = theOscMessage.get(0).intValue();
            int i = 0;
            while (i < this.page3OSC.length) {
                this.page3OSC[i] = theOscMessage.get(i + 1).intValue();
                ++i;
            }
            this.page3OSC_computed[0] = LDQR_Monitoring_noCache.max((int)this.page3OSC[1], (int)this.page3OSC[2]);
            this.page3OSC_computed[1] = LDQR_Monitoring_noCache.max((int)this.page3OSC[0], (int)this.page3OSC[3]);
            return;
        }
        if (theOscMessage.checkAddrPattern("/page4")) {
            this.hallArray[3] = this.hallPage4 = theOscMessage.get(0).intValue();
            int i = 0;
            while (i < this.page4OSC.length) {
                this.page4OSC[i] = theOscMessage.get(i + 1).intValue();
                ++i;
            }
            return;
        }
        if (theOscMessage.checkAddrPattern("/page5")) {
            this.hallArray[4] = this.hallPage5 = theOscMessage.get(0).intValue();
            int i = 0;
            while (i < this.page5OSC.length) {
                this.page5OSC[i] = theOscMessage.get(i + 1).intValue();
                ++i;
            }
            return;
        }
        if (theOscMessage.checkAddrPattern("/page6")) {
            this.hallArray[5] = this.hallPage6 = theOscMessage.get(0).intValue();
            int i = 0;
            while (i < this.page6OSC.length) {
                this.page6OSC[i] = theOscMessage.get(i + 1).intValue();
                if (i < 7) {
                    this.Page6_rows[i] = this.page6OSC[i];
                } else {
                    this.Page6_cols[i - 7] = this.page6OSC[i];
                }
                ++i;
            }
            i = 0;
            while (i < this.Page6_cols.length) {
                int j = 0;
                while (j < this.Page6_rows.length) {
                    this.page6OSC_computed[i + j * this.Page6_cols.length] = LDQR_Monitoring_noCache.min((int)this.Page6_cols[i], (int)this.Page6_rows[j]);
                    ++j;
                }
                ++i;
            }
            return;
        }
    }

    public float map2(float value, float start1, float stop1, float start2, float stop2, int type, int when) {
        float b = start2;
        float c = stop2 - start2;
        float t = value - start1;
        float d = stop1 - start1;
        float p = 0.5f;
        switch (type) {
            case 0: {
                return c * t / d + b;
            }
            case 8: {
                if (when == 0) {
                    return c * LDQR_Monitoring_noCache.pow((float)(t /= d), (float)p) + b;
                }
                if (when == 1) {
                    return c * (1.0f - LDQR_Monitoring_noCache.pow((float)(1.0f - (t /= d)), (float)p)) + b;
                }
                if (when != 2) break;
                if ((t /= d / 2.0f) < 1.0f) {
                    return c / 2.0f * LDQR_Monitoring_noCache.pow((float)t, (float)p) + b;
                }
                return c / 2.0f * (2.0f - LDQR_Monitoring_noCache.pow((float)(2.0f - t), (float)p)) + b;
            }
            case 1: {
                if (when == 0) {
                    return c * (t /= d) * t + b;
                }
                if (when == 1) {
                    return -c * (t /= d) * (t - 2.0f) + b;
                }
                if (when != 2) break;
                if ((t /= d / 2.0f) < 1.0f) {
                    return c / 2.0f * t * t + b;
                }
                return -c / 2.0f * ((t -= 1.0f) * (t - 2.0f) - 1.0f) + b;
            }
            case 2: {
                if (when == 0) {
                    return c * (t /= d) * t * t + b;
                }
                if (when == 1) {
                    t /= d;
                    return c * ((t -= 1.0f) * t * t + 1.0f) + b;
                }
                if (when != 2) break;
                if ((t /= d / 2.0f) < 1.0f) {
                    return c / 2.0f * t * t * t + b;
                }
                return c / 2.0f * ((t -= 2.0f) * t * t + 2.0f) + b;
            }
            case 3: {
                if (when == 0) {
                    return c * (t /= d) * t * t * t + b;
                }
                if (when == 1) {
                    t /= d;
                    return -c * ((t -= 1.0f) * t * t * t - 1.0f) + b;
                }
                if (when != 2) break;
                if ((t /= d / 2.0f) < 1.0f) {
                    return c / 2.0f * t * t * t * t + b;
                }
                return -c / 2.0f * ((t -= 2.0f) * t * t * t - 2.0f) + b;
            }
            case 4: {
                if (when == 0) {
                    return c * (t /= d) * t * t * t * t + b;
                }
                if (when == 1) {
                    t /= d;
                    return c * ((t -= 1.0f) * t * t * t * t + 1.0f) + b;
                }
                if (when != 2) break;
                if ((t /= d / 2.0f) < 1.0f) {
                    return c / 2.0f * t * t * t * t * t + b;
                }
                return c / 2.0f * ((t -= 2.0f) * t * t * t * t + 2.0f) + b;
            }
            case 5: {
                if (when == 0) {
                    return -c * LDQR_Monitoring_noCache.cos((float)(t / d * 1.5707964f)) + c + b;
                }
                if (when == 1) {
                    return c * LDQR_Monitoring_noCache.sin((float)(t / d * 1.5707964f)) + b;
                }
                if (when != 2) break;
                return -c / 2.0f * (LDQR_Monitoring_noCache.cos((float)((float)Math.PI * t / d)) - 1.0f) + b;
            }
            case 6: {
                if (when == 0) {
                    return c * LDQR_Monitoring_noCache.pow((float)2.0f, (float)(10.0f * (t / d - 1.0f))) + b;
                }
                if (when == 1) {
                    return c * (-LDQR_Monitoring_noCache.pow((float)2.0f, (float)(-10.0f * t / d)) + 1.0f) + b;
                }
                if (when != 2) break;
                if ((t /= d / 2.0f) < 1.0f) {
                    return c / 2.0f * LDQR_Monitoring_noCache.pow((float)2.0f, (float)(10.0f * (t - 1.0f))) + b;
                }
                return c / 2.0f * (-LDQR_Monitoring_noCache.pow((float)2.0f, (float)(-10.0f * (t -= 1.0f))) + 2.0f) + b;
            }
            case 7: {
                if (when == 0) {
                    return -c * (LDQR_Monitoring_noCache.sqrt((float)(1.0f - (t /= d) * t)) - 1.0f) + b;
                }
                if (when == 1) {
                    t /= d;
                    return c * LDQR_Monitoring_noCache.sqrt((float)(1.0f - (t -= 1.0f) * t)) + b;
                }
                if (when != 2) break;
                if ((t /= d / 2.0f) < 1.0f) {
                    return -c / 2.0f * (LDQR_Monitoring_noCache.sqrt((float)(1.0f - t * t)) - 1.0f) + b;
                }
                return c / 2.0f * (LDQR_Monitoring_noCache.sqrt((float)(1.0f - (t -= 2.0f) * t)) + 1.0f) + b;
            }
        }
        return 0.0f;
    }

    public float map3(float value, float start1, float stop1, float start2, float stop2, float v, int when) {
        float b = start2;
        float c = stop2 - start2;
        float t = value - start1;
        float d = stop1 - start1;
        float p = v;
        float out = 0.0f;
        if (when == 0) {
            out = c * LDQR_Monitoring_noCache.pow((float)(t /= d), (float)p) + b;
        } else if (when == 1) {
            out = c * (1.0f - LDQR_Monitoring_noCache.pow((float)(1.0f - (t /= d)), (float)p)) + b;
        } else if (when == 2) {
            if ((t /= d / 2.0f) < 1.0f) {
                return c / 2.0f * LDQR_Monitoring_noCache.pow((float)t, (float)p) + b;
            }
            out = c / 2.0f * (2.0f - LDQR_Monitoring_noCache.pow((float)(2.0f - t), (float)p)) + b;
        }
        return out;
    }

    public void settings() {
        this.size(800, 800);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#4D4B4B", "--stop-color=#cccccc", "LDQR_Monitoring_noCache"};
        if (passedArgs != null) {
            PApplet.main((String[])LDQR_Monitoring_noCache.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Page1 {
        Square[] squares = new Square[16];
        SoundFile loop1;
        SoundFile loop2;
        SoundFile[] sun;
        SoundFile[] birds;
        int numsounds_sun = 3;
        int numsounds_birds = 10;
        IntList birds_Order;
        int indexSun = 0;
        int indexBirds = 0;
        float volLoop1 = 0.0f;
        float volLoop2 = 0.0f;
        float objLoop1 = 0.0f;
        float objLoop2 = 0.0f;
        float mappedVol1 = 0.0f;
        float nextTimer = 0.0f;
        float lastUpdate = 0.0f;
        int scoreTouched;
        int lastScoreTouched;
        int lastMove = 0;
        int delta = 1000;
        int fadein_timer = 1000;
        int fadeout_timer = 1000;
        boolean fadeIn = false;
        boolean moving = false;
        boolean sunPressed = false;
        int numSoundsPlaying = 0;
        boolean quit = false;

        Page1(PApplet p) {
            float r = LDQR_Monitoring_noCache.this.width / 3;
            int numDots = 15;
            float theta = (float)Math.PI * 2 / (float)numDots;
            int widthDots = 120;
            int i = 0;
            while (i < 15) {
                float myTheta = (float)i * theta;
                float x = r * LDQR_Monitoring_noCache.cos((float)myTheta) + (float)(LDQR_Monitoring_noCache.this.width / 2);
                float y = r * LDQR_Monitoring_noCache.sin((float)myTheta) + (float)(LDQR_Monitoring_noCache.this.height / 2);
                this.squares[i] = new Square(x - (float)(widthDots / 2), y - (float)(widthDots / 2), widthDots, i + 1, LDQR_Monitoring_noCache.this.page1OSC, i, 1, 1);
                ++i;
            }
            this.squares[15] = new Square(LDQR_Monitoring_noCache.this.width / 2 - 40, LDQR_Monitoring_noCache.this.height / 2 - 40, 80.0f, 16, LDQR_Monitoring_noCache.this.page1OSC, 15, 1, 1);
            this.loop1 = new SoundFile(p, "P1/Planche01_Boucle Riviere.wav");
            this.loop2 = new SoundFile(p, "P1/PLANCHE01_Boucle Gigales.wav");
            this.sun = new SoundFile[this.numsounds_sun];
            this.sun[0] = new SoundFile(p, "P1/SOLEIL/SOLEIL1(4824).wav", false);
            this.sun[1] = new SoundFile(p, "P1/SOLEIL/SOLEIL2(4824).wav", false);
            this.sun[2] = new SoundFile(p, "P1/SOLEIL/SOLEIL3(4824).wav", false);
            this.birds = new SoundFile[this.numsounds_birds];
            this.birds[0] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle01.wav", false);
            this.birds[1] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle02.wav", false);
            this.birds[2] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle03.wav", false);
            this.birds[3] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle04.wav", false);
            this.birds[4] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette01.wav", false);
            this.birds[5] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette02.wav", false);
            this.birds[6] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette03.wav", false);
            this.birds[7] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol02.wav", false);
            this.birds[8] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol03.wav", false);
            this.birds[9] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol04.wav", false);
            this.birds_Order = new IntList();
            i = 0;
            while (i < this.numsounds_birds) {
                this.birds_Order.append(i);
                ++i;
            }
            this.birds_Order.shuffle();
            this.startSoundFiles();
        }

        public void draw(boolean _quit) {
            this.quit = _quit;
            if (!this.quit) {
                this.scoreTouched = 0;
                int i = 0;
                while (i < this.squares.length - 1) {
                    this.squares[i].draw();
                    if (this.squares[i].checkMouseOver() != 0) {
                        this.scoreTouched += this.squares[i].checkMouseOver();
                    }
                    ++i;
                }
                this.squares[15].draw();
                this.numSoundsPlaying = 0;
                i = 0;
                while (i < this.numsounds_sun) {
                    if (this.sun[i].isPlaying()) {
                        ++this.numSoundsPlaying;
                    }
                    ++i;
                }
                int j = 0;
                while (j < this.numsounds_birds) {
                    if (this.birds[j].isPlaying()) {
                        ++this.numSoundsPlaying;
                    }
                    ++j;
                }
                if (this.squares[15].checkMouseOver() == 16 && !this.sunPressed) {
                    this.sunPressed = true;
                    this.playSunSound();
                } else if (this.squares[15].checkMouseOver() == 0 && this.sunPressed) {
                    this.sunPressed = false;
                }
                if (this.lastScoreTouched != this.scoreTouched && this.scoreTouched > 0) {
                    this.fadeIn = true;
                    this.lastMove = LDQR_Monitoring_noCache.this.millis();
                    this.moving = true;
                    if ((float)LDQR_Monitoring_noCache.this.millis() > this.nextTimer) {
                        this.lastUpdate = LDQR_Monitoring_noCache.this.millis();
                        this.nextTimer = LDQR_Monitoring_noCache.this.millis() + this.fadein_timer;
                    }
                }
                if (LDQR_Monitoring_noCache.this.millis() - this.lastMove > this.delta && this.moving) {
                    this.fadeIn = false;
                    this.moving = false;
                    if ((float)LDQR_Monitoring_noCache.this.millis() > this.nextTimer) {
                        this.nextTimer = LDQR_Monitoring_noCache.this.millis() + this.fadeout_timer;
                        this.lastUpdate = LDQR_Monitoring_noCache.this.millis();
                    }
                }
                this.lastScoreTouched = this.scoreTouched;
                this.objLoop1 = this.fadeIn ? 100.0f : 0.0f;
                if (this.nextTimer > (float)LDQR_Monitoring_noCache.this.millis()) {
                    this.updateVolLoop();
                }
                this.mappedVol1 = LDQR_Monitoring_noCache.this.map2(this.volLoop1, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.loop1.amp(this.mappedVol1);
                this.loop2.amp(this.mappedVol1);
            } else {
                if ((float)LDQR_Monitoring_noCache.this.millis() > this.nextTimer) {
                    this.nextTimer = LDQR_Monitoring_noCache.this.millis() + this.fadeout_timer;
                    this.lastUpdate = LDQR_Monitoring_noCache.this.millis();
                }
                this.objLoop1 = 0.0f;
                if (this.nextTimer > (float)LDQR_Monitoring_noCache.this.millis()) {
                    this.updateVolLoop();
                }
                this.mappedVol1 = LDQR_Monitoring_noCache.this.map2(this.volLoop1, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.loop1.amp(this.mappedVol1);
                this.loop2.amp(this.mappedVol1);
            }
        }

        public void updateVolLoop() {
            float diff = LDQR_Monitoring_noCache.abs((float)(this.volLoop1 - this.objLoop1));
            float timeToReachObj = this.nextTimer - (float)LDQR_Monitoring_noCache.this.millis();
            float incrementByMs = diff / timeToReachObj;
            float deltaUpdate = (float)LDQR_Monitoring_noCache.this.millis() - this.lastUpdate;
            float update = incrementByMs * deltaUpdate;
            if (diff > 0.1f) {
                if (this.objLoop1 > this.volLoop1) {
                    this.volLoop1 += update;
                    if (this.volLoop1 > 100.0f) {
                        this.volLoop1 = 100.0f;
                    }
                } else if (this.objLoop1 < this.volLoop1) {
                    this.volLoop1 -= update;
                    if (this.volLoop1 < 0.0f) {
                        this.volLoop1 = 0.0f;
                    }
                }
            }
            this.lastUpdate = LDQR_Monitoring_noCache.this.millis();
        }

        public void startSoundFiles() {
            this.loop1.amp(0.0f);
            this.loop2.amp(0.0f);
            this.loop1.loop();
            this.loop2.loop();
        }

        public void playSunSound() {
            if (this.numSoundsPlaying < 2) {
                switch (this.indexSun) {
                    case 1: {
                        this.sun[0].play(1.0f, 1.0f);
                        ++this.indexSun;
                        break;
                    }
                    case 3: {
                        this.sun[1].play(1.0f, 1.0f);
                        ++this.indexSun;
                        break;
                    }
                    case 6: {
                        this.sun[2].play(1.0f, 1.0f);
                        ++this.indexSun;
                        break;
                    }
                    default: {
                        this.birds[this.birds_Order.get(this.indexBirds)].play(1.0f, 1.0f);
                        ++this.indexBirds;
                        if (this.indexBirds == this.numsounds_birds) {
                            this.birds_Order.shuffle();
                            this.indexBirds = 0;
                        }
                        ++this.indexSun;
                    }
                }
            }
        }
    }

    class Page2 {
        Square[] squares = new Square[2];
        SoundFile Ocean1;
        SoundFile Ocean2;
        SoundFile Kids;
        SoundFile Birds;
        PVector volLoopOcean1 = new PVector(0.0f, 0.0f);
        PVector volLoopOcean2 = new PVector(0.0f, 0.0f);
        PVector volLoopKids = new PVector(0.0f, 0.0f);
        PVector volLoopBirds = new PVector(0.0f, 0.0f);
        PVector timerOcean1 = new PVector(0.0f, 0.0f);
        PVector timerOcean2 = new PVector(0.0f, 0.0f);
        PVector timerKids = new PVector(0.0f, 0.0f);
        PVector timerBirds = new PVector(0.0f, 0.0f);
        boolean updatingOcean = false;
        boolean updatingOcean2 = false;
        boolean updatingKids = false;
        boolean updatingBirds = false;
        boolean windowOpened = false;
        boolean lastWindowState = false;
        boolean fadeIn;
        boolean fadeOut;
        boolean firstdog = true;
        SoundFile[] Chien;
        SoundFile[] Train;
        IntList dog_Order;
        IntList train_Order;
        int indexChien = 0;
        int indexTrain = 0;
        int nextChienTimer;
        int nextTrainTimer;
        boolean quit;

        Page2(PApplet p) {
            this.squares[0] = new Square(LDQR_Monitoring_noCache.this.width / 2 - 80, LDQR_Monitoring_noCache.this.height / 2 - 100, 70.0f, 1, LDQR_Monitoring_noCache.this.page2OSC_computed, 0, 0, 2);
            this.squares[1] = new Square(LDQR_Monitoring_noCache.this.width / 2 + 10, LDQR_Monitoring_noCache.this.height / 2 - 100, 70.0f, 2, LDQR_Monitoring_noCache.this.page2OSC_computed, 1, 0, 2);
            this.Ocean1 = new SoundFile(p, "P2/PLANCHE02_BoucleOcean.wav", false);
            this.Ocean2 = new SoundFile(p, "P2/PLANCHE02_BoucleOcean2.wav", false);
            this.Birds = new SoundFile(p, "P2/PLANCHE02_boucleoiseauxdemer.wav", false);
            this.Kids = new SoundFile(p, "P2/PLANCHE02_ambianceenfants.wav", false);
            this.Chien = new SoundFile[3];
            this.Chien[0] = new SoundFile(p, "P2/PLANCHE02_chien1.wav", false);
            this.Chien[1] = new SoundFile(p, "P2/PLANCHE02_chien2.wav", false);
            this.Chien[2] = new SoundFile(p, "P2/PLANCHE02_chien3.wav", false);
            this.Train = new SoundFile[2];
            this.Train[0] = new SoundFile(p, "P2/PLANCHE02_Train.wav", false);
            this.Train[1] = new SoundFile(p, "P2/PLANCHE02_Train2.wav", false);
            this.dog_Order = new IntList();
            int i = 0;
            while (i < this.Chien.length) {
                this.dog_Order.append(i);
                ++i;
            }
            this.dog_Order.shuffle();
            this.train_Order = new IntList();
            i = 0;
            while (i < this.Train.length) {
                this.train_Order.append(i);
                ++i;
            }
            this.train_Order.shuffle();
            this.nextChienTimer = LDQR_Monitoring_noCache.this.millis() + 3000;
            this.nextTrainTimer = LDQR_Monitoring_noCache.this.millis() + PApplet.parseInt((float)LDQR_Monitoring_noCache.this.random(20000.0f, 35000.0f));
            this.startSoundFiles();
        }

        public void draw(boolean _quit) {
            this.quit = _quit;
            if (!this.quit) {
                int score = 0;
                int i = 0;
                while (i < this.squares.length) {
                    this.squares[i].draw();
                    if (this.squares[i].checkMouseOver() > 0) {
                        ++score;
                    }
                    ++i;
                }
                this.windowOpened = score > 0;
                if (this.windowOpened) {
                    if (!this.lastWindowState) {
                        this.fadeIn = true;
                        this.volLoopOcean1.y = 50.0f;
                        this.timerOcean1.x = LDQR_Monitoring_noCache.this.millis();
                        this.timerOcean1.y = LDQR_Monitoring_noCache.this.millis() + 2000;
                        this.volLoopOcean2.y = 70.0f;
                        this.timerOcean2.x = LDQR_Monitoring_noCache.this.millis();
                        this.timerOcean2.y = LDQR_Monitoring_noCache.this.millis() + 2000;
                        this.volLoopKids.y = 80.0f;
                        this.timerKids.x = LDQR_Monitoring_noCache.this.millis();
                        this.timerKids.y = LDQR_Monitoring_noCache.this.millis() + 2000;
                        this.volLoopBirds.y = 50.0f;
                        this.timerBirds.x = LDQR_Monitoring_noCache.this.millis();
                        this.timerBirds.y = LDQR_Monitoring_noCache.this.millis() + 2000;
                        if (this.firstdog) {
                            this.nextChienTimer = LDQR_Monitoring_noCache.this.millis() + 3000;
                            this.firstdog = false;
                        } else {
                            this.nextChienTimer = LDQR_Monitoring_noCache.this.millis() + PApplet.parseInt((float)LDQR_Monitoring_noCache.this.random(15000.0f, 20000.0f));
                        }
                        this.nextTrainTimer = LDQR_Monitoring_noCache.this.millis() + PApplet.parseInt((float)LDQR_Monitoring_noCache.this.random(20000.0f, 35000.0f));
                        this.lastWindowState = this.windowOpened;
                    } else {
                        if (!(this.updatingOcean || this.fadeIn || this.fadeOut)) {
                            this.volLoopOcean1.y = LDQR_Monitoring_noCache.this.random(20.0f, 65.0f);
                            this.timerOcean1.x = LDQR_Monitoring_noCache.this.millis();
                            this.timerOcean1.y = (float)LDQR_Monitoring_noCache.this.millis() + LDQR_Monitoring_noCache.this.random(5000.0f, 7000.0f);
                            this.updatingOcean = true;
                        }
                        if (!(this.updatingOcean2 || this.fadeIn || this.fadeOut)) {
                            this.volLoopOcean2.y = LDQR_Monitoring_noCache.this.random(40.0f, 80.0f);
                            this.timerOcean2.x = LDQR_Monitoring_noCache.this.millis();
                            this.timerOcean2.y = (float)LDQR_Monitoring_noCache.this.millis() + LDQR_Monitoring_noCache.this.random(5000.0f, 7000.0f);
                            this.updatingOcean2 = true;
                        }
                        if (!(this.updatingKids || this.fadeIn || this.fadeOut)) {
                            this.volLoopKids.y = LDQR_Monitoring_noCache.this.random(75.0f, 100.0f);
                            this.timerKids.x = LDQR_Monitoring_noCache.this.millis();
                            this.timerKids.y = (float)LDQR_Monitoring_noCache.this.millis() + LDQR_Monitoring_noCache.this.random(5000.0f, 7000.0f);
                            this.updatingKids = true;
                        }
                        if (!(this.updatingBirds || this.fadeIn || this.fadeOut)) {
                            this.volLoopBirds.y = LDQR_Monitoring_noCache.this.random(20.0f, 50.0f);
                            this.timerBirds.x = LDQR_Monitoring_noCache.this.millis();
                            this.timerBirds.y = (float)LDQR_Monitoring_noCache.this.millis() + LDQR_Monitoring_noCache.this.random(5000.0f, 7000.0f);
                            this.updatingBirds = true;
                        }
                    }
                } else if (!this.windowOpened && this.lastWindowState) {
                    this.fadeOut = true;
                    this.volLoopOcean1.y = 0.0f;
                    this.timerOcean1.x = LDQR_Monitoring_noCache.this.millis();
                    this.timerOcean1.y = LDQR_Monitoring_noCache.this.millis() + 2000;
                    this.volLoopOcean2.y = 0.0f;
                    this.timerOcean2.x = LDQR_Monitoring_noCache.this.millis();
                    this.timerOcean2.y = LDQR_Monitoring_noCache.this.millis() + 2000;
                    this.volLoopKids.y = 0.0f;
                    this.timerKids.x = LDQR_Monitoring_noCache.this.millis();
                    this.timerKids.y = LDQR_Monitoring_noCache.this.millis() + 2000;
                    this.volLoopBirds.y = 0.0f;
                    this.timerBirds.x = LDQR_Monitoring_noCache.this.millis();
                    this.timerBirds.y = LDQR_Monitoring_noCache.this.millis() + 2000;
                    this.lastWindowState = this.windowOpened;
                }
                if (this.fadeIn && (float)LDQR_Monitoring_noCache.this.millis() > this.timerOcean1.y) {
                    this.fadeIn = false;
                }
                if (this.fadeOut && (float)LDQR_Monitoring_noCache.this.millis() > this.timerOcean1.y) {
                    this.fadeOut = false;
                }
                if ((float)LDQR_Monitoring_noCache.this.millis() > this.timerOcean1.y) {
                    this.updatingOcean = false;
                }
                if ((float)LDQR_Monitoring_noCache.this.millis() > this.timerOcean2.y) {
                    this.updatingOcean2 = false;
                }
                if ((float)LDQR_Monitoring_noCache.this.millis() > this.timerKids.y) {
                    this.updatingKids = false;
                }
                if ((float)LDQR_Monitoring_noCache.this.millis() > this.timerBirds.y) {
                    this.updatingBirds = false;
                }
                this.updateVolLoop(this.volLoopOcean1, this.timerOcean1);
                this.updateVolLoop(this.volLoopOcean2, this.timerOcean2);
                this.updateVolLoop(this.volLoopKids, this.timerKids);
                this.updateVolLoop(this.volLoopBirds, this.timerBirds);
                float mappedVol1 = LDQR_Monitoring_noCache.this.map2(this.volLoopOcean1.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.Ocean1.amp(mappedVol1);
                float mappedVol2 = LDQR_Monitoring_noCache.this.map2(this.volLoopOcean2.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.Ocean2.amp(mappedVol2);
                float mappedVol3 = LDQR_Monitoring_noCache.this.map2(this.volLoopKids.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.Kids.amp(mappedVol3);
                float mappedVol4 = LDQR_Monitoring_noCache.this.map2(this.volLoopBirds.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.Birds.amp(mappedVol4);
                if (this.windowOpened) {
                    if (LDQR_Monitoring_noCache.this.millis() > this.nextChienTimer) {
                        this.nextChienTimer = LDQR_Monitoring_noCache.this.millis() + PApplet.parseInt((float)LDQR_Monitoring_noCache.this.random(2000.0f, 25000.0f));
                        this.Chien[this.dog_Order.get(this.indexChien)].play();
                        ++this.indexChien;
                        if (this.indexChien == this.Chien.length) {
                            this.dog_Order.shuffle();
                        }
                        this.indexChien %= this.Chien.length;
                    }
                    if (LDQR_Monitoring_noCache.this.millis() > this.nextTrainTimer) {
                        this.nextTrainTimer = LDQR_Monitoring_noCache.this.millis() + PApplet.parseInt((float)LDQR_Monitoring_noCache.this.random(40000.0f, 60000.0f));
                        this.Train[this.train_Order.get(this.indexTrain)].play();
                        ++this.indexTrain;
                        if (this.indexTrain == this.Train.length) {
                            this.train_Order.shuffle();
                        }
                        this.indexTrain %= this.Train.length;
                    }
                }
            } else {
                if ((float)LDQR_Monitoring_noCache.this.millis() < this.timerOcean1.y && !this.fadeOut) {
                    this.volLoopOcean1.y = 0.0f;
                    this.timerOcean1.x = LDQR_Monitoring_noCache.this.millis();
                    this.timerOcean1.y = LDQR_Monitoring_noCache.this.millis() + 2000;
                    this.volLoopOcean2.y = 0.0f;
                    this.timerOcean2.x = LDQR_Monitoring_noCache.this.millis();
                    this.timerOcean2.y = LDQR_Monitoring_noCache.this.millis() + 2000;
                    this.volLoopKids.y = 0.0f;
                    this.timerKids.x = LDQR_Monitoring_noCache.this.millis();
                    this.timerKids.y = LDQR_Monitoring_noCache.this.millis() + 2000;
                    this.volLoopBirds.y = 0.0f;
                    this.timerBirds.x = LDQR_Monitoring_noCache.this.millis();
                    this.timerBirds.y = LDQR_Monitoring_noCache.this.millis() + 2000;
                    this.fadeOut = true;
                }
                this.updateVolLoop(this.volLoopOcean1, this.timerOcean1);
                this.updateVolLoop(this.volLoopOcean2, this.timerOcean2);
                this.updateVolLoop(this.volLoopKids, this.timerKids);
                this.updateVolLoop(this.volLoopBirds, this.timerBirds);
                float mappedVol1 = LDQR_Monitoring_noCache.this.map2(this.volLoopOcean1.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.Ocean1.amp(mappedVol1);
                float mappedVol2 = LDQR_Monitoring_noCache.this.map2(this.volLoopOcean2.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.Ocean2.amp(mappedVol2);
                float mappedVol3 = LDQR_Monitoring_noCache.this.map2(this.volLoopKids.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.Kids.amp(mappedVol3);
                float mappedVol4 = LDQR_Monitoring_noCache.this.map2(this.volLoopBirds.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.Birds.amp(mappedVol4);
            }
        }

        public void updateVolLoop(PVector volLoopFile, PVector timer) {
            float volLoop = volLoopFile.x;
            float objLoop = volLoopFile.y;
            float lastUpdate = timer.x;
            float nextTimer = timer.y;
            if ((float)LDQR_Monitoring_noCache.this.millis() < nextTimer) {
                float diff = LDQR_Monitoring_noCache.abs((float)(volLoop - objLoop));
                float timeToReachObj = nextTimer - (float)LDQR_Monitoring_noCache.this.millis();
                float incrementByMs = diff / timeToReachObj;
                float deltaUpdate = (float)LDQR_Monitoring_noCache.this.millis() - lastUpdate;
                float update = incrementByMs * deltaUpdate;
                if (diff > 0.1f) {
                    if (objLoop > volLoop) {
                        if ((volLoop += update) > 100.0f) {
                            volLoop = 100.0f;
                        }
                    } else if (objLoop < volLoop && (volLoop -= update) < 0.0f) {
                        volLoop = 0.0f;
                    }
                }
            }
            timer.x = LDQR_Monitoring_noCache.this.millis();
            volLoopFile.x = volLoop;
        }

        public void startSoundFiles() {
            this.Ocean1.amp(0.0f);
            this.Ocean2.amp(0.0f);
            this.Kids.amp(0.0f);
            this.Birds.amp(0.0f);
            this.Ocean1.loop();
            this.Ocean2.loop();
            this.Kids.loop();
            this.Birds.loop();
        }
    }

    class Page3 {
        Square[] squares = new Square[2];
        SoundFile[] sonsCourt;
        SoundFile[] sonsLongs;
        int numsounds_courts = 12;
        int numsounds_longs = 12;
        SoundFile song;
        boolean songStarted = false;
        int nberJumps = 0;
        boolean pressed = false;
        boolean lastPressed = false;
        int panning = 0;
        PVector volLoopSong = new PVector(0.0f, 0.0f);
        PVector timerSong = new PVector(0.0f, 0.0f);
        int delta = 2000;
        boolean halfway = false;
        boolean quit = false;

        Page3(PApplet p) {
            this.squares[0] = new Square(LDQR_Monitoring_noCache.this.width / 2 - 150, LDQR_Monitoring_noCache.this.height / 2 - 80, 140.0f, 1, LDQR_Monitoring_noCache.this.page3OSC_computed, 0, 1, 3);
            this.squares[1] = new Square(LDQR_Monitoring_noCache.this.width / 2 + 10, LDQR_Monitoring_noCache.this.height / 2 - 80, 140.0f, 2, LDQR_Monitoring_noCache.this.page3OSC_computed, 1, 1, 3);
            this.sonsCourt = new SoundFile[this.numsounds_courts];
            this.sonsCourt[0] = new SoundFile(p, "P3/COURT/CLAVEMONO-01.wav", false);
            this.sonsCourt[1] = new SoundFile(p, "P3/COURT/CLOCHE1MONO-01.wav", false);
            this.sonsCourt[2] = new SoundFile(p, "P3/COURT/CLOCHE2MONO.wav", false);
            this.sonsCourt[3] = new SoundFile(p, "P3/COURT/CONGASMONO-01.wav", false);
            this.sonsCourt[4] = new SoundFile(p, "P3/COURT/CRESSELLEMONO-01.wav", false);
            this.sonsCourt[5] = new SoundFile(p, "P3/COURT/GUITARE.wav", false);
            this.sonsCourt[6] = new SoundFile(p, "P3/COURT/SIFFLET.wav", false);
            this.sonsCourt[7] = new SoundFile(p, "P3/COURT/SNAP.wav", false);
            this.sonsCourt[8] = new SoundFile(p, "P3/COURT/STOMP.wav", false);
            this.sonsCourt[9] = new SoundFile(p, "P3/COURT/TAMBOURINMONO-01.wav", false);
            this.sonsCourt[10] = new SoundFile(p, "P3/COURT/TRIANGLEMONO-01.wav", false);
            this.sonsCourt[11] = new SoundFile(p, "P3/COURT/TRIANGLEMONO2.wav", false);
            this.sonsLongs = new SoundFile[this.numsounds_courts];
            this.sonsLongs[0] = new SoundFile(p, "P3/LONG/BASSE1MONO-01.wav", false);
            this.sonsLongs[1] = new SoundFile(p, "P3/LONG/BASSE2MONO.wav", false);
            this.sonsLongs[2] = new SoundFile(p, "P3/LONG/CLAVE2MONO-01.wav", false);
            this.sonsLongs[3] = new SoundFile(p, "P3/LONG/CLAVIER.wav", false);
            this.sonsLongs[4] = new SoundFile(p, "P3/LONG/CLAVIERPERCU.wav", false);
            this.sonsLongs[5] = new SoundFile(p, "P3/LONG/GUITARE2.wav", false);
            this.sonsLongs[6] = new SoundFile(p, "P3/LONG/PATTERN1.wav", false);
            this.sonsLongs[7] = new SoundFile(p, "P3/LONG/PATTERN1B.wav", false);
            this.sonsLongs[8] = new SoundFile(p, "P3/LONG/PATTERNC.wav", false);
            this.sonsLongs[9] = new SoundFile(p, "P3/LONG/PATTERND.wav", false);
            this.sonsLongs[10] = new SoundFile(p, "P3/LONG/SIFFLETPERCU.wav", false);
            this.sonsLongs[11] = new SoundFile(p, "P3/LONG/PATTERNE.wav", false);
            this.song = new SoundFile(p, "P3/KAPI.wav");
        }

        public void draw(boolean _quit) {
            this.quit = _quit;
            if (!this.quit) {
                int score = 0;
                int i = 0;
                while (i < this.squares.length) {
                    this.squares[i].draw();
                    if (this.squares[i].checkMouseOver() != 0) {
                        score = this.squares[i].checkMouseOver();
                    }
                    ++i;
                }
                if (score > 0) {
                    this.pressed = true;
                    if (score == 1) {
                        this.panning = -1;
                    } else if (score == 2) {
                        this.panning = 1;
                    }
                } else {
                    this.pressed = false;
                    if (this.lastPressed) {
                        this.lastPressed = false;
                    }
                }
                if (this.pressed && !this.lastPressed) {
                    int randomSound;
                    ++this.nberJumps;
                    this.halfway = false;
                    if (this.nberJumps < 11) {
                        randomSound = PApplet.parseInt((float)LDQR_Monitoring_noCache.this.random(0.0f, this.numsounds_courts));
                        this.sonsCourt[randomSound].pan((float)this.panning);
                        this.sonsCourt[randomSound].play();
                    } else if (this.nberJumps > 10 && this.nberJumps < 20) {
                        randomSound = PApplet.parseInt((float)LDQR_Monitoring_noCache.this.random(0.0f, this.numsounds_longs));
                        this.sonsLongs[randomSound].pan((float)this.panning);
                        this.sonsLongs[randomSound].play();
                    } else {
                        if (!this.songStarted) {
                            this.startSong();
                            this.songStarted = true;
                        }
                        this.volLoopSong.y = 100.0f;
                        this.timerSong.x = LDQR_Monitoring_noCache.this.millis();
                        this.timerSong.y = LDQR_Monitoring_noCache.this.millis() + 3000;
                    }
                    this.song.pan((float)this.panning);
                    this.lastPressed = true;
                }
                if (this.songStarted) {
                    this.updateVolLoop(this.volLoopSong, this.timerSong);
                    float mappedVol1 = LDQR_Monitoring_noCache.this.map2(this.volLoopSong.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                    this.song.amp(mappedVol1);
                    if ((float)LDQR_Monitoring_noCache.this.millis() - this.timerSong.y > (float)(this.delta * 2) && this.halfway || this.quit) {
                        this.volLoopSong.y = 0.0f;
                        this.timerSong.x = LDQR_Monitoring_noCache.this.millis();
                        this.timerSong.y = LDQR_Monitoring_noCache.this.millis() + 2000;
                    } else if ((float)LDQR_Monitoring_noCache.this.millis() - this.timerSong.y > (float)this.delta && !this.halfway) {
                        this.volLoopSong.y = 50.0f;
                        this.timerSong.x = LDQR_Monitoring_noCache.this.millis();
                        this.timerSong.y = LDQR_Monitoring_noCache.this.millis() + 2000;
                        this.halfway = true;
                    }
                }
            } else {
                if (this.songStarted) {
                    this.volLoopSong.y = 0.0f;
                    this.timerSong.x = LDQR_Monitoring_noCache.this.millis();
                    this.timerSong.y = LDQR_Monitoring_noCache.this.millis() + 1500;
                    this.songStarted = false;
                }
                this.updateVolLoop(this.volLoopSong, this.timerSong);
                float mappedVol1 = LDQR_Monitoring_noCache.this.map2(this.volLoopSong.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.song.amp(mappedVol1);
            }
        }

        public void updateVolLoop(PVector volLoopFile, PVector timer) {
            float volLoop = volLoopFile.x;
            float objLoop = volLoopFile.y;
            float lastUpdate = timer.x;
            float nextTimer = timer.y;
            if ((float)LDQR_Monitoring_noCache.this.millis() < nextTimer) {
                float diff = LDQR_Monitoring_noCache.abs((float)(volLoop - objLoop));
                float timeToReachObj = nextTimer - (float)LDQR_Monitoring_noCache.this.millis();
                float incrementByMs = diff / timeToReachObj;
                float deltaUpdate = (float)LDQR_Monitoring_noCache.this.millis() - lastUpdate;
                float update = incrementByMs * deltaUpdate;
                if (diff > 0.1f) {
                    if (objLoop > volLoop) {
                        if ((volLoop += update) > 100.0f) {
                            volLoop = 100.0f;
                        }
                    } else if (objLoop < volLoop && (volLoop -= update) < 0.0f) {
                        volLoop = 0.0f;
                    }
                }
            }
            timer.x = LDQR_Monitoring_noCache.this.millis();
            volLoopFile.x = volLoop;
        }

        public void startSong() {
            this.song.amp(0.0f);
            this.song.pan(0.0f);
            this.song.play();
        }
    }

    class Page4 {
        Square[] squares = new Square[3];
        SoundFile[] splotchs;
        SoundFile[] frog;
        int numsounds_splotchs = 9;
        int numsounds_frog = 3;
        IntList splotchs_Order;
        IntList frog_Order;
        int indexSplotchs = 0;
        int indexFrog = 0;
        boolean isPressed = false;
        boolean lastPressed = false;
        int chanceFrog = 15;
        int divFrog = 10;
        boolean quit;

        Page4(PApplet p) {
            this.squares[0] = new Square(LDQR_Monitoring_noCache.this.width / 2 - 150, LDQR_Monitoring_noCache.this.height / 2 + 50, 150.0f, 1, LDQR_Monitoring_noCache.this.page4OSC, 2, 1, 4);
            this.squares[1] = new Square(LDQR_Monitoring_noCache.this.width / 2 - 50, LDQR_Monitoring_noCache.this.height / 2 - 100, 75.0f, 2, LDQR_Monitoring_noCache.this.page4OSC, 1, 1, 4);
            this.squares[2] = new Square(LDQR_Monitoring_noCache.this.width / 2 + 20, LDQR_Monitoring_noCache.this.height / 2 - 200, 35.0f, 3, LDQR_Monitoring_noCache.this.page4OSC, 0, 1, 4);
            this.splotchs = new SoundFile[this.numsounds_splotchs];
            this.splotchs[0] = new SoundFile(p, "P4/PLANCEH04_Boue3.wav", false);
            this.splotchs[1] = new SoundFile(p, "P4/PLANCHE04_boue1.wav", false);
            this.splotchs[2] = new SoundFile(p, "P4/PLANCHE04_boue5.wav", false);
            this.splotchs[3] = new SoundFile(p, "P4/PLANCHE04_boue7.wav", false);
            this.splotchs[4] = new SoundFile(p, "P4/PLANCHE04_boue8.wav", false);
            this.splotchs[5] = new SoundFile(p, "P4/PLANCHE04_boue9.wav", false);
            this.splotchs[6] = new SoundFile(p, "P4/PLANCHE04_Boue2.wav", false);
            this.splotchs[7] = new SoundFile(p, "P4/PLANCHE04_Boue4.wav", false);
            this.splotchs[8] = new SoundFile(p, "P4/PLANCHE04_boue10.wav", false);
            this.frog = new SoundFile[this.numsounds_frog];
            this.frog[0] = new SoundFile(p, "P4/PLANCHE04_grenouille1.wav", false);
            this.frog[1] = new SoundFile(p, "P4/PLANCHE04_grenouille2.wav", false);
            this.frog[2] = new SoundFile(p, "P4/PLANCHE04_grenouille plonge.wav", false);
            this.splotchs_Order = new IntList();
            int i = 0;
            while (i < this.splotchs.length) {
                this.splotchs_Order.append(i);
                ++i;
            }
            this.splotchs_Order.shuffle();
            this.frog_Order = new IntList();
            i = 0;
            while (i < this.frog.length) {
                this.frog_Order.append(i);
                ++i;
            }
            this.frog_Order.shuffle();
        }

        public void draw(boolean _quit) {
            this.quit = _quit;
            if (!this.quit) {
                int score = 0;
                int i = 0;
                while (i < this.squares.length) {
                    this.squares[i].draw();
                    if (this.squares[i].checkMouseOver() != 0) {
                        ++score;
                    }
                    ++i;
                }
                if (score > 0) {
                    this.isPressed = true;
                } else {
                    this.isPressed = false;
                    if (this.lastPressed) {
                        this.lastPressed = false;
                    }
                }
                if (this.isPressed && !this.lastPressed) {
                    ++this.indexSplotchs;
                    if (this.indexSplotchs == this.numsounds_splotchs) {
                        this.indexSplotchs = 0;
                        this.splotchs_Order.shuffle();
                        if (LDQR_Monitoring_noCache.this.random(this.chanceFrog) > (float)this.divFrog) {
                            this.frog[this.frog_Order.get(this.indexFrog)].play();
                        }
                        ++this.indexFrog;
                        if (this.indexFrog == this.numsounds_frog) {
                            this.indexFrog = 0;
                            this.frog_Order.shuffle();
                        }
                    }
                    this.splotchs[this.splotchs_Order.get(this.indexSplotchs)].play();
                    this.lastPressed = true;
                }
            }
        }
    }

    class Page5 {
        Square[] squares = new Square[3];
        SoundFile[] PasZone1_A;
        SoundFile[] PasZone1_B;
        SoundFile[] PasZone2_A;
        SoundFile[] PasZone2_B;
        SoundFile[] PasZone3;
        SoundFile[] Mouettes;
        SoundFile BoucleChien;
        SoundFile BoucleMouettes;
        SoundFile Ocean1;
        PVector volLoopChien = new PVector(0.0f, 0.0f);
        PVector volLoopMouettes = new PVector(0.0f, 0.0f);
        PVector volLoopOcean1 = new PVector(0.0f, 0.0f);
        PVector timerChien = new PVector(0.0f, 0.0f);
        PVector timerMouettes = new PVector(0.0f, 0.0f);
        PVector timerOcean1 = new PVector(0.0f, 0.0f);
        boolean updatingChien = false;
        boolean updatingMouettes = false;
        boolean updatingOcean = false;
        int indexButton1;
        int indexButton2;
        int indexButton3 = 0;
        IntList steps_Order;
        IntList seagull_Order;
        boolean Button1Pressed = false;
        boolean Button2Pressed = false;
        boolean Button3Pressed = false;
        boolean lastButton1Pressed = false;
        boolean lastButton2Pressed = false;
        boolean lastButton3Pressed = false;
        boolean quit;
        boolean fadeIn = true;

        Page5(PApplet p) {
            this.squares[0] = new Square(LDQR_Monitoring_noCache.this.width / 2 - 100, LDQR_Monitoring_noCache.this.height / 2 + 100, 200.0f, 1, LDQR_Monitoring_noCache.this.page5OSC, 0, 1, 5);
            this.squares[1] = new Square(LDQR_Monitoring_noCache.this.width / 2 - 70, LDQR_Monitoring_noCache.this.height / 2 - 90, 140.0f, 2, LDQR_Monitoring_noCache.this.page5OSC, 1, 1, 5);
            this.squares[2] = new Square(LDQR_Monitoring_noCache.this.width / 2 - 30, LDQR_Monitoring_noCache.this.height / 2 - 200, 60.0f, 3, LDQR_Monitoring_noCache.this.page5OSC, 2, 1, 5);
            this.PasZone1_A = new SoundFile[6];
            this.PasZone1_A[0] = new SoundFile(p, "P5/1A.wav", false);
            this.PasZone1_A[1] = new SoundFile(p, "P5/1B.wav", false);
            this.PasZone1_A[2] = new SoundFile(p, "P5/1C.wav", false);
            this.PasZone1_A[3] = new SoundFile(p, "P5/1D.wav", false);
            this.PasZone1_A[4] = new SoundFile(p, "P5/1E.wav", false);
            this.PasZone1_A[5] = new SoundFile(p, "P5/1F.wav", false);
            this.PasZone1_B = new SoundFile[6];
            this.PasZone1_B[0] = new SoundFile(p, "P5/2A.wav", false);
            this.PasZone1_B[1] = new SoundFile(p, "P5/2B.wav", false);
            this.PasZone1_B[2] = new SoundFile(p, "P5/2C.wav", false);
            this.PasZone1_B[3] = new SoundFile(p, "P5/2D.wav", false);
            this.PasZone1_B[4] = new SoundFile(p, "P5/2E.wav", false);
            this.PasZone1_B[5] = new SoundFile(p, "P5/2F.wav", false);
            this.PasZone2_A = new SoundFile[6];
            this.PasZone2_A[0] = new SoundFile(p, "P5/3A.wav", false);
            this.PasZone2_A[1] = new SoundFile(p, "P5/3B.wav", false);
            this.PasZone2_A[2] = new SoundFile(p, "P5/3C.wav", false);
            this.PasZone2_A[3] = new SoundFile(p, "P5/3D.wav", false);
            this.PasZone2_A[4] = new SoundFile(p, "P5/3E.wav", false);
            this.PasZone2_A[5] = new SoundFile(p, "P5/3F.wav", false);
            this.PasZone2_B = new SoundFile[6];
            this.PasZone2_B[0] = new SoundFile(p, "P5/4A.wav", false);
            this.PasZone2_B[1] = new SoundFile(p, "P5/4B.wav", false);
            this.PasZone2_B[2] = new SoundFile(p, "P5/4C.wav", false);
            this.PasZone2_B[3] = new SoundFile(p, "P5/4D.wav", false);
            this.PasZone2_B[4] = new SoundFile(p, "P5/4E.wav", false);
            this.PasZone2_B[5] = new SoundFile(p, "P5/4F.wav", false);
            this.PasZone3 = new SoundFile[6];
            this.PasZone3[0] = new SoundFile(p, "P5/5A.wav", false);
            this.PasZone3[1] = new SoundFile(p, "P5/5B.wav", false);
            this.PasZone3[2] = new SoundFile(p, "P5/5C.wav", false);
            this.PasZone3[3] = new SoundFile(p, "P5/5D.wav", false);
            this.PasZone3[4] = new SoundFile(p, "P5/5E.wav", false);
            this.PasZone3[5] = new SoundFile(p, "P5/5F.wav", false);
            this.Mouettes = new SoundFile[4];
            this.Mouettes[0] = new SoundFile(p, "P5/Mouette1.wav", false);
            this.Mouettes[1] = new SoundFile(p, "P5/Mouette2.wav", false);
            this.Mouettes[2] = new SoundFile(p, "P5/Mouette3.wav", false);
            this.Mouettes[3] = new SoundFile(p, "P5/Mouette4.wav", false);
            this.BoucleChien = new SoundFile(p, "P5/Chien.wav", false);
            this.BoucleMouettes = new SoundFile(p, "P5/BoucleMouettes.wav", false);
            this.Ocean1 = new SoundFile(p, "P5/BoucleOcean.wav", false);
            this.steps_Order = new IntList();
            int i = 0;
            while (i < 6) {
                this.steps_Order.append(i);
                ++i;
            }
            this.steps_Order.shuffle();
            this.seagull_Order = new IntList();
            i = 0;
            while (i < 4) {
                this.seagull_Order.append(i);
                ++i;
            }
            this.seagull_Order.shuffle();
            this.startSoundFiles();
        }

        public void draw(boolean _quit) {
            this.quit = _quit;
            if (!this.quit) {
                if (this.fadeIn) {
                    this.volLoopOcean1.y = 25.0f;
                    this.timerOcean1.x = LDQR_Monitoring_noCache.this.millis();
                    this.timerOcean1.y = LDQR_Monitoring_noCache.this.millis() + 5000;
                    this.fadeIn = false;
                }
                this.Button1Pressed = false;
                this.Button2Pressed = false;
                this.Button3Pressed = false;
                int i = 0;
                while (i < this.squares.length) {
                    this.squares[i].draw();
                    ++i;
                }
                if (this.squares[0].checkMouseOver() == 1) {
                    if (!this.lastButton1Pressed) {
                        this.Button1Pressed = true;
                        if (this.indexButton1 < 6) {
                            this.PasZone1_A[this.steps_Order.get(this.indexButton1)].play();
                        } else {
                            this.PasZone1_B[this.steps_Order.get(this.indexButton1 % 6)].play();
                            if (this.indexButton1 % 6 == 0) {
                                this.steps_Order.shuffle();
                            }
                        }
                        if (this.volLoopChien.y > 0.0f) {
                            this.volLoopChien.y = 0.0f;
                            this.timerChien.x = LDQR_Monitoring_noCache.this.millis();
                            this.timerChien.y = LDQR_Monitoring_noCache.this.millis() + 1000;
                            this.updatingChien = true;
                            this.volLoopMouettes.y = 0.0f;
                            this.timerMouettes.x = LDQR_Monitoring_noCache.this.millis();
                            this.timerMouettes.y = LDQR_Monitoring_noCache.this.millis() + 1000;
                            this.updatingMouettes = true;
                        }
                        ++this.indexButton1;
                        this.lastButton1Pressed = true;
                    }
                } else {
                    this.Button1Pressed = false;
                    this.lastButton1Pressed = false;
                }
                if (this.squares[1].checkMouseOver() == 2) {
                    if (!this.lastButton2Pressed) {
                        this.Button2Pressed = true;
                        if (this.indexButton2 < 6) {
                            this.PasZone2_A[this.steps_Order.get(this.indexButton2)].play();
                        } else {
                            this.PasZone2_B[this.steps_Order.get(this.indexButton2 % 6)].play();
                            if (this.indexButton2 % 6 == 0) {
                                this.steps_Order.shuffle();
                            }
                        }
                        if (this.volLoopChien.y > 0.0f) {
                            this.volLoopChien.y = 0.0f;
                            this.timerChien.x = LDQR_Monitoring_noCache.this.millis();
                            this.timerChien.y = LDQR_Monitoring_noCache.this.millis() + 1000;
                            this.updatingChien = true;
                            this.volLoopMouettes.y = 0.0f;
                            this.timerMouettes.x = LDQR_Monitoring_noCache.this.millis();
                            this.timerMouettes.y = LDQR_Monitoring_noCache.this.millis() + 1000;
                            this.updatingMouettes = true;
                        }
                        ++this.indexButton2;
                        this.lastButton2Pressed = true;
                    }
                } else {
                    this.Button2Pressed = false;
                    this.lastButton2Pressed = false;
                }
                if (this.squares[2].checkMouseOver() == 3) {
                    if (!this.lastButton3Pressed) {
                        this.Button3Pressed = true;
                        this.PasZone3[this.steps_Order.get(this.indexButton3 % 6)].play();
                        if (this.indexButton3 % 6 == 0) {
                            this.steps_Order.shuffle();
                        }
                        if (this.volLoopChien.y <= 0.0f) {
                            this.volLoopChien.y = 100.0f;
                            this.timerChien.x = LDQR_Monitoring_noCache.this.millis();
                            this.timerChien.y = LDQR_Monitoring_noCache.this.millis() + 1000;
                            this.updatingChien = true;
                            this.volLoopMouettes.y = 100.0f;
                            this.timerMouettes.x = LDQR_Monitoring_noCache.this.millis();
                            this.timerMouettes.y = LDQR_Monitoring_noCache.this.millis() + 1000;
                            this.updatingMouettes = true;
                        }
                        if (this.indexButton3 % 6 == 3) {
                            if (LDQR_Monitoring_noCache.this.random(10.0f) > 5.0f) {
                                this.Mouettes[this.seagull_Order.get(PApplet.parseInt((float)LDQR_Monitoring_noCache.this.random(4.0f)))].play();
                            }
                            if (this.indexButton3 % 4 == 0) {
                                this.seagull_Order.shuffle();
                            }
                        }
                        ++this.indexButton3;
                        this.lastButton3Pressed = true;
                    }
                } else {
                    this.Button3Pressed = false;
                    this.lastButton3Pressed = false;
                }
                this.updateVolLoop(this.volLoopChien, this.timerChien);
                this.updateVolLoop(this.volLoopMouettes, this.timerMouettes);
                this.updateVolLoop(this.volLoopOcean1, this.timerOcean1);
                float mappedVol6 = LDQR_Monitoring_noCache.this.map2(this.volLoopChien.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.BoucleChien.amp(mappedVol6);
                float mappedVol7 = LDQR_Monitoring_noCache.this.map2(this.volLoopMouettes.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.BoucleMouettes.amp(mappedVol7);
                float mappedVol8 = LDQR_Monitoring_noCache.this.map2(this.volLoopOcean1.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.Ocean1.amp(mappedVol8);
                if (this.updatingChien && (float)LDQR_Monitoring_noCache.this.millis() > this.timerChien.y) {
                    this.updatingChien = false;
                }
                if (this.updatingMouettes && (float)LDQR_Monitoring_noCache.this.millis() > this.timerMouettes.y) {
                    this.updatingMouettes = false;
                }
                if (this.updatingOcean && (float)LDQR_Monitoring_noCache.this.millis() > this.timerOcean1.y) {
                    this.updatingOcean = false;
                }
            } else {
                if (!this.updatingChien) {
                    this.volLoopChien.y = 0.0f;
                    this.timerChien.x = LDQR_Monitoring_noCache.this.millis();
                    this.timerChien.y = LDQR_Monitoring_noCache.this.millis() + 1000;
                    this.updatingChien = true;
                    this.volLoopMouettes.y = 0.0f;
                    this.timerMouettes.x = LDQR_Monitoring_noCache.this.millis();
                    this.timerMouettes.y = LDQR_Monitoring_noCache.this.millis() + 1000;
                    this.updatingMouettes = true;
                    this.volLoopOcean1.y = 0.0f;
                    this.timerOcean1.x = LDQR_Monitoring_noCache.this.millis();
                    this.timerOcean1.y = LDQR_Monitoring_noCache.this.millis() + 1000;
                    this.updatingOcean = true;
                }
                this.updateVolLoop(this.volLoopChien, this.timerChien);
                this.updateVolLoop(this.volLoopMouettes, this.timerMouettes);
                this.updateVolLoop(this.volLoopOcean1, this.timerOcean1);
                float mappedVol6 = LDQR_Monitoring_noCache.this.map2(this.volLoopChien.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.BoucleChien.amp(mappedVol6);
                float mappedVol7 = LDQR_Monitoring_noCache.this.map2(this.volLoopMouettes.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.BoucleMouettes.amp(mappedVol7);
                float mappedVol8 = LDQR_Monitoring_noCache.this.map2(this.volLoopOcean1.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.Ocean1.amp(mappedVol8);
                if (this.updatingChien && (float)LDQR_Monitoring_noCache.this.millis() > this.timerChien.y) {
                    this.updatingChien = false;
                }
                if (this.updatingMouettes && (float)LDQR_Monitoring_noCache.this.millis() > this.timerMouettes.y) {
                    this.updatingMouettes = false;
                }
                if (this.updatingOcean && (float)LDQR_Monitoring_noCache.this.millis() > this.timerOcean1.y) {
                    this.updatingOcean = false;
                }
            }
        }

        public void updateVolLoop(PVector volLoopFile, PVector timer) {
            float volLoop = volLoopFile.x;
            float objLoop = volLoopFile.y;
            float lastUpdate = timer.x;
            float nextTimer = timer.y;
            if ((float)LDQR_Monitoring_noCache.this.millis() < nextTimer) {
                float diff = LDQR_Monitoring_noCache.abs((float)(volLoop - objLoop));
                float timeToReachObj = nextTimer - (float)LDQR_Monitoring_noCache.this.millis();
                float incrementByMs = diff / timeToReachObj;
                float deltaUpdate = (float)LDQR_Monitoring_noCache.this.millis() - lastUpdate;
                float update = incrementByMs * deltaUpdate;
                if (diff > 0.1f) {
                    if (objLoop > volLoop) {
                        if ((volLoop += update) > 100.0f) {
                            volLoop = 100.0f;
                        }
                    } else if (objLoop < volLoop && (volLoop -= update) < 0.0f) {
                        volLoop = 0.0f;
                    }
                }
            }
            timer.x = LDQR_Monitoring_noCache.this.millis();
            volLoopFile.x = volLoop;
        }

        public void startSoundFiles() {
            this.BoucleChien.amp(0.0f);
            this.BoucleMouettes.amp(0.0f);
            this.Ocean1.amp(0.0f);
            this.BoucleChien.loop();
            this.BoucleMouettes.loop();
            this.Ocean1.loop();
        }
    }

    class Page6 {
        int rows = 7;
        int cols = 6;
        int square_Width;
        int offset;
        Square[][] squares;
        SoundFile[] events;
        SoundFile loopBoat;
        IntList events_Order;
        float volLoopBoat;
        float objLoopBoat;
        int fadein_timer;
        int fadeout_timer;
        float nextTimer;
        float lastUpdate;
        boolean fadeIn;
        int scoreTouched;
        int lastScoreTouched;
        int lastMove;
        int delta;
        int deltaEvent;
        int lastEvent;
        int indexEvent;
        boolean moving;
        boolean lastStateMoving;
        boolean quit;

        Page6(PApplet p) {
            this.square_Width = LDQR_Monitoring_noCache.this.width / 8;
            this.offset = LDQR_Monitoring_noCache.this.width / 8;
            this.squares = new Square[this.cols][this.rows];
            this.volLoopBoat = 0.0f;
            this.objLoopBoat = 0.0f;
            this.fadein_timer = 1000;
            this.fadeout_timer = 1000;
            this.nextTimer = 0.0f;
            this.lastUpdate = 0.0f;
            this.fadeIn = false;
            this.lastMove = 0;
            this.delta = 2000;
            this.deltaEvent = 3000;
            this.lastEvent = 0;
            this.indexEvent = 0;
            int i = 0;
            while (i < this.cols) {
                int j = 0;
                while (j < this.rows) {
                    this.squares[i][j] = new Square(this.offset + i * this.square_Width, this.offset / 2 + j * this.square_Width, this.square_Width, 1 + (i + j * this.cols), LDQR_Monitoring_noCache.this.page6OSC_computed, i + j * this.cols, 1, 6);
                    ++j;
                }
                ++i;
            }
            this.loopBoat = new SoundFile(p, "P6/PLANCHE06_boucleclapotisbateau.wav", false);
            this.events = new SoundFile[10];
            this.events[0] = new SoundFile(p, "P6/PLANCHE06avion.wav", false);
            this.events[1] = new SoundFile(p, "P6/PLANCHE06Baleines.wav", false);
            this.events[2] = new SoundFile(p, "P6/PLANCHE06Cormorants.wav", false);
            this.events[3] = new SoundFile(p, "P6/PLANCHE06Dauphins.wav", false);
            this.events[4] = new SoundFile(p, "P6/PLANCHE06Fousdebassan.wav", false);
            this.events[5] = new SoundFile(p, "P6/PLANCHE06Grossevague.wav", false);
            this.events[6] = new SoundFile(p, "P6/PLANCHE06Paquebot.wav", false);
            this.events[7] = new SoundFile(p, "P6/PLANCHE06Ploufaboiement.wav", false);
            this.events[8] = new SoundFile(p, "P6/PLANCHE06ploufgrognement.wav", false);
            this.events[9] = new SoundFile(p, "P6/MARINS.wav");
            this.events_Order = new IntList();
            i = 0;
            while (i < 10) {
                this.events_Order.append(i);
                ++i;
            }
            this.events_Order.shuffle();
            this.loopBoat.amp(0.0f);
            this.loopBoat.loop();
        }

        public void draw(boolean _quit) {
            this.quit = _quit;
            if (!this.quit) {
                this.scoreTouched = 0;
                int i = 0;
                while (i < this.cols) {
                    int j = 0;
                    while (j < this.rows) {
                        this.squares[i][j].draw();
                        if (this.squares[i][j].checkMouseOver() != 0) {
                            this.scoreTouched += this.squares[i][j].checkMouseOver();
                        }
                        ++j;
                    }
                    ++i;
                }
                if (this.lastScoreTouched != this.scoreTouched && this.scoreTouched > 0) {
                    this.lastMove = LDQR_Monitoring_noCache.this.millis();
                    this.moving = true;
                }
                if (LDQR_Monitoring_noCache.this.millis() - this.lastMove > this.delta && this.moving) {
                    this.moving = false;
                }
                this.playBoat();
                if (this.moving && LDQR_Monitoring_noCache.this.millis() - this.lastEvent > this.deltaEvent && !this.events[this.indexEvent].isPlaying()) {
                    this.events[this.events_Order.get(this.indexEvent)].play();
                    if (this.indexEvent == 9) {
                        this.events_Order.shuffle();
                    }
                    this.deltaEvent = PApplet.parseInt((float)LDQR_Monitoring_noCache.this.random(10000.0f, 15000.0f));
                    ++this.indexEvent;
                    this.indexEvent %= this.events.length;
                    this.lastEvent = LDQR_Monitoring_noCache.this.millis();
                }
                this.lastScoreTouched = this.scoreTouched;
            } else {
                this.moving = false;
                int i = 0;
                while (i < 10) {
                    this.events[i].stop();
                    ++i;
                }
                this.playBoat();
            }
        }

        public void updateVolLoop() {
            float diff = LDQR_Monitoring_noCache.abs((float)(this.volLoopBoat - this.objLoopBoat));
            float timeToReachObj = this.nextTimer - (float)LDQR_Monitoring_noCache.this.millis();
            float incrementByMs = diff / timeToReachObj;
            float deltaUpdate = (float)LDQR_Monitoring_noCache.this.millis() - this.lastUpdate;
            float update = incrementByMs * deltaUpdate;
            if (diff > 0.1f) {
                if (this.objLoopBoat > this.volLoopBoat) {
                    this.volLoopBoat += update;
                    if (this.volLoopBoat > 100.0f) {
                        this.volLoopBoat = 100.0f;
                    }
                } else if (this.objLoopBoat < this.volLoopBoat) {
                    this.volLoopBoat -= update;
                    if (this.volLoopBoat < 0.0f) {
                        this.volLoopBoat = 0.0f;
                    }
                }
            }
            this.lastUpdate = LDQR_Monitoring_noCache.this.millis();
        }

        public void playBoat() {
            if (!this.lastStateMoving && this.moving) {
                this.fadeIn = true;
                this.lastMove = LDQR_Monitoring_noCache.this.millis();
                this.moving = true;
                if ((float)LDQR_Monitoring_noCache.this.millis() > this.nextTimer) {
                    this.lastUpdate = LDQR_Monitoring_noCache.this.millis();
                    this.nextTimer = LDQR_Monitoring_noCache.this.millis() + this.fadein_timer;
                }
                this.lastStateMoving = true;
            } else if (this.lastStateMoving && this.moving) {
                this.lastStateMoving = true;
            } else if (!this.moving && this.lastStateMoving) {
                this.fadeIn = false;
                this.moving = false;
                if ((float)LDQR_Monitoring_noCache.this.millis() > this.nextTimer) {
                    this.nextTimer = LDQR_Monitoring_noCache.this.millis() + this.fadeout_timer;
                    this.lastUpdate = LDQR_Monitoring_noCache.this.millis();
                }
                this.lastStateMoving = false;
            }
            this.objLoopBoat = this.fadeIn ? 100.0f : 0.0f;
            if (this.nextTimer > (float)LDQR_Monitoring_noCache.this.millis()) {
                this.updateVolLoop();
            }
            float mappedVolBoat = LDQR_Monitoring_noCache.this.map2(this.volLoopBoat, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
            this.loopBoat.amp(mappedVolBoat);
        }
    }

    class Square {
        float square_x;
        float square_y;
        float square_width;
        boolean mouseOver;
        int id;
        int[] OSCArray;
        int indexArray;
        int lim;
        int thePage;

        Square(float _x, float _y, float _width, int _id, int[] _OSCArray, int _indexArray, int _lim, int _thePage) {
            this.square_x = _x;
            this.square_y = _y;
            this.square_width = _width;
            this.id = _id;
            this.OSCArray = _OSCArray;
            this.indexArray = _indexArray;
            this.lim = _lim;
            this.thePage = _thePage;
            LDQR_Monitoring_noCache.this.textAlign(3);
        }

        public void draw() {
            if (this.mouseOver || this.OSCArray[this.indexArray] > this.lim) {
                LDQR_Monitoring_noCache.this.fill(125);
            } else {
                LDQR_Monitoring_noCache.this.fill(220);
            }
            LDQR_Monitoring_noCache.this.stroke(255);
            LDQR_Monitoring_noCache.this.strokeWeight(1.0f);
            LDQR_Monitoring_noCache.this.rect(this.square_x, this.square_y, this.square_width, this.square_width);
            LDQR_Monitoring_noCache.this.fill(0);
            LDQR_Monitoring_noCache.this.text(this.id, this.square_x + this.square_width / 2.0f, this.square_y + this.square_width / 2.0f);
        }

        public int checkMouseOver() {
            if ((float)LDQR_Monitoring_noCache.this.mouseX > this.square_x && (float)LDQR_Monitoring_noCache.this.mouseX < this.square_x + this.square_width && (float)LDQR_Monitoring_noCache.this.mouseY > this.square_y && (float)LDQR_Monitoring_noCache.this.mouseY < this.square_y + this.square_width || this.OSCArray[this.indexArray] > this.lim) {
                this.mouseOver = true;
                if (LDQR_Monitoring_noCache.this.record) {
                    TableRow row = LDQR_Monitoring_noCache.this.table.addRow();
                    row.setString("time", this.MsConversion(LDQR_Monitoring_noCache.this.millis() - LDQR_Monitoring_noCache.this.recordStart));
                    row.setInt("page", this.thePage);
                    row.setInt("sensor", this.id);
                }
                return this.id;
            }
            this.mouseOver = false;
            return 0;
        }

        public String MsConversion(int MS) {
            int cfr_ignored_0 = MS / 1000;
            int seconds = MS / 1000 % 60;
            int minutes = MS / 60000 % 60;
            int hours = MS / 3600000 % 24;
            String HumanTime = String.valueOf(hours) + ": " + minutes + ": " + seconds;
            return HumanTime;
        }
    }
}

