import processing.sound.*;
import oscP5.*;
import netP5.*;

OscP5 oscP5;
NetAddress myRemoteLocation;

//OSC
//Hall effect, 1/page
int hallPage1, hallPage2, hallPage3, hallPage4, hallPage5, hallPage6;
int hallArray[] = new int[6];

//Page 1, planète et whell
int[] page1OSC = new int[16];

//Page 2, fenetres
int[] page2OSC = new int[4];
int[] page2OSC_computed = new int[2];

//Page 3, tapis
int[] page3OSC = new int[4];
int[] page3OSC_computed = new int[2];

//Page4, flaques
int[] page4OSC = new int[3];

//Page5, iles
int[] page5OSC = new int[3];

//Page6, ocean
int[] page6OSC = new int[13];
int[] page6OSC_computed = new int[42];
int[] Page6_rows =new int[7];
int[] Page6_cols = new int [6];

PFont f;

/* The map2() function supports the following easing types */
final int LINEAR = 0;
final int QUADRATIC = 1;
final int CUBIC = 2;
final int QUARTIC = 3;
final int QUINTIC = 4;
final int SINUSOIDAL = 5;
final int EXPONENTIAL = 6;
final int CIRCULAR = 7;
final int SQRT = 8;

/* When the easing is applied (in, out, or both) */
final int EASE_IN = 0;
final int EASE_OUT = 1;
final int EASE_IN_OUT = 2;

int state = 0;
Page1 page1;
Page2 page2;
Page3 page3;
Page4 page4;
Page5 page5;
Page6 page6;

int lastPageChange;
int recordStart;

boolean hideOSC = false;
boolean listenHallEffect = true;
boolean record = false;
boolean lastRecordState = false;

// A Table object
Table table;
File fileMy = new File("record.csv");

void setup()
{
  size(800, 800);

  /* start oscP5, listening for incoming messages at port 12000 */
  oscP5 = new OscP5(this, 12000);
  /* send an OSC message to this sketch */
  hallPage1 = 3;
  hallPage2 = 3;
  hallPage3 = 3;
  hallPage4 = 3;
  hallPage5 = 3;
  hallPage6 = 3;

  f = createFont("SourceCodePro-Regular.ttf", 12);
  textFont(f);


  background(255, 248, 196);
  page1 = new Page1(this);
  page2 = new Page2(this);
  page3 = new Page3(this);
  page4 = new Page4(this);
  page5 = new Page5(this);
  page6 = new Page6(this);
  
  table = new Table();
  table.addColumn("time");
  table.addColumn("page");
  table.addColumn("sensor");
  
}

void drawOSC()
{
  textAlign(LEFT);
  stroke(255);
  fill(fillHall(hallPage1));
  rect(20, 20, 10, 10);
  fill(fillHall(hallPage2));
  rect(40, 20, 10, 10);
  fill(fillHall(hallPage3));
  rect(60, 20, 10, 10);
  fill(fillHall(hallPage4));
  rect(80, 20, 10, 10);
  fill(fillHall(hallPage5));
  rect(100, 20, 10, 10);
  fill(fillHall(hallPage6));
  rect(120, 20, 10, 10);
  fill(255);
  text("Capteurs effet hall", 140, 30);

  //Page 1
  String sensorsPage1 = "";
  for (int i =0; i<page1OSC.length; i++)
  {
    sensorsPage1 += page1OSC[i];
    sensorsPage1 += " ";
  }
  text("Page 1: "+sensorsPage1, 20, 60);

  //Page 2
  String sensorsPage2 = "";
  for (int i =0; i<page2OSC.length; i++)
  {
    sensorsPage2 += page2OSC[i];
    sensorsPage2 += " ";
  }
  text("Page 2: "+sensorsPage2, 20, 90);

  //Page 3
  String sensorsPage3 = "";
  for (int i =0; i<page3OSC.length; i++)
  {
    sensorsPage3 += page3OSC[i];
    sensorsPage3 += " ";
  }
  text("Page 3: "+sensorsPage3, 20, 120);

  //Page 4
  String sensorsPage4 = "";
  for (int i =0; i<page4OSC.length; i++)
  {
    sensorsPage4 += page4OSC[i];
    sensorsPage4 += " ";
  }
  text("Page 4: "+sensorsPage4, 20, 150);

  //Page 5
  String sensorsPage5 = "";
  for (int i =0; i<page5OSC.length; i++)
  {
    sensorsPage5 += page5OSC[i];
    sensorsPage5 += " ";
  }
  text("Page 5: "+sensorsPage5, 20, 180);

  //Page 6
  String sensorsPage6 = "";
  for (int i =0; i<page6OSC.length; i++)
  {
    sensorsPage6 += page6OSC[i];
    sensorsPage6 += " ";
  }
  text("Page 6: "+sensorsPage6, 20, 210);
  text("---------------------------", 20, 240);
  text("[H] pour afficher / masquer", 20, 270);
}

void drawText()
{
  fill(0);
  noStroke();
  rect(10, 320, width-20, 620-360+50);
  textAlign(LEFT);
  fill(255);
  text("-------------------------------------------------------", 20, 330);
  text("Les Doigts qui rêvent - Kapi Capitaine - v0.1 - 03/2021", 20, 360);
  text("-------------------------------------------------------", 20, 390);
  text("Pour lier le livre à l'application, connecter l'ordinateur", 20, 410);
  text("au réseau KAPI_WIFI avec le mot de passe KAPI_WIFI.", 20, 440);
  text("Branchez les enceintes à l'ordinateur et activez le son.", 20, 470);
  text("Les événements du livre peuvent être déclenchés en parallèle avec la souris en survolant ", 20, 500);
  text("les zones interactives à l'écran.", 20, 530);
  text(" ", 20, 560);
  text("[C] Activer/désactiver la naivigation dans les pages (avec les touches de [1] à [6]", 20, 590);
  text("[R] Enregistrer les événements dans un tableau en CSV.", 20, 620);
}


void draw()
{
  background(50);

  if (listenHallEffect)
  {
    //Check Hall effect sensors 
    int numHallEffects = 0;
    // D'abord, vérification qu'il n'y a bien qu'un seul capteur sans aimant
    for (int i =0; i<6; i++)
    {
      numHallEffects+=hallArray[i];
    }
    //////println(numHallEffects);
    // Une seule page est ouverte
    if (numHallEffects == 1)
    {
      for (int i =0; i<6; i++)
      {
        if (hallArray[i] == 1) state = (i+1)*10;
      }
    }
  }
  switch (state)
  {
  case 0:
    drawText();
    break;
    // entre parenthèses, true = quit

    //PAGE 1
  case 10:
    page1.draw(false);
    page2.draw(true);
    page3.draw(true);
    page4.draw(true);
    page5.draw(true);
    page6.draw(true);

    break;


    //PAGE 2
  case 20:
    page1.draw(true);
    page2.draw(false);
    page3.draw(true);
    page4.draw(true);
    page5.draw(true);
    page6.draw(true);
    break;


    //PAGE 3
  case 30:
    page1.draw(true);
    page2.draw(true);
    page3.draw(false);
    page4.draw(true);
    page5.draw(true);
    page6.draw(true);
    break;


    //PAGE 4
  case 40:
    page1.draw(true);
    page2.draw(true);
    page3.draw(true);
    page4.draw(false);
    page5.draw(true);
    page6.draw(true);

    break;


    //PAGE 5
  case 50:
    page1.draw(true);
    page2.draw(true);
    page3.draw(true);
    page4.draw(true);
    page5.draw(false);
    page6.draw(true);
    break;


    //PAGE 6
  case 60:
    page1.draw(true);
    page2.draw(true);
    page3.draw(true);
    page4.draw(true);
    page5.draw(true);
    page6.draw(false);
    break;
  }

  //OSC monitor
  if (!hideOSC) drawOSC();
  fill(255);
  textAlign(LEFT);
  if (listenHallEffect) 
  {
    text("[ Détection de la page ouverte du livre ] [C]   Navigation manuelle, touches [1] à [6]  ", 20, height - 20 );
  } else {
    text("  Détection de la page ouverte du livre   [C] [ Navigation manuelle, touches [1] à [6] ]", 20, height - 20 );
  }
  if (record == false) 
  {
    fill(0);
    rect(20, height - 65, 20, 20);
    fill(255);   
    text("[R] - Pour commencer l'enregistrement", 50, height - 50 );
  } else {
    fill(255,0,0);
    rect(20, height - 65, 20, 20);
    fill(255);   
    text("[R] - Pour stopper l'enregistrement", 50, height - 50 );
  }
  
  
}



void keyPressed()
{
  lastPageChange = millis();
  if (listenHallEffect == false)
  {
    switch (int(key)-48)
    {
    case 0:
      break;

      //PAGE 1
    case 1:
      ////println("Page 1");
      state = 10;
      break;


      //PAGE 2
    case 2:
      ////println("Page 2");
      state = 20;
      break;


      //PAGE 3
    case 3:
      ////println("Page 3");
      state = 30;
      break;


      //PAGE 4
    case 4:
      ////println("Page 4");
      state = 40;
      break;


      //PAGE 5
    case 5:
      ////println("Page 5");
      state = 50;
      break;


      //PAGE 6
    case 6:
      ////println("Page 6");
      state = 60;
      break;
    }
  }

  if (key == 'h' || key == 'H')hideOSC = !hideOSC;
  if (key == 'c' || key == 'C')listenHallEffect = !listenHallEffect;
  if (key == 'r' || key == 'R')
  {
    if (record == false)
    {
      record = true;
      recordStart = millis();
      lastRecordState = true;
    } else if (record == true)
    {
      record = false;
      lastRecordState = true;
    }
    if (lastRecordState == true && record == false) // on était en traion d'enregistrer
    {
      selectOutput("Select a file to write to:", "fileSelected", fileMy);
    }
  }
}

void fileSelected(File selection) {
  if (selection == null) {
    ////println("Window was closed or the user hit cancel.");
  } else {
    ////println("User selected " + selection.getAbsolutePath());
    saveTable(table, selection.getAbsolutePath());
  }
}

int fillHall(int hallState) {
  int theColor = 0;
  switch (hallState)
  {
  case 0:
    theColor = 255;
    break;

  case 1:
    theColor = 125;
    break;

  default:
    theColor = 0;
    break;
  }
  return theColor;
}

void oscEvent(OscMessage theOscMessage) {
  ////println(theOscMessage);
  if (theOscMessage.checkAddrPattern("/page1")==true) {
    hallPage1 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[0] = hallPage1;
    for (int i =0; i<page1OSC.length; i++)
    {
      page1OSC[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page2")==true) {
    for (int i =0; i<page2OSC.length; i++)
    {
      page2OSC[i] = theOscMessage.get(i+1).intValue();
    }
    // We compute value of both sensors
    page2OSC_computed[0] = min(page2OSC[0], page2OSC[1]);
    page2OSC_computed[1] = min(page2OSC[2], page2OSC[3]);

    hallPage2 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[1] = hallPage2;
    return;
  } else if (theOscMessage.checkAddrPattern("/page3")==true) {
    hallPage3 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[2] = hallPage3;
    for (int i =0; i<page3OSC.length; i++)
    {
      page3OSC[i] = theOscMessage.get(i+1).intValue();
    }
    // on fusionne les valeurs des zones du tapis
    page3OSC_computed[0] = max(page3OSC[1], page3OSC[2]);
    page3OSC_computed[1] = max(page3OSC[0], page3OSC[3]);

    return;
  } else if (theOscMessage.checkAddrPattern("/page4")==true) {
    hallPage4 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[3] = hallPage4;
    for (int i =0; i<page4OSC.length; i++)
    {
      page4OSC[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page5")==true) {
    hallPage5 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[4] = hallPage5;
    for (int i =0; i<page5OSC.length; i++)
    {
      page5OSC[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page6")==true) {
    hallPage6 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[5] = hallPage6;
    for (int i =0; i<page6OSC.length; i++)
    {
      page6OSC[i] = theOscMessage.get(i+1).intValue();
      /*
      */

      if (i<7)
      {
        Page6_rows[i] = page6OSC[i];
      } else {
        Page6_cols[i-7] = page6OSC[i];
      }
    }


    // On interpole les colonnes et les lignes pour reconstiteur les points de croisements
    for (int i =0; i<Page6_cols.length; i++)
    {
      for (int j=0; j<Page6_rows.length; j++)
      {
        page6OSC_computed[i+j*Page6_cols.length]= min( Page6_cols[i], Page6_rows[j]);
      }
    }


    return;
  }
}


/*
 * A map() replacement that allows for specifying easing curves
 * with arbitrary exponents.
 *
 * value :   The value to map
 * start1:   The lower limit of the input range
 * stop1 :   The upper limit of the input range
 * start2:   The lower limit of the output range
 * stop2 :   The upper limit of the output range
 * type  :   The type of easing (see above)
 * when  :   One of EASE_IN, EASE_OUT, or EASE_IN_OUT
 */
float map2(float value, float start1, float stop1, float start2, float stop2, int type, int when) {
  float b = start2;
  float c = stop2 - start2;
  float t = value - start1;
  float d = stop1 - start1;
  float p = 0.5;
  switch (type) {
  case LINEAR:
    return c*t/d + b;
  case SQRT:
    if (when == EASE_IN) {
      t /= d;
      return c*pow(t, p) + b;
    } else if (when == EASE_OUT) {
      t /= d;
      return c * (1 - pow(1 - t, p)) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*pow(t, p) + b;
      return c/2 * (2 - pow(2 - t, p)) + b;
    }
    break;
  case QUADRATIC:
    if (when == EASE_IN) {
      t /= d;
      return c*t*t + b;
    } else if (when == EASE_OUT) {
      t /= d;
      return -c * t*(t-2) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*t*t + b;
      t--;
      return -c/2 * (t*(t-2) - 1) + b;
    }
    break;
  case CUBIC:
    if (when == EASE_IN) {
      t /= d;
      return c*t*t*t + b;
    } else if (when == EASE_OUT) {
      t /= d;
      t--;
      return c*(t*t*t + 1) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*t*t*t + b;
      t -= 2;
      return c/2*(t*t*t + 2) + b;
    }
    break;
  case QUARTIC:
    if (when == EASE_IN) {
      t /= d;
      return c*t*t*t*t + b;
    } else if (when == EASE_OUT) {
      t /= d;
      t--;
      return -c * (t*t*t*t - 1) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*t*t*t*t + b;
      t -= 2;
      return -c/2 * (t*t*t*t - 2) + b;
    }
    break;
  case QUINTIC:
    if (when == EASE_IN) {
      t /= d;
      return c*t*t*t*t*t + b;
    } else if (when == EASE_OUT) {
      t /= d;
      t--;
      return c*(t*t*t*t*t + 1) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*t*t*t*t*t + b;
      t -= 2;
      return c/2*(t*t*t*t*t + 2) + b;
    }
    break;
  case SINUSOIDAL:
    if (when == EASE_IN) {
      return -c * cos(t/d * (PI/2)) + c + b;
    } else if (when == EASE_OUT) {
      return c * sin(t/d * (PI/2)) + b;
    } else if (when == EASE_IN_OUT) {
      return -c/2 * (cos(PI*t/d) - 1) + b;
    }
    break;
  case EXPONENTIAL:
    if (when == EASE_IN) {
      return c * pow( 2, 10 * (t/d - 1) ) + b;
    } else if (when == EASE_OUT) {
      return c * ( -pow( 2, -10 * t/d ) + 1 ) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2 * pow( 2, 10 * (t - 1) ) + b;
      t--;
      return c/2 * ( -pow( 2, -10 * t) + 2 ) + b;
    }
    break;
  case CIRCULAR:
    if (when == EASE_IN) {
      t /= d;
      return -c * (sqrt(1 - t*t) - 1) + b;
    } else if (when == EASE_OUT) {
      t /= d;
      t--;
      return c * sqrt(1 - t*t) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return -c/2 * (sqrt(1 - t*t) - 1) + b;
      t -= 2;
      return c/2 * (sqrt(1 - t*t) + 1) + b;
    }
    break;
  };
  return 0;
}

/*
 * A map() replacement that allows for specifying easing curves
 * with arbitrary exponents.
 *
 * value :   The value to map
 * start1:   The lower limit of the input range
 * stop1 :   The upper limit of the input range
 * start2:   The lower limit of the output range
 * stop2 :   The upper limit of the output range
 * v     :   The exponent value (e.g., 0.5, 0.1, 0.3)
 * when  :   One of EASE_IN, EASE_OUT, or EASE_IN_OUT
 */
float map3(float value, float start1, float stop1, float start2, float stop2, float v, int when) {
  float b = start2;
  float c = stop2 - start2;
  float t = value - start1;
  float d = stop1 - start1;
  float p = v;
  float out = 0;
  if (when == EASE_IN) {
    t /= d;
    out = c*pow(t, p) + b;
  } else if (when == EASE_OUT) {
    t /= d;
    out = c * (1 - pow(1 - t, p)) + b;
  } else if (when == EASE_IN_OUT) {
    t /= d/2;
    if (t < 1) return c/2*pow(t, p) + b;
    out = c/2 * (2 - pow(2 - t, p)) + b;
  }
  return out;
}
