/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.AudioTrack;
import com.jsyn.devices.AudioDeviceInputStream;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.devices.AudioDeviceOutputStream;

class JSynAndroidAudioDeviceManager
implements AudioDeviceManager {
    private static String[] ANDROIDDEVICENAMES = new String[]{"default", "mic", "voice uplink", "voice downlink", "voice call", "camcorder", "voice recognition", "voice communication", "remote submix", "unprocessed", "voice performance"};
    private double suggestedOutputLatency = 0.1;
    private double suggestedInputLatency = 0.1;

    JSynAndroidAudioDeviceManager() {
    }

    public String getName() {
        return "JSyn Android Audio for Processing Sound";
    }

    public AudioDeviceOutputStream createOutputStream(int n, int n2, int n3) {
        return new AndroidAudioOutputStream(n, n2, n3);
    }

    public AudioDeviceInputStream createInputStream(int n, int n2, int n3) {
        return new AndroidAudioInputStream(n, n2, n3);
    }

    public double getDefaultHighInputLatency(int n) {
        return 0.3;
    }

    public double getDefaultHighOutputLatency(int n) {
        return 0.3;
    }

    public int getDefaultInputDeviceID() {
        return 0;
    }

    public int getDefaultOutputDeviceID() {
        return 0;
    }

    public double getDefaultLowInputLatency(int n) {
        return 0.1;
    }

    public double getDefaultLowOutputLatency(int n) {
        return 0.1;
    }

    public int getDeviceCount() {
        return ANDROIDDEVICENAMES.length;
    }

    public String getDeviceName(int n) {
        return "Android " + ANDROIDDEVICENAMES[n] + " input";
    }

    public int getMaxInputChannels(int n) {
        return 1;
    }

    public int getMaxOutputChannels(int n) {
        return 2;
    }

    public int setSuggestedOutputLatency(double d) {
        this.suggestedOutputLatency = d;
        return 0;
    }

    public int setSuggestedInputLatency(double d) {
        this.suggestedInputLatency = d;
        return 0;
    }

    private class AndroidAudioInputStream
    extends AndroidAudioStream
    implements AudioDeviceInputStream {
        private AudioRecord audioRecord;

        public AndroidAudioInputStream(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        public void start() {
            this.minBufferSize = AudioRecord.getMinBufferSize((int)this.frameRate, (int)12, (int)2);
            this.bufferSize = 3 * (this.minBufferSize / 2) & 0xFFFFFFFC;
            try {
                this.audioRecord = new AudioRecord.Builder().setAudioSource(this.deviceID).setAudioFormat(new AudioFormat.Builder().setChannelMask(16).setEncoding(2).setSampleRate(this.frameRate).build()).setBufferSizeInBytes(this.bufferSize).build();
                this.audioRecord.startRecording();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }

        public double read() {
            double[] dArray = new double[1];
            this.read(dArray, 0, 1);
            return dArray[0];
        }

        public int read(double[] dArray) {
            return this.read(dArray, 0, dArray.length);
        }

        public int read(double[] dArray, int n, int n2) {
            int n3;
            if (this.audioRecord == null) {
                return 0;
            }
            if (this.shortBuffer == null || this.shortBuffer.length < n2) {
                this.shortBuffer = new short[n2];
            }
            if ((n3 = this.audioRecord.read(this.shortBuffer, 0, n2, 1)) < 0) {
                switch (n3) {
                    case -3: {
                        throw new RuntimeException("AudioRecord ERROR_INVALID_OPERATION: Device not properly initialized");
                    }
                    case -2: {
                        throw new RuntimeException("AudioRecord ERROR_BAD_VALUE: Paramters don't resolve to valid data and indices");
                    }
                    case -6: {
                        throw new RuntimeException("AudioRecord ERROR_DEAD_OBJECT: Object must be recreated");
                    }
                    case -1: {
                        throw new RuntimeException("AudioRecord ERROR: Unknown error");
                    }
                }
            }
            for (int i = 0; i < n3; ++i) {
                dArray[i + n] = (double)this.shortBuffer[i] / 32767.0;
            }
            return n3;
        }

        public void stop() {
            if (this.audioRecord != null) {
                this.audioRecord.stop();
                this.audioRecord.release();
            }
        }

        public int available() {
            return this.bufferSize;
        }

        public void close() {
        }
    }

    private class AndroidAudioOutputStream
    extends AndroidAudioStream
    implements AudioDeviceOutputStream {
        AudioTrack audioTrack;

        public AndroidAudioOutputStream(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        public void start() {
            this.minBufferSize = AudioTrack.getMinBufferSize((int)this.frameRate, (int)12, (int)2);
            this.bufferSize = 3 * (this.minBufferSize / 2) & 0xFFFFFFFC;
            this.audioTrack = new AudioTrack.Builder().setAudioAttributes(new AudioAttributes.Builder().setUsage(1).setContentType(2).build()).setAudioFormat(new AudioFormat.Builder().setChannelMask(12).setEncoding(2).setSampleRate(this.frameRate).build()).setBufferSizeInBytes(this.bufferSize).setTransferMode(1).build();
            this.audioTrack.play();
        }

        public void write(double d) {
            double[] dArray = new double[]{d};
            this.write(dArray, 0, 1);
        }

        public void write(double[] dArray) {
            this.write(dArray, 0, dArray.length);
        }

        public void write(double[] dArray, int n, int n2) {
            if (this.shortBuffer == null || this.shortBuffer.length < n2) {
                this.shortBuffer = new short[n2];
            }
            for (int i = 0; i < n2; ++i) {
                int n3 = (int)(32767.0 * dArray[i + n]);
                if (n3 > Short.MAX_VALUE) {
                    n3 = Short.MAX_VALUE;
                } else if (n3 < Short.MIN_VALUE) {
                    n3 = Short.MIN_VALUE;
                }
                this.shortBuffer[i] = (short)n3;
            }
            this.audioTrack.write(this.shortBuffer, 0, n2);
        }

        public void stop() {
            if (this.audioTrack != null) {
                this.audioTrack.stop();
                this.audioTrack.release();
            }
        }

        public void close() {
        }
    }

    private class AndroidAudioStream {
        protected short[] shortBuffer;
        protected int frameRate;
        protected int samplesPerFrame;
        protected int minBufferSize;
        protected int bufferSize;
        protected int deviceID;

        public AndroidAudioStream(int n, int n2, int n3) {
            this.deviceID = n;
            this.frameRate = n2;
            this.samplesPerFrame = n3;
        }

        public double getLatency() {
            int n = this.bufferSize / this.samplesPerFrame;
            return (double)n / (double)this.frameRate;
        }
    }
}

