import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import processing.sound.*; 
import oscP5.*; 
import netP5.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class LDQR_Monitoring extends PApplet {





OscP5 oscP5;
NetAddress myRemoteLocation;

//OSC
//Hall effect, 1/page
int hallPage1, hallPage2, hallPage3, hallPage4, hallPage5, hallPage6;
int hallArray[] = new int[6];

//Page 1, planète et whell
int[] page1OSC = new int[16];

//Page 2, fenetres
int[] page2OSC = new int[4];
int[] page2OSC_computed = new int[2];

//Page 3, tapis
int[] page3OSC = new int[4];
int[] page3OSC_computed = new int[2];

//Page4, flaques
int[] page4OSC = new int[3];

//Page5, iles
int[] page5OSC = new int[3];

//Page6, ocean
int[] page6OSC = new int[13];
int[] page6OSC_computed = new int[42];
int[] Page6_rows =new int[7];
int[] Page6_cols = new int [6];

PFont f;

/* The map2() function supports the following easing types */
final int LINEAR = 0;
final int QUADRATIC = 1;
final int CUBIC = 2;
final int QUARTIC = 3;
final int QUINTIC = 4;
final int SINUSOIDAL = 5;
final int EXPONENTIAL = 6;
final int CIRCULAR = 7;
final int SQRT = 8;

/* When the easing is applied (in, out, or both) */
final int EASE_IN = 0;
final int EASE_OUT = 1;
final int EASE_IN_OUT = 2;

int state = 0;
Page1 page1;
Page2 page2;
Page3 page3;
Page4 page4;
Page5 page5;
Page6 page6;

int lastPageChange;
int recordStart;

boolean hideOSC = false;
boolean listenHallEffect = true;
boolean record = false;
boolean lastRecordState = false;

// A Table object
Table table;
File fileMy = new File("record.csv");

public void setup()
{
  

  /* start oscP5, listening for incoming messages at port 12000 */
  oscP5 = new OscP5(this, 12000);
  /* send an OSC message to this sketch */
  hallPage1 = 3;
  hallPage2 = 3;
  hallPage3 = 3;
  hallPage4 = 3;
  hallPage5 = 3;
  hallPage6 = 3;

  f = createFont("SourceCodePro-Regular.ttf", 12);
  textFont(f);


  background(255, 248, 196);
  page1 = new Page1(this);
  page2 = new Page2(this);
  page3 = new Page3(this);
  page4 = new Page4(this);
  page5 = new Page5(this);
  page6 = new Page6(this);
  
  table = new Table();
  table.addColumn("time");
  table.addColumn("page");
  table.addColumn("sensor");
  
}

public void drawOSC()
{
  textAlign(LEFT);
  stroke(255);
  fill(fillHall(hallPage1));
  rect(20, 20, 10, 10);
  fill(fillHall(hallPage2));
  rect(40, 20, 10, 10);
  fill(fillHall(hallPage3));
  rect(60, 20, 10, 10);
  fill(fillHall(hallPage4));
  rect(80, 20, 10, 10);
  fill(fillHall(hallPage5));
  rect(100, 20, 10, 10);
  fill(fillHall(hallPage6));
  rect(120, 20, 10, 10);
  fill(255);
  text("Capteurs effet hall", 140, 30);

  //Page 1
  String sensorsPage1 = "";
  for (int i =0; i<page1OSC.length; i++)
  {
    sensorsPage1 += page1OSC[i];
    sensorsPage1 += " ";
  }
  text("Page 1: "+sensorsPage1, 20, 60);

  //Page 2
  String sensorsPage2 = "";
  for (int i =0; i<page2OSC.length; i++)
  {
    sensorsPage2 += page2OSC[i];
    sensorsPage2 += " ";
  }
  text("Page 2: "+sensorsPage2, 20, 90);

  //Page 3
  String sensorsPage3 = "";
  for (int i =0; i<page3OSC.length; i++)
  {
    sensorsPage3 += page3OSC[i];
    sensorsPage3 += " ";
  }
  text("Page 3: "+sensorsPage3, 20, 120);

  //Page 4
  String sensorsPage4 = "";
  for (int i =0; i<page4OSC.length; i++)
  {
    sensorsPage4 += page4OSC[i];
    sensorsPage4 += " ";
  }
  text("Page 4: "+sensorsPage4, 20, 150);

  //Page 5
  String sensorsPage5 = "";
  for (int i =0; i<page5OSC.length; i++)
  {
    sensorsPage5 += page5OSC[i];
    sensorsPage5 += " ";
  }
  text("Page 5: "+sensorsPage5, 20, 180);

  //Page 6
  String sensorsPage6 = "";
  for (int i =0; i<page6OSC.length; i++)
  {
    sensorsPage6 += page6OSC[i];
    sensorsPage6 += " ";
  }
  text("Page 6: "+sensorsPage6, 20, 210);
  text("---------------------------", 20, 240);
  text("[H] pour afficher / masquer", 20, 270);
}

public void drawText()
{
  fill(0);
  noStroke();
  rect(10, 320, width-20, 620-360+50);
  textAlign(LEFT);
  fill(255);
  text("-------------------------------------------------------", 20, 330);
  text("Les Doigts qui rêvent - Kapi Capitaine - v0.1 - 03/2021", 20, 360);
  text("-------------------------------------------------------", 20, 390);
  text("Pour lier le livre à l'application, connecter l'ordinateur", 20, 410);
  text("au réseau KAPI_WIFI avec le mot de passe KAPI_WIFI.", 20, 440);
  text("Branchez les enceintes à l'ordinateur et activez le son.", 20, 470);
  text("Les événements du livre peuvent être déclenchés en parallèle avec la souris en survolant ", 20, 500);
  text("les zones interactives à l'écran.", 20, 530);
  text(" ", 20, 560);
  text("[C] Activer/désactiver la naivigation dans les pages (avec les touches de [1] à [6]", 20, 590);
  text("[R] Enregistrer les événements dans un tableau en CSV.", 20, 620);
}


public void draw()
{
  background(50);

  if (listenHallEffect)
  {
    //Check Hall effect sensors 
    int numHallEffects = 0;
    // D'abord, vérification qu'il n'y a bien qu'un seul capteur sans aimant
    for (int i =0; i<6; i++)
    {
      numHallEffects+=hallArray[i];
    }
    println(numHallEffects);
    // Une seule page est ouverte
    if (numHallEffects == 1)
    {
      for (int i =0; i<6; i++)
      {
        if (hallArray[i] == 1) state = (i+1)*10;
      }
    }
  }
  switch (state)
  {
  case 0:
    drawText();
    break;
    // entre parenthèses, true = quit

    //PAGE 1
  case 10:
    page1.draw(false);
    page2.draw(true);
    page3.draw(true);
    page4.draw(true);
    page5.draw(true);
    page6.draw(true);

    break;


    //PAGE 2
  case 20:
    page1.draw(true);
    page2.draw(false);
    page3.draw(true);
    page4.draw(true);
    page5.draw(true);
    page6.draw(true);
    break;


    //PAGE 3
  case 30:
    page1.draw(true);
    page2.draw(true);
    page3.draw(false);
    page4.draw(true);
    page5.draw(true);
    page6.draw(true);
    break;


    //PAGE 4
  case 40:
    page1.draw(true);
    page2.draw(true);
    page3.draw(true);
    page4.draw(false);
    page5.draw(true);
    page6.draw(true);

    break;


    //PAGE 5
  case 50:
    page1.draw(true);
    page2.draw(true);
    page3.draw(true);
    page4.draw(true);
    page5.draw(false);
    page6.draw(true);
    break;


    //PAGE 6
  case 60:
    page1.draw(true);
    page2.draw(true);
    page3.draw(true);
    page4.draw(true);
    page5.draw(true);
    page6.draw(false);
    break;
  }

  //OSC monitor
  if (!hideOSC) drawOSC();
  fill(255);
  textAlign(LEFT);
  if (listenHallEffect) 
  {
    text("[ Détection de la page ouverte du livre ] [C]   Navigation manuelle, touches [1] à [6]  ", 20, height - 20 );
  } else {
    text("  Détection de la page ouverte du livre   [C] [ Navigation manuelle, touches [1] à [6] ]", 20, height - 20 );
  }
  if (record == false) 
  {
    fill(0);
    rect(20, height - 65, 20, 20);
    fill(255);   
    text("[R] - Pour commencer l'enregistrement", 50, height - 50 );
  } else {
    fill(255,0,0);
    rect(20, height - 65, 20, 20);
    fill(255);   
    text("[R] - Pour stopper l'enregistrement", 50, height - 50 );
  }
  
  
}



public void keyPressed()
{
  lastPageChange = millis();
  if (listenHallEffect == false)
  {
    switch (PApplet.parseInt(key)-48)
    {
    case 0:
      break;

      //PAGE 1
    case 1:
      println("Page 1");
      state = 10;
      break;


      //PAGE 2
    case 2:
      println("Page 2");
      state = 20;
      break;


      //PAGE 3
    case 3:
      println("Page 3");
      state = 30;
      break;


      //PAGE 4
    case 4:
      println("Page 4");
      state = 40;
      break;


      //PAGE 5
    case 5:
      println("Page 5");
      state = 50;
      break;


      //PAGE 6
    case 6:
      println("Page 6");
      state = 60;
      break;
    }
  }

  if (key == 'h' || key == 'H')hideOSC = !hideOSC;
  if (key == 'c' || key == 'C')listenHallEffect = !listenHallEffect;
  if (key == 'r' || key == 'R')
  {
    if (record == false)
    {
      record = true;
      recordStart = millis();
      lastRecordState = true;
    } else if (record == true)
    {
      record = false;
      lastRecordState = true;
    }
    if (lastRecordState == true && record == false) // on était en traion d'enregistrer
    {
      selectOutput("Select a file to write to:", "fileSelected", fileMy);
    }
  }
}

public void fileSelected(File selection) {
  if (selection == null) {
    println("Window was closed or the user hit cancel.");
  } else {
    println("User selected " + selection.getAbsolutePath());
    saveTable(table, selection.getAbsolutePath());
  }
}

public int fillHall(int hallState) {
  int theColor = 0;
  switch (hallState)
  {
  case 0:
    theColor = 255;
    break;

  case 1:
    theColor = 125;
    break;

  default:
    theColor = 0;
    break;
  }
  return theColor;
}

public void oscEvent(OscMessage theOscMessage) {
  println(theOscMessage);
  if (theOscMessage.checkAddrPattern("/page1")==true) {
    hallPage1 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[0] = hallPage1;
    for (int i =0; i<page1OSC.length; i++)
    {
      page1OSC[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page2")==true) {
    for (int i =0; i<page2OSC.length; i++)
    {
      page2OSC[i] = theOscMessage.get(i+1).intValue();
    }
    // We compute value of both sensors
    page2OSC_computed[0] = min(page2OSC[0], page2OSC[1]);
    page2OSC_computed[1] = min(page2OSC[2], page2OSC[3]);

    hallPage2 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[1] = hallPage2;
    return;
  } else if (theOscMessage.checkAddrPattern("/page3")==true) {
    hallPage3 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[2] = hallPage3;
    for (int i =0; i<page3OSC.length; i++)
    {
      page3OSC[i] = theOscMessage.get(i+1).intValue();
    }
    // on fusionne les valeurs des zones du tapis
    page3OSC_computed[0] = max(page3OSC[1], page3OSC[2]);
    page3OSC_computed[1] = max(page3OSC[0], page3OSC[3]);

    return;
  } else if (theOscMessage.checkAddrPattern("/page4")==true) {
    hallPage4 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[3] = hallPage4;
    for (int i =0; i<page4OSC.length; i++)
    {
      page4OSC[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page5")==true) {
    hallPage5 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[4] = hallPage5;
    for (int i =0; i<page5OSC.length; i++)
    {
      page5OSC[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page6")==true) {
    hallPage6 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[5] = hallPage6;
    for (int i =0; i<page6OSC.length; i++)
    {
      page6OSC[i] = theOscMessage.get(i+1).intValue();
      /*
      */

      if (i<7)
      {
        Page6_rows[i] = page6OSC[i];
      } else {
        Page6_cols[i-7] = page6OSC[i];
      }
    }


    // On interpole les colonnes et les lignes pour reconstiteur les points de croisements
    for (int i =0; i<Page6_cols.length; i++)
    {
      for (int j=0; j<Page6_rows.length; j++)
      {
        page6OSC_computed[i+j*Page6_cols.length]= min( Page6_cols[i], Page6_rows[j]);
      }
    }


    return;
  }
}


/*
 * A map() replacement that allows for specifying easing curves
 * with arbitrary exponents.
 *
 * value :   The value to map
 * start1:   The lower limit of the input range
 * stop1 :   The upper limit of the input range
 * start2:   The lower limit of the output range
 * stop2 :   The upper limit of the output range
 * type  :   The type of easing (see above)
 * when  :   One of EASE_IN, EASE_OUT, or EASE_IN_OUT
 */
public float map2(float value, float start1, float stop1, float start2, float stop2, int type, int when) {
  float b = start2;
  float c = stop2 - start2;
  float t = value - start1;
  float d = stop1 - start1;
  float p = 0.5f;
  switch (type) {
  case LINEAR:
    return c*t/d + b;
  case SQRT:
    if (when == EASE_IN) {
      t /= d;
      return c*pow(t, p) + b;
    } else if (when == EASE_OUT) {
      t /= d;
      return c * (1 - pow(1 - t, p)) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*pow(t, p) + b;
      return c/2 * (2 - pow(2 - t, p)) + b;
    }
    break;
  case QUADRATIC:
    if (when == EASE_IN) {
      t /= d;
      return c*t*t + b;
    } else if (when == EASE_OUT) {
      t /= d;
      return -c * t*(t-2) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*t*t + b;
      t--;
      return -c/2 * (t*(t-2) - 1) + b;
    }
    break;
  case CUBIC:
    if (when == EASE_IN) {
      t /= d;
      return c*t*t*t + b;
    } else if (when == EASE_OUT) {
      t /= d;
      t--;
      return c*(t*t*t + 1) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*t*t*t + b;
      t -= 2;
      return c/2*(t*t*t + 2) + b;
    }
    break;
  case QUARTIC:
    if (when == EASE_IN) {
      t /= d;
      return c*t*t*t*t + b;
    } else if (when == EASE_OUT) {
      t /= d;
      t--;
      return -c * (t*t*t*t - 1) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*t*t*t*t + b;
      t -= 2;
      return -c/2 * (t*t*t*t - 2) + b;
    }
    break;
  case QUINTIC:
    if (when == EASE_IN) {
      t /= d;
      return c*t*t*t*t*t + b;
    } else if (when == EASE_OUT) {
      t /= d;
      t--;
      return c*(t*t*t*t*t + 1) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*t*t*t*t*t + b;
      t -= 2;
      return c/2*(t*t*t*t*t + 2) + b;
    }
    break;
  case SINUSOIDAL:
    if (when == EASE_IN) {
      return -c * cos(t/d * (PI/2)) + c + b;
    } else if (when == EASE_OUT) {
      return c * sin(t/d * (PI/2)) + b;
    } else if (when == EASE_IN_OUT) {
      return -c/2 * (cos(PI*t/d) - 1) + b;
    }
    break;
  case EXPONENTIAL:
    if (when == EASE_IN) {
      return c * pow( 2, 10 * (t/d - 1) ) + b;
    } else if (when == EASE_OUT) {
      return c * ( -pow( 2, -10 * t/d ) + 1 ) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2 * pow( 2, 10 * (t - 1) ) + b;
      t--;
      return c/2 * ( -pow( 2, -10 * t) + 2 ) + b;
    }
    break;
  case CIRCULAR:
    if (when == EASE_IN) {
      t /= d;
      return -c * (sqrt(1 - t*t) - 1) + b;
    } else if (when == EASE_OUT) {
      t /= d;
      t--;
      return c * sqrt(1 - t*t) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return -c/2 * (sqrt(1 - t*t) - 1) + b;
      t -= 2;
      return c/2 * (sqrt(1 - t*t) + 1) + b;
    }
    break;
  };
  return 0;
}

/*
 * A map() replacement that allows for specifying easing curves
 * with arbitrary exponents.
 *
 * value :   The value to map
 * start1:   The lower limit of the input range
 * stop1 :   The upper limit of the input range
 * start2:   The lower limit of the output range
 * stop2 :   The upper limit of the output range
 * v     :   The exponent value (e.g., 0.5, 0.1, 0.3)
 * when  :   One of EASE_IN, EASE_OUT, or EASE_IN_OUT
 */
public float map3(float value, float start1, float stop1, float start2, float stop2, float v, int when) {
  float b = start2;
  float c = stop2 - start2;
  float t = value - start1;
  float d = stop1 - start1;
  float p = v;
  float out = 0;
  if (when == EASE_IN) {
    t /= d;
    out = c*pow(t, p) + b;
  } else if (when == EASE_OUT) {
    t /= d;
    out = c * (1 - pow(1 - t, p)) + b;
  } else if (when == EASE_IN_OUT) {
    t /= d/2;
    if (t < 1) return c/2*pow(t, p) + b;
    out = c/2 * (2 - pow(2 - t, p)) + b;
  }
  return out;
}

class Page1 {

  // Aroud planet -> nber 1-15
  //Planet -> 16

  Square[] squares= new Square [16];

  SoundFile loop1;
  SoundFile loop2;
  SoundFile[] sun;
  SoundFile[] birds;
  // Define the number of samples 
  int numsounds_sun = 3;
  int numsounds_birds = 10;
  IntList birds_Order;
  int indexSun = 0;
  int indexBirds = 0;

  float volLoop1 = 0.0f;
  float volLoop2 = 0.0f;
  float objLoop1 = 0.0f;
  float objLoop2 = 0.0f;

  float mappedVol1 = 0.0f;

  float nextTimer = 0;
  float lastUpdate = 0;

  int scoreTouched;
  int lastScoreTouched;
  int lastMove = 0;

  //timers
  int delta = 1000;
  int fadein_timer = 1000;
  int fadeout_timer = 1000;

  boolean fadeIn = false;
  boolean moving = false;
  boolean sunPressed = false;
  int numSoundsPlaying = 0;

  boolean quit = false;


  Page1(PApplet p)
  { 
    //init

    //GUI
    //circle
    float r = width/3; //radius of circle
    int numDots = 15;
    // Calculate angle between two ellipses
    float theta = TWO_PI / numDots;
    int widthDots = 120;
    //create squares
    for (int i =0; i<15; i++)
    {
      float myTheta = i*theta; //calculate current angle
      float x = r*cos(myTheta) + width/2 ; //calculate xPos
      float y = r*sin(myTheta) + height/2 ; //calculate yPos
      squares[i] = new Square( x-widthDots/2, y-widthDots/2, widthDots, i+1, page1OSC, i, 1, 1);
    }
    squares[15] = new Square (width/2-40, height/2-40, 80, 16, page1OSC, 15, 1, 1);

    //SOUNDS
    //WHEEL
    // Load soundfiles
    loop1 = new SoundFile(p, "P1/Planche01_Boucle Riviere.wav");
    // Load a soundfile
    loop2 = new SoundFile(p, "P1/PLANCHE01_Boucle Gigales.wav");

    //SUN
    // Create an array of soundfiles
    sun = new SoundFile[numsounds_sun];
    sun[0] = new SoundFile(p, "P1/SOLEIL/SOLEIL1(4824).wav");
    sun[1] = new SoundFile(p, "P1/SOLEIL/SOLEIL2(4824).wav");
    sun[2] = new SoundFile(p, "P1/SOLEIL/SOLEIL3(4824).wav");

    birds = new SoundFile[numsounds_birds];
    birds[0] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle01.wav");
    birds[1] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle02.wav");
    birds[2] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle03.wav");
    birds[3] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle04.wav");
    birds[4] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette01.wav");
    birds[5] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette02.wav");
    birds[6] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette03.wav");
    birds[7] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol02.wav");
    birds[8] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol03.wav");
    birds[9] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol04.wav");

    birds_Order = new IntList();
    for (int i=0; i<numsounds_birds; i++)
    {
      birds_Order.append(i);
    }
    birds_Order.shuffle();

    startSoundFiles();
  }

  public void draw(boolean _quit)
  {
    quit = _quit;
    if (!quit)
    {
      scoreTouched=0;

      //draw interactive areas
      //check if they're touched
      for (int i =0; i<squares.length-1; i++)
      {
        squares[i].draw();
        if (squares[i].checkMouseOver() != 0)
        {
          //println(squares[i].checkMouseOver());
          //wheel
          scoreTouched+=squares[i].checkMouseOver();
        }
      }

      //SUN
      squares[15].draw();
      // check if sun is already playing
      numSoundsPlaying = 0;
      for (int i=0; i<numsounds_sun; i++)
      {
        if (sun[i].isPlaying())
        { 
          numSoundsPlaying++;
        }
      }

      for (int j=0; j<numsounds_birds; j++)
      {
        if (birds[j].isPlaying())
        {
          numSoundsPlaying++;
        }
      }


      if (squares[15].checkMouseOver()==16 && sunPressed == false)
      {
        sunPressed = true;
        playSunSound();
        println("Sun pressed");
      } else if (squares[15].checkMouseOver()== 0 && sunPressed == true) 
      {
        sunPressed = false;
      }


      //Check for movement by additioning every id. If Id change, they're is a movement
      if (lastScoreTouched != scoreTouched && scoreTouched>0)
      {
        //println("moved");
        fadeIn = true;
        lastMove = millis();
        moving = true;
        if (millis()>nextTimer) {
          lastUpdate = millis();
          nextTimer = millis()+fadein_timer;
        }
      }

      // if no change since a while, it's stopped
      if (millis()-lastMove>delta && moving == true)
      {
        //println("stopped");
        fadeIn = false;
        moving = false;
        if (millis()>nextTimer) {
          nextTimer = millis()+fadeout_timer;
          lastUpdate = millis();
        }
      }

      //println (scoreTouched);
      lastScoreTouched = scoreTouched;

      if (fadeIn)
      {
        objLoop1 = 100;
      } else {
        objLoop1 = 0;
      }



      if (nextTimer> millis())
      {
        updateVolLoop();
      }

      // On applique une interpolation à la valeur, pour que ce soit plus amorti en entrée et en sortie.
      mappedVol1 = map2(volLoop1, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      loop1.amp(mappedVol1);
      loop2.amp(mappedVol1);
    }

    else
    {
      // Fade out quand on tourne la page
      if (millis()>nextTimer) {
          nextTimer = millis()+fadeout_timer;
          lastUpdate = millis();
        }
      
      objLoop1 = 0;
      if (nextTimer> millis())
      {
        updateVolLoop();
      }
      mappedVol1 = map2(volLoop1, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      loop1.amp(mappedVol1);
      loop2.amp(mappedVol1);
    }
  }  



  public void updateVolLoop()
  {
    // difference entre objectif et valeur
    float diff = abs( volLoop1-objLoop1);
    //le temps qu'il reste avant la fin de la transition
    float timeToReachObj = nextTimer-millis();
    // de combien il faut bouger à chaque milliseconde
    float incrementByMs = diff/timeToReachObj;
    // combien de ms dure un cycle
    float deltaUpdate = millis()-lastUpdate;
    // de combien il faut bouger pour un cycle
    float update = incrementByMs*deltaUpdate;
    // on s'arrête lorsque l'on est proche de la cible à 0.1 près
    if ( diff>0.1f)
    {
      if (objLoop1>volLoop1)
      {
        volLoop1+=update;
        // on contraint pour être sûr de ne pas dépasser.
        if (volLoop1>100.0f)volLoop1=100.0f;
      } else if (objLoop1<volLoop1) {
        volLoop1-=update;
        if (volLoop1<0.0f)volLoop1=0.0f;
      }
    }
    lastUpdate = millis();
    //println(volLoop1);
  }


  public void startSoundFiles()
  {
    loop1.amp(0.0f);
    loop2.amp(0.0f);
    loop1.loop();
    loop2.loop();
  }

  public void playSunSound()
  {
    if (numSoundsPlaying <2)
    {
      switch (indexSun)
      {
        //2nd hit on sun
      case 1:
        sun[0].play(1.0f, 1.0f);
        indexSun++;
        break;
        //4th hit on sun  
      case 3:
        sun[1].play(1.0f, 1.0f);
        indexSun++;
        break;
        //7th hit on sun  
      case 6:
        sun[2].play(1.0f, 1.0f);
        indexSun++;
        break;
      default:
        birds[birds_Order.get(indexBirds)].play(1.0f, 1.0f);
        indexBirds++;
        if (indexBirds == numsounds_birds)
        {
          birds_Order.shuffle();
          indexBirds = 0;
        }
        indexSun++;
        break;
      }
    }
  }
}

class Page2 {
  Square[] squares= new Square [2];

  //LOOP
  SoundFile Ocean1;
  SoundFile Ocean2;
  SoundFile Kids;
  SoundFile Birds;

  // We store the volume in X and the objectif to reach in Y
  PVector volLoopOcean1 = new PVector (0.0f, 0.0f);
  PVector volLoopOcean2 =  new PVector (0.0f, 0.0f);
  PVector volLoopKids =  new PVector (0.0f, 0.0f);
  PVector volLoopBirds =  new PVector (0.0f, 0.0f);

  PVector timerOcean1 = new PVector (0.0f, 0.0f);
  PVector timerOcean2 = new PVector (0.0f, 0.0f);
  PVector timerKids = new PVector (0.0f, 0.0f);
  PVector timerBirds = new PVector (0.0f, 0.0f);

  boolean updatingOcean = false;
  boolean updatingOcean2 = false;
  boolean updatingKids = false;
  boolean updatingBirds = false;

  boolean windowOpened = false;
  boolean lastWindowState = false;
  boolean fadeIn, fadeOut;
  boolean firstdog = true;

  //EVENTS
  SoundFile[] Chien;
  SoundFile[] Train;
  IntList dog_Order;
  IntList train_Order;

  int indexChien =0;
  int indexTrain = 0;
  int nextChienTimer;
  int nextTrainTimer;

  boolean quit;

  Page2(PApplet p)
  { 
    //init
    //GUI
    //WindowLeft
    squares[0] = new Square (width/2-80, height/2-100, 70, 1, page2OSC_computed, 0, 0, 2);
    //Window Right
    squares[1] = new Square (width/2+10, height/2-100, 70, 2, page2OSC_computed, 1, 0, 2);

    // Load soundfiles
    //LOOP
    Ocean1 = new SoundFile(p, "P2/PLANCHE02_BoucleOcean.wav");
    Ocean2 = new SoundFile(p, "P2/PLANCHE02_BoucleOcean2.wav");
    Birds = new SoundFile(p, "P2/PLANCHE02_boucleoiseauxdemer.wav");
    Kids = new SoundFile(p, "P2/PLANCHE02_ambianceenfants.wav");

    //EVENTS
    Chien = new SoundFile[3];
    Chien[0] = new SoundFile(p, "P2/PLANCHE02_chien1.wav");
    Chien[1] = new SoundFile(p, "P2/PLANCHE02_chien2.wav");
    Chien[2] = new SoundFile(p, "P2/PLANCHE02_chien3.wav");
    Train = new SoundFile[2];
    Train[0] = new SoundFile(p, "P2/PLANCHE02_Train.wav");
    Train[1] = new SoundFile(p, "P2/PLANCHE02_Train2.wav");

    dog_Order = new IntList();
    for (int i=0; i<Chien.length; i++)
    {
      dog_Order.append(i);
    }
    dog_Order.shuffle();

    train_Order = new IntList();
    for (int i=0; i<Train.length; i++)
    {
      train_Order.append(i);
    }
    train_Order.shuffle();

    nextChienTimer = millis()+3000;
    nextTrainTimer = millis()+PApplet.parseInt(random(20000, 35000));

    startSoundFiles();
  }

  public void draw(boolean _quit)
  {
    quit = _quit;
    if (quit == false)
    {
      //draw interactive areas
      int score = 0;
      for (int i =0; i<squares.length; i++)
      {
        squares[i].draw();

        if (squares[i].checkMouseOver() > 0)
        {
          score ++;
        }
      }

      if (score >0)
      {
        windowOpened = true;
      } else {
        windowOpened = false;
      }

      if (windowOpened)
      {
        if (lastWindowState == false)
        {
          //FadeIn
          println("Fade in");
          fadeIn = true;
          //objectif
          volLoopOcean1.y = 50;
          timerOcean1.x = millis();
          timerOcean1.y = millis()+2000;
          //
          //objectif
          volLoopOcean2.y = 70;
          timerOcean2.x = millis();
          timerOcean2.y = millis()+2000;
          //
          //objectif
          volLoopKids.y = 80;
          timerKids.x = millis();
          timerKids.y = millis()+2000;
          //
          //objectif
          volLoopBirds.y = 50;
          timerBirds.x = millis();
          timerBirds.y = millis()+2000;
          //
          if (firstdog)
          {
            nextChienTimer = millis()+3000;
            firstdog = false;
          } else {
            nextChienTimer = millis()+PApplet.parseInt(random(15000, 20000));
          }
          nextTrainTimer = millis()+PApplet.parseInt(random(20000, 35000));
          lastWindowState = windowOpened;
        } else
        {
          // Random variations along time
          if (updatingOcean == false && fadeIn == false && fadeOut == false)
          {
            //objectif
            volLoopOcean1.y = random(20, 65);
            timerOcean1.x = millis();
            timerOcean1.y = millis()+random(5000, 7000);
            updatingOcean = true;
          }

          if (updatingOcean2 == false && fadeIn == false && fadeOut == false)
          {
            //objectif
            volLoopOcean2.y = random(40, 80);
            timerOcean2.x = millis();
            timerOcean2.y = millis()+random(5000, 7000);
            updatingOcean2 = true;
          }

          if (updatingKids == false && fadeIn == false && fadeOut == false)
          {
            //objectif
            volLoopKids.y = random(75, 100);
            timerKids.x = millis();
            timerKids.y = millis()+random(5000, 7000);
            updatingKids = true;
          }

          if (updatingBirds == false && fadeIn == false && fadeOut == false)
          {
            //objectif
            volLoopBirds.y = random(20, 50);
            timerBirds.x = millis();
            timerBirds.y = millis()+random(5000, 7000);
            updatingBirds = true;
          }
        }
      } else if (windowOpened == false)
      {
        if (lastWindowState == true)
        {
          //FadeIn
          println("Fade out");
          fadeOut = true;
          //objectif
          volLoopOcean1.y = 0.0f;
          timerOcean1.x = millis();
          timerOcean1.y = millis()+2000;
          //objectif
          volLoopOcean2.y = 0.0f;
          timerOcean2.x = millis();
          timerOcean2.y = millis()+2000;
          //
          //objectif
          volLoopKids.y = 0.0f;
          timerKids.x = millis();
          timerKids.y = millis()+2000;
          //
          //objectif
          volLoopBirds.y = 0.0f;
          timerBirds.x = millis();
          timerBirds.y = millis()+2000;
          //
          lastWindowState = windowOpened;
        }
      }
      // For fading, as it's always the same timer, we just watch ocean1
      if (fadeIn && millis()>timerOcean1.y)fadeIn = false;
      if (fadeOut && millis()>timerOcean1.y)fadeOut = false;

      if (millis()>timerOcean1.y)updatingOcean=false;
      if (millis()>timerOcean2.y)updatingOcean2=false;
      if (millis()>timerKids.y)updatingKids=false;
      if (millis()>timerBirds.y)updatingBirds=false;

      updateVolLoop(volLoopOcean1, timerOcean1);
      updateVolLoop(volLoopOcean2, timerOcean2);
      updateVolLoop(volLoopKids, timerKids);
      updateVolLoop(volLoopBirds, timerBirds);

      float mappedVol1 = map2(volLoopOcean1.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      Ocean1.amp(mappedVol1);

      float mappedVol2 = map2(volLoopOcean2.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      Ocean2.amp(mappedVol2);

      float mappedVol3 = map2(volLoopKids.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      Kids.amp(mappedVol3);

      float mappedVol4 = map2(volLoopBirds.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      Birds.amp(mappedVol4);

      //println("Volumes LOOP", volLoopOcean1.x, volLoopOcean2.x, volLoopKids.x, volLoopBirds.x);

      if (windowOpened == true)
      {
        // RandomEvents
        if (millis()>nextChienTimer) {
          nextChienTimer = millis()+ PApplet.parseInt(random(2000, 25000));
          Chien[dog_Order.get(indexChien)].play();
          println("Play Chien ", dog_Order.get(indexChien));
          indexChien++;
          if (indexChien == Chien.length)dog_Order.shuffle();
          indexChien %= Chien.length;
        }

        if (millis()>nextTrainTimer) {
          nextTrainTimer = millis()+ PApplet.parseInt(random(40000, 60000));
          Train[train_Order.get(indexTrain)].play();
          println("Play Train ", train_Order.get(indexTrain));
          indexTrain++;
          if (indexTrain == Train.length)train_Order.shuffle();
          indexTrain %= Train.length;
        }
      }
    }
    //FADE OUT lorsque l'on change de page
    else
    {
      if (millis()<timerOcean1.y && fadeOut == false) {
        volLoopOcean1.y = 0.0f;
        timerOcean1.x = millis();
        timerOcean1.y = millis()+2000;
        //objectif
        volLoopOcean2.y = 0.0f;
        timerOcean2.x = millis();
        timerOcean2.y = millis()+2000;
        //
        //objectif
        volLoopKids.y = 0.0f;
        timerKids.x = millis();
        timerKids.y = millis()+2000;
        //
        //objectif
        volLoopBirds.y = 0.0f;
        timerBirds.x = millis();
        timerBirds.y = millis()+2000;
        
        fadeOut = true;
      }
      updateVolLoop(volLoopOcean1, timerOcean1);
      updateVolLoop(volLoopOcean2, timerOcean2);
      updateVolLoop(volLoopKids, timerKids);
      updateVolLoop(volLoopBirds, timerBirds);

      float mappedVol1 = map2(volLoopOcean1.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      Ocean1.amp(mappedVol1);

      float mappedVol2 = map2(volLoopOcean2.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      Ocean2.amp(mappedVol2);

      float mappedVol3 = map2(volLoopKids.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      Kids.amp(mappedVol3);

      float mappedVol4 = map2(volLoopBirds.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      Birds.amp(mappedVol4);
    }
  }  


  public void updateVolLoop(PVector volLoopFile, PVector timer)
  {

    float volLoop = volLoopFile.x;
    float objLoop = volLoopFile.y;

    float lastUpdate = timer.x;
    float nextTimer = timer.y;

    if (millis()<nextTimer) {

      // difference entre objectif et valeur
      float diff = abs( volLoop-objLoop);
      //le temps qu'il reste avant la fin de la transition
      float timeToReachObj = nextTimer-millis();
      // de combien il faut bouger à chaque milliseconde
      float incrementByMs = diff/timeToReachObj;
      // combien de ms dure un cycle
      float deltaUpdate = millis()-lastUpdate;
      // de combien il faut bouger pour un cycle
      float update = incrementByMs*deltaUpdate;
      // on s'arrête lorsque l'on est proche de la cible à 0.1 près
      if ( diff>0.1f)
      {
        if (objLoop>volLoop)
        {
          volLoop+=update;
          // on contraint pour être sûr de ne pas dépasser.
          if (volLoop>100.0f)volLoop=100.0f;
        } else if (objLoop<volLoop) {
          volLoop-=update;
          if (volLoop<0.0f)volLoop=0.0f;
        }
      }
    }
    timer.x = millis();
    volLoopFile.x = volLoop;
    //println(volLoopFile.x, volLoopFile.y, timer.x, timer.y);
  }



  public void startSoundFiles()
  {
    //Background
    Ocean1.amp(0.0f);
    Ocean2.amp(0.0f);
    Kids.amp(0.0f);
    Birds.amp(0.0f);
    Ocean1.loop();
    Ocean2.loop();
    Kids.loop();
    Birds.loop();
  }
}

class Page3 {
  Square[] squares= new Square [2];

  SoundFile[] sonsCourt;
  SoundFile[] sonsLongs;
  int numsounds_courts = 12;
  int numsounds_longs = 12;

  SoundFile song;
  boolean songStarted = false;
  //
  int nberJumps=0;

  boolean pressed = false;
  boolean lastPressed = false;
  int panning = 0;

  PVector volLoopSong = new PVector (0.0f, 0.0f);
  PVector timerSong = new PVector (0.0f, 0.0f);

  int delta = 2000;
  boolean halfway = false;

  boolean quit = false;

  Page3(PApplet p)
  { 
    //init
    //Carpet Top Left
    squares[0] = new Square (width/2-150, height/2-80, 140, 1, page3OSC_computed, 0, 1,3 );
    //Carpet Top Right
    squares[1] = new Square (width/2+10, height/2-80, 140, 2, page3OSC_computed, 1, 1, 3);

    //COURTS
    // Create an array of soundfiles
    sonsCourt = new SoundFile[numsounds_courts];
    sonsCourt[0] = new SoundFile(p, "P3/COURT/CLAVEMONO-01.wav");
    sonsCourt[1] = new SoundFile(p, "P3/COURT/CLOCHE1MONO-01.wav");
    sonsCourt[2] = new SoundFile(p, "P3/COURT/CLOCHE2MONO.wav");
    sonsCourt[3] = new SoundFile(p, "P3/COURT/CONGASMONO-01.wav");
    sonsCourt[4] = new SoundFile(p, "P3/COURT/CRESSELLEMONO-01.wav");
    sonsCourt[5] = new SoundFile(p, "P3/COURT/GUITARE.wav");
    sonsCourt[6] = new SoundFile(p, "P3/COURT/SIFFLET.wav");
    sonsCourt[7] = new SoundFile(p, "P3/COURT/SNAP.wav");
    sonsCourt[8] = new SoundFile(p, "P3/COURT/STOMP.wav");
    sonsCourt[9] = new SoundFile(p, "P3/COURT/TAMBOURINMONO-01.wav");
    sonsCourt[10] = new SoundFile(p, "P3/COURT/TRIANGLEMONO-01.wav");
    sonsCourt[11] = new SoundFile(p, "P3/COURT/TRIANGLEMONO2.wav");

    //LONGS
    // Create an array of soundfiles
    sonsLongs = new SoundFile[numsounds_courts];
    sonsLongs[0] = new SoundFile(p, "P3/LONG/BASSE1MONO-01.wav");
    sonsLongs[1] = new SoundFile(p, "P3/LONG/BASSE2MONO.wav");
    sonsLongs[2] = new SoundFile(p, "P3/LONG/CLAVE2MONO-01.wav");
    sonsLongs[3] = new SoundFile(p, "P3/LONG/CLAVIER.wav");
    sonsLongs[4] = new SoundFile(p, "P3/LONG/CLAVIERPERCU.wav");
    sonsLongs[5] = new SoundFile(p, "P3/LONG/GUITARE2.wav");
    sonsLongs[6] = new SoundFile(p, "P3/LONG/PATTERN1.wav");
    sonsLongs[7] = new SoundFile(p, "P3/LONG/PATTERN1B.wav");
    sonsLongs[8] = new SoundFile(p, "P3/LONG/PATTERNC.wav");
    sonsLongs[9] = new SoundFile(p, "P3/LONG/PATTERND.wav");
    sonsLongs[10] = new SoundFile(p, "P3/LONG/SIFFLETPERCU.wav");
    sonsLongs[11] = new SoundFile(p, "P3/LONG/PATTERNE.wav");

    song = new SoundFile(p, "P3/KAPI.wav");
  }

  public void draw(boolean _quit)
  {
    quit = _quit;
    if (!quit)
    {
      //draw interactive areas
      int score = 0;
      for (int i =0; i<squares.length; i++)
      {
        squares[i].draw();
        if (squares[i].checkMouseOver() != 0)
        {
          //println(squares[i].checkMouseOver());
          score = squares[i].checkMouseOver();
        }
      }

      if (score >0)
      {
        pressed = true;
        if (score == 1) panning = -1;
        else if (score == 2) panning = 1;
      } else {
        pressed = false;
        if (lastPressed == true)lastPressed = false;
      }

      if (pressed == true && lastPressed == false)
      {
        print ("Jump!"+nberJumps+" ");
        print ("panning "+panning+" ");
        nberJumps ++;
        halfway = false;
        //COURTS
        if (nberJumps<11)
        {
          int randomSound = PApplet.parseInt(random(0, numsounds_courts));
          sonsCourt[randomSound].pan(panning);
          sonsCourt[randomSound].play();
          print ("played short "+randomSound+" ");
        }
        //LONGS
        else if (nberJumps>10 && nberJumps<20)
        {
          int randomSound = PApplet.parseInt(random(0, numsounds_longs));
          sonsLongs[randomSound].pan(panning);
          sonsLongs[randomSound].play();
          print ("played long "+randomSound+" ");
        } else
        {
          //SONG
          if (songStarted == false)
          {
            startSong();
            songStarted = true;
          }
          volLoopSong.y = 100;
          timerSong.x = millis();
          timerSong.y = millis()+3000;
        }

        song.pan(panning);
        lastPressed = true;
        println();
      }

      if (songStarted == true)
      {
        updateVolLoop(volLoopSong, timerSong);
        float mappedVol1 = map2(volLoopSong.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
        song.amp(mappedVol1);
        //halfway = false;

        //Nothing since delta
        if (millis()-timerSong.y>(delta*2) && halfway == true || quit)
        {
          volLoopSong.y = 0.0f;
          timerSong.x = millis();
          timerSong.y = millis()+2000;
        } else if (millis()-timerSong.y>delta && halfway==false)
        {
          volLoopSong.y = 50;
          timerSong.x = millis();
          timerSong.y = millis()+2000;
          halfway = true;
        }
      }
    }
    //FADE OUT CHANGEMENT PAGE
    else
    {
      if (songStarted == true)
      {
        volLoopSong.y = 0;
        timerSong.x = millis();
        timerSong.y = millis()+1500;
        songStarted = false;
      }
      updateVolLoop(volLoopSong, timerSong);
      float mappedVol1 = map2(volLoopSong.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      song.amp(mappedVol1);
    }
  }
  //println(millis(), timerSong.y, millis()-timerSong.y, volLoopSong.x);


  public void updateVolLoop(PVector volLoopFile, PVector timer)
  {

    float volLoop = volLoopFile.x;
    float objLoop = volLoopFile.y;

    float lastUpdate = timer.x;
    float nextTimer = timer.y;

    if (millis()<nextTimer) {

      // difference entre objectif et valeur
      float diff = abs( volLoop-objLoop);
      //le temps qu'il reste avant la fin de la transition
      float timeToReachObj = nextTimer-millis();
      // de combien il faut bouger à chaque milliseconde
      float incrementByMs = diff/timeToReachObj;
      // combien de ms dure un cycle
      float deltaUpdate = millis()-lastUpdate;
      // de combien il faut bouger pour un cycle
      float update = incrementByMs*deltaUpdate;
      // on s'arrête lorsque l'on est proche de la cible à 0.1 près
      if ( diff>0.1f)
      {
        if (objLoop>volLoop)
        {
          volLoop+=update;
          // on contraint pour être sûr de ne pas dépasser.
          if (volLoop>100.0f)volLoop=100.0f;
        } else if (objLoop<volLoop) {
          volLoop-=update;
          if (volLoop<0.0f)volLoop=0.0f;
        }
      }
    }
    timer.x = millis();
    volLoopFile.x = volLoop;
    //println(volLoopFile.x, volLoopFile.y, timer.x, timer.y);
  }

  public void startSong() 
  {
    song.amp(0.0f);
    song.pan(0);
    song.play();
  }
}

class Page4 {
  Square[] squares= new Square [3];

  SoundFile[] splotchs;
  SoundFile[] frog;
  int numsounds_splotchs = 9;
  int numsounds_frog = 3;

  IntList splotchs_Order;
  IntList frog_Order;

  int indexSplotchs =0;
  int indexFrog = 0;

  boolean isPressed = false;
  boolean lastPressed = false;

  int chanceFrog = 15; // Une chance sur deux de jouer la grenouille. passer à 15/10 pour moins de chances
  int divFrog = 10;
  
  boolean quit;


  Page4(PApplet p)
  { 
    //init
    //Bottom Puddle
    squares[0] = new Square (width/2-150, height/2+50, 150, 1, page4OSC, 2, 1, 4);
    //Middle Puddle
    squares[1] = new Square (width/2-50, height/2-100, 75, 2, page4OSC, 1, 1, 4);
    //Top Puddle
    squares[2] = new Square (width/2+20, height/2-200, 35, 3, page4OSC, 0, 1, 4);


    //EVENTS
    splotchs = new SoundFile[numsounds_splotchs];
    splotchs[0] = new SoundFile(p, "P4/PLANCEH04_Boue3.wav");
    splotchs[1] = new SoundFile(p, "P4/PLANCHE04_boue1.wav");
    splotchs[2] = new SoundFile(p, "P4/PLANCHE04_boue5.wav");
    splotchs[3] = new SoundFile(p, "P4/PLANCHE04_boue7.wav");
    splotchs[4] = new SoundFile(p, "P4/PLANCHE04_boue8.wav");
    splotchs[5] = new SoundFile(p, "P4/PLANCHE04_boue9.wav");
    splotchs[6] = new SoundFile(p, "P4/PLANCHE04_Boue2.wav");
    splotchs[7] = new SoundFile(p, "P4/PLANCHE04_Boue4.wav");
    splotchs[8] = new SoundFile(p, "P4/PLANCHE04_boue10.wav");

    frog = new SoundFile[numsounds_frog];
    frog[0] = new SoundFile(p, "P4/PLANCHE04_grenouille1.wav");
    frog[1] = new SoundFile(p, "P4/PLANCHE04_grenouille2.wav");
    frog[2] = new SoundFile(p, "P4/PLANCHE04_grenouille plonge.wav");

    splotchs_Order = new IntList();
    for (int i=0; i<splotchs.length; i++)
    {
      splotchs_Order.append(i);
    }
    splotchs_Order.shuffle();

    frog_Order = new IntList();
    for (int i=0; i<frog.length; i++)
    {
      frog_Order.append(i);
    }
    frog_Order.shuffle();
  }

  public void draw(boolean _quit)
  {
    quit = _quit;
    if (!quit)
    {
      int score = 0;
      //draw interactive areas
      for (int i =0; i<squares.length; i++)
      {
        squares[i].draw();
        if (squares[i].checkMouseOver() != 0)
        {
          score ++;
          //println(squares[i].checkMouseOver());
        }
      }

      if (score>0)
      {
        isPressed = true;
      } else {
        isPressed = false;
        if (lastPressed == true)lastPressed = false;
      }

      if (isPressed == true && lastPressed == false)
      {
        //Splotch
        indexSplotchs ++;
        if (indexSplotchs == numsounds_splotchs)
        {
          indexSplotchs = 0;
          splotchs_Order.shuffle();
          if (random(chanceFrog)>divFrog)frog[frog_Order.get(indexFrog)].play();
          println("Frog n° "+frog_Order.get(indexFrog));
          indexFrog++;

          if (indexFrog == numsounds_frog)
          {
            indexFrog = 0;
            frog_Order.shuffle();
          }
        }
        splotchs[splotchs_Order.get(indexSplotchs)].play();
        lastPressed = true;
        println("Splotch n° "+splotchs_Order.get(indexSplotchs));
      }
    }
  }
}

class Page5 {
  Square[] squares= new Square [3];

  SoundFile[] PasZone1_A;
  SoundFile[] PasZone1_B;

  SoundFile[] PasZone2_A;
  SoundFile[] PasZone2_B;

  SoundFile[] PasZone3;
  SoundFile[] Mouettes;

  //LOOP
  SoundFile BoucleChien;
  SoundFile BoucleMouettes;
  SoundFile Ocean1;

  PVector volLoopChien =  new PVector (0.0f, 0.0f);
  PVector volLoopMouettes =  new PVector (0.0f, 0.0f);
  PVector volLoopOcean1 = new PVector (0.0f, 0.0f);

  PVector timerChien = new PVector (0.0f, 0.0f);
  PVector timerMouettes = new PVector (0.0f, 0.0f);
  PVector timerOcean1 = new PVector (0.0f, 0.0f);

  boolean updatingChien = false;
  boolean updatingMouettes = false;
  boolean updatingOcean = false;

  int indexButton1, indexButton2, indexButton3 = 0;
  IntList steps_Order;
  IntList seagull_Order;

  boolean Button1Pressed = false;
  boolean Button2Pressed = false;
  boolean Button3Pressed = false;

  boolean lastButton1Pressed = false;
  boolean lastButton2Pressed = false;
  boolean lastButton3Pressed = false;
  
  boolean quit;

  /*
  // Système pour avoir deux temps dans la boucle avec un seul appui.
   //Obsolète car nous avons changé le principe des sons, mais bien de le conserver dans un coin.
   boolean Button1APressed = false;
   boolean Button1BPressed = false;
   boolean Button2APressed = false;
   boolean Button2BPressed = false;
   boolean Button3APressed = false;
   boolean Button3BPressed = false;
   
   boolean lastButton1APressed = false;
   boolean lastButton1BPressed = false;
   boolean lastButton2APressed = false;
   boolean lastButton2BPressed = false;
   boolean lastButton3APressed = false;
   boolean lastButton3BPressed = false;
   
   int startButton1Pressed = 0;
   int startButton2Pressed = 0;
   int startButton3Pressed = 0;
   
   //Transistion entre deux profondeurs
   int delayButton1 = 5000;
   //Transistion entre deux profondeurs
   int delayButton2 = 5000;
   //Arrivée sur la plage avant le chien
   int delayButton3 = 5500;
   
   */

  // FadeIn pour l'entrée dans la page
  boolean fadeIn = true;

  Page5(PApplet p)
  { 
    //init
    //Under the sea
    squares[0] = new Square (width/2-100, height/2+100, 200, 1, page5OSC, 0, 1, 5);
    //Island
    squares[1] = new Square (width/2-70, height/2-90, 140, 2, page5OSC, 1, 1, 5);
    //Mountain
    squares[2] = new Square (width/2-30, height/2-200, 60, 3, page5OSC, 2, 1, 5);

    PasZone1_A = new SoundFile[6];
    PasZone1_A[0] = new SoundFile(p, "P5/1A.wav");
    PasZone1_A[1] = new SoundFile(p, "P5/1B.wav");
    PasZone1_A[2] = new SoundFile(p, "P5/1C.wav");
    PasZone1_A[3] = new SoundFile(p, "P5/1D.wav");
    PasZone1_A[4] = new SoundFile(p, "P5/1E.wav");
    PasZone1_A[5] = new SoundFile(p, "P5/1F.wav");

    PasZone1_B = new SoundFile[6];
    PasZone1_B[0] = new SoundFile(p, "P5/2A.wav");
    PasZone1_B[1] = new SoundFile(p, "P5/2B.wav");
    PasZone1_B[2] = new SoundFile(p, "P5/2C.wav");
    PasZone1_B[3] = new SoundFile(p, "P5/2D.wav");
    PasZone1_B[4] = new SoundFile(p, "P5/2E.wav");
    PasZone1_B[5] = new SoundFile(p, "P5/2F.wav");

    PasZone2_A = new SoundFile[6];
    PasZone2_A[0] = new SoundFile(p, "P5/3A.wav");
    PasZone2_A[1] = new SoundFile(p, "P5/3B.wav");
    PasZone2_A[2] = new SoundFile(p, "P5/3C.wav");
    PasZone2_A[3] = new SoundFile(p, "P5/3D.wav");
    PasZone2_A[4] = new SoundFile(p, "P5/3E.wav");
    PasZone2_A[5] = new SoundFile(p, "P5/3F.wav");

    PasZone2_B = new SoundFile[6];
    PasZone2_B[0] = new SoundFile(p, "P5/4A.wav");
    PasZone2_B[1] = new SoundFile(p, "P5/4B.wav");
    PasZone2_B[2] = new SoundFile(p, "P5/4C.wav");
    PasZone2_B[3] = new SoundFile(p, "P5/4D.wav");
    PasZone2_B[4] = new SoundFile(p, "P5/4E.wav");
    PasZone2_B[5] = new SoundFile(p, "P5/4F.wav");

    PasZone3 = new SoundFile[6];
    PasZone3[0] = new SoundFile(p, "P5/5A.wav");
    PasZone3[1] = new SoundFile(p, "P5/5B.wav");
    PasZone3[2] = new SoundFile(p, "P5/5C.wav");
    PasZone3[3] = new SoundFile(p, "P5/5D.wav");
    PasZone3[4] = new SoundFile(p, "P5/5E.wav");
    PasZone3[5] = new SoundFile(p, "P5/5F.wav");

    Mouettes = new SoundFile[4];
    Mouettes[0] = new SoundFile(p, "P5/Mouette1.wav");
    Mouettes[1] = new SoundFile(p, "P5/Mouette2.wav");
    Mouettes[2] = new SoundFile(p, "P5/Mouette3.wav");
    Mouettes[3] = new SoundFile(p, "P5/Mouette4.wav");

    //LOOPS
    BoucleChien = new SoundFile(p, "P5/Chien.wav");
    BoucleMouettes = new SoundFile(p, "P5/BoucleMouettes.wav");
    Ocean1 = new SoundFile(p, "P5/BoucleOcean.wav");

    steps_Order = new IntList();
    for (int i=0; i<6; i++)
    {
      steps_Order.append(i);
    }
    steps_Order.shuffle();

    seagull_Order = new IntList();
    for (int i=0; i<4; i++)
    {
      seagull_Order.append(i);
    }
    seagull_Order.shuffle();

    startSoundFiles();
  }

  public void draw(boolean _quit)
  {
    quit = _quit;
    if (quit == false)
    {
      /*
      Button1APressed = false;
       Button1BPressed = false;
       Button2APressed = false;
       Button2BPressed = false;
       Button3APressed = false;
       Button3BPressed = false;
       */
      if (fadeIn)
      {
        volLoopOcean1.y = 25;
        timerOcean1.x = millis();
        timerOcean1.y = millis()+5000;
        fadeIn = false;
      }

      Button1Pressed = false;
      Button2Pressed = false;
      Button3Pressed = false;


      //draw interactive areas
      for (int i =0; i<squares.length; i++)
      {
        squares[i].draw();
      }

      //btn1
      if (squares[0].checkMouseOver() == 1)
      {
        if (lastButton1Pressed==false)
        {
          Button1Pressed = true;
          if (indexButton1 < 6) // Premier tableau de pas, on est dans l'eau profonde
          {
            PasZone1_A[steps_Order.get(indexButton1)].play();
          } else {
            PasZone1_B[steps_Order.get(indexButton1%6)].play();
            if (indexButton1%6 == 0)steps_Order.shuffle();
          }
          //println(millis(), "Step1", indexButton1, steps_Order.get(indexButton1%6));
          
          // On coupe les boucles chien et mouettes, au premier pas.
          if ( volLoopChien.y > 0) 
          {
            volLoopChien.y = 0.0f;
            timerChien.x = millis();
            timerChien.y = millis()+1000;
            updatingChien = true;
            
            volLoopMouettes.y = 0.0f;
            timerMouettes.x = millis();
            timerMouettes.y = millis()+1000;
            updatingMouettes = true;
            
          }
          
          indexButton1++;
          lastButton1Pressed = true;
        }
      } else
      {
        Button1Pressed = false;
        lastButton1Pressed = false;
      }

      //btn2
      if (squares[1].checkMouseOver() == 2)
      {
        if (lastButton2Pressed==false)
        {
          Button2Pressed = true;
          if (indexButton2 < 6) // Premier tableau de pas, on est dans l'eau profonde
          {
            PasZone2_A[steps_Order.get(indexButton2)].play();
          } else {
            PasZone2_B[steps_Order.get(indexButton2%6)].play();
            if (indexButton2%6 == 0)steps_Order.shuffle();
          }
          //println(millis(), "Step1", indexButton1, steps_Order.get(indexButton1%6));
          
          // On coupe les boucles chien et mouettes, au premier pas.
          if (volLoopChien.y > 0) 
          {
            volLoopChien.y = 0.0f;
            timerChien.x = millis();
            timerChien.y = millis()+1000;
            updatingChien = true;
            
            volLoopMouettes.y = 0.0f;
            timerMouettes.x = millis();
            timerMouettes.y = millis()+1000;
            updatingMouettes = true;
            
          }
          
          indexButton2 ++;
          //println(millis(), "Step2", indexButton2);
          lastButton2Pressed = true;
        }
      } else
      {
        Button2Pressed = false;
        lastButton2Pressed = false;
      }

      //btn3
      if (squares[2].checkMouseOver() == 3)
      {
        if (lastButton3Pressed==false)
        {
          Button3Pressed = true;
          PasZone3[steps_Order.get(indexButton3%6)].play();
          if (indexButton3%6 == 0)steps_Order.shuffle();
          //println(millis(), "Step1", indexButton1, steps_Order.get(indexButton1%6));
          // On lance les boucles chien et mouettes, au premier pas.
          if (volLoopChien.y <= 0) 
          {
            volLoopChien.y = 100.0f;
            timerChien.x = millis();
            timerChien.y = millis()+1000;
            updatingChien = true;
            
            volLoopMouettes.y = 100.0f;
            timerMouettes.x = millis();
            timerMouettes.y = millis()+1000;
            updatingMouettes = true;
            
          }
          
          if (indexButton3 % 6 == 3)
          {
            if (random(10)>5)Mouettes[seagull_Order.get(PApplet.parseInt(random(4)))].play();
            if (indexButton3%4 == 0)seagull_Order.shuffle(); // Tirage aléatoire pour diminuer la fréquence des mouettes
          }
          indexButton3 ++;
          //println(millis(), "Step3", indexButton3);
          lastButton3Pressed = true;
        }
      } else
      {
        Button3Pressed = false;
        lastButton3Pressed = false;
        
      }





      ///////////////////////////////////////////////////////////////////////////////////////////////////
      // BUTTON 1
      ///////////////////////////////////////////////////////////////////////////////////////////////////

      /*
      if (Button1APressed && updatingBoucle1 == false && lastButton1APressed == false)
       {
       //objectif
       volLoopBoucle1.y = 100.0;
       timerBoucle1.x = millis();
       timerBoucle1.y = millis()+1000;
       updatingBoucle1 = true;
       lastButton1APressed = true;
       //startButton1Pressed = millis();
       } else if (Button1APressed==false && updatingBoucle1 == false && lastButton1APressed==true  )  //Transistion between 2 loops if button is kept pressed
       {
       //objectif
       volLoopBoucle1.y = 0.0;
       timerBoucle1.x = millis();
       timerBoucle1.y = millis()+1000;
       updatingBoucle1 = true;
       lastButton1APressed = false;
       }
       
       //
       if (Button1BPressed && updatingBoucle2 == false && lastButton1BPressed == false)
       {
       //objectif
       volLoopBoucle2.y = 100.0;
       timerBoucle2.x = millis();
       timerBoucle2.y = millis()+1000;
       updatingBoucle2 = true;
       lastButton1BPressed = true;
       } else if (Button1BPressed==false && updatingBoucle2 == false && lastButton1BPressed==true  )  //Transistion between 2 loops if button is kept pressed
       {
       //objectif
       volLoopBoucle2.y = 0.0;
       timerBoucle2.x = millis();
       timerBoucle2.y = millis()+1000;
       updatingBoucle2 = true;
       lastButton1BPressed = false;
       }
       */
      //println((millis()-startButton1Pressed), Button1APressed, Button1BPressed, lastButton1APressed, lastButton1BPressed, volLoopBoucle1.x, volLoopBoucle2.x, startButton1Pressed);

      ///////////////////////////////////////////////////////////////////////////////////////////////////
      // BUTTON 2
      ///////////////////////////////////////////////////////////////////////////////////////////////////


      //println(Button2APressed, Button2BPressed, volLoopBoucle3.x, volLoopBoucle4.x, startButton2Pressed);

      ///////////////////////////////////////////////////////////////////////////////////////////////////
      // BUTTON 3
      ///////////////////////////////////////////////////////////////////////////////////////////////////




      updateVolLoop(volLoopChien, timerChien);
      updateVolLoop(volLoopMouettes, timerMouettes);
      updateVolLoop(volLoopOcean1, timerOcean1);

      float mappedVol6 = map2(volLoopChien.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      BoucleChien.amp(mappedVol6);
      float mappedVol7 = map2(volLoopMouettes.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      BoucleMouettes.amp(mappedVol7);
      float mappedVol8 = map2(volLoopOcean1.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      Ocean1.amp(mappedVol8);
      /*
      if (updatingBoucle1 && millis()>timerBoucle1.y)updatingBoucle1 = false;
       if (updatingBoucle2 && millis()>timerBoucle2.y)updatingBoucle2 = false;
       if (updatingBoucle3 && millis()>timerBoucle3.y)updatingBoucle3 = false;
       if (updatingBoucle4 && millis()>timerBoucle4.y)updatingBoucle4 = false;
       if (updatingBoucle5 && millis()>timerBoucle5.y)updatingBoucle5 = false;
       */
      if (updatingChien && millis()>timerChien.y)updatingChien = false;
      if (updatingMouettes && millis()>timerMouettes.y)updatingMouettes = false;
      if (updatingOcean && millis()>timerOcean1.y)updatingOcean = false;
    }
    else
    {
      if (updatingChien == false)
      {
            volLoopChien.y = 0.0f;
            timerChien.x = millis();
            timerChien.y = millis()+1000;
            updatingChien = true;
            
            volLoopMouettes.y = 0.0f;
            timerMouettes.x = millis();
            timerMouettes.y = millis()+1000;
            updatingMouettes = true; 
            
            volLoopOcean1.y = 0.0f;
            timerOcean1.x = millis();
            timerOcean1.y = millis()+1000;
            updatingOcean = true; 
      
      }
      updateVolLoop(volLoopChien, timerChien);
      updateVolLoop(volLoopMouettes, timerMouettes);
      updateVolLoop(volLoopOcean1, timerOcean1);

      float mappedVol6 = map2(volLoopChien.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      BoucleChien.amp(mappedVol6);
      float mappedVol7 = map2(volLoopMouettes.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      BoucleMouettes.amp(mappedVol7);
      float mappedVol8 = map2(volLoopOcean1.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      Ocean1.amp(mappedVol8);
      
      if (updatingChien && millis()>timerChien.y)updatingChien = false;
      if (updatingMouettes && millis()>timerMouettes.y)updatingMouettes = false;
      if (updatingOcean && millis()>timerOcean1.y)updatingOcean = false;
    }
  }

  public void updateVolLoop(PVector volLoopFile, PVector timer)
  {

    float volLoop = volLoopFile.x;
    float objLoop = volLoopFile.y;

    float lastUpdate = timer.x;
    float nextTimer = timer.y;

    if (millis()<nextTimer) {

      // difference entre objectif et valeur
      float diff = abs( volLoop-objLoop);
      //le temps qu'il reste avant la fin de la transition
      float timeToReachObj = nextTimer-millis();
      // de combien il faut bouger à chaque milliseconde
      float incrementByMs = diff/timeToReachObj;
      // combien de ms dure un cycle
      float deltaUpdate = millis()-lastUpdate;
      // de combien il faut bouger pour un cycle
      float update = incrementByMs*deltaUpdate;
      // on s'arrête lorsque l'on est proche de la cible à 0.1 près
      if ( diff>0.1f)
      {
        if (objLoop>volLoop)
        {
          volLoop+=update;
          // on contraint pour être sûr de ne pas dépasser.
          if (volLoop>100.0f)volLoop=100.0f;
        } else if (objLoop<volLoop) {
          volLoop-=update;
          if (volLoop<0.0f)volLoop=0.0f;
        }
      }
    }
    timer.x = millis();
    volLoopFile.x = volLoop;
    //println(volLoopFile.x, volLoopFile.y, timer.x, timer.y);
  }




  public void startSoundFiles()
  {
    BoucleChien.amp(0.0f);
    BoucleMouettes.amp(0.0f);
    Ocean1.amp(0.0f);
    BoucleChien.loop();
    BoucleMouettes.loop();
    Ocean1.loop();
  }
}

class Page6 {

  int rows =7;
  int cols =6;
  int square_Width = width/8;
  int offset = width/8;
  Square[][] squares= new Square [cols][rows];


  SoundFile[] events;
  SoundFile loopBoat;

  IntList events_Order;

  float volLoopBoat = 0.0f;
  float objLoopBoat = 0.0f;

  int fadein_timer = 1000;
  int fadeout_timer = 1000;

  float nextTimer = 0;
  float lastUpdate = 0;
  boolean fadeIn = false;

  int scoreTouched;
  int lastScoreTouched;
  int lastMove = 0;

  //timers
  int delta = 2000;
  int deltaEvent = 3000;
  int lastEvent = 0;
  int indexEvent = 0;
  boolean moving;
  boolean lastStateMoving;

  boolean quit;

  Page6(PApplet p)
  { 
    //init
    //create squares
    for (int i =0; i<cols; i++)
    {
      for (int j=0; j<rows; j++)
      {
        squares[i][j] = new Square( offset + i*square_Width, offset/2 + j*square_Width, square_Width, 1+(i+j*cols), page6OSC_computed, (i+j*cols), 1, 6);
      }
    }



    //Sounds
    loopBoat = new SoundFile(p, "P6/PLANCHE06_boucleclapotisbateau.wav");

    events = new SoundFile[10];
    events[0] = new SoundFile (p, "P6/PLANCHE06avion.wav");
    events[1] = new SoundFile (p, "P6/PLANCHE06Baleines.wav");
    events[2] = new SoundFile (p, "P6/PLANCHE06Cormorants.wav");
    events[3] = new SoundFile (p, "P6/PLANCHE06Dauphins.wav");
    events[4] = new SoundFile (p, "P6/PLANCHE06Fousdebassan.wav");
    events[5] = new SoundFile (p, "P6/PLANCHE06Grossevague.wav");
    events[6] = new SoundFile (p, "P6/PLANCHE06Paquebot.wav");
    events[7] = new SoundFile (p, "P6/PLANCHE06Ploufaboiement.wav");
    events[8] = new SoundFile (p, "P6/PLANCHE06ploufgrognement.wav");
    events[9] = new SoundFile (p, "P6/MARINS.wav");

    events_Order = new IntList();
    for (int i=0; i<10; i++)
    {
      events_Order.append(i);
    }
    events_Order.shuffle(); 

    loopBoat.amp(0.0f);
    loopBoat.loop();
  }  


  public void draw(boolean _quit)
  {
    quit = _quit;
    if (!quit)
    {
      scoreTouched=0;

      //draw interactive areas
      for (int i = 0; i < cols; i++) {
        for (int j = 0; j < rows; j++) {

          squares[i][j].draw();
          if (squares[i][j].checkMouseOver() != 0)
          {
            scoreTouched+=squares[i][j].checkMouseOver();
          }
        }
      }

      //Check for movement by additioning every id. If Id change, they're is a movement
      if (lastScoreTouched != scoreTouched && scoreTouched>0)
      {
        //println("moved");
        lastMove = millis();
        moving = true;
      }

      // if no change since a while, it's stopped
      if (millis()-lastMove>delta && moving == true)
      {
        //println("stopped");
        moving = false;
      }


      playBoat(); 

      if (moving && millis() - lastEvent > deltaEvent)
      {
        if ( events[indexEvent].isPlaying() == false)
        {
          events[events_Order.get(indexEvent)].play();
          if (indexEvent == 9)events_Order.shuffle();
          deltaEvent = PApplet.parseInt(random(10000, 15000));
          indexEvent++;
          indexEvent %= events.length;
          lastEvent = millis();
        }
      }


      lastScoreTouched = scoreTouched;
    } 
    // Changement de page
    else
    {
      moving = false;
      for (int i=0; i<10; i++)
      {
         events[i].stop();
      }
      playBoat(); 
      
    }
    
  }

  public void updateVolLoop()
  {
    // difference entre objectif et valeur
    float diff = abs( volLoopBoat-objLoopBoat);
    //le temps qu'il reste avant la fin de la transition
    float timeToReachObj = nextTimer-millis();
    // de combien il faut bouger à chaque milliseconde
    float incrementByMs = diff/timeToReachObj;
    // combien de ms dure un cycle
    float deltaUpdate = millis()-lastUpdate;
    // de combien il faut bouger pour un cycle
    float update = incrementByMs*deltaUpdate;
    // on s'arrête lorsque l'on est proche de la cible à 0.1 près
    if ( diff>0.1f)
    {
      if (objLoopBoat>volLoopBoat)
      {
        volLoopBoat+=update;
        // on contraint pour être sûr de ne pas dépasser.
        if (volLoopBoat>100.0f)
        {
          volLoopBoat=100.0f;
        }
      } else if (objLoopBoat<volLoopBoat) 
      {
        volLoopBoat-=update;
        if (volLoopBoat<0.0f)volLoopBoat=0.0f;
      }
    }
    lastUpdate = millis();
  }

  public void playBoat()
  {
    if (lastStateMoving == false && moving == true) // The boat was stopped, play "start"
    {
      println("START");
      //println("moved");
      fadeIn = true;
      lastMove = millis();
      moving = true;
      if (millis()>nextTimer) {
        lastUpdate = millis();
        nextTimer = millis()+fadein_timer;
      }
      //
      lastStateMoving = true;
    } else if (lastStateMoving == true && moving == true) { // the boat is moving
      println("LOOP");
      lastStateMoving = true;
    } else if (moving == false && lastStateMoving == true) // the boats has stopped
    {
      println("STOP");
      //
      fadeIn = false;
      moving = false;
      if (millis()>nextTimer) {
        nextTimer = millis()+fadeout_timer;
        lastUpdate = millis();
      }
      //
      lastStateMoving = false;
    }

    if (fadeIn)
    {
      objLoopBoat = 100;
    } else {
      objLoopBoat = 0;
    }

    if (nextTimer> millis())
    {
      updateVolLoop();
    }

    // On applique une interpolation à la valeur, pour que ce soit plus amorti en entrée et en sortie.
    float mappedVolBoat = map2(volLoopBoat, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
    loopBoat.amp(mappedVolBoat);
  }
}

class Square
{
  // interactive square, bonded to mouse & OSC events
  float square_x, square_y, square_width;
  boolean mouseOver;
  int id;
  int[] OSCArray; // Tableau OSC lié à ce bouton
  int indexArray; // Index du bouton OSC lié
  int lim; //seuil de déclenchement
  int thePage;

  Square(float _x, float _y, float _width, int _id, int[] _OSCArray, int _indexArray, int _lim, int _thePage)
  {
    square_x = _x;
    square_y = _y;
    square_width = _width;
    id = _id;
    OSCArray = _OSCArray;
    indexArray = _indexArray;
    lim = _lim;
    thePage = _thePage;
    textAlign(CENTER);
  }


  public void draw()
  {
    if (mouseOver || OSCArray[indexArray]>lim)
    {
      fill(125);
    } else {
      fill(220);
    }
    stroke(255);
    strokeWeight(1);
    rect(square_x, square_y, square_width, square_width);
    fill(0);
    text(id, square_x +square_width/2, square_y+square_width/2);
  }

  public int checkMouseOver()
  {
    if (mouseX > square_x && mouseX < square_x+square_width && mouseY>square_y && mouseY<square_y+square_width || OSCArray[indexArray]>lim)
    {
      mouseOver = true;
      //
      if (record)
      {
        TableRow row = table.addRow();

        row.setString("time", MsConversion(millis() - recordStart));
        row.setInt("page", thePage);
        row.setInt("sensor", id);
      }


      return id;
    } else {
      mouseOver = false;
      return 0;
    }
  }

  public String MsConversion(int MS)

  {
    int totalSec= (MS / 1000);
    int seconds = (MS / 1000) % 60;
    int minutes = (MS / (1000*60)) % 60;
    int hours = ((MS/(1000*60*60)) % 24);                      

    String HumanTime= (hours+": " +minutes+ ": "+ seconds);
    return (HumanTime);
  }
}



































  public void settings() {  size(800, 800); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--present", "--window-color=#4D4B4B", "--stop-color=#cccccc", "LDQR_Monitoring" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
