/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.devices.AudioDeviceManager;
import processing.core.PApplet;
import processing.sound.Engine;

public class Sound {
    private Engine engine;

    public Sound(PApplet pApplet) {
        this.engine = Engine.getEngine(pApplet);
    }

    public Sound(PApplet pApplet, int n, int n2, int n3, float f) {
        this(pApplet);
        this.sampleRate(n);
        this.inputDevice(n3);
        this.outputDevice(n2);
        this.volume(f);
    }

    public static String[] list() {
        AudioDeviceManager audioDeviceManager = Engine.getAudioManager();
        int n = audioDeviceManager.getDeviceCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = audioDeviceManager.getDeviceName(i);
            stringArray[i] = audioDeviceManager.getDeviceName(i);
            int n2 = audioDeviceManager.getMaxInputChannels(i);
            int n3 = audioDeviceManager.getMaxOutputChannels(i);
            boolean bl = i == audioDeviceManager.getDefaultInputDeviceID();
            boolean bl2 = i == audioDeviceManager.getDefaultOutputDeviceID();
            System.out.println("device id " + i + ": " + string);
            System.out.println("  max inputs : " + n2 + (bl ? "   (default)" : ""));
            System.out.println("  max outputs: " + n3 + (bl2 ? "   (default)" : ""));
        }
        return stringArray;
    }

    public int sampleRate() {
        return this.engine.getSampleRate();
    }

    public int sampleRate(int n) {
        this.engine.setSampleRate(n);
        return this.sampleRate();
    }

    public void inputDevice(int n) {
        this.engine.selectInputDevice(n);
    }

    public void outputDevice(int n) {
        this.engine.selectOutputDevice(n);
    }

    public void volume(float f) {
        this.engine.setVolume(f);
    }
}

