/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.unitgen.UnitOscillator;

public class SineOscillator
extends UnitOscillator {
    public SineOscillator() {
    }

    public SineOscillator(double d) {
        this.frequency.set(d);
    }

    public SineOscillator(double d, double d2) {
        this.frequency.set(d);
        this.amplitude.set(d2);
    }

    @Override
    public void generate(int n, int n2) {
        double[] dArray = this.frequency.getValues();
        double[] dArray2 = this.amplitude.getValues();
        double[] dArray3 = this.output.getValues();
        double d = this.phase.getValue();
        for (int i = n; i < n2; ++i) {
            double d2 = this.convertFrequencyToPhaseIncrement(dArray[i]);
            d = this.incrementWrapPhase(d, d2);
            double d3 = SineOscillator.fastSin(d);
            dArray3[i] = d3 * dArray2[i];
        }
        this.phase.setValue(d);
    }

    public static double fastSin(double d) {
        double d2 = d > 0.5 ? 1.0 - d : (d < -0.5 ? -1.0 - d : d);
        double d3 = d2 * Math.PI;
        double d4 = d3 * d3;
        double d5 = d3 * (d4 * (d4 * (d4 * (d4 * (d4 * -2.505210838544172E-8 + 2.7557319223985893E-6) - 1.984126984126984E-4) + 0.008333333333333333) - 0.16666666666666666) + 1.0);
        return d5;
    }
}

