/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.io.AudioOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class WaveFileWriter
implements AudioOutputStream {
    private static final short WAVE_FORMAT_PCM = 1;
    private OutputStream outputStream;
    private long riffSizePosition = 0L;
    private long dataSizePosition = 0L;
    private int frameRate = 44100;
    private int samplesPerFrame = 1;
    private int bitsPerSample = 16;
    private int bytesWritten;
    private File outputFile;
    private boolean headerWritten = false;
    private static final int PCM24_MIN = -8388608;
    private static final int PCM24_MAX = 0x7FFFFF;

    public WaveFileWriter(File file) throws FileNotFoundException {
        this.outputFile = file;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.outputStream = new BufferedOutputStream(fileOutputStream);
    }

    public void setFrameRate(int n) {
        this.frameRate = n;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setSamplesPerFrame(int n) {
        this.samplesPerFrame = n;
    }

    public int getSamplesPerFrame() {
        return this.samplesPerFrame;
    }

    public void setBitsPerSample(int n) {
        if (n != 16 && n != 24) {
            throw new IllegalArgumentException("Only 16 or 24 bits per sample allowed. Not " + n);
        }
        this.bitsPerSample = n;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
        this.fixSizes();
    }

    @Override
    public void write(double[] dArray) throws IOException {
        this.write(dArray, 0, dArray.length);
    }

    public void write(float[] fArray) throws IOException {
        this.write(fArray, 0, fArray.length);
    }

    @Override
    public void write(double d) throws IOException {
        if (!this.headerWritten) {
            this.writeHeader();
        }
        if (this.bitsPerSample == 24) {
            this.writePCM24(d);
        } else {
            this.writePCM16(d);
        }
    }

    private void writePCM24(double d) throws IOException {
        double d2 = 8388607.0 * d + 0.5 - -8388608.0;
        int n = (int)d2 + -8388608;
        if (n > 0x7FFFFF) {
            n = 0x7FFFFF;
        } else if (n < -8388608) {
            n = -8388608;
        }
        this.writeByte(n);
        this.writeByte(n >> 8);
        this.writeByte(n >> 16);
    }

    private void writePCM16(double d) throws IOException {
        double d2 = 32767.0 * d + 0.5 - -32768.0;
        int n = (int)d2 + Short.MIN_VALUE;
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        } else if (n < Short.MIN_VALUE) {
            n = Short.MIN_VALUE;
        }
        this.writeByte(n);
        this.writeByte(n >> 8);
    }

    @Override
    public void write(double[] dArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(dArray[n + i]);
        }
    }

    public void write(float[] fArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(fArray[n + i]);
        }
    }

    private void writeByte(int n) throws IOException {
        this.outputStream.write(n);
        ++this.bytesWritten;
    }

    public void writeIntLittle(int n) throws IOException {
        this.writeByte(n);
        this.writeByte(n >> 8);
        this.writeByte(n >> 16);
        this.writeByte(n >> 24);
    }

    public void writeShortLittle(short s) throws IOException {
        this.writeByte(s);
        this.writeByte(s >> 8);
    }

    private void writeHeader() throws IOException {
        this.writeRiffHeader();
        this.writeFormatChunk();
        this.writeDataChunkHeader();
        this.outputStream.flush();
        this.headerWritten = true;
    }

    private void writeRiffHeader() throws IOException {
        this.writeByte(82);
        this.writeByte(73);
        this.writeByte(70);
        this.writeByte(70);
        this.riffSizePosition = this.bytesWritten;
        this.writeIntLittle(Integer.MAX_VALUE);
        this.writeByte(87);
        this.writeByte(65);
        this.writeByte(86);
        this.writeByte(69);
    }

    public void writeFormatChunk() throws IOException {
        int n = (this.bitsPerSample + 7) / 8;
        this.writeByte(102);
        this.writeByte(109);
        this.writeByte(116);
        this.writeByte(32);
        this.writeIntLittle(16);
        this.writeShortLittle((short)1);
        this.writeShortLittle((short)this.samplesPerFrame);
        this.writeIntLittle(this.frameRate);
        this.writeIntLittle(this.frameRate * this.samplesPerFrame * n);
        this.writeShortLittle((short)(this.samplesPerFrame * n));
        this.writeShortLittle((short)this.bitsPerSample);
    }

    public void writeDataChunkHeader() throws IOException {
        this.writeByte(100);
        this.writeByte(97);
        this.writeByte(116);
        this.writeByte(97);
        this.dataSizePosition = this.bytesWritten;
        this.writeIntLittle(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixSizes() throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.outputFile, "rw");
        try {
            long l = this.bytesWritten;
            int n = (int)(l - this.riffSizePosition) - 4;
            randomAccessFile.seek(this.riffSizePosition);
            this.writeRandomIntLittle(randomAccessFile, n);
            int n2 = (int)(l - this.dataSizePosition) - 4;
            randomAccessFile.seek(this.dataSizePosition);
            this.writeRandomIntLittle(randomAccessFile, n2);
        }
        finally {
            randomAccessFile.close();
        }
    }

    private void writeRandomIntLittle(RandomAccessFile randomAccessFile, int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
        randomAccessFile.write(byArray);
    }
}

