class Page1 {

  // Aroud planet -> nber 1-15
  //Planet -> 16

  Square[] squares= new Square [16];

  SoundFile loop1;
  SoundFile loop2;
  SoundFile[] sun;
  SoundFile[] birds;
  // Define the number of samples 
  int numsounds_sun = 3;
  int numsounds_birds = 10;
  IntList birds_Order;
  int indexSun = 0;
  int indexBirds = 0;

  float volLoop1 = 0.0;
  float volLoop2 = 0.0;
  float objLoop1 = 0.0;
  float objLoop2 = 0.0;

  float mappedVol1 = 0.0;

  float nextTimer = 0;
  float lastUpdate = 0;

  int scoreTouched;
  int lastScoreTouched;
  int lastMove = 0;

  //timers
  int delta = 1000;
  int fadein_timer = 1000;
  int fadeout_timer = 1000;

  boolean fadeIn = false;
  boolean moving = false;
  boolean sunPressed = false;
  int numSoundsPlaying = 0;

  boolean quit = false;


  Page1(PApplet p)
  { 
    //init

    //GUI
    //circle
    float r = width/3; //radius of circle
    int numDots = 15;
    // Calculate angle between two ellipses
    float theta = TWO_PI / numDots;
    int widthDots = 120;
    //create squares
    for (int i =0; i<15; i++)
    {
      float myTheta = i*theta; //calculate current angle
      float x = r*cos(myTheta) + width/2 ; //calculate xPos
      float y = r*sin(myTheta) + height/2 ; //calculate yPos
      squares[i] = new Square( x-widthDots/2, y-widthDots/2, widthDots, i+1, page1OSC, i, 1, 1);
    }
    squares[15] = new Square (width/2-40, height/2-40, 80, 16, page1OSC, 15, 1, 1);

    //SOUNDS
    //WHEEL
    // Load soundfiles
    loop1 = new SoundFile(p, "P1/Planche01_Boucle Riviere.wav");
    // Load a soundfile
    loop2 = new SoundFile(p, "P1/PLANCHE01_Boucle Gigales.wav");

    //SUN
    // Create an array of soundfiles
    sun = new SoundFile[numsounds_sun];
    sun[0] = new SoundFile(p, "P1/SOLEIL/SOLEIL1(4824).wav");
    sun[1] = new SoundFile(p, "P1/SOLEIL/SOLEIL2(4824).wav");
    sun[2] = new SoundFile(p, "P1/SOLEIL/SOLEIL3(4824).wav");

    birds = new SoundFile[numsounds_birds];
    birds[0] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle01.wav");
    birds[1] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle02.wav");
    birds[2] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle03.wav");
    birds[3] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle04.wav");
    birds[4] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette01.wav");
    birds[5] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette02.wav");
    birds[6] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette03.wav");
    birds[7] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol02.wav");
    birds[8] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol03.wav");
    birds[9] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol04.wav");

    birds_Order = new IntList();
    for (int i=0; i<numsounds_birds; i++)
    {
      birds_Order.append(i);
    }
    birds_Order.shuffle();

    startSoundFiles();
  }

  void draw(boolean _quit)
  {
    quit = _quit;
    if (!quit)
    {
      scoreTouched=0;

      //draw interactive areas
      //check if they're touched
      for (int i =0; i<squares.length-1; i++)
      {
        squares[i].draw();
        if (squares[i].checkMouseOver() != 0)
        {
          //println(squares[i].checkMouseOver());
          //wheel
          scoreTouched+=squares[i].checkMouseOver();
        }
      }

      //SUN
      squares[15].draw();
      // check if sun is already playing
      numSoundsPlaying = 0;
      for (int i=0; i<numsounds_sun; i++)
      {
        if (sun[i].isPlaying())
        { 
          numSoundsPlaying++;
        }
      }

      for (int j=0; j<numsounds_birds; j++)
      {
        if (birds[j].isPlaying())
        {
          numSoundsPlaying++;
        }
      }


      if (squares[15].checkMouseOver()==16 && sunPressed == false)
      {
        sunPressed = true;
        playSunSound();
        println("Sun pressed");
      } else if (squares[15].checkMouseOver()== 0 && sunPressed == true) 
      {
        sunPressed = false;
      }


      //Check for movement by additioning every id. If Id change, they're is a movement
      if (lastScoreTouched != scoreTouched && scoreTouched>0)
      {
        //println("moved");
        fadeIn = true;
        lastMove = millis();
        moving = true;
        if (millis()>nextTimer) {
          lastUpdate = millis();
          nextTimer = millis()+fadein_timer;
        }
      }

      // if no change since a while, it's stopped
      if (millis()-lastMove>delta && moving == true)
      {
        //println("stopped");
        fadeIn = false;
        moving = false;
        if (millis()>nextTimer) {
          nextTimer = millis()+fadeout_timer;
          lastUpdate = millis();
        }
      }

      //println (scoreTouched);
      lastScoreTouched = scoreTouched;

      if (fadeIn)
      {
        objLoop1 = 100;
      } else {
        objLoop1 = 0;
      }



      if (nextTimer> millis())
      {
        updateVolLoop();
      }

      // On applique une interpolation à la valeur, pour que ce soit plus amorti en entrée et en sortie.
      mappedVol1 = map2(volLoop1, 0, 100, 0.0, 1.0, QUADRATIC, EASE_IN_OUT);
      loop1.amp(mappedVol1);
      loop2.amp(mappedVol1);
    }

    else
    {
      // Fade out quand on tourne la page
      if (millis()>nextTimer) {
          nextTimer = millis()+fadeout_timer;
          lastUpdate = millis();
        }
      
      objLoop1 = 0;
      if (nextTimer> millis())
      {
        updateVolLoop();
      }
      mappedVol1 = map2(volLoop1, 0, 100, 0.0, 1.0, QUADRATIC, EASE_IN_OUT);
      loop1.amp(mappedVol1);
      loop2.amp(mappedVol1);
    }
  }  



  void updateVolLoop()
  {
    // difference entre objectif et valeur
    float diff = abs( volLoop1-objLoop1);
    //le temps qu'il reste avant la fin de la transition
    float timeToReachObj = nextTimer-millis();
    // de combien il faut bouger à chaque milliseconde
    float incrementByMs = diff/timeToReachObj;
    // combien de ms dure un cycle
    float deltaUpdate = millis()-lastUpdate;
    // de combien il faut bouger pour un cycle
    float update = incrementByMs*deltaUpdate;
    // on s'arrête lorsque l'on est proche de la cible à 0.1 près
    if ( diff>0.1)
    {
      if (objLoop1>volLoop1)
      {
        volLoop1+=update;
        // on contraint pour être sûr de ne pas dépasser.
        if (volLoop1>100.0)volLoop1=100.0;
      } else if (objLoop1<volLoop1) {
        volLoop1-=update;
        if (volLoop1<0.0)volLoop1=0.0;
      }
    }
    lastUpdate = millis();
    //println(volLoop1);
  }


  void startSoundFiles()
  {
    loop1.amp(0.0);
    loop2.amp(0.0);
    loop1.loop();
    loop2.loop();
  }

  void playSunSound()
  {
    if (numSoundsPlaying <2)
    {
      switch (indexSun)
      {
        //2nd hit on sun
      case 1:
        sun[0].play(1.0, 1.0);
        indexSun++;
        break;
        //4th hit on sun  
      case 3:
        sun[1].play(1.0, 1.0);
        indexSun++;
        break;
        //7th hit on sun  
      case 6:
        sun[2].play(1.0, 1.0);
        indexSun++;
        break;
      default:
        birds[birds_Order.get(indexBirds)].play(1.0, 1.0);
        indexBirds++;
        if (indexBirds == numsounds_birds)
        {
          birds_Order.shuffle();
          indexBirds = 0;
        }
        indexSun++;
        break;
      }
    }
  }
}
