class Page6 {

  int rows =7;
  int cols =6;
  int square_Width = width/8;
  int offset = width/8;
  Square[][] squares= new Square [cols][rows];


  SoundFile[] events;
  SoundFile loopBoat;

  IntList events_Order;

  float volLoopBoat = 0.0;
  float objLoopBoat = 0.0;

  int fadein_timer = 1000;
  int fadeout_timer = 1000;

  float nextTimer = 0;
  float lastUpdate = 0;
  boolean fadeIn = false;

  int scoreTouched;
  int lastScoreTouched;
  int lastMove = 0;

  //timers
  int delta = 2000;
  int deltaEvent = 3000;
  int lastEvent = 0;
  int indexEvent = 0;
  boolean moving;
  boolean lastStateMoving;

  boolean quit;

  Page6(PApplet p)
  { 
    //init
    //create squares
    for (int i =0; i<cols; i++)
    {
      for (int j=0; j<rows; j++)
      {
        squares[i][j] = new Square( offset + i*square_Width, offset/2 + j*square_Width, square_Width, 1+(i+j*cols), page6OSC_computed, (i+j*cols), 1, 6);
      }
    }



    //Sounds
    loopBoat = new SoundFile(p, "P6/PLANCHE06_boucleclapotisbateau.wav");

    events = new SoundFile[10];
    events[0] = new SoundFile (p, "P6/PLANCHE06avion.wav");
    events[1] = new SoundFile (p, "P6/PLANCHE06Baleines.wav");
    events[2] = new SoundFile (p, "P6/PLANCHE06Cormorants.wav");
    events[3] = new SoundFile (p, "P6/PLANCHE06Dauphins.wav");
    events[4] = new SoundFile (p, "P6/PLANCHE06Fousdebassan.wav");
    events[5] = new SoundFile (p, "P6/PLANCHE06Grossevague.wav");
    events[6] = new SoundFile (p, "P6/PLANCHE06Paquebot.wav");
    events[7] = new SoundFile (p, "P6/PLANCHE06Ploufaboiement.wav");
    events[8] = new SoundFile (p, "P6/PLANCHE06ploufgrognement.wav");
    events[9] = new SoundFile (p, "P6/MARINS.wav");

    events_Order = new IntList();
    for (int i=0; i<10; i++)
    {
      events_Order.append(i);
    }
    events_Order.shuffle(); 

    loopBoat.amp(0.0);
    loopBoat.loop();
  }  


  void draw(boolean _quit)
  {
    quit = _quit;
    if (!quit)
    {
      scoreTouched=0;

      //draw interactive areas
      for (int i = 0; i < cols; i++) {
        for (int j = 0; j < rows; j++) {

          squares[i][j].draw();
          if (squares[i][j].checkMouseOver() != 0)
          {
            scoreTouched+=squares[i][j].checkMouseOver();
          }
        }
      }

      //Check for movement by additioning every id. If Id change, they're is a movement
      if (lastScoreTouched != scoreTouched && scoreTouched>0)
      {
        //println("moved");
        lastMove = millis();
        moving = true;
      }

      // if no change since a while, it's stopped
      if (millis()-lastMove>delta && moving == true)
      {
        //println("stopped");
        moving = false;
      }


      playBoat(); 

      if (moving && millis() - lastEvent > deltaEvent)
      {
        if ( events[indexEvent].isPlaying() == false)
        {
          events[events_Order.get(indexEvent)].play();
          if (indexEvent == 9)events_Order.shuffle();
          deltaEvent = int(random(10000, 15000));
          indexEvent++;
          indexEvent %= events.length;
          lastEvent = millis();
        }
      }


      lastScoreTouched = scoreTouched;
    } 
    // Changement de page
    else
    {
      moving = false;
      for (int i=0; i<10; i++)
      {
         events[i].stop();
      }
      playBoat(); 
      
    }
    
  }

  void updateVolLoop()
  {
    // difference entre objectif et valeur
    float diff = abs( volLoopBoat-objLoopBoat);
    //le temps qu'il reste avant la fin de la transition
    float timeToReachObj = nextTimer-millis();
    // de combien il faut bouger à chaque milliseconde
    float incrementByMs = diff/timeToReachObj;
    // combien de ms dure un cycle
    float deltaUpdate = millis()-lastUpdate;
    // de combien il faut bouger pour un cycle
    float update = incrementByMs*deltaUpdate;
    // on s'arrête lorsque l'on est proche de la cible à 0.1 près
    if ( diff>0.1)
    {
      if (objLoopBoat>volLoopBoat)
      {
        volLoopBoat+=update;
        // on contraint pour être sûr de ne pas dépasser.
        if (volLoopBoat>100.0)
        {
          volLoopBoat=100.0;
        }
      } else if (objLoopBoat<volLoopBoat) 
      {
        volLoopBoat-=update;
        if (volLoopBoat<0.0)volLoopBoat=0.0;
      }
    }
    lastUpdate = millis();
  }

  void playBoat()
  {
    if (lastStateMoving == false && moving == true) // The boat was stopped, play "start"
    {
      println("START");
      //println("moved");
      fadeIn = true;
      lastMove = millis();
      moving = true;
      if (millis()>nextTimer) {
        lastUpdate = millis();
        nextTimer = millis()+fadein_timer;
      }
      //
      lastStateMoving = true;
    } else if (lastStateMoving == true && moving == true) { // the boat is moving
      println("LOOP");
      lastStateMoving = true;
    } else if (moving == false && lastStateMoving == true) // the boats has stopped
    {
      println("STOP");
      //
      fadeIn = false;
      moving = false;
      if (millis()>nextTimer) {
        nextTimer = millis()+fadeout_timer;
        lastUpdate = millis();
      }
      //
      lastStateMoving = false;
    }

    if (fadeIn)
    {
      objLoopBoat = 100;
    } else {
      objLoopBoat = 0;
    }

    if (nextTimer> millis())
    {
      updateVolLoop();
    }

    // On applique une interpolation à la valeur, pour que ce soit plus amorti en entrée et en sortie.
    float mappedVolBoat = map2(volLoopBoat, 0, 100, 0.0, 1.0, QUADRATIC, EASE_IN_OUT);
    loopBoat.amp(mappedVolBoat);
  }
}
