import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import processing.sound.*; 
import beads.*; 
import oscP5.*; 
import netP5.*; 
import processing.io.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class Ka_pi_zero_DemoAgilack extends PApplet {

/*

ajouter -Xms512m -Xmx1024m à la commande java de démarrage sur Raspi

*/








OscP5 oscP5;
NetAddress myRemoteLocation;

//Beads
AudioContext ac;

//Player
Player player;

//LED
boolean ledOn = false;
long lastOSCEvent;

//OSC
//Hall effect, 1/page
int hallPage1, hallPage2, hallPage3, hallPage4, hallPage5, hallPage6;
int hallArray[] = new int[6];

//Page 1, planète et whell
int[] page1OSC = new int[16];

//Page 2, fenetres
int[] page2OSC = new int[4];
int[] page2OSC_computed = new int[2];

//Page 3, tapis
int[] page3OSC = new int[4];
int[] page3OSC_computed = new int[2];

//Page4, flaques
int[] page4OSC = new int[3];

//Page5, iles
int[] page5OSC = new int[3];

//Page6, ocean
int[] page6OSC = new int[13];
int[] page6OSC_computed = new int[42];
int[] Page6_rows =new int[7];
int[] Page6_cols = new int [6];

PFont f;

int state = 0;
int lastState = 0;
int nextState = 0;

int lastHallState = 0;

Page1 page1;
Page2 page2;
Page3 page3;
Page4 page4;
Page5 page5;
Page6 page6;

int lastPageChange;
int recordStart;

boolean listenHallEffect = false;

public void settings() {
  size(800, 800);
  final int buffer_size = 4096;
  ac = AudioContext.getDefaultContext();
  //ac = new AudioContext(new JavaSoundAudioIO(buffer_size), buffer_size, new IOAudioFormat(44100, 16, 0, 2, true, false));
  //IOAudioFormat(float sampleRate, int bitDepth, int inputs, int outputs, boolean signed, boolean bigEndian) 
  //ac = new AudioContext(new AudioServerIO.Jack(), buffer_size, new IOAudioFormat(44100, 16, 0, 2, true, false));

  ac.start(); //<>//
  
 //<>//
}

public void setup()
{
  //size(800, 800);
  
  
  
  /* start oscP5, listening for incoming messages at port 12000 */
  oscP5 = new OscP5(this, 12000);
  
  hallPage1 = 3;
  hallPage2 = 3;
  hallPage3 = 3;
  hallPage4 = 3;
  hallPage5 = 3;
  hallPage6 = 3;

  f = createFont("SourceCodePro-Regular.ttf", 12);
  textFont(f);
  
  player = new Player();
    
  background(255, 248, 196);
}

public void draw()
{
  background(50);
  if (listenHallEffect)
  {
    //Check Hall effect sensors 
    int numHallEffects = 0;
    // D'abord, vérification qu'il n'y a bien qu'un seul capteur sans aimant
    for (int i =0; i<6; i++)
    {
      numHallEffects+=hallArray[i];
    }
    // Une seule page est ouverte
    if (numHallEffects == 1)
    {

      for (int i =0; i<6; i++)
      {
        if (hallArray[i] == 1) {
          nextState = (i+1)*10;
        }
        //
        if (lastHallState != nextState)
        {
          lastState = state; 
          lastHallState = nextState;
        }
      }
    } else { // plusieurs pages ouvertes
      // go back to zero
      nextState = 0;
      if (lastHallState != nextState)
      {
        lastState = state; 
        lastHallState = nextState;
      }
    }
  }
  switch (state)
  {
  case 0:
    //println (page1);
    fill(255);
    text("Kapi Capitaine _ demo Agilack", 50,50);
    text("touches 1 à 6 pour changer de page", 50,75);
    break;
    // entre parenthèses, true = quit
    

    //PAGE 1
  case 10:
    if (page1 == null)
    {
      page1 = new Page1();
    } else {
      page1.draw();
    }

    break;


    //PAGE 2
  case 20:
    if (page2 == null)
    {
      page2 = new Page2();
    } else {
      page2.draw();
    }  
    break;


    //PAGE 3
  case 30:
    if (page3 == null)
    {
      page3 = new Page3();
    } else {
      page3.draw();
    }  
    break;


    //PAGE 4
  case 40:
    if (page4 == null)
    {
      page4 = new Page4();
    } else {
      page4.draw();
    }  
    break;


    //PAGE 5
  case 50:
    if (page5 == null)
    {
      page5 = new Page5();
    } else {
      page5.draw();
    }  
    break;


    //PAGE 6
  case 60:
    if (page6 == null)
    {
      page6 = new Page6();
    } else {
      page6.draw();
    }  
    break;
  }

  end();
}

// This function is used to fade out the current page, kill it by passing it to null, then launching the new page
public void end()
{
  if (lastState == 0)
  {
    state = nextState;
  } else   
  if (lastState != nextState)
  {
    switch (lastState)
    {
    case 10:
      //println(page1 != null);
      if (page1 != null)
      {
        page1.end();
        if (player.masterZero == true)
        {
          page1 = null;
          player.reset();
          state = nextState;
        }
      } 
      break;

    case 20:
      if (page2 != null)
      {
        page2.end();
        if (player.masterZero == true)
        {
          page2 = null;
          player.reset();
          state = nextState;
        }
      } 
      break;

    case 30:
    if (page3 != null)
      {
        page3.end();
        if (player.masterZero == true)
        {
          page3 = null;
          player.reset();
          state = nextState;
        }
      } 

      break;    

    case 40:
    if (page4 != null)
      {
        page4.end();
        if (player.masterZero == true)
        {
          page4 = null;
          player.reset();
          state = nextState;
        }
      } 

      break;

    case 50:
    if (page5!= null)
      {
        page5.end();
        if (player.masterZero == true)
        {
          page5 = null;
          player.reset();
          state = nextState;
        }
      } 

      break;

    case 60:
    if (page6 != null)
      {
        page6.end();
        if (player.masterZero == true)
        {
          page6 = null;
          player.reset();
          state = nextState;
        }
      } 

      break;

    default:
      break;
    }
  }
}

// only used when testing on a screen
public void keyPressed()
{
  if (listenHallEffect == false)
  {
    lastState = state;
    switch (PApplet.parseInt(key)-48)
    {
    case 0:
      break;

      //PAGE 1
    case 1:
      //println("Page 1");
      nextState = 10;
      break;


      //PAGE 2
    case 2:
      //println("Page 2");
      nextState = 20;
      break;


      //PAGE 3
    case 3:
      //println("Page 3");
      nextState = 30;
      break;


      //PAGE 4
    case 4:
      //println("Page 4");
      nextState = 40;
      break;


      //PAGE 5
    case 5:
      //println("Page 5");
      nextState = 50;
      break;


      //PAGE 6
    case 6:
      //println("Page 6");
      nextState = 60;
      break;
    }
  }
  // for testing purpose
  //if (key == 'c' || key == 'C') listenHallEffect = !listenHallEffect;
  
  
}

// OSC events received from the book
public void oscEvent(OscMessage theOscMessage) {
  lastOSCEvent = millis();
 
  //println(theOscMessage);
  if (theOscMessage.checkAddrPattern("/page1")==true) {
    
    hallPage1 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[0] = hallPage1;
    for (int i =0; i<page1OSC.length; i++)
    {
      page1OSC[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page2")==true) {
    for (int i =0; i<page2OSC.length; i++)
    {
      page2OSC[i] = theOscMessage.get(i+1).intValue();
    }
    // We compute value of both sensors
    page2OSC_computed[0] = min(page2OSC[0], page2OSC[1]);
    page2OSC_computed[1] = min(page2OSC[2], page2OSC[3]);

    hallPage2 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[1] = hallPage2;
    return;
  } else if (theOscMessage.checkAddrPattern("/page3")==true) {
    hallPage3 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[2] = hallPage3;
    for (int i =0; i<page3OSC.length; i++)
    {
      page3OSC[i] = theOscMessage.get(i+1).intValue();
    }
    // on fusionne les valeurs des zones du tapis
    page3OSC_computed[0] = max(page3OSC[1], page3OSC[2]);
    page3OSC_computed[1] = max(page3OSC[0], page3OSC[3]);

    return;
  } else if (theOscMessage.checkAddrPattern("/page4")==true) {
    hallPage4 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[3] = hallPage4;
    for (int i =0; i<page4OSC.length; i++)
    {
      page4OSC[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page5")==true) {
    hallPage5 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[4] = hallPage5;
    for (int i =0; i<page5OSC.length; i++)
    {
      page5OSC[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page6")==true) {
    hallPage6 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[5] = hallPage6;
    for (int i =0; i<page6OSC.length; i++)
    {
      page6OSC[i] = theOscMessage.get(i+1).intValue();
      /*
      */

      if (i<7)
      {
        Page6_rows[i] = page6OSC[i];
      } else {
        Page6_cols[i-7] = page6OSC[i];
      }
    }

    // On interpole les colonnes et les lignes pour reconstiteur les points de croisements
    for (int i =0; i<Page6_cols.length; i++)
    {
      for (int j=0; j<Page6_rows.length; j++)
      {
        page6OSC_computed[i+j*Page6_cols.length]= min( Page6_cols[i], Page6_rows[j]);
      }
    }


    return;
  }
}
class Page1 {

  // Aroud planet -> nber 1-15
  // Planet -> 16

  //GUI
  Square[] squares= new Square [16];

  // Define the number of samples 
  int numsounds_sun = 3;
  int numsounds_birds = 10;

  String[] filepathLoops = new String[2];
  String[] filepathSun = new String[numsounds_sun];
  String[] filepathBirds = new String[numsounds_birds];

  Sample[] samplesLoop = new Sample[2];
  Sample[] samplesSun = new Sample[numsounds_sun];
  Sample[] samplesBirds = new Sample[numsounds_birds];
  
  IntList birds_Order;
  int indexSun = 0;
  int indexBirds = 0;

  float nextTimer = 0;
  float lastUpdate = 0;

  int scoreTouched;
  int lastScoreTouched;
  int lastMove = 0;

  //timers
  int delta = 1000;

  boolean fadeIn = false;
  boolean moving = false;
  boolean sunPressed = false;
  int numSoundsPlaying = 0;

  boolean ended = false;


  Page1()
  { 
    //init
    println("INIT");
    //GUI
    //circle
    float r = width/3; //radius of circle
    int numDots = 15;
    // Calculate angle between two ellipses
    float theta = TWO_PI / numDots;
    int widthDots = 120;
    //create squares
    for (int i =0; i<15; i++)
    {
      float myTheta = i*theta; //calculate current angle
      float x = r*cos(myTheta) + width/2 ; //calculate xPos
      float y = r*sin(myTheta) + height/2 ; //calculate yPos
      squares[i] = new Square( x-widthDots/2, y-widthDots/2, widthDots, i+1, page1OSC, i, 1, 1);
    }
    squares[15] = new Square (width/2-40, height/2-40, 80, 16, page1OSC, 15, 1, 1);

    //SOUNDS
    //WHEEL
    // Load soundfiles
    filepathLoops[0] = sketchPath()+"/data/P1/Planche01_Boucle Riviere.wav";
    // Load a soundfile
    filepathLoops[1] = sketchPath()+"/data/P1/PLANCHE01_Boucle Gigales.wav";

    //SUN
    // Create an array of soundfiles
    filepathSun[0] = sketchPath()+"/data/P1/SOLEIL/SOLEIL1(4824).wav";
    filepathSun[1] = sketchPath()+"/data/P1/SOLEIL/SOLEIL2(4824).wav";
    filepathSun[2] = sketchPath()+"/data/P1/SOLEIL/SOLEIL3(4824).wav";

    filepathBirds[0] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Merle01.wav";
    filepathBirds[1] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Merle02.wav";
    filepathBirds[2] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Merle03.wav";
    filepathBirds[3] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Merle04.wav";
    filepathBirds[4] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Mouette01.wav";
    filepathBirds[5] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Mouette02.wav";
    filepathBirds[6] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Mouette03.wav";
    filepathBirds[7] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Rossignol02.wav";
    filepathBirds[8] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Rossignol03.wav";
    filepathBirds[9] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Rossignol04.wav";
    /*
    glides[0] = new Glide(ac, 0.0, 850);
    glides[1] = new Glide(ac, 0.0, 1100);
    */
    // 2 loops, around the circle
    for (int i = 0; i < filepathLoops.length; i++) {
      samplesLoop[i] = SampleManager.sample(filepathLoops[i]);
    }

    // The sun
    for (int i = 0; i < filepathSun.length; i++) {
      samplesSun[i] = SampleManager.sample(filepathSun[i]);
    }

    // The sun (but birds)
    for (int i = 0; i < filepathBirds.length; i++) {
      samplesBirds[i] = SampleManager.sample(filepathBirds[i]);
    }

    birds_Order = new IntList();
     for (int i=0; i<numsounds_birds; i++)
     {
     birds_Order.append(i);
     }
     birds_Order.shuffle();
    
    player.masterFadeIn(1, 500, true);
    startSoundFiles();
  }

  public void draw()
  {
    scoreTouched=0;

    //draw interactive areas
    //check if they're touched
    
    for (int i =0; i<squares.length-1; i++)
    {
      squares[i].draw();
      if (squares[i].checkMouseOver() != 0)
      {
        //wheel
        scoreTouched+=squares[i].checkMouseOver();
      }
    }

    //SUN (button in the center of the page
    squares[15].draw();

    if (squares[15].checkMouseOver() == 16 && sunPressed == false)
    {
      sunPressed = true;
      playSunSound();
      println("Sun pressed");
    } else if (squares[15].checkMouseOver()== 0 && sunPressed == true) 
    {
      sunPressed = false;
    }

    // the ring aroud the sun
    
    //Check for movement by additioning every id. If Id change, they're is a movement
    if (lastScoreTouched != scoreTouched && scoreTouched>0)
    {
      println("moved");
      fadeIn = true;
      lastMove = millis();
      moving = true;
      if (millis()>nextTimer) {
        lastUpdate = millis();
        //nextTimer = millis()+fadein_timer;
      }
    }

    // if no change since a while, it's stopped
    if (millis()-lastMove>delta && moving == true)
    {
      println("stopped");
      fadeIn = false;
      moving = false;
      if (millis()>nextTimer) {
        //nextTimer = millis()+fadeout_timer;
        lastUpdate = millis();
      }
    }

    lastScoreTouched = scoreTouched;
    if (fadeIn)
    {
      player.loopFade(0,1,PApplet.parseInt(random(800, 1100)));
      player.loopFade(1,1,PApplet.parseInt(random(800, 1100)));
    } 
    else {
      player.loopFade(0,0,PApplet.parseInt(random(800, 1100)));
     player.loopFade(1,0,PApplet.parseInt(random(800, 1100)));
    }
  }  
    
    
  public void end()
  {
   player.masterFadeOut(0,1000, true);
  }
  
  // start water loops
  public void startSoundFiles()
  {
    player.playLoop(samplesLoop[0], 0);
    player.playLoop(samplesLoop[1], 1);
    player.loopVolSet(0, 0);
    player.loopVolSet(1,0);
  }


  public void playSunSound()
  {
    // not more than 2 sounds at a time
    if (player.howManyEventsArePlayed() <2)
    {
      switch (indexSun)
      {
        //2nd hit on sun
      case 1:
        println("sun 1");
        player.playSample(samplesSun[0],0);
        indexSun++;
        break;
        //4th hit on sun  
      case 3:
        player.playSample(samplesSun[1],0);
        indexSun++;
        break;
        //7th hit on sun  
      case 6:
        player.playSample(samplesSun[2],0);
        indexSun++;
        break;
      default:
        player.playSample(samplesBirds[indexBirds],0);
         indexBirds++;
        if (indexBirds == numsounds_birds)
        {
          indexBirds = 0;
        }
        indexSun++;
        break;
      }
    }
  }
}
class Page2 {
  Square[] squares= new Square [2];

  //LOOP
  SoundFile Ocean1;
  SoundFile Ocean2;
  SoundFile Kids;
  SoundFile Birds;

  //BEADS///////////////////////////////////////////////////////////////////////////////////////

  // fade in time when opening window
  int timeFadeInOut = 2000;

  // Used to store next variation
  timerStorage timerOcean1 = new timerStorage();
  timerStorage timerOcean2= new timerStorage();
  timerStorage timerKids= new timerStorage();
  timerStorage timerBirds= new timerStorage();

  // Define the number of samples 
  int numsounds_loops = 4;
  int numsounds_Dogs = 3;
  int numsounds_Train = 2;

  String[] filepathLoops = new String[numsounds_loops];
  String[] filepathDogs = new String[numsounds_Dogs];
  String[] filepathTrain = new String[numsounds_Train];

  Sample[] samplesLoop = new Sample[numsounds_loops];
  Sample[] samplesDogs = new Sample[numsounds_Dogs];
  Sample[] samplesTrain = new Sample[numsounds_Train];

  // helpers to randomize events
  IntList dog_Order;
  IntList train_Order;
  int indexChien =0;
  int indexTrain = 0;
  int nextChienTimer;
  int nextTrainTimer;

  boolean windowOpened = false;
  boolean lastWindowState = false;
  boolean fadeIn, fadeOut;

  // Dog needs to be hearded no too late after first window opening
  boolean firstdog = true;

  Page2()
  { 
    //init

    //GUI
    //WindowLeft
    squares[0] = new Square (width/2-80, height/2-100, 70, 1, page2OSC_computed, 0, 0, 2);
    //Window Right
    squares[1] = new Square (width/2+10, height/2-100, 70, 2, page2OSC_computed, 1, 0, 2);

    // Load soundfiles
    //LOOP
    filepathLoops[0] = sketchPath()+"/data/P2/PLANCHE02_BoucleOcean.wav";
    filepathLoops[1] = sketchPath()+"/data/P2/PLANCHE02_BoucleOcean2.wav";
    filepathLoops[2] = sketchPath()+"/data/P2/PLANCHE02_boucleoiseauxdemer.wav";
    filepathLoops[3] = sketchPath()+"/data/P2/PLANCHE02_ambianceenfants.wav";

    //EVENTS
    filepathDogs[0] = sketchPath()+"/data/P2/PLANCHE02_chien1.wav";
    filepathDogs[1] = sketchPath()+"/data/P2/PLANCHE02_chien2.wav";
    filepathDogs[2] = sketchPath()+"/data/P2/PLANCHE02_chien3.wav";

    filepathTrain[0] = sketchPath()+"/data/P2/PLANCHE02_Train.wav";
    filepathTrain[1] = sketchPath()+"/data/P2/PLANCHE02_Train2.wav";

    //// RANDOM EVENTS

    //let's start the 4 loops
    initAndStartLoops();

    nextChienTimer = millis()+3000;      
    nextTrainTimer = millis()+PApplet.parseInt(random(20000, 35000));

    // Complex way to avoid repetition when using random: a list is shuffled 
    dog_Order = new IntList();
    for (int i=0; i<numsounds_Dogs; i++)
    {
      dog_Order.append(i);
    }
    dog_Order.shuffle();

    train_Order = new IntList();
    for (int i=0; i<numsounds_Train; i++)
    {
      train_Order.append(i);
    }
    train_Order.shuffle();
    
    player.masterZero = false;
  }

  public void draw()
  {
    //draw interactive areas
    int score = 0;
    for (int i =0; i<squares.length; i++)
    {
      squares[i].draw();

      if (squares[i].checkMouseOver() > 0)
      {
        score ++;
      }
    }

    if (score >0)
    {
      windowOpened = true;
    } else {
      windowOpened = false;
    }

    if (windowOpened)
    {
      // Window is just opened, we start random events timers
      if (lastWindowState == false)
      {
        //FadeIn
        println("Fade in");
        player.masterFadeIn(1, timeFadeInOut, false);
        fadeIn = true;

        if (firstdog)
        {
          nextChienTimer = millis()+3000;
          firstdog = false;
        } else {
          nextChienTimer = millis()+PApplet.parseInt(random(15000, 20000));
        }
        nextTrainTimer = millis()+PApplet.parseInt(random(20000, 35000));
        lastWindowState = windowOpened;
      } else
      {
        //
      }
    } else if (windowOpened == false)
    {
      if (lastWindowState == true)
      {
        //Fade out
        println("Fade out");
        fadeOut = true;
        player.masterFadeOut(0, timeFadeInOut, false);
        lastWindowState = windowOpened;
      }
    }

    //Some random events
    if (windowOpened == true)
    {
      if (millis()>nextChienTimer) {
        nextChienTimer = millis()+ PApplet.parseInt(random(2000, 25000));
        Sample dogSample = SampleManager.sample(filepathDogs[dog_Order.get(indexChien)]); 
        player.playSample(dogSample,0);
        println("Play Chien ", dog_Order.get(indexChien));
        indexChien++;
        if (indexChien == numsounds_Dogs)dog_Order.shuffle();
        indexChien %= numsounds_Dogs;
      }

      if (millis()>nextTrainTimer) {
        nextTrainTimer = millis()+ PApplet.parseInt(random(40000, 60000));
        Sample trainSample = SampleManager.sample(filepathTrain[train_Order.get(indexTrain)]); 
        player.playSample(trainSample,0);
        println("Play Train ", train_Order.get(indexTrain));
        indexTrain++;
        if (indexTrain == numsounds_Train) train_Order.shuffle();
        indexTrain %= numsounds_Train;
      }
    }


    if (millis()>timerOcean1.delay) 
    {
      updateVolLoop(0, 0.2f, 0.65f, timerOcean1);
    }

    if (millis()>timerOcean2.delay) 
    {
      updateVolLoop(1, 0.4f, 0.8f, timerOcean2);
    }

    if (millis()>timerKids.delay) 
    {
      updateVolLoop(2, 0.75f, 1.0f, timerKids);
    }

    if (millis()>timerBirds.delay) 
    {
      updateVolLoop(3, 0.2f, 0.50f, timerBirds);
    }
  }


  public void updateVolLoop(int loop, float minVol, float maxVol, timerStorage timer)
  {
    float theVol = random(minVol, maxVol);
    int newTimer = PApplet.parseInt(random(5000, 7000));
    player.loopFade(loop, theVol, newTimer);
    timer.delay = millis()+newTimer+200;
    println(theVol, newTimer, timer, millis());
  }



  public void initAndStartLoops()
  {
    for (int i = 0; i < filepathLoops.length; i++) 
    {
      samplesLoop[i] = SampleManager.sample(filepathLoops[i]);
      player.playLoop(samplesLoop[i], i);
      player.loopVolSet(i, 0);
    }
    timerOcean1.delay= millis();
    timerOcean2.delay = millis();
    timerKids.delay = millis();
    timerBirds.delay = millis();
  }
  
  
  public void end()
  {
    player.masterFadeOut(0, 1000, true);
  } 

  class timerStorage {
    int delay;
  }
}
class Page3 {

  //GUI
  Square[] squares= new Square [2];

  //BEADS///////////////////////////////////////////////////////////////////////////////////////

  // Define the number of samples 
  int numsounds_shortSounds = 12;
  int numsounds_longSounds = 12;

  String[] pathShortSounds = new String[numsounds_shortSounds];
  String[] pathLongSounds = new String[numsounds_longSounds];

  int indexShort = 0;

  Sample[] samplesShortSounds = new Sample[numsounds_shortSounds];
  Sample[] samplesLongSounds = new Sample[numsounds_longSounds];
  
  Sample songSample;

  String pathSong;
  Sample sampleSong;
  //SamplePlayer playerSong = new SamplePlayer(ac, 1);
  boolean songStarted = false;

  // Delay = if nothing happened sinc delta ms, sound fade out
  int delta = 2000;
  /*
  Glide masterGlide = new Glide(ac, 1, delta);
   Gain masterGain = new Gain(ac, 2, masterGlide); // construct gain object
   
   Gain soundsLGain = new Gain(ac, 1); // construct gain object
   Gain soundsRGain = new Gain(ac, 1); // construct gain object
   
   Panner pannerMaster;
   Panner pannerSoundsL;
   Panner pannerSoundsR;
   */
  IntList sounds_Order;

  ///////////////////////////////////////////////////////////////////////////////////////

  int nberJumps=0;

  /*
  // helpers object, to know if sample player is plaing, or which one we will play
   playerWatcher LeftPlayerWatcher1 = new playerWatcher();
   playerWatcher RightPlayerWatcher1  = new playerWatcher();
   playerWatcher LeftPlayerWatcher2  = new playerWatcher();
   playerWatcher RightPlayerWatcher2  = new playerWatcher();
   
   playerSwitcher Left_Player1 = new playerSwitcher();
   playerSwitcher Right_Player1 = new playerSwitcher();
   */

  boolean pressed = false;
  boolean lastPressed = false;

  // to know if we play left or right
  int panning = 0;

  // fade out in two steps
  boolean halfway = false;

  boolean ended = false;

  long timerSong;

  Page3()
  { 
    //init

    //Carpet Top Left
    squares[0] = new Square (width/2-150, height/2-80, 140, 1, page3OSC_computed, 0, 1, 3 );
    //Carpet Top Right
    squares[1] = new Square (width/2+10, height/2-80, 140, 2, page3OSC_computed, 1, 1, 3);

    //SOUNDS    
    //
    //Short Sounds
    // Create an array of soundfiles
    pathShortSounds[0] = sketchPath()+"/data/P3/COURT/CLAVEMONO-01.wav";
    pathShortSounds[1] = sketchPath()+"/data/P3/COURT/CLOCHE1MONO-01.wav";
    pathShortSounds[2] = sketchPath()+"/data/P3/COURT/CLOCHE2MONO.wav";
    pathShortSounds[3] = sketchPath()+"/data/P3/COURT/CONGASMONO-01.wav";
    pathShortSounds[4] = sketchPath()+"/data/P3/COURT/CRESSELLEMONO-01.wav";
    pathShortSounds[5] = sketchPath()+"/data/P3/COURT/GUITARE.wav";
    pathShortSounds[6] = sketchPath()+"/data/P3/COURT/SIFFLET.wav";
    pathShortSounds[7] = sketchPath()+"/data/P3/COURT/SNAP.wav";
    pathShortSounds[8] = sketchPath()+"/data/P3/COURT/STOMP.wav";
    pathShortSounds[9] = sketchPath()+"/data/P3/COURT/TAMBOURINMONO-01.wav";
    pathShortSounds[10] = sketchPath()+"/data/P3/COURT/TRIANGLEMONO-01.wav";
    pathShortSounds[11] = sketchPath()+"/data/P3/COURT/TRIANGLEMONO2.wav";

    //LONGS
    // Create an array of soundfiles
    pathLongSounds[0] = sketchPath()+"/data/P3/LONG/BASSE1MONO-01.wav";
    pathLongSounds[1] = sketchPath()+"/data/P3/LONG/BASSE2MONO.wav";
    pathLongSounds[2] = sketchPath()+"/data/P3/LONG/CLAVE2MONO-01.wav";
    pathLongSounds[3] = sketchPath()+"/data/P3/LONG/CLAVIER.wav";
    pathLongSounds[4] = sketchPath()+"/data/P3/LONG/CLAVIERPERCU.wav";
    pathLongSounds[5] = sketchPath()+"/data/P3/LONG/GUITARE2.wav";
    pathLongSounds[6] = sketchPath()+"/data/P3/LONG/PATTERN1.wav";
    pathLongSounds[7] = sketchPath()+"/data/P3/LONG/PATTERN1B.wav";
    pathLongSounds[8] = sketchPath()+"/data/P3/LONG/PATTERNC.wav";
    pathLongSounds[9] = sketchPath()+"/data/P3/LONG/PATTERND.wav";
    pathLongSounds[10] = sketchPath()+"/data/P3/LONG/SIFFLETPERCU.wav";
    pathLongSounds[11] = sketchPath()+"/data/P3/LONG/PATTERNE.wav";
    
    
    for (int i = 0; i< samplesShortSounds.length; i++)
    {
      samplesShortSounds[i] = SampleManager.sample(pathShortSounds[i]);
    }
    
    for (int i = 0; i< samplesLongSounds.length; i++)
    {
      samplesLongSounds[i] = SampleManager.sample(pathLongSounds[i]);
    }
     

    //Song
    pathSong = sketchPath()+"/data/P3/KAPI.wav";
    songSample = SampleManager.sample(pathSong);

    //Used to shuffle order of sounds bank 
    sounds_Order = new IntList();
    for (int i=0; i<numsounds_shortSounds; i++)
    {
      sounds_Order.append(i);
    }
    sounds_Order.shuffle();

    player.masterFadeIn(1, 500, true);
  }

  public void draw()
  {


    //draw interactive areas
    int score = 0;
    for (int i =0; i<squares.length; i++)
    {
      squares[i].draw();
      if (squares[i].checkMouseOver() != 0)
      {
        score = squares[i].checkMouseOver();
      }
    }

    if (score >0)
    {
      pressed = true;
      if (score == 1) panning = -1;
      else if (score == 2) panning = 1;
    } else {
      pressed = false;
      if (lastPressed == true)lastPressed = false;
    }

    //pannerMaster.setPos(map(panning, -1, 1, -0.85, 0.85));

    /*
      checkIsPlaying(playerSoundsL1, LeftPlayerWatcher1);
     checkIsPlaying(playerSoundsR1, RightPlayerWatcher1);
     checkIsPlaying(playerSoundsL2, LeftPlayerWatcher2);
     checkIsPlaying(playerSoundsR2, RightPlayerWatcher2);
     */
    //println(LeftPlayerWatcher1.isPlaying, LeftPlayerWatcher2.isPlaying, RightPlayerWatcher1.isPlaying, RightPlayerWatcher2.isPlaying);

    // we count a "Jump" only if one of the players is available     
    //if (panning == -1 && !LeftPlayerWatcher1.isPlaying || panning == -1 && !LeftPlayerWatcher2.isPlaying || panning == 1 && !RightPlayerWatcher1.isPlaying || panning == 1 && !RightPlayerWatcher2.isPlaying)
    {
      if (pressed == true && lastPressed == false )
      {
        print ("Jump! n°"+nberJumps+" ");
        print (" panning "+panning+" ");

        nberJumps ++;
        halfway = false;

        // 2 banks of sounds : 0->10 short sounds // 11 -> 20 long sounds
        if (nberJumps<20)
        {
          Sample mySample;
          if (nberJumps<10)
          {
            mySample = samplesShortSounds[sounds_Order.get(indexShort)];
          } else 
          {
            mySample =  samplesLongSounds[sounds_Order.get(indexShort)];
          }
          // we suffle order of banks when switching between shorts and longs sounds
          if (indexShort == 9)
          {
            indexShort = 0;
            sounds_Order.shuffle();
            println("Shuffle");
          }

          player.playSample(mySample,panning);
          indexShort ++;
        }
        // The song
        else {
          player.masterFadeOut(1, 1000, false);
          halfway = false;
          timerSong = millis()+3000;
          if (songStarted == false)
          {
            player.playSample(songSample,panning);
            songStarted = true;
          }
        }
        lastPressed = true;
      }
      if (songStarted)
      {
        player.setPanner(panning);
        //Nothing since delta
        if (millis()-timerSong>(delta*2) && halfway == true)
        {
          println("2");
          player.masterFadeOut(0, 1000, false);
          timerSong = millis()+2000;
        } else if (millis()-timerSong>delta && halfway == false)
        {
          println("1");
          player.masterFadeOut(0.25f, 1000, false);
          timerSong = millis()+2000;
          halfway = true;
        }
      }
    }
  }

  public void end()
  {
    player.masterFadeOut(0, 1000, true);
  }  

}
class Page4 {
  
  Square[] squares= new Square [3];

  SoundFile[] splotchs;
  SoundFile[] frog;
  
  int numsounds_splotchs = 9;
  int numsounds_frog = 3;

  IntList splotchs_Order;
  IntList frog_Order;

  int indexSplotchs =0;
  int indexFrog = 0;

  boolean isPressed = false;
  boolean lastPressed = false;

  String[] filepathSplotchs = new String[numsounds_splotchs];
  String[] filepathFrogs = new String[numsounds_frog];
  
  Sample[] samplesSplotchs = new Sample[numsounds_splotchs];
  Sample[] samplesFrogs = new Sample[numsounds_frog];
  
  // If the frog has not been trigged since XX seconds from beginning, we help the chance
  boolean firstFrog = false;
  long timerFrog = 30000;
  long start;
  
  // a way to manage the frequency of frogs events
  int chanceFrog = 20;
  int divFrog = 15;
  
  int splotchsFrog = 0;
  int minSplotchs = 6;
  
  boolean ended = false;

  Page4()
  { 
    //init
    //Bottom Puddle
    squares[0] = new Square (width/2-150, height/2+50, 150, 1, page4OSC, 2, 1, 4);
    //Middle Puddle
    squares[1] = new Square (width/2-50, height/2-100, 75, 2, page4OSC, 1, 1, 4);
    //Top Puddle
    squares[2] = new Square (width/2+20, height/2-200, 35, 3, page4OSC, 0, 1, 4);

    //EVENTS
    filepathSplotchs[0] = sketchPath()+"/data/P4/PLANCEH04_Boue3.wav";
    filepathSplotchs[1] = sketchPath()+"/data/P4/PLANCHE04_boue1.wav";
    filepathSplotchs[2] = sketchPath()+"/data/P4/PLANCHE04_boue5.wav";
    filepathSplotchs[3] = sketchPath()+"/data/P4/PLANCHE04_boue7.wav";
    filepathSplotchs[4] = sketchPath()+"/data/P4/PLANCHE04_boue8.wav";
    filepathSplotchs[5] = sketchPath()+"/data/P4/PLANCHE04_boue9.wav";
    filepathSplotchs[6] = sketchPath()+"/data/P4/PLANCHE04_Boue2.wav";
    filepathSplotchs[7] = sketchPath()+"/data/P4/PLANCHE04_Boue4.wav";
    filepathSplotchs[8] = sketchPath()+"/data/P4/PLANCHE04_boue10.wav";

    filepathFrogs[0] = sketchPath()+"/data/P4/PLANCHE04_grenouille1.wav";
    filepathFrogs[1] = sketchPath()+"/data/P4/PLANCHE04_grenouille2.wav";
    filepathFrogs[2] = sketchPath()+"/data/P4/PLANCHE04_grenouille plonge.wav";
    
      
    for (int i = 0; i < numsounds_splotchs; i++) {
      samplesSplotchs[i] = SampleManager.sample(filepathSplotchs[i]);
    }
    
    for (int i = 0; i < numsounds_frog; i++) {
      samplesFrogs[i] = SampleManager.sample(filepathFrogs[i]);
    }
    
    splotchs_Order = new IntList();
    for (int i=0; i<numsounds_splotchs; i++)
    {
      splotchs_Order.append(i);
    }
    splotchs_Order.shuffle();

    frog_Order = new IntList();
    for (int i=0; i<numsounds_frog; i++)
    {
      frog_Order.append(i);
    }
    frog_Order.shuffle();
    
    start = millis();
    
    player.masterFadeIn(1, 500,true);
  }

  public void draw()
  {

      int score = 0;
      //draw interactive areas
      for (int i =0; i<squares.length; i++)
      {
        squares[i].draw();
        if (squares[i].checkMouseOver() != 0)
        {
          score ++;
          //println(squares[i].checkMouseOver());
        }
      }

      if (score>0)
      {
        isPressed = true;
      } else {
        isPressed = false;
        if (lastPressed == true)lastPressed = false;
      }

      if (isPressed == true && lastPressed == false)
      {
        //Splotch
        indexSplotchs ++;
        if (indexSplotchs == numsounds_splotchs)
        {
          indexSplotchs = 0;
          splotchs_Order.shuffle();
        }  
        
        // frogs events have to be surprising, so they happen at least after "minSplotchs" events, and then we use random to decide if the frog shows his legs.
        float dice = random(chanceFrog);
                
        if (dice>divFrog && splotchsFrog>minSplotchs)
        {
          playFrog(frog_Order.get(indexFrog));
          firstFrog = true;
          println("Frog n° "+frog_Order.get(indexFrog));
          indexFrog++;
          splotchsFrog = 0;
        }
        
        // but if the child has not heard any frog since the beginning, we help the chance a little bit.  
        if (millis()>start+timerFrog && firstFrog == false)
        {
          println("first Frog");
          playFrog(frog_Order.get(indexFrog));
          firstFrog = true;
          indexFrog++;
        }
          
        if (indexFrog == numsounds_frog)
        {
          indexFrog = 0;
          frog_Order.shuffle();
        }
        
        //splotchs[splotchs_Order.get(indexSplotchs)].play();
        playSplotch(splotchs_Order.get(indexSplotchs));
        splotchsFrog++;
        lastPressed = true;
        println("Splotch n° "+splotchs_Order.get(indexSplotchs));
      }
    
  }
  
  public void end()
  {
   player.masterFadeOut(0,1000, true);
  }
  
  public void playFrog(int index)
  {
    player.playSample(samplesFrogs[index],0);
  }
  
  public void playSplotch(int index)
  {
    player.playSample(samplesSplotchs[index],0);
  }
  
}
class Page5 {
  Square[] squares= new Square [3];

  //Paths
  int num_Steps = 12;
  int num_Mouettes = 4;
  
  String[] pathStepsZone1 = new String[num_Steps];
  String[] pathStepsZone2 = new String[num_Steps];
  String[] pathStepsZone3 = new String[num_Steps/2];
  
  String[] pathMouettes = new String[num_Mouettes];;

  String pathBoucleChien;
  String pathBoucleMouettes;
  
  String pathOcean;
  
  //Samples
  Sample[] samplesStepsZone1 = new Sample[num_Steps];
  Sample[] samplesStepsZone2 = new Sample[num_Steps];
  Sample[] samplesStepsZone3 = new Sample[num_Steps/2];
  Sample[] samplesMouettes = new Sample[num_Mouettes];
  
  Sample sampleBoucleChien;
  Sample sampleBoucleMouettes;
  Sample sampleOcean;
  
  int indexButton1, indexButton2, indexButton3 = 0;

  IntList steps_Order;
  IntList seagull_Order;

  boolean Button1Pressed = false;
  boolean Button2Pressed = false;
  boolean Button3Pressed = false;

  boolean lastButton1Pressed = false;
  boolean lastButton2Pressed = false;
  boolean lastButton3Pressed = false;
  
  boolean ended = false;

  Page5()
  { 
    //init
    //Under the sea
    squares[0] = new Square (width/2-100, height/2+100, 200, 1, page5OSC, 0, 1, 5);
    //Island
    squares[1] = new Square (width/2-70, height/2-90, 140, 2, page5OSC, 1, 1, 5);
    //Mountain
    squares[2] = new Square (width/2-30, height/2-200, 60, 3, page5OSC, 2, 1, 5);
    
    //Zone 1
    //A
    pathStepsZone1[0] = sketchPath()+"/data/P5/1A.wav";
    pathStepsZone1[1] = sketchPath()+"/data/P5/1B.wav";
    pathStepsZone1[2] = sketchPath()+"/data/P5/1C.wav";
    pathStepsZone1[3] = sketchPath()+"/data/P5/1D.wav";
    pathStepsZone1[4] = sketchPath()+"/data/P5/1E.wav";
    pathStepsZone1[5] = sketchPath()+"/data/P5/1F.wav";
    //B
    pathStepsZone1[6] = sketchPath()+"/data/P5/2A.wav";
    pathStepsZone1[7] = sketchPath()+"/data/P5/2B.wav";
    pathStepsZone1[8] = sketchPath()+"/data/P5/2C.wav";
    pathStepsZone1[9] = sketchPath()+"/data/P5/2D.wav";
    pathStepsZone1[10] = sketchPath()+"/data/P5/2E.wav";
    pathStepsZone1[11] = sketchPath()+"/data/P5/2F.wav";
    
    //Zone 2
    //A
    pathStepsZone2[0] = sketchPath()+"/data/P5/3A.wav";
    pathStepsZone2[1] = sketchPath()+"/data/P5/3B.wav";
    pathStepsZone2[2] = sketchPath()+"/data/P5/3C.wav";
    pathStepsZone2[3] = sketchPath()+"/data/P5/3D.wav";
    pathStepsZone2[4] = sketchPath()+"/data/P5/3E.wav";
    pathStepsZone2[5] = sketchPath()+"/data/P5/3F.wav";
    //B
    pathStepsZone2[6] = sketchPath()+"/data/P5/4A.wav";
    pathStepsZone2[7] = sketchPath()+"/data/P5/4B.wav";
    pathStepsZone2[8] = sketchPath()+"/data/P5/4C.wav";
    pathStepsZone2[9] = sketchPath()+"/data/P5/4D.wav";
    pathStepsZone2[10] = sketchPath()+"/data/P5/4E.wav";
    pathStepsZone2[11] = sketchPath()+"/data/P5/4F.wav";
    
    //Zone 3
    pathStepsZone3[0] = sketchPath()+"/data/P5/5A.wav";
    pathStepsZone3[1] = sketchPath()+"/data/P5/5B.wav";
    pathStepsZone3[2] = sketchPath()+"/data/P5/5C.wav";
    pathStepsZone3[3] = sketchPath()+"/data/P5/5D.wav";
    pathStepsZone3[4] = sketchPath()+"/data/P5/5E.wav";
    pathStepsZone3[5] = sketchPath()+"/data/P5/5F.wav";

    pathMouettes[0]  = sketchPath()+"/data/P5/Mouette1.wav";
    pathMouettes[1]  = sketchPath()+"/data/P5/Mouette2.wav";
    pathMouettes[2] = sketchPath()+"/data/P5/Mouette3.wav";
    pathMouettes[3] = sketchPath()+"/data/P5/Mouette4.wav";

    //LOOPS
    pathBoucleChien = sketchPath()+"/data/P5/Chien.wav";
    pathBoucleMouettes = sketchPath()+"/data/P5/BoucleMouettes.wav";
    pathOcean = sketchPath()+"/data/P5/BoucleOcean.wav";
    
    //SamplePlayers
    // 12 steps // Zone 1
    for (int i = 0; i < num_Steps; i++) {
      samplesStepsZone1[i] = SampleManager.sample(pathStepsZone1[i]);
    }
    
    // 12 steps // Zone 2
    for (int i = 0; i < num_Steps; i++) {
      samplesStepsZone2[i] = SampleManager.sample(pathStepsZone2[i]);
    }
    
    // 6 steps // Zone 3
    for (int i = 0; i < num_Steps/2; i++) {
      samplesStepsZone3[i] = SampleManager.sample(pathStepsZone3[i]);
    }
    
    // 6 steps // Zone 3
    for (int i = 0; i < num_Steps/2; i++) {
      samplesStepsZone3[i] = SampleManager.sample(pathStepsZone3[i]);
    }
    
    // Mouettes
    for (int i = 0; i < num_Mouettes; i++) {
      samplesMouettes[i] = SampleManager.sample(pathMouettes[i]);
    }
    
    sampleBoucleChien = SampleManager.sample(pathBoucleChien);
    sampleBoucleMouettes = SampleManager.sample(pathBoucleMouettes);
    sampleOcean = SampleManager.sample(pathOcean);
    
    steps_Order = new IntList();
    for (int i=0; i<6; i++)
    {
      steps_Order.append(i);
    }
    steps_Order.shuffle();

    seagull_Order = new IntList();
    for (int i=0; i<4; i++)
    {
      seagull_Order.append(i);
    }
    seagull_Order.shuffle();

    startSoundFiles();
    player.masterFadeIn(1, 1000, true);
  }

  public void draw()
  {

      Button1Pressed = false;
      Button2Pressed = false;
      Button3Pressed = false;

      //draw interactive areas
      for (int i =0; i<squares.length; i++)
      {
        squares[i].draw();
      }

      //btn1
      if (squares[0].checkMouseOver() == 1)
      {
        if (lastButton1Pressed==false)
        {
          indexButton2 = 0;
          indexButton3 = 0;
          
          Button1Pressed = true;
          // Every 6 steps we shuffle the array
          if (indexButton1%6 == 0)steps_Order.shuffle();
          int sampleToPlay = steps_Order.get(indexButton1%6);

          if (indexButton1 < 6) // Premier tableau de pas, on est dans l'eau profonde
          {
            // 6 first steps
            player.playSample(samplesStepsZone1[sampleToPlay],0);
           } else {
            // Every other steps
            player.playSample(samplesStepsZone1[sampleToPlay+6],0);
          }
          
          // On coupe les boucles chien et mouettes, au premier pas.
          if (indexButton1 == 0)
          {          
            player.loopFade(0, 0,1000);
            player.loopFade(1, 0,1000);
          }
          
          indexButton1++;
          lastButton1Pressed = true;
        }
      } else
      {
        Button1Pressed = false;
        lastButton1Pressed = false;
      }

      //btn2
      if (squares[1].checkMouseOver() == 2)
      {
        if (lastButton2Pressed==false)
        {
          indexButton1 = 0;
          indexButton3 = 0;
          
          Button2Pressed = true;
          if (indexButton2%6 == 0)steps_Order.shuffle();
          int sampleToPlay = steps_Order.get(indexButton2%6);
          if (indexButton2 < 6) // Second tableau de pas, on est dans l'eau moins profonde
          {
            // 6 first steps
            player.playSample(samplesStepsZone2[sampleToPlay],0);
          } else {
            // Every other steps
             player.playSample(samplesStepsZone2[sampleToPlay+6],0);
            
          }

          // On coupe les boucles chien et mouettes, au premier pas.
          if (indexButton2 == 0)
          {          
            player.loopFade(0, 0,1000);
            player.loopFade(1, 0,1000);
          }
          
          indexButton2 ++;
          lastButton2Pressed = true;
        }
      } else
      {
        Button2Pressed = false;
        lastButton2Pressed = false;
      }

      //btn3
      if (squares[2].checkMouseOver() == 3)
      {
        if (lastButton3Pressed==false)
        {
          indexButton1 = 0;
          indexButton2 = 0;
          
          Button3Pressed = true;
          // Steps in the sand (on the island, central area)
          if (indexButton3%6 == 0)steps_Order.shuffle();
          int sampleToPlay = steps_Order.get(indexButton3%6);
          player.playSample(samplesStepsZone3[sampleToPlay],0);
         
          
          // On lance les boucles chien et mouettes, au premier pas.
          if (indexButton3 == 0)
          {
            player.loopFade(0, 1,1000);
            player.loopFade(1, 1,1000);
          }
          
          // From time to time, we wake up a seagull
          if (indexButton3 % 6 == 3)
          {
            if (random(10)>5){ // Tirage aléatoire pour diminuer la fréquence des mouettes
              player.playSample(samplesMouettes[seagull_Order.get(indexButton3%4)],0);
              
              println("Moouettes");
            }
            if (indexButton3%4 == 0)seagull_Order.shuffle(); 
          }
          indexButton3 ++;
          lastButton3Pressed = true;
        }
      } else
      {
        Button3Pressed = false;
        lastButton3Pressed = false;
      }

    
  }
  
  public void end()
  {
   player.masterFadeOut(0,1000, true);
  }

  public void startSoundFiles()
  {
    player.playLoop(sampleBoucleChien, 0);
    player.playLoop(sampleBoucleMouettes, 1);
    player.playLoop(sampleOcean, 2);
    player.loopVolSet(0, 0);
    player.loopVolSet(1,0);
    player.loopFade(2, 0.25f,1000);
  }
}
class Page6 {

  int rows =7;
  int cols =6;
  int square_Width = width/8;
  int offset = width/8;
  Square[][] squares= new Square [cols][rows];

  int numsounds_events = 9;

  String filepathBoat;
  String filepathSong;
  String[] filepathEvents = new String[numsounds_events];

  Sample sampleBoat;
  Sample sampleSong;
  Sample[] samplesEvents = new Sample[numsounds_events];

  IntList events_Order;

  float nextTimer = 0;
  float lastUpdate = 0;

  int scoreTouched;
  int lastScoreTouched;
  int lastMove = 0;

  //timers
  int delta = 2000;
  int nextEvent = 0;
  int indexEvent = 0;
  boolean songAlreadyPlayed = false;
  boolean moving;
  boolean lastStateMoving;

  boolean ended = false;

  Page6()
  { 
    //init
    //create squares
    for (int i =0; i<cols; i++)
    {
      for (int j=0; j<rows; j++)
      {
        squares[i][j] = new Square( offset + i*square_Width, offset/2 + j*square_Width, square_Width, 1+(i+j*cols), page6OSC_computed, (i+j*cols), 1, 6);
      }
    }

    //Sounds
    filepathBoat = sketchPath()+"/data/P6/PLANCHE06_boucleclapotisbateau.wav";
    filepathSong = sketchPath()+"/data/P6/MARINS.wav";
    // 
    filepathEvents[0] = sketchPath()+"/data/P6/PLANCHE06avion.wav";
    filepathEvents[1] = sketchPath()+"/data/P6/PLANCHE06Baleines.wav";
    filepathEvents[2] = sketchPath()+"/data/P6/PLANCHE06Cormorants.wav";
    filepathEvents[3] = sketchPath()+"/data/P6/PLANCHE06Dauphins.wav";
    filepathEvents[4] = sketchPath()+"/data/P6/PLANCHE06Fousdebassan.wav";
    filepathEvents[5] = sketchPath()+"/data/P6/PLANCHE06Grossevague.wav";
    filepathEvents[6] = sketchPath()+"/data/P6/PLANCHE06Paquebot.wav";
    filepathEvents[7] = sketchPath()+"/data/P6/PLANCHE06Ploufaboiement.wav";
    filepathEvents[8] = sketchPath()+"/data/P6/PLANCHE06ploufgrognement.wav";

    // Boat Loop
    sampleBoat = SampleManager.sample(filepathBoat);

    //The Song
    sampleSong = SampleManager.sample(filepathSong);

    //Events
    for (int i = 0; i < numsounds_events; i++) {
      samplesEvents[i] = SampleManager.sample(filepathEvents[i]);
    }

    events_Order = new IntList();
    for (int i=0; i<numsounds_events; i++)
    {
      events_Order.append(i);
    }
    events_Order.shuffle(); 
    
    nextEvent = millis() + PApplet.parseInt(random(2000, 5000));

    player.playLoop(sampleBoat, 0);
    player.loopVolSet(0, 0);
    player.masterFadeIn(1, 500, true);
  }  

  public void draw()
  {

      scoreTouched=0;

      //draw interactive areas
      for (int i = 0; i < cols; i++) {
        for (int j = 0; j < rows; j++) {

          squares[i][j].draw();
          if (squares[i][j].checkMouseOver() != 0)
          {
            scoreTouched+=squares[i][j].checkMouseOver();
          }
        }
      }

      //Check for movement by additioning every id. If Id change, they're is a movement
      if (lastScoreTouched != scoreTouched && scoreTouched>0)
      {
        //println("moving");
        lastMove = millis();
        moving = true;
        player.loopFade(0, 1, 1000);
      }

      // if no change since a while, it's stopped
      if (millis()-lastMove>delta && moving == true)
      {
        //println("stop");
        moving = false;
        player.loopFade(0, 0, 1000);
      }

      if (moving && millis() > nextEvent)
      {
        if (indexEvent == 6 && songAlreadyPlayed == false)
        {
          player.playSample(sampleSong,0);
          nextEvent = PApplet.parseInt(random(2000, 3000)) + (int)sampleSong.getLength() + millis();
          songAlreadyPlayed = true;
        } else {
          println("Playing ", events_Order.get(indexEvent));
          player.playSample(samplesEvents[events_Order.get(indexEvent)],0);
          if (indexEvent == numsounds_events-1)events_Order.shuffle();
          nextEvent = PApplet.parseInt(random(2000, 5000)) + (int)samplesEvents[events_Order.get(indexEvent)].getLength() + millis();
          indexEvent++;
          indexEvent %= numsounds_events;
        }
      }

      lastScoreTouched = scoreTouched;
     
    
  }
  
  public void end()
  {
   player.masterFadeOut(0,1000, true);
  }
  
  
}
class Player  //<>// //<>// //<>// //<>// //<>// //<>//
{

  int nbrLoopPlayers = 4;
  SamplePlayer[] loopPlayers = new SamplePlayer[nbrLoopPlayers];
  Envelope[] loopEnvelopes = new Envelope[nbrLoopPlayers];
  Gain[] loopGains = new Gain[nbrLoopPlayers];
  boolean[] EnvelopeIsAvailable = new boolean[nbrLoopPlayers];

  int nbrEventPlayers = 3;
  SamplePlayer[] eventPlayers = new SamplePlayer[nbrEventPlayers];
  //Envelope[] eventEnvelopes = new Envelope[nbrEventPlayers];
  Gain[] eventGains = new Gain[nbrEventPlayers];
  boolean[] eventPlayerIsAvailable = new boolean[nbrEventPlayers];

  Envelope masterFade;
  Gain master;
  Panner panner;
  
  boolean masterZero = false;
  
  Player()
  {
    // Master
    masterFade = new Envelope(1.0f);
    master = new Gain(ac, 1, masterFade);

    //Loop players
    for (int i = 0; i< nbrLoopPlayers; i++)
    {
      //Players 
      // We strangely need to create the SampleManager with a wav to be able to change and start a new Sample
      Sample blank = SampleManager.sample(sketchPath()+"/data/blank.wav");
      loopPlayers[i] = new SamplePlayer(ac, blank); 
      loopPlayers[i].setKillOnEnd(false);
      loopPlayers[i].setLoopType(SamplePlayer.LoopType.LOOP_FORWARDS); // enable looping
      loopPlayers[i].pause(false); // pause playback
      //Envelopes
      loopEnvelopes[i] = new Envelope(ac, 1.0f);
      EnvelopeIsAvailable[i] = true;
      //Gain
      loopGains[i] = new Gain(ac, 1, loopEnvelopes[i]); // construct gain object
      loopGains[i].addInput(loopPlayers[i]); // connect each sample player to each gain object
      master.addInput(loopGains[i]); // connect each gain to the main output
    }

    //Events players 
    for (int i = 0; i< nbrEventPlayers; i++)
    {
      //Used to track available player
      eventPlayerIsAvailable[i] = true;
      //Players 
      Sample blank = SampleManager.sample(sketchPath()+"/data/blank.wav");
      eventPlayers[i] = new SamplePlayer(ac, blank); 
      eventPlayers[i].setKillOnEnd(false);
      eventPlayers[i].setLoopType(SamplePlayer.LoopType.NO_LOOP_FORWARDS); // disable looping
      eventPlayers[i].pause(false); // pause playback
     
      //Gain
      eventGains[i] = new Gain(ac, 1); // construct gain object
      eventGains[i].addInput(eventPlayers[i]); // connect each sample player to each gain object
   
      master.addInput(eventGains[i]); // connect each gain to the main output
    } 
    
    panner = new Panner(ac);
    panner.addInput(master);
    
    ac.out.addInput(panner);

    masterFade.setValue(0);
  }
  
  // Load a sound event 
  public void playSample(Sample theSample, float thePanSetting)
  {
    panner.setPos(thePanSetting);
    for (int i = 0; i<nbrEventPlayers; i++)
    {
      // we check if a sampleplayer is available
      if ( eventPlayerIsAvailable[i] == true) // the player is available
      {
        println("Set Sample: "+theSample+"to player "+i);
        eventPlayers[i].setSample(theSample);
        eventPlayers[i].setToLoopStart();
        eventPlayers[i].start();
        eventPlayerIsAvailable[i] = false;

        // Could be cool to improve that mess
        switch (i)
        {
        case 0:
          eventPlayers[i].setEndListener(
            new Bead() {
            public void messageReceived(Bead message) 
            {
              eventPlayerIsAvailable[0] = true;
            }
          }
          );
          break;

        case 1:    
          eventPlayers[i].setEndListener(
            new Bead() {
            public void messageReceived(Bead message) 
            {
              eventPlayerIsAvailable[1] = true;
            }
          }
          );
          break;

        case 2:      
          eventPlayers[i].setEndListener(
            new Bead() {
            public void messageReceived(Bead message) 
            {
              eventPlayerIsAvailable[2] = true;
            }
          }  
          );
          break;
        }

        break;
      }
    }
  }
  
  public void setPanner(int pan)
  {
    panner.setPos(pan);
  }

  // Load and start a loop sample                          
  public void playLoop(Sample theLoop, int index)
  {
    loopPlayers[index].setSample(theLoop);
    loopPlayers[index].setLoopPointsFraction(0.0f, 1.0f);
    loopPlayers[index].start();
    println("LOOP, set sample :" + theLoop.getFileName()+" envelope " + loopEnvelopes[index].getValue());
  }

  // Fade a loop sample
  public void loopFade(int index, float obj, int time)
  {
    if (EnvelopeIsAvailable[index])
    {
      EnvelopeIsAvailable[index] = false;

      switch(index)
      {
      case 0:
        loopEnvelopes[index].addSegment(obj, time, 
          new Bead() {
          public void messageReceived(Bead message) 
          {
            EnvelopeIsAvailable[0] = true;
          }
        }        
        );
        break;

      case 1:
        loopEnvelopes[index].addSegment(obj, time, 
          new Bead() {
          public void messageReceived(Bead message) 
          {
            EnvelopeIsAvailable[1] = true;
          }
        }        
        );
        break;

      case 2:
        loopEnvelopes[index].addSegment(obj, time, 
          new Bead() {
          public void messageReceived(Bead message) 
          {
            EnvelopeIsAvailable[2] = true;
          }
        }        
        );
        break;

      case 3:
        loopEnvelopes[index].addSegment(obj, time, 
          new Bead() {
          public void messageReceived(Bead message) 
          {
            EnvelopeIsAvailable[3] = true;
          }
        }        
        );
        break;
      }
    }
  }

  // Set the volume of a loop immediately
  public void loopVolSet(int index, int obj)
  {
    loopEnvelopes[index].setValue(obj);
  }

  //Return the nbr of sonic events that are played at the same moments
  public int howManyEventsArePlayed()
  {
    int nbrOfPlayersOn = 0;

    for (int i = 0; i<nbrEventPlayers; i++)
    {
      if (eventPlayerIsAvailable[i] == false)nbrOfPlayersOn++;
    }
    return  nbrOfPlayersOn;
  }

  //Print the state of each event sample player
  public void getSamplePlayers()
  {
    for (int i = 0; i<nbrEventPlayers; i++)
    {
      print(i +" "+eventPlayerIsAvailable[i]+" ");
    }
    println();
  }

  public void masterFadeOut(float vol, int timer, boolean needsABeadMessage)
  {
    if (needsABeadMessage)
    {
    masterFade.addSegment(vol, timer, 
      new Bead() {
      public void messageReceived(Bead message) 
      {
        masterZero = true;
      }
    }
    );
    } else {
      masterFade.addSegment(vol, timer);
    }
  }

  public void masterFadeIn(float vol, int timer, boolean needsABeadMessage)
  {
    if (needsABeadMessage)
    {
    masterFade.addSegment(vol, timer, 
      new Bead() {
      public void messageReceived(Bead message) 
      {
        masterZero = false;
      }
    }  
    );
    } else {
      masterFade.addSegment(vol, timer);
    }
  }

  public void reset() {

    //Unloading every sampleplayer
    //Loop players
    for (int i = 0; i< nbrLoopPlayers; i++)
    {
      loopPlayers[i].setSample(SampleManager.sample(sketchPath()+"/data/blank.wav"));
      EnvelopeIsAvailable[i] = true;
      loopEnvelopes[i].clear();
      loopEnvelopes[i].setValue(1.0f);
    }

    //Events players 
    for (int i = 0; i< nbrEventPlayers; i++)
    {
      eventPlayers[i].setSample(SampleManager.sample(sketchPath()+"/data/blank.wav"));
    }

    masterFade.setValue(0.0f);
    panner.setPos(0.0f);
  }
}
class Square
{
  // interactive square, bonded to mouse & OSC events
  float square_x, square_y, square_width;
  boolean mouseOver;
  int id;
  int[] OSCArray; // Tableau OSC lié à ce bouton
  int indexArray; // Index du bouton OSC lié
  int lim; //seuil de déclenchement
  int thePage;

  Square(float _x, float _y, float _width, int _id, int[] _OSCArray, int _indexArray, int _lim, int _thePage)
  {
    square_x = _x;
    square_y = _y;
    square_width = _width;
    id = _id;
    OSCArray = _OSCArray;
    indexArray = _indexArray;
    lim = _lim;
    thePage = _thePage;
    textAlign(CENTER);
  }


  public void draw()
  {
    
    if (mouseOver || OSCArray[indexArray]>lim)
    {
      fill(125);
    } else {
      fill(220);
    }
    stroke(255);
    strokeWeight(1);
    rect(square_x, square_y, square_width, square_width);
    fill(0);
    text(id, square_x +square_width/2, square_y+square_width/2);
  }

  public int checkMouseOver()
  {
    
    if (mouseX > square_x && mouseX < square_x+square_width && mouseY>square_y && mouseY<square_y+square_width || OSCArray[indexArray]>lim)
    {
      mouseOver = true;
      return id;
    } else {
      mouseOver = false;
      return 0;
    }
  }
  
}
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "Ka_pi_zero_DemoAgilack" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
