class Page1 {

  // Aroud planet -> nber 1-15
  // Planet -> 16

  //GUI
  Square[] squares= new Square [16];

  // Define the number of samples 
  int numsounds_sun = 3;
  int numsounds_birds = 10;

  String[] filepathLoops = new String[2];
  String[] filepathSun = new String[numsounds_sun];
  String[] filepathBirds = new String[numsounds_birds];

  Sample[] samplesLoop = new Sample[2];
  Sample[] samplesSun = new Sample[numsounds_sun];
  Sample[] samplesBirds = new Sample[numsounds_birds];
  
  IntList birds_Order;
  int indexSun = 0;
  int indexBirds = 0;

  float nextTimer = 0;
  float lastUpdate = 0;

  int scoreTouched;
  int lastScoreTouched;
  int lastMove = 0;

  //timers
  int delta = 1000;

  boolean fadeIn = false;
  boolean moving = false;
  boolean sunPressed = false;
  int numSoundsPlaying = 0;

  boolean ended = false;


  Page1()
  { 
    //init
    println("INIT");
    //GUI
    //circle
    float r = width/3; //radius of circle
    int numDots = 15;
    // Calculate angle between two ellipses
    float theta = TWO_PI / numDots;
    int widthDots = 120;
    //create squares
    for (int i =0; i<15; i++)
    {
      float myTheta = i*theta; //calculate current angle
      float x = r*cos(myTheta) + width/2 ; //calculate xPos
      float y = r*sin(myTheta) + height/2 ; //calculate yPos
      squares[i] = new Square( x-widthDots/2, y-widthDots/2, widthDots, i+1, page1OSC, i, 1, 1);
    }
    squares[15] = new Square (width/2-40, height/2-40, 80, 16, page1OSC, 15, 1, 1);

    //SOUNDS
    //WHEEL
    // Load soundfiles
    filepathLoops[0] = sketchPath()+"/data/P1/Planche01_Boucle Riviere.wav";
    // Load a soundfile
    filepathLoops[1] = sketchPath()+"/data/P1/PLANCHE01_Boucle Gigales.wav";

    //SUN
    // Create an array of soundfiles
    filepathSun[0] = sketchPath()+"/data/P1/SOLEIL/SOLEIL1(4824).wav";
    filepathSun[1] = sketchPath()+"/data/P1/SOLEIL/SOLEIL2(4824).wav";
    filepathSun[2] = sketchPath()+"/data/P1/SOLEIL/SOLEIL3(4824).wav";

    filepathBirds[0] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Merle01.wav";
    filepathBirds[1] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Merle02.wav";
    filepathBirds[2] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Merle03.wav";
    filepathBirds[3] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Merle04.wav";
    filepathBirds[4] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Mouette01.wav";
    filepathBirds[5] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Mouette02.wav";
    filepathBirds[6] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Mouette03.wav";
    filepathBirds[7] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Rossignol02.wav";
    filepathBirds[8] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Rossignol03.wav";
    filepathBirds[9] = sketchPath()+"/data/P1/SOLEIL/PLANCHE01_Rossignol04.wav";
    /*
    glides[0] = new Glide(ac, 0.0, 850);
    glides[1] = new Glide(ac, 0.0, 1100);
    */
    // 2 loops, around the circle
    for (int i = 0; i < filepathLoops.length; i++) {
      samplesLoop[i] = SampleManager.sample(filepathLoops[i]);
    }

    // The sun
    for (int i = 0; i < filepathSun.length; i++) {
      samplesSun[i] = SampleManager.sample(filepathSun[i]);
    }

    // The sun (but birds)
    for (int i = 0; i < filepathBirds.length; i++) {
      samplesBirds[i] = SampleManager.sample(filepathBirds[i]);
    }

    birds_Order = new IntList();
     for (int i=0; i<numsounds_birds; i++)
     {
     birds_Order.append(i);
     }
     birds_Order.shuffle();
    
    player.masterFadeIn(1, 500, true);
    startSoundFiles();
  }

  void draw()
  {
    scoreTouched=0;

    //draw interactive areas
    //check if they're touched
    
    for (int i =0; i<squares.length-1; i++)
    {
      squares[i].draw();
      if (squares[i].checkMouseOver() != 0)
      {
        //wheel
        scoreTouched+=squares[i].checkMouseOver();
      }
    }

    //SUN (button in the center of the page
    squares[15].draw();

    if (squares[15].checkMouseOver() == 16 && sunPressed == false)
    {
      sunPressed = true;
      playSunSound();
      println("Sun pressed");
    } else if (squares[15].checkMouseOver()== 0 && sunPressed == true) 
    {
      sunPressed = false;
    }

    // the ring aroud the sun
    
    //Check for movement by additioning every id. If Id change, they're is a movement
    if (lastScoreTouched != scoreTouched && scoreTouched>0)
    {
      println("moved");
      fadeIn = true;
      lastMove = millis();
      moving = true;
      if (millis()>nextTimer) {
        lastUpdate = millis();
        //nextTimer = millis()+fadein_timer;
      }
    }

    // if no change since a while, it's stopped
    if (millis()-lastMove>delta && moving == true)
    {
      println("stopped");
      fadeIn = false;
      moving = false;
      if (millis()>nextTimer) {
        //nextTimer = millis()+fadeout_timer;
        lastUpdate = millis();
      }
    }

    lastScoreTouched = scoreTouched;
    if (fadeIn)
    {
      player.loopFade(0,1,int(random(800, 1100)));
      player.loopFade(1,1,int(random(800, 1100)));
    } 
    else {
      player.loopFade(0,0,int(random(800, 1100)));
     player.loopFade(1,0,int(random(800, 1100)));
    }
  }  
    
    
  void end()
  {
   player.masterFadeOut(0,1000, true);
  }
  
  // start water loops
  void startSoundFiles()
  {
    player.playLoop(samplesLoop[0], 0);
    player.playLoop(samplesLoop[1], 1);
    player.loopVolSet(0, 0);
    player.loopVolSet(1,0);
  }


  void playSunSound()
  {
    // not more than 2 sounds at a time
    if (player.howManyEventsArePlayed() <2)
    {
      switch (indexSun)
      {
        //2nd hit on sun
      case 1:
        println("sun 1");
        player.playSample(samplesSun[0],0);
        indexSun++;
        break;
        //4th hit on sun  
      case 3:
        player.playSample(samplesSun[1],0);
        indexSun++;
        break;
        //7th hit on sun  
      case 6:
        player.playSample(samplesSun[2],0);
        indexSun++;
        break;
      default:
        player.playSample(samplesBirds[indexBirds],0);
         indexBirds++;
        if (indexBirds == numsounds_birds)
        {
          indexBirds = 0;
        }
        indexSun++;
        break;
      }
    }
  }
}
