class Page2 {
  Square[] squares= new Square [2];

  //LOOP
  SoundFile Ocean1;
  SoundFile Ocean2;
  SoundFile Kids;
  SoundFile Birds;

  //BEADS///////////////////////////////////////////////////////////////////////////////////////

  // fade in time when opening window
  int timeFadeInOut = 2000;

  // Used to store next variation
  timerStorage timerOcean1 = new timerStorage();
  timerStorage timerOcean2= new timerStorage();
  timerStorage timerKids= new timerStorage();
  timerStorage timerBirds= new timerStorage();

  // Define the number of samples 
  int numsounds_loops = 4;
  int numsounds_Dogs = 3;
  int numsounds_Train = 2;

  String[] filepathLoops = new String[numsounds_loops];
  String[] filepathDogs = new String[numsounds_Dogs];
  String[] filepathTrain = new String[numsounds_Train];

  Sample[] samplesLoop = new Sample[numsounds_loops];
  Sample[] samplesDogs = new Sample[numsounds_Dogs];
  Sample[] samplesTrain = new Sample[numsounds_Train];

  // helpers to randomize events
  IntList dog_Order;
  IntList train_Order;
  int indexChien =0;
  int indexTrain = 0;
  int nextChienTimer;
  int nextTrainTimer;

  boolean windowOpened = false;
  boolean lastWindowState = false;
  boolean fadeIn, fadeOut;

  // Dog needs to be hearded no too late after first window opening
  boolean firstdog = true;

  Page2()
  { 
    //init

    //GUI
    //WindowLeft
    squares[0] = new Square (width/2-80, height/2-100, 70, 1, page2OSC_computed, 0, 0, 2);
    //Window Right
    squares[1] = new Square (width/2+10, height/2-100, 70, 2, page2OSC_computed, 1, 0, 2);

    // Load soundfiles
    //LOOP
    filepathLoops[0] = sketchPath()+"/data/P2/PLANCHE02_BoucleOcean.wav";
    filepathLoops[1] = sketchPath()+"/data/P2/PLANCHE02_BoucleOcean2.wav";
    filepathLoops[2] = sketchPath()+"/data/P2/PLANCHE02_boucleoiseauxdemer.wav";
    filepathLoops[3] = sketchPath()+"/data/P2/PLANCHE02_ambianceenfants.wav";

    //EVENTS
    filepathDogs[0] = sketchPath()+"/data/P2/PLANCHE02_chien1.wav";
    filepathDogs[1] = sketchPath()+"/data/P2/PLANCHE02_chien2.wav";
    filepathDogs[2] = sketchPath()+"/data/P2/PLANCHE02_chien3.wav";

    filepathTrain[0] = sketchPath()+"/data/P2/PLANCHE02_Train.wav";
    filepathTrain[1] = sketchPath()+"/data/P2/PLANCHE02_Train2.wav";

    //// RANDOM EVENTS

    //let's start the 4 loops
    initAndStartLoops();

    nextChienTimer = millis()+3000;      
    nextTrainTimer = millis()+int(random(20000, 35000));

    // Complex way to avoid repetition when using random: a list is shuffled 
    dog_Order = new IntList();
    for (int i=0; i<numsounds_Dogs; i++)
    {
      dog_Order.append(i);
    }
    dog_Order.shuffle();

    train_Order = new IntList();
    for (int i=0; i<numsounds_Train; i++)
    {
      train_Order.append(i);
    }
    train_Order.shuffle();
    
    player.masterZero = false;
  }

  void draw()
  {
    //draw interactive areas
    int score = 0;
    for (int i =0; i<squares.length; i++)
    {
      squares[i].draw();

      if (squares[i].checkMouseOver() > 0)
      {
        score ++;
      }
    }

    if (score >0)
    {
      windowOpened = true;
    } else {
      windowOpened = false;
    }

    if (windowOpened)
    {
      // Window is just opened, we start random events timers
      if (lastWindowState == false)
      {
        //FadeIn
        println("Fade in");
        player.masterFadeIn(1, timeFadeInOut, false);
        fadeIn = true;

        if (firstdog)
        {
          nextChienTimer = millis()+3000;
          firstdog = false;
        } else {
          nextChienTimer = millis()+int(random(15000, 20000));
        }
        nextTrainTimer = millis()+int(random(20000, 35000));
        lastWindowState = windowOpened;
      } else
      {
        //
      }
    } else if (windowOpened == false)
    {
      if (lastWindowState == true)
      {
        //Fade out
        println("Fade out");
        fadeOut = true;
        player.masterFadeOut(0, timeFadeInOut, false);
        lastWindowState = windowOpened;
      }
    }

    //Some random events
    if (windowOpened == true)
    {
      if (millis()>nextChienTimer) {
        nextChienTimer = millis()+ int(random(2000, 25000));
        Sample dogSample = SampleManager.sample(filepathDogs[dog_Order.get(indexChien)]); 
        player.playSample(dogSample,0);
        println("Play Chien ", dog_Order.get(indexChien));
        indexChien++;
        if (indexChien == numsounds_Dogs)dog_Order.shuffle();
        indexChien %= numsounds_Dogs;
      }

      if (millis()>nextTrainTimer) {
        nextTrainTimer = millis()+ int(random(40000, 60000));
        Sample trainSample = SampleManager.sample(filepathTrain[train_Order.get(indexTrain)]); 
        player.playSample(trainSample,0);
        println("Play Train ", train_Order.get(indexTrain));
        indexTrain++;
        if (indexTrain == numsounds_Train) train_Order.shuffle();
        indexTrain %= numsounds_Train;
      }
    }


    if (millis()>timerOcean1.delay) 
    {
      updateVolLoop(0, 0.2, 0.65, timerOcean1);
    }

    if (millis()>timerOcean2.delay) 
    {
      updateVolLoop(1, 0.4, 0.8, timerOcean2);
    }

    if (millis()>timerKids.delay) 
    {
      updateVolLoop(2, 0.75, 1.0, timerKids);
    }

    if (millis()>timerBirds.delay) 
    {
      updateVolLoop(3, 0.2, 0.50, timerBirds);
    }
  }


  void updateVolLoop(int loop, float minVol, float maxVol, timerStorage timer)
  {
    float theVol = random(minVol, maxVol);
    int newTimer = int(random(5000, 7000));
    player.loopFade(loop, theVol, newTimer);
    timer.delay = millis()+newTimer+200;
    println(theVol, newTimer, timer, millis());
  }



  void initAndStartLoops()
  {
    for (int i = 0; i < filepathLoops.length; i++) 
    {
      samplesLoop[i] = SampleManager.sample(filepathLoops[i]);
      player.playLoop(samplesLoop[i], i);
      player.loopVolSet(i, 0);
    }
    timerOcean1.delay= millis();
    timerOcean2.delay = millis();
    timerKids.delay = millis();
    timerBirds.delay = millis();
  }
  
  
  void end()
  {
    player.masterFadeOut(0, 1000, true);
  } 

  class timerStorage {
    int delay;
  }
}
