class Square
{
  // interactive square, bonded to mouse & OSC events
  float square_x, square_y, square_width;
  boolean mouseOver;
  int id;
  int[] OSCArray; // Tableau OSC lié à ce bouton
  int indexArray; // Index du bouton OSC lié
  int lim; //seuil de déclenchement
  int thePage;

  Square(float _x, float _y, float _width, int _id, int[] _OSCArray, int _indexArray, int _lim, int _thePage)
  {
    square_x = _x;
    square_y = _y;
    square_width = _width;
    id = _id;
    OSCArray = _OSCArray;
    indexArray = _indexArray;
    lim = _lim;
    thePage = _thePage;
    textAlign(CENTER);
  }


  void draw()
  {
    
    if (mouseOver || OSCArray[indexArray]>lim)
    {
      fill(125);
    } else {
      fill(220);
    }
    stroke(255);
    strokeWeight(1);
    rect(square_x, square_y, square_width, square_width);
    fill(0);
    text(id, square_x +square_width/2, square_y+square_width/2);
  }

  int checkMouseOver()
  {
    
    if (mouseX > square_x && mouseX < square_x+square_width && mouseY>square_y && mouseY<square_y+square_width || OSCArray[indexArray]>lim)
    {
      mouseOver = true;
      return id;
    } else {
      mouseOver = false;
      return 0;
    }
  }
  
}
