/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.FeatureExtractor;
import beads.SegmentListener;
import beads.SegmentMaker;
import beads.TimeStamp;
import beads.UGen;
import java.util.ArrayList;
import java.util.List;

public abstract class AudioSegmenter
extends UGen
implements SegmentMaker {
    private ArrayList<FeatureExtractor<?, float[]>> listeners = new ArrayList();
    private List<SegmentListener> segmentListeners = new ArrayList<SegmentListener>();

    public AudioSegmenter(AudioContext context) {
        super(context, 1, 0);
    }

    public AudioSegmenter() {
        this(AudioSegmenter.getDefaultContext());
    }

    public void addListener(FeatureExtractor<?, float[]> fe) {
        this.listeners.add(fe);
    }

    @Override
    public void addSegmentListener(SegmentListener sl) {
        this.segmentListeners.add(sl);
    }

    @Override
    public void removeSegmentListener(SegmentListener sl) {
        this.segmentListeners.add(sl);
    }

    protected void segment(TimeStamp startTime, TimeStamp endTime, float[] data) {
        if (data != null) {
            for (FeatureExtractor featureExtractor : this.listeners) {
                featureExtractor.process(startTime, endTime, data);
            }
        }
        for (SegmentListener segmentListener : this.segmentListeners) {
            segmentListener.newSegment(startTime, endTime);
        }
    }

    public abstract void resetTimeStamp();

    public abstract void setBeginningTimeStamp(TimeStamp var1);

    public abstract void setLastTimeStamp(TimeStamp var1);

    @Override
    public String toString() {
        String result = "Segmenter: " + this.getClass().getSimpleName();
        for (FeatureExtractor<?, float[]> fe : this.listeners) {
            result = result + "\n    " + fe.getName();
        }
        return result;
    }
}

