/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.AudioIO;
import beads.UGen;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiolibs.audioservers.AudioClient;
import org.jaudiolibs.audioservers.AudioConfiguration;
import org.jaudiolibs.audioservers.AudioServer;
import org.jaudiolibs.audioservers.AudioServerProvider;
import org.jaudiolibs.audioservers.ext.ClientID;
import org.jaudiolibs.audioservers.ext.Connections;
import org.jaudiolibs.audioservers.ext.Device;
import org.jaudiolibs.audioservers.javasound.JSTimingMode;

public abstract class AudioServerIO
extends AudioIO
implements AudioClient {
    protected AudioServer server;
    protected AudioConfiguration config;
    private List<FloatBuffer> inputs;

    @Override
    protected UGen getAudioInput(int[] channels) {
        return new RTInput(this.context, channels);
    }

    public void configure(AudioConfiguration ac) throws Exception {
        if (this.config.getSampleRate() != ac.getSampleRate() || this.config.getInputChannelCount() != ac.getInputChannelCount() || this.config.getOutputChannelCount() != ac.getOutputChannelCount() || this.config.getMaxBufferSize() != ac.getMaxBufferSize() || !ac.isFixedBufferSize()) {
            System.out.println("Unexpected audio configuration");
            throw new IllegalArgumentException("Unexpected audio configuration");
        }
    }

    protected boolean runThread() {
        Thread audioThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AudioServerIO.this.server.run();
                }
                catch (Exception ex) {
                    Logger.getLogger(AudioServerIO.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }, "audio");
        audioThread.setPriority(10);
        audioThread.start();
        return true;
    }

    public boolean process(long time, List<FloatBuffer> inputs, List<FloatBuffer> outputs, int nFrames) {
        if (!this.context.isRunning()) {
            return false;
        }
        this.inputs = inputs;
        this.update();
        for (int i = 0; i < outputs.size(); ++i) {
            outputs.get(i).put(this.context.out.getOutBuffer(i));
        }
        this.inputs = null;
        return true;
    }

    public void shutdown() {
    }

    private class RTInput
    extends UGen {
        private int[] channels;

        RTInput(int[] channels) {
            this(RTInput.getDefaultContext(), channels);
        }

        RTInput(AudioContext context, int[] channels) {
            super(context, channels.length);
            this.channels = channels;
        }

        @Override
        public void calculateBuffer() {
            for (int i = 0; i < this.channels.length; ++i) {
                ((FloatBuffer)AudioServerIO.this.inputs.get(this.channels[i] - 1)).get(this.bufOut[i]);
            }
        }
    }

    protected class audioDevice
    extends Device {
        protected audioDevice(String name, int maxInputChannels, int maxOutputChannels) {
            super(name, maxInputChannels, maxOutputChannels);
        }

        protected audioDevice(String name) {
            super(name, 1, 1);
        }
    }

    public static class JavaSound
    extends AudioServerIO {
        JSTimingMode jsTiming = JSTimingMode.FramePosition;
        String device = null;
        String name = "Beads";

        public JavaSound() {
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                this.jsTiming = JSTimingMode.Estimated;
            }
        }

        public JavaSound(String device) {
            this.device = device;
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                this.jsTiming = JSTimingMode.Estimated;
            }
        }

        @Override
        protected boolean start() {
            System.out.println("Starting JavaSound implementation of AudioServerIO");
            this.config = this.device != null ? new AudioConfiguration(this.context.getSampleRate(), this.context.getAudioFormat().inputs, this.context.getAudioFormat().outputs, this.context.getBufferSize(), new Object[]{new ClientID(this.name), Connections.ALL, this.jsTiming, new audioDevice(this.device)}) : new AudioConfiguration(this.context.getSampleRate(), this.context.getAudioFormat().inputs, this.context.getAudioFormat().outputs, this.context.getBufferSize(), new Object[]{new ClientID(this.name), Connections.ALL, this.jsTiming});
            String jaudioLib = "JavaSound";
            AudioServerProvider provider = null;
            for (AudioServerProvider p : ServiceLoader.load(AudioServerProvider.class)) {
                if (!jaudioLib.equals(p.getLibraryName())) continue;
                provider = p;
                break;
            }
            if (provider == null) {
                throw new NullPointerException("No AudioServer found that matches : " + jaudioLib);
            }
            try {
                this.server = provider.createServer(this.config, (AudioClient)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.runThread();
        }
    }

    public static class Jack
    extends AudioServerIO {
        private String name = "Beads";

        public Jack() {
        }

        public Jack(String name) {
            this.name = name;
        }

        @Override
        protected boolean start() {
            System.out.println("Starting Jack implementation of AudioServerIO");
            this.config = new AudioConfiguration(this.context.getSampleRate(), this.context.getAudioFormat().inputs, this.context.getAudioFormat().outputs, this.context.getBufferSize(), new Object[]{new ClientID(this.name), Connections.ALL});
            String jaudioLib = "JACK";
            AudioServerProvider provider = null;
            for (AudioServerProvider p : ServiceLoader.load(AudioServerProvider.class)) {
                if (!jaudioLib.equals(p.getLibraryName())) continue;
                provider = p;
                break;
            }
            if (provider == null) {
                throw new NullPointerException("No AudioServer found that matches : " + jaudioLib);
            }
            try {
                this.server = provider.createServer(this.config, (AudioClient)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.runThread();
        }
    }
}

