/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.Bead;
import java.util.ArrayList;

public class BeadArray
extends Bead {
    private ArrayList<Bead> beads = new ArrayList();
    private boolean forwardKillCommand = false;
    private boolean forwardPauseCommand = false;

    public void add(Bead bead) {
        this.beads.add(bead);
    }

    public void remove(Bead bead) {
        this.beads.remove(bead);
    }

    public Bead get(int i) {
        return this.beads.get(i);
    }

    public void clear() {
        this.beads.clear();
    }

    public int size() {
        return this.beads.size();
    }

    public ArrayList<Bead> getBeads() {
        return this.beads;
    }

    @Override
    public void messageReceived(Bead message) {
        BeadArray clone = this.clone();
        for (int i = 0; i < clone.size(); ++i) {
            Bead bead = clone.get(i);
            if (bead.isDeleted()) {
                this.remove(bead);
                continue;
            }
            bead.message(message);
        }
    }

    public BeadArray clone() {
        BeadArray clone = new BeadArray();
        for (int i = 0; i < this.beads.size(); ++i) {
            clone.add(this.beads.get(i));
        }
        return clone;
    }

    public boolean doesForwardKillCommand() {
        return this.forwardKillCommand;
    }

    public void setForwardKillCommand(boolean forwardKillCommand) {
        this.forwardKillCommand = forwardKillCommand;
    }

    public boolean doesForwardPauseCommand() {
        return this.forwardPauseCommand;
    }

    public void setForwardPauseCommand(boolean forwardPauseCommand) {
        this.forwardPauseCommand = forwardPauseCommand;
    }

    @Override
    public void kill() {
        super.kill();
        if (this.forwardKillCommand) {
            BeadArray clone = this.clone();
            for (Bead bead : clone.beads) {
                if (bead.isDeleted()) {
                    this.remove(bead);
                    continue;
                }
                bead.kill();
            }
        }
    }

    @Override
    public void pause(boolean paused) {
        super.pause(paused);
        if (this.forwardPauseCommand) {
            BeadArray clone = this.clone();
            for (Bead bead : clone.beads) {
                if (bead.isDeleted()) {
                    this.remove(bead);
                    continue;
                }
                bead.pause(paused);
            }
        }
    }

    @Override
    public void start() {
        super.start();
        if (this.forwardPauseCommand) {
            BeadArray clone = this.clone();
            for (Bead bead : clone.beads) {
                if (bead.isDeleted()) {
                    this.remove(bead);
                    continue;
                }
                bead.start();
            }
        }
    }
}

