/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.BiquadFilter;
import beads.DataBead;
import beads.DataBeadReceiver;
import beads.RMS;
import beads.UGen;

public class Compressor
extends UGen
implements DataBeadReceiver {
    private int channels;
    private int memSize;
    private int index = 0;
    private float[][] delayMem;
    private UGen powerUGen;
    private BiquadFilter pf;
    private float downstep = 0.9998f;
    private float upstep = 1.0002f;
    private float ratio = 0.5f;
    private float threshold = 0.5f;
    private float knee = 1.0f;
    private float tok;
    private float kt;
    private float ikp1;
    private float ktrm1;
    private float tt1mr;
    private float attack;
    private float decay;
    private float currval = 1.0f;
    private float target = 1.0f;
    private float delay;
    private int delaySamps;
    private int rmsMemorySize = 500;
    private UGen myInputs;
    private float[][] myBufIn;

    public Compressor(AudioContext context) {
        this(context, 1);
    }

    public Compressor() {
        this(Compressor.getDefaultContext());
    }

    public Compressor(AudioContext context, int channels) {
        this(context, channels, 0.0f, null);
    }

    public Compressor(int channels) {
        this(Compressor.getDefaultContext(), channels);
    }

    public Compressor(AudioContext context, int channels, UGen sideChain) {
        this(context, channels, 0.0f, sideChain);
    }

    public Compressor(int channels, UGen sideChain) {
        this(Compressor.getDefaultContext(), channels, sideChain);
    }

    public Compressor(AudioContext context, int channels, float lookAheadDelay) {
        this(context, channels, lookAheadDelay, null);
    }

    public Compressor(int channels, float lookAheadDelay) {
        this(Compressor.getDefaultContext(), channels, lookAheadDelay);
    }

    public Compressor(AudioContext context, int channels, float lookAheadDelay, UGen sideChain) {
        super(context, channels, channels);
        this.channels = channels;
        this.delay = lookAheadDelay;
        this.delaySamps = (int)this.delay;
        this.memSize = (int)context.msToSamples(this.delay) + 1;
        this.delayMem = new float[channels][this.memSize];
        this.myBufIn = this.bufIn;
        class MyInputs
        extends UGen {
            MyInputs(AudioContext context, int channels) {
                super(context, 0, channels);
                this.bufOut = Compressor.this.myBufIn;
                this.outputInitializationRegime = UGen.OutputInitializationRegime.RETAIN;
            }

            @Override
            public void calculateBuffer() {
            }
        }
        this.myInputs = new MyInputs(context, channels);
        this.setSideChain(sideChain).setAttack(1.0f).setDecay(0.5f).setRatio(2.0f).setThreshold(0.5f).setKnee(0.5f);
    }

    public Compressor(int channels, float lookAheadDelay, UGen sideChain) {
        this(Compressor.getDefaultContext(), channels, lookAheadDelay, sideChain);
    }

    @Override
    public void calculateBuffer() {
        this.pf.update();
        if (this.channels == 1) {
            float[] bi = this.bufIn[0];
            float[] bo = this.bufOut[0];
            float[] dm = this.delayMem[0];
            for (int i = 0; i < this.bufferSize; ++i) {
                float p = this.pf.getValue(0, i);
                if (p <= this.tok) {
                    this.target = 1.0f;
                } else if (p >= this.kt) {
                    this.target = ((p - this.threshold) * this.ratio + this.threshold) / p;
                } else {
                    float x1 = (p - this.tok) * this.ikp1 + this.tok;
                    this.target = ((this.ktrm1 * x1 + this.tt1mr) * (p - x1) / (x1 * (this.knee - 1.0f)) + x1) / p;
                }
                if (this.currval > this.target) {
                    this.currval *= this.downstep;
                    if (this.currval < this.target) {
                        this.currval = this.target;
                    }
                } else if (this.currval < this.target) {
                    this.currval *= this.upstep;
                    if (this.currval > this.target) {
                        this.currval = this.target;
                    }
                }
                dm[this.index] = bi[i];
                bo[i] = dm[(this.index + this.delaySamps) % this.memSize] * this.currval;
                this.index = (this.index + 1) % this.memSize;
            }
        } else {
            for (int i = 0; i < this.bufferSize; ++i) {
                float p = this.pf.getValue(0, i);
                if (p <= this.tok) {
                    this.target = 1.0f;
                } else if (p >= this.kt) {
                    this.target = ((p - this.threshold) * this.ratio + this.threshold) / p;
                } else {
                    float x1 = (p - this.tok) * this.ikp1 + this.tok;
                    this.target = (this.ktrm1 * x1 + this.tt1mr) * (p - x1) / (x1 * (this.knee - 1.0f)) + x1;
                }
                if (this.currval > this.target) {
                    this.currval *= this.downstep;
                    if (this.currval < this.target) {
                        this.currval = this.target;
                    }
                } else if (this.currval < this.target) {
                    this.currval *= this.upstep;
                    if (this.currval > this.target) {
                        this.currval = this.target;
                    }
                }
                int delIndex = (this.index + this.delaySamps) % this.memSize;
                for (int j = 0; j < this.channels; ++j) {
                    this.delayMem[j][this.index] = this.bufIn[j][i];
                    this.bufOut[j][i] = this.delayMem[j][delIndex] * this.currval;
                }
                this.index = (this.index + 1) % this.memSize;
            }
        }
    }

    private void calcVals() {
        this.tok = this.threshold / this.knee;
        this.kt = this.knee * this.threshold;
        this.ikp1 = 1.0f / (this.knee + 1.0f);
        this.ktrm1 = this.knee * this.ratio - 1.0f;
        this.tt1mr = this.threshold * (1.0f - this.ratio);
    }

    public Compressor setSideChain(UGen sideChain) {
        this.pf = new BiquadFilter(this.context, 1, BiquadFilter.BUTTERWORTH_LP).setFrequency(31.0f);
        if (sideChain == null) {
            this.powerUGen = new RMS(this.context, this.channels, this.rmsMemorySize);
            this.powerUGen.addInput(this.myInputs);
            this.pf.addInput(this.powerUGen);
        } else {
            this.powerUGen = new RMS(this.context, sideChain.getOuts(), this.rmsMemorySize);
            this.powerUGen.addInput(sideChain);
            this.pf.addInput(this.powerUGen);
        }
        return this;
    }

    public float getAttack() {
        return this.attack;
    }

    public Compressor setAttack(float attack) {
        if (attack < 1.0E-4f) {
            attack = 1.0E-4f;
        }
        this.attack = attack;
        this.downstep = (float)Math.pow(Math.pow(10.0, attack / 20.0f), -1000.0f / this.context.getSampleRate());
        return this;
    }

    public float getDecay() {
        return this.decay;
    }

    public Compressor setDecay(float decay) {
        if (decay < 1.0E-4f) {
            decay = 1.0E-4f;
        }
        this.decay = decay;
        this.upstep = (float)Math.pow(Math.pow(10.0, decay / 20.0f), 1000.0f / this.context.getSampleRate());
        return this;
    }

    public float getRatio() {
        return 1.0f / this.ratio;
    }

    public Compressor setRatio(float ratio) {
        if (ratio <= 0.0f) {
            ratio = 0.01f;
        }
        this.ratio = 1.0f / ratio;
        this.calcVals();
        return this;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public Compressor setThreshold(float threshold) {
        this.threshold = threshold;
        this.calcVals();
        return this;
    }

    public float getKnee() {
        return this.knee - 1.0f;
    }

    public Compressor setKnee(float knee) {
        this.knee = knee + 1.0f;
        this.calcVals();
        return this;
    }

    @Override
    public DataBeadReceiver sendData(DataBead db) {
        if (db != null) {
            this.setThreshold(db.getFloat("threshold", this.threshold));
            this.setRatio(db.getFloat("ratio", this.getRatio()));
            this.setAttack(db.getFloat("attack", this.getAttack()));
            this.setDecay(db.getFloat("decay", this.getDecay()));
            this.setKnee(db.getFloat("knee", this.getKnee()));
            this.setSideChain(db.getUGen("sidechain"));
        }
        return this;
    }

    public DataBead getParams() {
        DataBead db = new DataBead();
        db.put("threshold", (Object)Float.valueOf(this.getThreshold()));
        db.put("ratio", (Object)Float.valueOf(this.getRatio()));
        db.put("attack", (Object)Float.valueOf(this.getAttack()));
        db.put("decay", (Object)Float.valueOf(this.getDecay()));
        db.put("knee", (Object)Float.valueOf(this.getKnee()));
        return db;
    }

    public float getCurrentCompression() {
        return this.currval;
    }
}

