/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.Buffer;
import beads.BufferFactory;

public class CurveBuffer
extends BufferFactory {
    private final float curviness;

    public CurveBuffer(float curviness) {
        this.curviness = Math.min(1.0f, Math.max(-1.0f, curviness));
    }

    @Override
    public Buffer generateBuffer(int bufferSize) {
        Buffer b = new Buffer(bufferSize);
        double exponent = Math.exp(-this.curviness);
        for (int i = 0; i < bufferSize; ++i) {
            b.buf[i] = (float)Math.pow((float)i / (float)bufferSize, exponent);
        }
        return b;
    }

    @Override
    public String getName() {
        return "Curve " + this.curviness;
    }
}

