/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.Bead;
import beads.TimeStamp;
import java.util.ArrayList;

public abstract class FeatureExtractor<R, P>
extends Bead {
    protected int numFeatures;
    protected R features = null;
    protected String name = this.getClass().getSimpleName();
    protected String[] featureDescriptions;
    private ArrayList<FeatureExtractor<?, R>> featureExtractorListeners = new ArrayList();

    public abstract void process(TimeStamp var1, TimeStamp var2, P var3);

    public void forward(TimeStamp startTime, TimeStamp endTime) {
        for (FeatureExtractor<?, R> fe : this.featureExtractorListeners) {
            fe.process(startTime, endTime, this.features);
        }
    }

    public void addListener(FeatureExtractor<?, R> listener) {
        this.featureExtractorListeners.add(listener);
    }

    public void removeListener(FeatureExtractor<?, R> listener) {
        this.featureExtractorListeners.remove(listener);
    }

    public R getFeatures() {
        return this.features;
    }

    public int getNumberOfFeatures() {
        return this.numFeatures;
    }

    public void setNumberOfFeatures(int numFeatures) {
        this.numFeatures = numFeatures;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String[] getFeatureDescriptions() {
        return this.featureDescriptions;
    }
}

