/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.FeatureSet;
import beads.Sample;
import beads.SampleManager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

public class FeatureManager {
    private static final Map<Sample, FeatureSet> featureSets = new Hashtable<Sample, FeatureSet>();
    private static boolean verbose = true;

    public static void setFeaturesForSample(Sample s, FeatureSet fs) {
        featureSets.put(s, fs);
    }

    public static FeatureSet featuresForSample(Sample sample) {
        if (featureSets.containsKey(sample)) {
            return featureSets.get(sample);
        }
        FeatureSet set = FeatureSet.forSample(sample);
        if (set != null) {
            featureSets.put(sample, set);
            if (verbose) {
                System.out.println("Loaded features for " + sample.getFileName());
            }
        } else if (verbose) {
            System.out.println("Could not find features for " + sample.getFileName());
        }
        return set;
    }

    public static FeatureSet featuresForSampleIfLoaded(Sample sample) {
        if (featureSets.containsKey(sample)) {
            return featureSets.get(sample);
        }
        return null;
    }

    public static void featuresForGroup(String groupName) {
        ArrayList<Sample> theSamples = SampleManager.getGroup(groupName);
        if (theSamples != null) {
            for (Sample s : theSamples) {
                FeatureManager.featuresForSample(s);
            }
        }
    }

    public static void removeSample(Sample s) {
        if (featureSets.containsKey(s)) {
            featureSets.remove(s);
        }
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean verbose) {
        FeatureManager.verbose = verbose;
    }
}

