/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.UGen;

public class Mult
extends UGen {
    private float multiplier = 1.0f;
    private UGen multiplierUGen;

    public Mult(AudioContext context, int channels, float multiplier) {
        super(context, channels, channels);
        this.setMultiplier(multiplier);
    }

    public Mult(int channels, float multiplier) {
        this(Mult.getDefaultContext(), channels, multiplier);
    }

    public Mult(AudioContext context, int channels, UGen multiplierUGen) {
        super(context, channels, channels);
        this.setMultiplier(multiplierUGen);
    }

    public Mult(int channels, UGen multiplierUGen) {
        this(Mult.getDefaultContext(), channels, multiplierUGen);
    }

    public Mult(AudioContext context, UGen input, UGen multiplierUGen) {
        super(context, input.getOuts(), input.getOuts());
        this.setMultiplier(multiplierUGen);
        this.addInput(input);
    }

    public Mult(UGen input, UGen multiplierUGen) {
        this(Mult.getDefaultContext(), input, multiplierUGen);
    }

    @Override
    public void calculateBuffer() {
        if (this.multiplierUGen == null) {
            for (int j = 0; j < this.outs; ++j) {
                float[] bi = this.bufIn[j];
                float[] bo = this.bufOut[j];
                for (int i = 0; i < this.bufferSize; ++i) {
                    bo[i] = bi[i] * this.multiplier;
                }
            }
        } else {
            this.multiplierUGen.update();
            if (this.outs == 1) {
                float[] bi = this.bufIn[0];
                float[] bo = this.bufOut[0];
                for (int i = 0; i < this.bufferSize; ++i) {
                    this.multiplier = this.multiplierUGen.getValue(0, i);
                    bo[i] = bi[i] * this.multiplier;
                }
            } else {
                for (int i = 0; i < this.bufferSize; ++i) {
                    for (int j = 0; j < this.outs; ++j) {
                        this.multiplier = this.multiplierUGen.getValue(0, i);
                        this.bufOut[j][i] = this.bufIn[j][i] * this.multiplier;
                    }
                }
            }
        }
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public Mult setMultiplier(float multiplier) {
        this.multiplier = multiplier;
        this.multiplierUGen = null;
        return this;
    }

    public Mult setMultiplier(UGen multiplierUGen) {
        if (multiplierUGen == null) {
            this.setMultiplier(this.multiplier);
        } else {
            this.multiplierUGen = multiplierUGen;
            multiplierUGen.update();
            this.multiplier = multiplierUGen.getValue();
        }
        return this;
    }

    public UGen getMultiplierUGen() {
        return this.multiplierUGen;
    }
}

