/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.Sample;
import beads.UGen;

public class RecordToSample
extends UGen {
    private Sample sample = null;
    private long position;
    private long framesWritten;
    private Mode mode = Mode.FINITE;
    private double doubleUpTime = 0.0;
    private double constantResizeLength = 10000.0;
    private long doubleUpFrame;
    private long constantResizeLengthInFrames;

    public RecordToSample(AudioContext context, Sample sample) {
        this(context, sample, Mode.FINITE);
    }

    public RecordToSample(Sample sample) {
        this(RecordToSample.getDefaultContext(), sample);
    }

    public RecordToSample(AudioContext context, Sample sample, Mode mode) {
        this(context, sample.getNumChannels());
        this.mode = mode;
        this.setSample(sample);
    }

    public RecordToSample(Sample sample, Mode mode) {
        this(RecordToSample.getDefaultContext(), sample, mode);
    }

    public RecordToSample(AudioContext context, int numChannels) {
        super(context, numChannels, 0);
    }

    public RecordToSample(int numChannels) {
        this(RecordToSample.getDefaultContext(), numChannels);
    }

    public Sample getSample() {
        return this.sample;
    }

    public void setSample(Sample sample) {
        this.sample = sample;
        this.framesWritten = 0L;
        this.position = 0L;
        this.doubleUpFrame = (long)sample.msToSamples(this.doubleUpTime);
        this.constantResizeLengthInFrames = (long)sample.msToSamples(this.constantResizeLength);
    }

    public void reset() {
        this.position = 0L;
    }

    public void clip() {
        this.sample.resize(this.framesWritten);
    }

    public void setPosition(double positionMs) {
        this.framesWritten = this.position = (long)this.sample.msToSamples(positionMs);
    }

    @Override
    public void calculateBuffer() {
        if (this.sample != null) {
            long nFrames = this.sample.getNumFrames();
            if (this.position + (long)this.bufferSize >= nFrames) {
                switch (this.mode) {
                    case FINITE: {
                        this.sample.putFrames((int)this.position, this.bufIn, 0, (int)(nFrames - this.position));
                        this.framesWritten = Math.max(this.framesWritten, nFrames);
                        this.kill();
                        break;
                    }
                    case LOOPING: {
                        int framesToEnd = (int)(nFrames - this.position);
                        int numframesleft = this.bufferSize - framesToEnd;
                        this.sample.putFrames((int)this.position, this.bufIn, 0, framesToEnd);
                        this.sample.putFrames(0, this.bufIn, framesToEnd, numframesleft);
                        this.position += (long)this.bufferSize;
                        this.position %= nFrames;
                        this.framesWritten = Math.max(this.framesWritten, nFrames);
                        break;
                    }
                    case INFINITE: {
                        try {
                            if (this.position < this.doubleUpFrame) {
                                this.sample.resize(nFrames * 2L);
                            } else {
                                this.sample.resize(nFrames + this.constantResizeLengthInFrames);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.sample.putFrames((int)this.position, this.bufIn);
                        this.position += (long)this.bufferSize;
                        this.framesWritten = Math.max(this.framesWritten, this.position);
                    }
                }
            } else {
                this.sample.putFrames((int)this.position, this.bufIn);
                this.position += (long)this.bufferSize;
                this.framesWritten = Math.max(this.framesWritten, this.position);
            }
        }
    }

    public double getPosition() {
        return this.context.samplesToMs(this.position);
    }

    public long getNumFramesRecorded() {
        return this.framesWritten;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setResizingParameters(double doubleUpTime, double constantResizeLength) {
        this.doubleUpTime = doubleUpTime;
        this.constantResizeLength = constantResizeLength;
        this.doubleUpFrame = (long)this.sample.msToSamples(this.doubleUpTime);
        this.constantResizeLengthInFrames = (long)this.sample.msToSamples(this.constantResizeLength);
    }

    public boolean isLoopRecord() {
        return this.mode == Mode.LOOPING;
    }

    public void setLoopRecord(boolean loopRecord) {
        this.mode = Mode.LOOPING;
    }

    public static enum Mode {
        FINITE,
        LOOPING,
        INFINITE;

    }
}

