/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioFileReader;
import beads.AudioFileType;
import beads.AudioFileWriter;
import beads.SampleAudioFormat;
import java.io.IOException;
import java.util.Arrays;

public class Sample {
    private float sampleRate;
    private int nChannels;
    private long nFrames;
    private String simpleName;
    private String filename = null;
    private float[][] theSampleData;
    private float[] current;
    private float[] next;
    private Class<? extends AudioFileReader> audioFileReaderClass = null;
    private Class<? extends AudioFileWriter> audioFileWriterClass = null;
    private static Class<? extends AudioFileReader> defaultAudioFileReaderClass;
    private static Class<? extends AudioFileWriter> defaultAudioFileWriterClass;

    public Sample(double length) {
        this(length, 2, 44100.0f);
    }

    public Sample(double length, int nChannels) {
        this(length, nChannels, 44100.0f);
    }

    public Sample(double length, int nChannels, float sampleRate) {
        this.nChannels = nChannels;
        this.sampleRate = sampleRate;
        this.current = new float[nChannels];
        this.next = new float[nChannels];
        this.nFrames = (long)this.msToSamples(length);
        this.theSampleData = new float[nChannels][(int)this.nFrames];
        length = 1000.0f * (float)this.nFrames / this.sampleRate;
    }

    public Sample(String filename) throws IOException {
        this.loadAudioFile(filename);
        this.filename = filename;
    }

    public Class<? extends AudioFileReader> getAudioFileReaderClass() {
        return this.audioFileReaderClass;
    }

    public Class<? extends AudioFileWriter> getAudioFileWriterClass() {
        return this.audioFileWriterClass;
    }

    public void setAudioFileReaderClass(Class<? extends AudioFileReader> audioFileReaderClass) {
        this.audioFileReaderClass = audioFileReaderClass;
    }

    public void setAudioFileWriterClass(Class<? extends AudioFileWriter> audioFileWriterClass) {
        this.audioFileWriterClass = audioFileWriterClass;
    }

    public void getFrame(int frame, float[] frameData) {
        if (frame < 0 || (long)frame >= this.nFrames) {
            return;
        }
        for (int i = 0; i < this.nChannels; ++i) {
            frameData[i] = this.theSampleData[i][frame];
        }
    }

    public void getFrameNoInterp(double posInMS, float[] result) {
        double frame = this.msToSamples(posInMS);
        int frame_floor = (int)Math.floor(frame);
        this.getFrame(frame_floor, result);
    }

    public void getFrameLinear(double posInMS, float[] result) {
        double frame = this.msToSamples(posInMS);
        int frame_floor = (int)Math.floor(frame);
        if (frame_floor > 0 && (long)frame_floor < this.nFrames) {
            double frame_frac = frame - (double)frame_floor;
            if ((long)frame_floor == this.nFrames - 1L) {
                this.getFrame(frame_floor, result);
            } else {
                this.getFrame(frame_floor, this.current);
                this.getFrame(frame_floor + 1, this.next);
                for (int i = 0; i < this.nChannels; ++i) {
                    result[i] = (float)((1.0 - frame_frac) * (double)this.current[i] + frame_frac * (double)this.next[i]);
                }
            }
        } else {
            for (int i = 0; i < this.nChannels; ++i) {
                result[i] = 0.0f;
            }
        }
    }

    public void getFrameCubic(double posInMS, float[] result) {
        double frame = this.msToSamples(posInMS);
        for (int i = 0; i < this.nChannels; ++i) {
            int realCurrentSample = (int)Math.floor(frame);
            float fractionOffset = (float)(frame - (double)realCurrentSample);
            if (realCurrentSample >= 0 && (long)realCurrentSample < this.nFrames - 1L) {
                float y2;
                float y1;
                float ym1;
                if (--realCurrentSample < 0) {
                    this.getFrame(0, this.current);
                    ym1 = this.current[i];
                    realCurrentSample = 0;
                } else {
                    this.getFrame(realCurrentSample++, this.current);
                    ym1 = this.current[i];
                }
                this.getFrame(realCurrentSample++, this.current);
                float y0 = this.current[i];
                if ((long)realCurrentSample >= this.nFrames) {
                    this.getFrame((int)this.nFrames - 1, this.current);
                    y1 = this.current[i];
                } else {
                    this.getFrame(realCurrentSample++, this.current);
                    y1 = this.current[i];
                }
                if ((long)realCurrentSample >= this.nFrames) {
                    this.getFrame((int)this.nFrames - 1, this.current);
                    y2 = this.current[i];
                } else {
                    this.getFrame(realCurrentSample++, this.current);
                    y2 = this.current[i];
                }
                float mu2 = fractionOffset * fractionOffset;
                float a0 = y2 - y1 - ym1 + y0;
                float a1 = ym1 - y0 - a0;
                float a2 = y1 - ym1;
                float a3 = y0;
                result[i] = a0 * fractionOffset * mu2 + a1 * mu2 + a2 * fractionOffset + a3;
                continue;
            }
            result[i] = 0.0f;
        }
    }

    public void getFrames(int frame, float[][] frameData) {
        if ((long)frame >= this.nFrames) {
            return;
        }
        int numFloats = Math.min(frameData[0].length, (int)(this.nFrames - (long)frame));
        for (int i = 0; i < this.nChannels; ++i) {
            System.arraycopy(this.theSampleData[i], frame, frameData[i], 0, numFloats);
        }
    }

    public void clear() {
        for (int i = 0; i < this.nChannels; ++i) {
            Arrays.fill(this.theSampleData[i], 0.0f);
        }
    }

    public void putFrame(int frame, float[] frameData) {
        for (int i = 0; i < this.nChannels; ++i) {
            this.theSampleData[i][frame] = frameData[i];
        }
    }

    public void putFrames(int frame, float[][] frameData) {
        int numFrames = Math.min(frameData[0].length, (int)(this.nFrames - (long)frame));
        if (frame < 0) {
            return;
        }
        for (int i = 0; i < this.nChannels; ++i) {
            System.arraycopy(frameData[i], 0, this.theSampleData[i], frame, numFrames);
        }
    }

    public void putFrames(int frame, float[][] frameData, int offset, int numFrames) {
        if (numFrames <= 0) {
            return;
        }
        numFrames = Math.min(numFrames, (int)(this.nFrames - (long)frame));
        for (int i = 0; i < this.nChannels; ++i) {
            System.arraycopy(frameData[i], offset, this.theSampleData[i], frame, numFrames);
        }
    }

    public void write(String fn) throws IOException {
        this.write(fn, AudioFileType.WAV);
    }

    public void write(String fn, AudioFileType type) throws IOException {
        this.write(fn, type, new SampleAudioFormat(this.sampleRate, 16, this.nChannels));
    }

    public void write(String fn, AudioFileType type, SampleAudioFormat saf) throws IOException {
        Class<AudioFileWriter> theRealAudioFileWriterClass;
        Class<? extends AudioFileWriter> clazz = theRealAudioFileWriterClass = this.audioFileWriterClass == null ? defaultAudioFileWriterClass : this.audioFileWriterClass;
        if (type == AudioFileType.WAV) {
            try {
                theRealAudioFileWriterClass = Class.forName("beads.WavFileReaderWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (theRealAudioFileWriterClass == null) {
            throw new IOException("Sample: No AudioFile Class has been set and the default JavaSoundAudioFile Class cannot be found. Aborting write(). You may need to link to beads-io.jar.");
        }
        try {
            AudioFileWriter audioFileWriter = theRealAudioFileWriterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            audioFileWriter.writeAudioFile(this.theSampleData, fn, type, saf);
        }
        catch (Exception e) {
            throw new IOException("Sample: Unable to create or use the AudioFileWriter class.", e);
        }
    }

    public void resize(long frames) {
        int framesToCopy = (int)Math.min(frames, this.nFrames);
        float[][] olddata = this.theSampleData;
        this.theSampleData = new float[this.nChannels][(int)frames];
        for (int i = 0; i < this.nChannels; ++i) {
            System.arraycopy(olddata[i], 0, this.theSampleData[i], 0, framesToCopy);
        }
        this.nFrames = frames;
    }

    public void resizeWithZeros(long frames) {
        this.nFrames = frames;
    }

    public double msToSamples(double msTime) {
        return msTime * (double)this.sampleRate / 1000.0;
    }

    public double samplesToMs(double sampleTime) {
        return sampleTime / (double)this.sampleRate * 1000.0;
    }

    public String toString() {
        return this.getFileName();
    }

    public String getFileName() {
        if (this.filename == null) {
            return null;
        }
        return this.filename;
    }

    public String getSimpleName() {
        if (this.simpleName != null) {
            return this.simpleName;
        }
        String fileName = this.getFileName();
        if (fileName == null) {
            return null;
        }
        String[] nameParts = fileName.split("/");
        return nameParts[nameParts.length - 1];
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getNumChannels() {
        return this.nChannels;
    }

    public long getNumFrames() {
        return this.nFrames;
    }

    public double getLength() {
        return 1000.0f * (float)this.nFrames / this.sampleRate;
    }

    private void loadAudioFile(String file) throws IOException {
        AudioFileReader audioFileReader;
        Class<AudioFileReader> theRealAudioFileReaderClass;
        Class<? extends AudioFileReader> clazz = theRealAudioFileReaderClass = this.audioFileReaderClass == null ? defaultAudioFileReaderClass : this.audioFileReaderClass;
        if (file.endsWith(".wav") || file.endsWith(".WAV")) {
            try {
                theRealAudioFileReaderClass = Class.forName("beads.WavFileReaderWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            audioFileReader = theRealAudioFileReaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e1) {
            throw new IOException("Sample: No AudioFileReader Class has been set and the default JavaSoundAudioFile Class cannot be found. Aborting write(). You may need to link to beads-io.jar.");
        }
        try {
            this.theSampleData = audioFileReader.readAudioFile(file);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.sampleRate = audioFileReader.getSampleAudioFormat().sampleRate;
        this.nChannels = this.theSampleData.length;
        this.nFrames = this.theSampleData[0].length;
        this.current = new float[this.nChannels];
        this.next = new float[this.nChannels];
    }

    static {
        try {
            defaultAudioFileReaderClass = Class.forName("beads.JavaSoundAudioFile");
        }
        catch (ClassNotFoundException e) {
            try {
                defaultAudioFileReaderClass = Class.forName("beads.WavFileReaderWriter");
            }
            catch (ClassNotFoundException e2) {
                defaultAudioFileReaderClass = null;
            }
        }
        try {
            defaultAudioFileWriterClass = Class.forName("beads.JavaSoundAudioFile");
        }
        catch (ClassNotFoundException e) {
            try {
                defaultAudioFileWriterClass = Class.forName("beads.WavFileReaderWriter");
            }
            catch (ClassNotFoundException e2) {
                defaultAudioFileWriterClass = null;
            }
        }
    }
}

