/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.FeatureExtractor;
import beads.TimeStamp;

public class SpectralPeaks
extends FeatureExtractor<float[][], float[]> {
    static final int FIRSTBAND = 3;
    private float bin2hz = -1.0f;
    private float samplingRate;

    public SpectralPeaks(AudioContext context) {
        this(context, 10);
    }

    public SpectralPeaks(AudioContext context, int numFeatures) {
        this.samplingRate = context.getSampleRate();
        this.setNumberOfFeatures(numFeatures);
    }

    @Override
    public synchronized void process(TimeStamp startTime, TimeStamp endTime, float[] powerSpectrum) {
        if (this.bin2hz < 0.0f) {
            this.bin2hz = this.samplingRate / (float)(2 * powerSpectrum.length - 1);
        }
        double[] linSpec = new double[powerSpectrum.length];
        for (int band = 0; band < linSpec.length; ++band) {
            linSpec[band] = powerSpectrum[band];
        }
        for (int i = 0; i < ((float[][])this.features).length; ++i) {
            double pmax = -1.0;
            int maxbin = 0;
            for (int band = 3; band < powerSpectrum.length; ++band) {
                double pwr = linSpec[band];
                if (!(pwr > pmax)) continue;
                pmax = pwr;
                maxbin = band;
            }
            double yz = linSpec[maxbin];
            double ym = maxbin <= 0 ? linSpec[maxbin] : linSpec[maxbin - 1];
            double yp = maxbin < linSpec.length - 1 ? linSpec[maxbin + 1] : linSpec[maxbin];
            double k = (yp + ym) / 2.0 - yz;
            double x0 = (ym - yp) / (4.0 * k);
            ((float[][])this.features)[i][0] = (float)((double)this.bin2hz * ((double)maxbin + x0));
            ((float[][])this.features)[i][1] = (float)pmax;
            ((float[][])this.features)[i][1] = (float)Math.sqrt(((float[][])this.features)[i][1] / (float)powerSpectrum.length);
            if (Float.isNaN(((float[][])this.features)[i][0]) || ((float[][])this.features)[i][0] < 0.0f) {
                ((float[][])this.features)[i][0] = 0.0f;
                ((float[][])this.features)[i][1] = 0.0f;
            }
            linSpec[maxbin] = -1.0;
        }
        this.forward(startTime, endTime);
    }

    @Override
    public float[][] getFeatures() {
        float[][] original = (float[][])this.features;
        float[][] copy = new float[original.length][original[0].length];
        for (int i = 0; i < copy.length; ++i) {
            for (int j = 0; j < copy[i].length; ++j) {
                copy[i][j] = original[i][j];
            }
        }
        return copy;
    }

    @Override
    public void setNumberOfFeatures(int numFeatures) {
        this.features = new float[numFeatures][2];
        this.featureDescriptions = new String[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            this.featureDescriptions[i] = "peak" + i;
        }
    }
}

