/*
 * Decompiled with CFR 0.152.
 */
package beads;

import beads.AudioContext;
import beads.Buffer;
import beads.Static;
import beads.UGen;

public class WavePlayer
extends UGen {
    private double phase;
    private UGen frequencyEnvelope;
    private UGen phaseEnvelope;
    private Buffer buffer;
    private float frequency;
    private float one_over_sr;
    private boolean isFreqStatic;

    private WavePlayer(AudioContext context, Buffer buffer) {
        super(context, 1);
        this.buffer = buffer;
        this.phase = 0.0;
        System.out.println(context);
        this.one_over_sr = 1.0f / context.getSampleRate();
    }

    public WavePlayer(AudioContext context, UGen frequencyController, Buffer buffer) {
        this(context, buffer);
        this.setFrequency(frequencyController);
    }

    public WavePlayer(UGen frequencyController, Buffer buffer) {
        this(WavePlayer.getDefaultContext(), frequencyController, buffer);
    }

    public WavePlayer(AudioContext context, float frequency, Buffer buffer) {
        this(context, buffer);
        this.setFrequency(frequency);
    }

    public WavePlayer(float frequency, Buffer buffer) {
        this(WavePlayer.getDefaultContext(), frequency, buffer);
    }

    @Override
    public void start() {
        super.start();
        this.phase = 0.0;
    }

    @Override
    public void calculateBuffer() {
        this.frequencyEnvelope.update();
        float[] bo = this.bufOut[0];
        if (this.phaseEnvelope == null) {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.frequency = this.frequencyEnvelope.getValue(0, i);
                this.phase = ((this.phase + (double)(this.frequency * this.one_over_sr)) % 1.0 + 1.0) % 1.0;
                bo[i] = this.buffer.getValueFraction((float)this.phase);
            }
        } else {
            this.phaseEnvelope.update();
            for (int i = 0; i < this.bufferSize; ++i) {
                bo[i] = this.buffer.getValueFraction(this.phaseEnvelope.getValue(0, i));
            }
        }
    }

    @Deprecated
    public UGen getFrequencyEnvelope() {
        return this.frequencyEnvelope;
    }

    public UGen getFrequencyUGen() {
        if (this.isFreqStatic) {
            return null;
        }
        return this.frequencyEnvelope;
    }

    public float getFrequency() {
        return this.frequency;
    }

    @Deprecated
    public void setFrequencyEnvelope(UGen frequencyEnvelope) {
        this.setFrequency(frequencyEnvelope);
    }

    public WavePlayer setFrequency(UGen frequencyUGen) {
        if (frequencyUGen == null) {
            this.setFrequency(this.frequency);
        } else {
            this.frequencyEnvelope = frequencyUGen;
            this.isFreqStatic = false;
        }
        return this;
    }

    public WavePlayer setFrequency(float frequency) {
        if (this.isFreqStatic) {
            ((Static)this.frequencyEnvelope).setValue(frequency);
        } else {
            this.frequencyEnvelope = new Static(this.context, frequency);
            this.isFreqStatic = true;
        }
        this.frequency = frequency;
        return this;
    }

    @Deprecated
    public UGen getPhaseEnvelope() {
        return this.phaseEnvelope;
    }

    public UGen getPhaseUGen() {
        return this.phaseEnvelope;
    }

    public float getPhase() {
        return (float)this.phase;
    }

    @Deprecated
    public void setPhaseEnvelope(UGen phaseEnvelope) {
        this.setPhase(phaseEnvelope);
    }

    public WavePlayer setPhase(UGen phaseController) {
        this.phaseEnvelope = phaseController;
        if (phaseController != null) {
            this.phase = phaseController.getValue();
        }
        return this;
    }

    public WavePlayer setPhase(float phase) {
        this.phase = phase;
        this.phaseEnvelope = null;
        return this;
    }

    public WavePlayer setBuffer(Buffer b) {
        this.buffer = b;
        return this;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }
}

