/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.jnajack;

import com.sun.jna.Callback;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jaudiolibs.jnajack.JackClient;
import org.jaudiolibs.jnajack.JackException;
import org.jaudiolibs.jnajack.JackOptions;
import org.jaudiolibs.jnajack.JackPortFlags;
import org.jaudiolibs.jnajack.JackPortType;
import org.jaudiolibs.jnajack.JackStatus;
import org.jaudiolibs.jnajack.lowlevel.JackLibrary;
import org.jaudiolibs.jnajack.lowlevel.JackLibraryDirect;

public class Jack {
    private static final Logger LOG = Logger.getLogger(Jack.class.getName());
    private static final String CALL_ERROR_MSG = "Error calling native lib";
    private static final String PROP_DISABLE_CTI = "jnajack.disable-cti";
    private static Jack instance;
    final JackLibrary jackLib;
    private Method setCTIMethod;
    private Method detachMethod;
    private Constructor<?> ctiConstructor;

    private Jack(JackLibrary jackLib) {
        this.jackLib = jackLib;
        if (!Boolean.getBoolean(PROP_DISABLE_CTI)) {
            this.initCallbackMethods();
        }
    }

    private void initCallbackMethods() {
        try {
            Class<?> ctiClass = Class.forName("com.sun.jna.CallbackThreadInitializer", true, Native.class.getClassLoader());
            this.setCTIMethod = Native.class.getMethod("setCallbackThreadInitializer", Callback.class, ctiClass);
            this.detachMethod = Native.class.getMethod("detach", Boolean.TYPE);
            this.ctiConstructor = ctiClass.getConstructor(Boolean.TYPE, Boolean.TYPE, String.class);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "You seem to be using a version of JNA below 3.4.0 - performance may suffer");
            LOG.log(Level.FINE, "Exception creating CTI reflection methods", ex);
            this.setCTIMethod = null;
            this.detachMethod = null;
            this.ctiConstructor = null;
        }
    }

    void setupCTI(Callback callback) {
        if (this.setCTIMethod == null) {
            return;
        }
        try {
            this.setCTIMethod.invoke(null, callback, this.ctiConstructor.newInstance(false, false, "JNAJack"));
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Error setting up CallbackThreadInitializer", ex);
        }
    }

    void forceThreadDetach() {
        if (this.detachMethod == null) {
            return;
        }
        try {
            this.detachMethod.invoke(null, true);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Error invoking Native.detach(true)", ex);
        }
    }

    public JackClient openClient(String name, EnumSet<JackOptions> options, EnumSet<JackStatus> status) throws JackException {
        int opt = 0;
        if (options != null) {
            for (JackOptions option : options) {
                opt |= option.getIntValue();
            }
        }
        IntByReference statRef = new IntByReference(0);
        JackLibrary._jack_client cl = null;
        try {
            cl = this.jackLib.jack_client_open(name, opt, statRef);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException("Could not create Jack client", e);
        }
        int statVal = statRef.getValue();
        if (status != null) {
            status.clear();
            for (JackStatus stat : JackStatus.values()) {
                if ((stat.getIntValue() & statVal) == 0) continue;
                status.add(stat);
            }
        }
        if (cl == null) {
            throw new JackException("Could not create Jack client, check status set.");
        }
        if ((JackStatus.JackNameNotUnique.getIntValue() & statVal) != 0) {
            try {
                name = this.jackLib.jack_get_client_name(cl);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
                try {
                    this.jackLib.jack_client_close(cl);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new JackException("Could not create Jack client, check status set.", e);
            }
        }
        return new JackClient(name, this, cl);
    }

    public JackClient openClient(String name, EnumSet<JackOptions> options, EnumSet<JackStatus> status, Object ... args) throws JackException {
        return this.openClient(name, options, status);
    }

    @Deprecated
    public String[] getPorts(String regex, JackPortType type, EnumSet<JackPortFlags> flags) throws JackException {
        JackClient client = this.openClient("__jnajack__", EnumSet.of(JackOptions.JackNoStartServer), null);
        String[] ret = this.getPorts(client, regex, type, flags);
        client.close();
        return ret;
    }

    public String[] getPorts(JackClient client, String regex, JackPortType type, EnumSet<JackPortFlags> flags) throws JackException {
        int fl = 0;
        if (flags != null) {
            for (JackPortFlags flag : flags) {
                fl |= flag.getIntValue();
            }
        }
        String typeString = type == null ? null : type.getTypeString();
        try {
            Pointer ptr = this.jackLib.jack_get_ports(client.clientPtr, null, typeString, new NativeLong((long)fl));
            if (ptr == null) {
                return new String[0];
            }
            String[] names = ptr.getStringArray(0L);
            this.jackLib.jack_free(ptr);
            if (regex != null && !regex.isEmpty()) {
                names = this.filterRegex(names, regex);
            }
            return names;
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    private String[] filterRegex(String[] names, String regex) {
        Pattern pattern = Pattern.compile(regex);
        ArrayList<String> list = new ArrayList<String>();
        for (String name : names) {
            if (!pattern.matcher(name).find()) continue;
            list.add(name);
        }
        return list.toArray(new String[list.size()]);
    }

    @Deprecated
    public void connect(String source, String destination) throws JackException {
        JackClient client = this.openClient("__jnajack__", EnumSet.of(JackOptions.JackNoStartServer), null);
        this.connect(client, source, destination);
        client.close();
    }

    public void connect(JackClient client, String source, String destination) throws JackException {
        int ret = -1;
        try {
            ret = this.jackLib.jack_connect(client.clientPtr, source, destination);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
        if (ret != 0) {
            throw new JackException();
        }
    }

    @Deprecated
    public void disconnect(String source, String destination) throws JackException {
        JackClient client = this.openClient("__jnajack__", EnumSet.of(JackOptions.JackNoStartServer), null);
        this.disconnect(client, source, destination);
        client.close();
    }

    public void disconnect(JackClient client, String source, String destination) throws JackException {
        int ret = -1;
        try {
            ret = this.jackLib.jack_disconnect(client.clientPtr, source, destination);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
        if (ret != 0) {
            throw new JackException();
        }
    }

    public int getMaximumClientNameSize() throws JackException {
        try {
            return this.jackLib.jack_client_name_size() - 1;
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public int getMaximumPortNameSize() throws JackException {
        try {
            return this.jackLib.jack_port_name_size() - 1;
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public long getTime() throws JackException {
        try {
            return this.jackLib.jack_get_time().longValue();
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public String[] getAllConnections(JackClient client, String fullPortName) throws JackException {
        if (fullPortName == null) {
            throw new NullPointerException("fullPortName is null.");
        }
        try {
            JackLibrary._jack_port port = this.jackLib.jack_port_by_name(client.clientPtr, fullPortName);
            Pointer ptr = this.jackLib.jack_port_get_all_connections(client.clientPtr, port);
            if (ptr == null) {
                return new String[0];
            }
            String[] res = ptr.getStringArray(0L);
            this.jackLib.jack_free(ptr);
            return res;
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public static synchronized Jack getInstance() throws JackException {
        JackLibraryDirect jackLib;
        if (instance != null) {
            return instance;
        }
        try {
            jackLib = new JackLibraryDirect();
        }
        catch (Throwable e) {
            throw new JackException("Can't find native library", e);
        }
        instance = new Jack(jackLib);
        return instance;
    }
}

