/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.jnajack;

import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiolibs.jnajack.JackClient;
import org.jaudiolibs.jnajack.JackException;
import org.jaudiolibs.jnajack.JackLatencyCallbackMode;
import org.jaudiolibs.jnajack.JackPortType;
import org.jaudiolibs.jnajack.lowlevel.JackLibrary;

public class JackPort {
    private static final Logger LOG = Logger.getLogger(JackPort.class.getName());
    private static final String CALL_ERROR_MSG = "Error calling native lib";
    final JackClient client;
    final String shortName;
    final JackPortType type;
    final JackLibrary jackLib;
    final JackLibrary._jack_port portPtr;
    Pointer bufferPtr;
    ByteBuffer byteBuffer;
    FloatBuffer floatBuffer;

    JackPort(String shortName, JackClient client, JackPortType type, JackLibrary._jack_port portPtr) {
        this.shortName = shortName;
        this.client = client;
        this.type = type;
        this.portPtr = portPtr;
        this.jackLib = client.jackLib;
    }

    public ByteBuffer getBuffer() {
        return this.byteBuffer;
    }

    public FloatBuffer getFloatBuffer() {
        return this.floatBuffer;
    }

    public String getName() {
        return this.client.getName() + ":" + this.shortName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public JackPortType getType() {
        return this.type;
    }

    public String[] getConnections() throws JackException {
        try {
            Pointer ptr = this.jackLib.jack_port_get_connections(this.portPtr);
            if (ptr == null) {
                return new String[0];
            }
            String[] res = ptr.getStringArray(0L);
            this.jackLib.jack_free(ptr);
            return res;
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public void getLatencyRange(JackLatencyRange latencyRange, JackLatencyCallbackMode mode) throws JackException {
        try {
            this.jackLib.jack_port_get_latency_range(this.portPtr, mode.val, latencyRange.nativeRange);
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, CALL_ERROR_MSG, e);
            throw new JackException(e);
        }
    }

    public static class JackLatencyRange {
        private final JackLibrary.jack_latency_range_t nativeRange = new JackLibrary.jack_latency_range_t();

        public int getMin() {
            return this.nativeRange.min;
        }

        public int getMax() {
            return this.nativeRange.max;
        }
    }
}

