/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.jnajack;

import java.util.EnumSet;
import org.jaudiolibs.jnajack.JackPositionBits;
import org.jaudiolibs.jnajack.lowlevel.JackLibrary;

public class JackPosition {
    private JackLibrary.jack_position_t nativePosition;

    public JackPosition() {
        this.nativePosition = new JackLibrary.jack_position_t();
    }

    JackPosition(JackLibrary.jack_position_t p) {
        this.nativePosition = p;
    }

    public final long getUsecs() {
        return this.nativePosition.usecs;
    }

    public final int getFrameRate() {
        return this.nativePosition.frame_rate;
    }

    public int getFrame() {
        return this.nativePosition.frame;
    }

    public void setValid(JackPositionBits valid) {
        this.nativePosition.valid = valid.getIntValue();
    }

    public void setValid(EnumSet<JackPositionBits> valid) {
        int v = 0;
        for (JackPositionBits bit : valid) {
            v |= bit.getIntValue();
        }
        this.nativePosition.valid = v;
    }

    public EnumSet<JackPositionBits> getValid() {
        int bits = this.nativePosition.valid;
        EnumSet<JackPositionBits> ret = EnumSet.noneOf(JackPositionBits.class);
        for (JackPositionBits bit : JackPositionBits.values()) {
            if ((bit.getIntValue() & bits) == 0) continue;
            ret.add(bit);
        }
        return ret;
    }

    public void setBar(int b) {
        this.nativePosition.bar = b;
    }

    public int getBar() {
        return this.nativePosition.bar;
    }

    public void setBeat(int b) {
        this.nativePosition.beat = b;
    }

    public int getBeat() {
        return this.nativePosition.beat;
    }

    public void setTick(int t) {
        this.nativePosition.tick = t;
    }

    public int getTick() {
        return this.nativePosition.tick;
    }

    public void setBarStartTick(double bsp) {
        this.nativePosition.bar_start_tick = bsp;
    }

    public double getBarStartTick() {
        return this.nativePosition.bar_start_tick;
    }

    public void setBeatsPerBar(float bpb) {
        this.nativePosition.beats_per_bar = bpb;
    }

    public float getBeatsPerBar() {
        return this.nativePosition.beats_per_bar;
    }

    public void setBeatType(float bt) {
        this.nativePosition.beat_type = bt;
    }

    public float getBeatType() {
        return this.nativePosition.beat_type;
    }

    public void setTicksPerBeat(double tpb) {
        this.nativePosition.ticks_per_beat = tpb;
    }

    public double getTicksPerBeat() {
        return this.nativePosition.ticks_per_beat;
    }

    public void setBeatsPerMinute(double bpm) {
        this.nativePosition.beats_per_minute = bpm;
    }

    public double getBeatsPerMinute() {
        return this.nativePosition.beats_per_minute;
    }

    public double getFrameTime() {
        return this.nativePosition.frame_time;
    }

    public double getNextTime() {
        return this.nativePosition.next_time;
    }

    public int getBbtOffset() {
        return this.nativePosition.bbt_offset;
    }

    public float getAudioFramesPerVideoFrame() {
        return this.nativePosition.audio_frames_per_video_frame;
    }

    public int getVideoOffset() {
        return this.nativePosition.video_offset;
    }

    JackLibrary.jack_position_t getNativePosition() {
        return this.nativePosition;
    }

    void setNativePosition(JackLibrary.jack_position_t np) {
        if (np == null) {
            throw new NullPointerException();
        }
        this.nativePosition = np;
    }

    public void incrementBar() {
        ++this.nativePosition.bar;
    }

    public void incrementBeat() {
        ++this.nativePosition.beat;
    }

    public void incrementTick() {
        ++this.nativePosition.tick;
    }

    public void addToBar(int toAdd) {
        this.nativePosition.bar += toAdd;
    }

    public void addToBeat(int toAdd) {
        this.nativePosition.beat += toAdd;
    }

    public void addToTick(int toAdd) {
        this.nativePosition.tick += toAdd;
    }

    public void addToBarStartTick(double toAdd) {
        this.nativePosition.bar_start_tick += toAdd;
    }

    public void subtractFromBar(int toAdd) {
        this.nativePosition.bar -= toAdd;
    }

    public void subtractFromBeat(int toAdd) {
        this.nativePosition.beat -= toAdd;
    }

    public void subtractFromTick(int toAdd) {
        this.nativePosition.tick -= toAdd;
    }
}

