/*
 * Decompiled with CFR 0.152.
 */
package processing.io;

import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import processing.core.PApplet;
import processing.io.NativeInterface;

public class GPIO {
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int INPUT_PULLUP = 2;
    public static final int INPUT_PULLDOWN = 3;
    public static final int LOW = 0;
    public static final int HIGH = 1;
    public static final int NONE = 0;
    public static final int CHANGE = 1;
    public static final int FALLING = 2;
    public static final int RISING = 3;
    protected static Map<Integer, Thread> irqThreads = new HashMap<Integer, Thread>();
    protected static boolean serveInterrupts = true;
    protected static BitSet values = new BitSet();

    static {
        NativeInterface.loadLibrary();
    }

    public static void analogWrite(int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    public static void attachInterrupt(int n, PApplet pApplet, String string, int n2) {
        Method method;
        if (irqThreads.containsKey(n)) {
            throw new RuntimeException("You must call releaseInterrupt before attaching another interrupt on the same pin");
        }
        GPIO.enableInterrupt(n, n2);
        final int n3 = n;
        final PApplet pApplet2 = pApplet;
        try {
            method = pApplet.getClass().getMethod(string, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Method " + string + " does not exist");
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                try {
                    do {
                        try {
                            if (GPIO.waitForInterrupt(n3, 100)) {
                                bl = true;
                            }
                            if (!bl || !serveInterrupts) continue;
                            method.invoke((Object)pApplet2, n3);
                            bl = false;
                        }
                        catch (RuntimeException runtimeException) {
                            Thread.sleep(100L);
                        }
                    } while (!Thread.currentThread().isInterrupted());
                }
                catch (Exception exception) {
                    System.err.println("Terminating interrupt handling for pin " + n3 + " after catching: " + exception.getMessage());
                }
            }
        }, "GPIO" + n + " IRQ");
        thread.setPriority(10);
        thread.start();
        irqThreads.put(n, thread);
    }

    protected static void checkValidPin(int n) {
        if (n < 0) {
            throw new RuntimeException("Operation not supported on this pin");
        }
    }

    public static int digitalRead(int n) {
        byte[] byArray;
        GPIO.checkValidPin(n);
        if (NativeInterface.isSimulated()) {
            return 0;
        }
        String string = String.format("/sys/class/gpio/gpio%d/value", n);
        int n2 = NativeInterface.readFile(string, byArray = new byte[2]);
        if (n2 < 0) {
            throw new RuntimeException(NativeInterface.getError(n2));
        }
        if (1 <= n2 && byArray[0] == 48) {
            return 0;
        }
        if (1 <= n2 && byArray[0] == 49) {
            return 1;
        }
        System.err.print("Read " + n2 + " bytes");
        if (n2 > 0) {
            System.err.format(", first byte is 0x%02x" + byArray[0], new Object[0]);
        }
        System.err.println();
        throw new RuntimeException("Unexpected value");
    }

    public static void digitalWrite(int n, int n2) {
        String string;
        GPIO.checkValidPin(n);
        if (n2 == 0) {
            values.clear(n);
            string = "0";
        } else if (n2 == 1) {
            values.set(n);
            string = "1";
        } else {
            System.err.println("Only GPIO.LOW and GPIO.HIGH, 0 and 1, or true and false, can be used.");
            throw new IllegalArgumentException("Illegal value");
        }
        if (NativeInterface.isSimulated()) {
            return;
        }
        String string2 = String.format("/sys/class/gpio/gpio%d/value", n);
        int n3 = NativeInterface.writeFile(string2, string);
        if (n3 < 0 && n3 != -2) {
            throw new RuntimeException(NativeInterface.getError(n3));
        }
    }

    public static void digitalWrite(int n, boolean bl) {
        if (bl) {
            GPIO.digitalWrite(n, 1);
        } else {
            GPIO.digitalWrite(n, 0);
        }
    }

    protected static void disableInterrupt(int n) {
        GPIO.enableInterrupt(n, 0);
    }

    protected static void enableInterrupt(int n, int n2) {
        String string;
        GPIO.checkValidPin(n);
        if (n2 == 0) {
            string = "none";
        } else if (n2 == 1) {
            string = "both";
        } else if (n2 == 2) {
            string = "falling";
        } else if (n2 == 3) {
            string = "rising";
        } else {
            throw new IllegalArgumentException("Unknown mode");
        }
        if (NativeInterface.isSimulated()) {
            return;
        }
        String string2 = String.format("/sys/class/gpio/gpio%d/edge", n);
        int n3 = NativeInterface.writeFile(string2, string);
        if (n3 < 0) {
            if (n3 == -2) {
                System.err.println("Make sure your called pinMode on the input pin");
            }
            throw new RuntimeException(NativeInterface.getError(n3));
        }
    }

    public static void interrupts() {
        serveInterrupts = true;
    }

    public static void noInterrupts() {
        serveInterrupts = false;
    }

    public static void pinMode(int n, int n2) {
        String string;
        GPIO.checkValidPin(n);
        if (NativeInterface.isSimulated()) {
            return;
        }
        String string2 = "/sys/class/gpio/export";
        int n3 = NativeInterface.writeFile(string2, Integer.toString(n));
        if (n3 < 0) {
            if (n3 == -2) {
                System.err.println("Make sure your kernel is compiled with GPIO_SYSFS enabled");
            }
            if (n3 == -22) {
                System.err.println("GPIO pin " + n + " does not seem to be available on your platform");
            }
            if (n3 != -16) {
                throw new RuntimeException(String.valueOf(string2) + ": " + NativeInterface.getError(n3));
            }
        }
        string2 = String.format("/sys/class/gpio/gpio%d/direction", n);
        if (n2 == 0) {
            string = "in";
            NativeInterface.raspbianGpioMemSetPinBias(n, n2);
        } else if (n2 == 1) {
            string = values.get(n) ? "high" : "low";
        } else if (n2 == 2 || n2 == 3) {
            string = "in";
            n3 = NativeInterface.raspbianGpioMemSetPinBias(n, n2);
            if (n3 == -2) {
                System.err.println("Setting pullup or pulldown resistors is currently only supported on the Raspberry Pi running Raspbian. Continuing without.");
            } else if (n3 < 0) {
                System.err.println("Error setting pullup or pulldown resistors: " + NativeInterface.getError(n3) + ". Continuing without.");
            }
        } else {
            throw new IllegalArgumentException("Unknown mode");
        }
        long l = System.currentTimeMillis();
        do {
            if ((n3 = NativeInterface.writeFile(string2, string)) != -1) continue;
            Thread.yield();
        } while (n3 == -1 && System.currentTimeMillis() - l < 500L);
        if (n3 < 0) {
            throw new RuntimeException(String.valueOf(string2) + ": " + NativeInterface.getError(n3));
        }
    }

    public static void releaseInterrupt(int n) {
        Thread thread = irqThreads.get(n);
        if (thread == null) {
            return;
        }
        thread.interrupt();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Error joining thread in releaseInterrupt: " + interruptedException.getMessage());
        }
        thread = null;
        irqThreads.remove(n);
        GPIO.disableInterrupt(n);
    }

    public static void releasePin(int n) {
        GPIO.checkValidPin(n);
        if (NativeInterface.isSimulated()) {
            return;
        }
        String string = "/sys/class/gpio/unexport";
        int n2 = NativeInterface.writeFile(string, Integer.toString(n));
        if (n2 < 0) {
            if (n2 == -2) {
                System.err.println("Make sure your kernel is compiled with GPIO_SYSFS enabled");
            }
            if (n2 != -22) {
                throw new RuntimeException(NativeInterface.getError(n2));
            }
        }
    }

    public static void waitFor(int n, int n2) {
        GPIO.waitFor(n, n2, -1);
    }

    public static void waitFor(int n, int n2, int n3) {
        GPIO.enableInterrupt(n, n2);
        if (!GPIO.waitForInterrupt(n, n3)) {
            throw new RuntimeException("Timeout occurred");
        }
    }

    public static boolean waitForInterrupt(int n, int n2, int n3) {
        throw new RuntimeException("The waitForInterrupt function has been renamed to waitFor. Please update your sketch accordingly.");
    }

    protected static boolean waitForInterrupt(int n, int n2) {
        GPIO.checkValidPin(n);
        if (NativeInterface.isSimulated()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
            return true;
        }
        String string = String.format("/sys/class/gpio/gpio%d/value", n);
        int n3 = NativeInterface.pollDevice(string, n2);
        if (n3 < 0) {
            if (n3 == -2) {
                System.err.println("Make sure your called pinMode on the input pin");
            }
            throw new RuntimeException(NativeInterface.getError(n3));
        }
        return n3 != 0;
    }
}

