/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.engine.MultiTable;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.PulseOscillatorBL;

public class MorphingOscillatorBL
extends PulseOscillatorBL {
    public UnitInputPort shape = new UnitInputPort("Shape");

    public MorphingOscillatorBL() {
        this.addPort(this.shape);
        this.shape.setMinimum(-1.0);
        this.shape.setMaximum(1.0);
    }

    @Override
    protected double generateBL(MultiTable multiTable, double d, double d2, double d3, int n) {
        double[] dArray = this.shape.getValues();
        double d4 = dArray[n];
        if (d4 < 0.0) {
            d3 += d3 * d4;
            return multiTable.calculateSawtooth(d, d2, d3);
        }
        double[] dArray2 = this.width.getValues();
        double d5 = dArray2[n];
        d5 = d5 > 0.999 ? 0.999 : (d5 < -0.999 ? -0.999 : d5);
        double d6 = multiTable.calculateSawtooth(d, d2, d3);
        double d7 = d + 1.0 - d5;
        if (d7 >= 1.0) {
            d7 -= 2.0;
        }
        double d8 = multiTable.calculateSawtooth(d7, d2, d3);
        double d9 = 1.0 - d2;
        return d9 * (d6 - (d8 + d5) * d4);
    }
}

