/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.audioservers.jack;

import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiolibs.audioservers.AudioClient;
import org.jaudiolibs.audioservers.AudioConfiguration;
import org.jaudiolibs.audioservers.AudioServer;
import org.jaudiolibs.audioservers.ext.ClientID;
import org.jaudiolibs.audioservers.ext.Connections;
import org.jaudiolibs.jnajack.Jack;
import org.jaudiolibs.jnajack.JackClient;
import org.jaudiolibs.jnajack.JackException;
import org.jaudiolibs.jnajack.JackOptions;
import org.jaudiolibs.jnajack.JackPort;
import org.jaudiolibs.jnajack.JackPortFlags;
import org.jaudiolibs.jnajack.JackPortType;
import org.jaudiolibs.jnajack.JackProcessCallback;
import org.jaudiolibs.jnajack.JackShutdownCallback;
import org.jaudiolibs.jnajack.JackStatus;

public class JackAudioServer
implements AudioServer {
    private static final Logger LOG = Logger.getLogger(JackAudioServer.class.getName());
    private final ClientID clientID;
    private final AudioClient client;
    private final AtomicReference<State> state;
    private final Connections connections;
    private AudioConfiguration context;
    private Jack jack;
    private JackClient jackclient;
    private JackPort[] inputPorts;
    private List<FloatBuffer> inputBuffers;
    private JackPort[] outputPorts;
    private List<FloatBuffer> outputBuffers;

    JackAudioServer(ClientID id, Connections connections, AudioConfiguration ctxt, AudioClient client) {
        this.clientID = id;
        this.connections = connections;
        this.context = ctxt;
        this.client = client;
        this.state = new AtomicReference<State>(State.New);
    }

    public void run() throws Exception {
        if (!this.state.compareAndSet(State.New, State.Initialising)) {
            throw new IllegalStateException();
        }
        try {
            this.initialise();
        }
        catch (Exception ex) {
            this.state.set(State.Terminated);
            this.closeAll();
            this.client.shutdown();
            throw ex;
        }
        if (this.state.compareAndSet(State.Initialising, State.Active)) {
            this.runImpl();
        }
        this.closeAll();
        this.client.shutdown();
        this.state.set(State.Terminated);
    }

    private void initialise() throws Exception {
        int i;
        this.jack = Jack.getInstance();
        EnumSet<JackOptions> options = this.connections.isConnectInputs() || this.connections.isConnectOutputs() ? EnumSet.noneOf(JackOptions.class) : EnumSet.of(JackOptions.JackNoStartServer);
        EnumSet<JackStatus> status = EnumSet.noneOf(JackStatus.class);
        try {
            this.jackclient = this.jack.openClient(this.clientID.getIdentifier(), options, status);
        }
        catch (JackException ex) {
            LOG.log(Level.FINE, "Exception creating JACK client\nStatus set\n{0}", status);
            throw ex;
        }
        LOG.log(Level.FINE, "JACK client created\nStatus set\n{0}", status);
        int count = this.context.getInputChannelCount();
        this.inputPorts = new JackPort[count];
        this.inputBuffers = Arrays.asList(new FloatBuffer[count]);
        for (i = 0; i < count; ++i) {
            this.inputPorts[i] = this.jackclient.registerPort("Input_" + (i + 1), JackPortType.AUDIO, JackPortFlags.JackPortIsInput);
        }
        count = this.context.getOutputChannelCount();
        this.outputPorts = new JackPort[count];
        this.outputBuffers = Arrays.asList(new FloatBuffer[count]);
        for (i = 0; i < count; ++i) {
            this.outputPorts[i] = this.jackclient.registerPort("Output_" + (i + 1), JackPortType.AUDIO, JackPortFlags.JackPortIsOutput);
        }
    }

    private void runImpl() {
        try {
            ClientID id = this.clientID;
            String actualID = this.jackclient.getName();
            if (!id.getIdentifier().equals(actualID)) {
                id = new ClientID(actualID);
            }
            this.context = new AudioConfiguration((float)this.jackclient.getSampleRate(), this.inputPorts.length, this.outputPorts.length, this.jackclient.getBufferSize(), new Object[]{id, this.connections, this.jackclient});
            LOG.log(Level.FINE, "Configuring AudioClient\n{0}", this.context);
            this.client.configure(this.context);
            this.jackclient.setProcessCallback((JackProcessCallback)new Callback());
            this.jackclient.onShutdown((JackShutdownCallback)new ShutDownHook());
            this.jackclient.activate();
            if (this.connections.isConnectInputs()) {
                this.connectInputs();
            }
            if (this.connections.isConnectOutputs()) {
                this.connectOutputs();
            }
            while (this.state.get() == State.Active) {
                Thread.sleep(100L);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "", ex);
            this.shutdown();
        }
    }

    private void connectInputs() {
        try {
            String[] ins = this.jack.getPorts(this.jackclient, null, JackPortType.AUDIO, EnumSet.of(JackPortFlags.JackPortIsOutput, JackPortFlags.JackPortIsPhysical));
            int inCount = Math.min(ins.length, this.inputPorts.length);
            for (int i = 0; i < inCount; ++i) {
                this.jack.connect(this.jackclient, ins[i], this.inputPorts[i].getName());
            }
        }
        catch (JackException ex) {
            LOG.log(Level.SEVERE, "", ex);
        }
    }

    private void connectOutputs() {
        try {
            String[] outs = this.jack.getPorts(this.jackclient, null, JackPortType.AUDIO, EnumSet.of(JackPortFlags.JackPortIsInput, JackPortFlags.JackPortIsPhysical));
            int outCount = Math.min(outs.length, this.outputPorts.length);
            for (int i = 0; i < outCount; ++i) {
                this.jack.connect(this.jackclient, this.outputPorts[i].getName(), outs[i]);
            }
        }
        catch (JackException ex) {
            LOG.log(Level.SEVERE, "", ex);
        }
    }

    private void processBuffers(int nframes) {
        int i;
        for (i = 0; i < this.inputPorts.length; ++i) {
            this.inputBuffers.set(i, this.inputPorts[i].getFloatBuffer());
        }
        for (i = 0; i < this.outputPorts.length; ++i) {
            this.outputBuffers.set(i, this.outputPorts[i].getFloatBuffer());
        }
        this.client.process(System.nanoTime(), this.inputBuffers, this.outputBuffers, nframes);
    }

    public AudioConfiguration getAudioContext() {
        return this.context;
    }

    public boolean isActive() {
        State st = this.state.get();
        return st == State.Active || st == State.Closing;
    }

    public void shutdown() {
        State st;
        while ((st = this.state.get()) != State.Terminated && st != State.Closing && !this.state.compareAndSet(st, State.Closing)) {
        }
    }

    private void closeAll() {
        try {
            this.jackclient.close();
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "", t);
        }
    }

    private class ShutDownHook
    implements JackShutdownCallback {
        private ShutDownHook() {
        }

        public void clientShutdown(JackClient client) {
            JackAudioServer.this.shutdown();
        }
    }

    private class Callback
    implements JackProcessCallback {
        private Callback() {
        }

        public boolean process(JackClient client, int nframes) {
            if (JackAudioServer.this.state.get() != State.Active) {
                return false;
            }
            try {
                JackAudioServer.this.processBuffers(nframes);
                return true;
            }
            catch (Exception ex) {
                JackAudioServer.this.shutdown();
                return false;
            }
        }
    }

    private static enum State {
        New,
        Initialising,
        Active,
        Closing,
        Terminated;

    }
}

