/*

ajouter -Xms512m -Xmx1024m à la commande java de démarrage sur Raspi

*/


import processing.sound.*;
import beads.*;
import oscP5.*;
import netP5.*;
import processing.io.*;

OscP5 oscP5;
NetAddress myRemoteLocation;

//Beads
AudioContext ac;

//Player
Player player;

//LED
boolean ledOn = false;
long lastOSCEvent;

//OSC
//Hall effect, 1/page
int hallPage1, hallPage2, hallPage3, hallPage4, hallPage5, hallPage6;
int hallArray[] = new int[6];

//Page 1, planète et whell
int[] page1OSC = new int[16];

//Page 2, fenetres
int[] page2OSC = new int[4];
int[] page2OSC_computed = new int[2];

//Page 3, tapis
int[] page3OSC = new int[4];
int[] page3OSC_computed = new int[2];

//Page4, flaques
int[] page4OSC = new int[3];

//Page5, iles
int[] page5OSC = new int[3];

//Page6, ocean
int[] page6OSC = new int[13];
int[] page6OSC_computed = new int[42];
int[] Page6_rows =new int[7];
int[] Page6_cols = new int [6];

PFont f;

int state = 0;
int lastState = 0;
int nextState = 0;

int lastHallState = 0;

Page1 page1;
Page2 page2;
Page3 page3;
Page4 page4;
Page5 page5;
Page6 page6;

int lastPageChange;
int recordStart;

boolean listenHallEffect = false;

void settings() {
  size(800, 800);
  final int buffer_size = 4096;
  ac = AudioContext.getDefaultContext();
  //ac = new AudioContext(new JavaSoundAudioIO(buffer_size), buffer_size, new IOAudioFormat(44100, 16, 0, 2, true, false));
  //IOAudioFormat(float sampleRate, int bitDepth, int inputs, int outputs, boolean signed, boolean bigEndian) 
  //ac = new AudioContext(new AudioServerIO.Jack(), buffer_size, new IOAudioFormat(44100, 16, 0, 2, true, false));

  ac.start(); //<>//
  
 //<>//
}

void setup()
{
  //size(800, 800);
  
  
  
  /* start oscP5, listening for incoming messages at port 12000 */
  oscP5 = new OscP5(this, 12000);
  
  hallPage1 = 3;
  hallPage2 = 3;
  hallPage3 = 3;
  hallPage4 = 3;
  hallPage5 = 3;
  hallPage6 = 3;

  f = createFont("SourceCodePro-Regular.ttf", 12);
  textFont(f);
  
  player = new Player();
    
  background(255, 248, 196);
}

void draw()
{
  background(50);
  if (listenHallEffect)
  {
    //Check Hall effect sensors 
    int numHallEffects = 0;
    // D'abord, vérification qu'il n'y a bien qu'un seul capteur sans aimant
    for (int i =0; i<6; i++)
    {
      numHallEffects+=hallArray[i];
    }
    // Une seule page est ouverte
    if (numHallEffects == 1)
    {

      for (int i =0; i<6; i++)
      {
        if (hallArray[i] == 1) {
          nextState = (i+1)*10;
        }
        //
        if (lastHallState != nextState)
        {
          lastState = state; 
          lastHallState = nextState;
        }
      }
    } else { // plusieurs pages ouvertes
      // go back to zero
      nextState = 0;
      if (lastHallState != nextState)
      {
        lastState = state; 
        lastHallState = nextState;
      }
    }
  }
  switch (state)
  {
  case 0:
    //println (page1);
    fill(255);
    text("Kapi Capitaine _ demo Agilack", 50,50);
    text("touches 1 à 6 pour changer de page", 50,75);
    break;
    // entre parenthèses, true = quit
    

    //PAGE 1
  case 10:
    if (page1 == null)
    {
      page1 = new Page1();
    } else {
      page1.draw();
    }

    break;


    //PAGE 2
  case 20:
    if (page2 == null)
    {
      page2 = new Page2();
    } else {
      page2.draw();
    }  
    break;


    //PAGE 3
  case 30:
    if (page3 == null)
    {
      page3 = new Page3();
    } else {
      page3.draw();
    }  
    break;


    //PAGE 4
  case 40:
    if (page4 == null)
    {
      page4 = new Page4();
    } else {
      page4.draw();
    }  
    break;


    //PAGE 5
  case 50:
    if (page5 == null)
    {
      page5 = new Page5();
    } else {
      page5.draw();
    }  
    break;


    //PAGE 6
  case 60:
    if (page6 == null)
    {
      page6 = new Page6();
    } else {
      page6.draw();
    }  
    break;
  }

  end();
}

// This function is used to fade out the current page, kill it by passing it to null, then launching the new page
void end()
{
  if (lastState == 0)
  {
    state = nextState;
  } else   
  if (lastState != nextState)
  {
    switch (lastState)
    {
    case 10:
      //println(page1 != null);
      if (page1 != null)
      {
        page1.end();
        if (player.masterZero == true)
        {
          page1 = null;
          player.reset();
          state = nextState;
        }
      } 
      break;

    case 20:
      if (page2 != null)
      {
        page2.end();
        if (player.masterZero == true)
        {
          page2 = null;
          player.reset();
          state = nextState;
        }
      } 
      break;

    case 30:
    if (page3 != null)
      {
        page3.end();
        if (player.masterZero == true)
        {
          page3 = null;
          player.reset();
          state = nextState;
        }
      } 

      break;    

    case 40:
    if (page4 != null)
      {
        page4.end();
        if (player.masterZero == true)
        {
          page4 = null;
          player.reset();
          state = nextState;
        }
      } 

      break;

    case 50:
    if (page5!= null)
      {
        page5.end();
        if (player.masterZero == true)
        {
          page5 = null;
          player.reset();
          state = nextState;
        }
      } 

      break;

    case 60:
    if (page6 != null)
      {
        page6.end();
        if (player.masterZero == true)
        {
          page6 = null;
          player.reset();
          state = nextState;
        }
      } 

      break;

    default:
      break;
    }
  }
}

// only used when testing on a screen
void keyPressed()
{
  if (listenHallEffect == false)
  {
    lastState = state;
    switch (int(key)-48)
    {
    case 0:
      break;

      //PAGE 1
    case 1:
      //println("Page 1");
      nextState = 10;
      break;


      //PAGE 2
    case 2:
      //println("Page 2");
      nextState = 20;
      break;


      //PAGE 3
    case 3:
      //println("Page 3");
      nextState = 30;
      break;


      //PAGE 4
    case 4:
      //println("Page 4");
      nextState = 40;
      break;


      //PAGE 5
    case 5:
      //println("Page 5");
      nextState = 50;
      break;


      //PAGE 6
    case 6:
      //println("Page 6");
      nextState = 60;
      break;
    }
  }
  // for testing purpose
  //if (key == 'c' || key == 'C') listenHallEffect = !listenHallEffect;
  
  
}

// OSC events received from the book
void oscEvent(OscMessage theOscMessage) {
  lastOSCEvent = millis();
 
  //println(theOscMessage);
  if (theOscMessage.checkAddrPattern("/page1")==true) {
    
    hallPage1 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[0] = hallPage1;
    for (int i =0; i<page1OSC.length; i++)
    {
      page1OSC[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page2")==true) {
    for (int i =0; i<page2OSC.length; i++)
    {
      page2OSC[i] = theOscMessage.get(i+1).intValue();
    }
    // We compute value of both sensors
    page2OSC_computed[0] = min(page2OSC[0], page2OSC[1]);
    page2OSC_computed[1] = min(page2OSC[2], page2OSC[3]);

    hallPage2 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[1] = hallPage2;
    return;
  } else if (theOscMessage.checkAddrPattern("/page3")==true) {
    hallPage3 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[2] = hallPage3;
    for (int i =0; i<page3OSC.length; i++)
    {
      page3OSC[i] = theOscMessage.get(i+1).intValue();
    }
    // on fusionne les valeurs des zones du tapis
    page3OSC_computed[0] = max(page3OSC[1], page3OSC[2]);
    page3OSC_computed[1] = max(page3OSC[0], page3OSC[3]);

    return;
  } else if (theOscMessage.checkAddrPattern("/page4")==true) {
    hallPage4 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[3] = hallPage4;
    for (int i =0; i<page4OSC.length; i++)
    {
      page4OSC[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page5")==true) {
    hallPage5 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[4] = hallPage5;
    for (int i =0; i<page5OSC.length; i++)
    {
      page5OSC[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page6")==true) {
    hallPage6 = theOscMessage.get(0).intValue();  // get the first osc argument
    hallArray[5] = hallPage6;
    for (int i =0; i<page6OSC.length; i++)
    {
      page6OSC[i] = theOscMessage.get(i+1).intValue();
      /*
      */

      if (i<7)
      {
        Page6_rows[i] = page6OSC[i];
      } else {
        Page6_cols[i-7] = page6OSC[i];
      }
    }

    // On interpole les colonnes et les lignes pour reconstiteur les points de croisements
    for (int i =0; i<Page6_cols.length; i++)
    {
      for (int j=0; j<Page6_rows.length; j++)
      {
        page6OSC_computed[i+j*Page6_cols.length]= min( Page6_cols[i], Page6_rows[j]);
      }
    }


    return;
  }
}
