class Page6 {

  int rows =7;
  int cols =6;
  int square_Width = width/8;
  int offset = width/8;
  Square[][] squares= new Square [cols][rows];

  int numsounds_events = 9;

  String filepathBoat;
  String filepathSong;
  String[] filepathEvents = new String[numsounds_events];

  Sample sampleBoat;
  Sample sampleSong;
  Sample[] samplesEvents = new Sample[numsounds_events];

  IntList events_Order;

  float nextTimer = 0;
  float lastUpdate = 0;

  int scoreTouched;
  int lastScoreTouched;
  int lastMove = 0;

  //timers
  int delta = 2000;
  int nextEvent = 0;
  int indexEvent = 0;
  boolean songAlreadyPlayed = false;
  boolean moving;
  boolean lastStateMoving;

  boolean ended = false;

  Page6()
  { 
    //init
    //create squares
    for (int i =0; i<cols; i++)
    {
      for (int j=0; j<rows; j++)
      {
        squares[i][j] = new Square( offset + i*square_Width, offset/2 + j*square_Width, square_Width, 1+(i+j*cols), page6OSC_computed, (i+j*cols), 1, 6);
      }
    }

    //Sounds
    filepathBoat = sketchPath()+"/data/P6/PLANCHE06_boucleclapotisbateau.wav";
    filepathSong = sketchPath()+"/data/P6/MARINS.wav";
    // 
    filepathEvents[0] = sketchPath()+"/data/P6/PLANCHE06avion.wav";
    filepathEvents[1] = sketchPath()+"/data/P6/PLANCHE06Baleines.wav";
    filepathEvents[2] = sketchPath()+"/data/P6/PLANCHE06Cormorants.wav";
    filepathEvents[3] = sketchPath()+"/data/P6/PLANCHE06Dauphins.wav";
    filepathEvents[4] = sketchPath()+"/data/P6/PLANCHE06Fousdebassan.wav";
    filepathEvents[5] = sketchPath()+"/data/P6/PLANCHE06Grossevague.wav";
    filepathEvents[6] = sketchPath()+"/data/P6/PLANCHE06Paquebot.wav";
    filepathEvents[7] = sketchPath()+"/data/P6/PLANCHE06Ploufaboiement.wav";
    filepathEvents[8] = sketchPath()+"/data/P6/PLANCHE06ploufgrognement.wav";

    // Boat Loop
    sampleBoat = SampleManager.sample(filepathBoat);

    //The Song
    sampleSong = SampleManager.sample(filepathSong);

    //Events
    for (int i = 0; i < numsounds_events; i++) {
      samplesEvents[i] = SampleManager.sample(filepathEvents[i]);
    }

    events_Order = new IntList();
    for (int i=0; i<numsounds_events; i++)
    {
      events_Order.append(i);
    }
    events_Order.shuffle(); 
    
    nextEvent = millis() + int(random(2000, 5000));

    player.playLoop(sampleBoat, 0);
    player.loopVolSet(0, 0);
    player.masterFadeIn(1, 500, true);
  }  

  void draw()
  {

      scoreTouched=0;

      //draw interactive areas
      for (int i = 0; i < cols; i++) {
        for (int j = 0; j < rows; j++) {

          squares[i][j].draw();
          if (squares[i][j].checkMouseOver() != 0)
          {
            scoreTouched+=squares[i][j].checkMouseOver();
          }
        }
      }

      //Check for movement by additioning every id. If Id change, they're is a movement
      if (lastScoreTouched != scoreTouched && scoreTouched>0)
      {
        //println("moving");
        lastMove = millis();
        moving = true;
        player.loopFade(0, 1, 1000);
      }

      // if no change since a while, it's stopped
      if (millis()-lastMove>delta && moving == true)
      {
        //println("stop");
        moving = false;
        player.loopFade(0, 0, 1000);
      }

      if (moving && millis() > nextEvent)
      {
        if (indexEvent == 6 && songAlreadyPlayed == false)
        {
          player.playSample(sampleSong,0);
          nextEvent = int(random(2000, 3000)) + (int)sampleSong.getLength() + millis();
          songAlreadyPlayed = true;
        } else {
          println("Playing ", events_Order.get(indexEvent));
          player.playSample(samplesEvents[events_Order.get(indexEvent)],0);
          if (indexEvent == numsounds_events-1)events_Order.shuffle();
          nextEvent = int(random(2000, 5000)) + (int)samplesEvents[events_Order.get(indexEvent)].getLength() + millis();
          indexEvent++;
          indexEvent %= numsounds_events;
        }
      }

      lastScoreTouched = scoreTouched;
     
    
  }
  
  void end()
  {
   player.masterFadeOut(0,1000, true);
  }
  
  
}
