class Player  //<>// //<>// //<>// //<>// //<>// //<>//
{

  int nbrLoopPlayers = 4;
  SamplePlayer[] loopPlayers = new SamplePlayer[nbrLoopPlayers];
  Envelope[] loopEnvelopes = new Envelope[nbrLoopPlayers];
  Gain[] loopGains = new Gain[nbrLoopPlayers];
  boolean[] EnvelopeIsAvailable = new boolean[nbrLoopPlayers];

  int nbrEventPlayers = 3;
  SamplePlayer[] eventPlayers = new SamplePlayer[nbrEventPlayers];
  //Envelope[] eventEnvelopes = new Envelope[nbrEventPlayers];
  Gain[] eventGains = new Gain[nbrEventPlayers];
  boolean[] eventPlayerIsAvailable = new boolean[nbrEventPlayers];

  Envelope masterFade;
  Gain master;
  Panner panner;
  
  boolean masterZero = false;
  
  Player()
  {
    // Master
    masterFade = new Envelope(1.0);
    master = new Gain(ac, 1, masterFade);

    //Loop players
    for (int i = 0; i< nbrLoopPlayers; i++)
    {
      //Players 
      // We strangely need to create the SampleManager with a wav to be able to change and start a new Sample
      Sample blank = SampleManager.sample(sketchPath()+"/data/blank.wav");
      loopPlayers[i] = new SamplePlayer(ac, blank); 
      loopPlayers[i].setKillOnEnd(false);
      loopPlayers[i].setLoopType(SamplePlayer.LoopType.LOOP_FORWARDS); // enable looping
      loopPlayers[i].pause(false); // pause playback
      //Envelopes
      loopEnvelopes[i] = new Envelope(ac, 1.0);
      EnvelopeIsAvailable[i] = true;
      //Gain
      loopGains[i] = new Gain(ac, 1, loopEnvelopes[i]); // construct gain object
      loopGains[i].addInput(loopPlayers[i]); // connect each sample player to each gain object
      master.addInput(loopGains[i]); // connect each gain to the main output
    }

    //Events players 
    for (int i = 0; i< nbrEventPlayers; i++)
    {
      //Used to track available player
      eventPlayerIsAvailable[i] = true;
      //Players 
      Sample blank = SampleManager.sample(sketchPath()+"/data/blank.wav");
      eventPlayers[i] = new SamplePlayer(ac, blank); 
      eventPlayers[i].setKillOnEnd(false);
      eventPlayers[i].setLoopType(SamplePlayer.LoopType.NO_LOOP_FORWARDS); // disable looping
      eventPlayers[i].pause(false); // pause playback
     
      //Gain
      eventGains[i] = new Gain(ac, 1); // construct gain object
      eventGains[i].addInput(eventPlayers[i]); // connect each sample player to each gain object
   
      master.addInput(eventGains[i]); // connect each gain to the main output
    } 
    
    panner = new Panner(ac);
    panner.addInput(master);
    
    ac.out.addInput(panner);

    masterFade.setValue(0);
  }
  
  // Load a sound event 
  void playSample(Sample theSample, float thePanSetting)
  {
    panner.setPos(thePanSetting);
    for (int i = 0; i<nbrEventPlayers; i++)
    {
      // we check if a sampleplayer is available
      if ( eventPlayerIsAvailable[i] == true) // the player is available
      {
        println("Set Sample: "+theSample+"to player "+i);
        eventPlayers[i].setSample(theSample);
        eventPlayers[i].setToLoopStart();
        eventPlayers[i].start();
        eventPlayerIsAvailable[i] = false;

        // Could be cool to improve that mess
        switch (i)
        {
        case 0:
          eventPlayers[i].setEndListener(
            new Bead() {
            public void messageReceived(Bead message) 
            {
              eventPlayerIsAvailable[0] = true;
            }
          }
          );
          break;

        case 1:    
          eventPlayers[i].setEndListener(
            new Bead() {
            public void messageReceived(Bead message) 
            {
              eventPlayerIsAvailable[1] = true;
            }
          }
          );
          break;

        case 2:      
          eventPlayers[i].setEndListener(
            new Bead() {
            public void messageReceived(Bead message) 
            {
              eventPlayerIsAvailable[2] = true;
            }
          }  
          );
          break;
        }

        break;
      }
    }
  }
  
  void setPanner(int pan)
  {
    panner.setPos(pan);
  }

  // Load and start a loop sample                          
  void playLoop(Sample theLoop, int index)
  {
    loopPlayers[index].setSample(theLoop);
    loopPlayers[index].setLoopPointsFraction(0.0, 1.0);
    loopPlayers[index].start();
    println("LOOP, set sample :" + theLoop.getFileName()+" envelope " + loopEnvelopes[index].getValue());
  }

  // Fade a loop sample
  void loopFade(int index, float obj, int time)
  {
    if (EnvelopeIsAvailable[index])
    {
      EnvelopeIsAvailable[index] = false;

      switch(index)
      {
      case 0:
        loopEnvelopes[index].addSegment(obj, time, 
          new Bead() {
          public void messageReceived(Bead message) 
          {
            EnvelopeIsAvailable[0] = true;
          }
        }        
        );
        break;

      case 1:
        loopEnvelopes[index].addSegment(obj, time, 
          new Bead() {
          public void messageReceived(Bead message) 
          {
            EnvelopeIsAvailable[1] = true;
          }
        }        
        );
        break;

      case 2:
        loopEnvelopes[index].addSegment(obj, time, 
          new Bead() {
          public void messageReceived(Bead message) 
          {
            EnvelopeIsAvailable[2] = true;
          }
        }        
        );
        break;

      case 3:
        loopEnvelopes[index].addSegment(obj, time, 
          new Bead() {
          public void messageReceived(Bead message) 
          {
            EnvelopeIsAvailable[3] = true;
          }
        }        
        );
        break;
      }
    }
  }

  // Set the volume of a loop immediately
  void loopVolSet(int index, int obj)
  {
    loopEnvelopes[index].setValue(obj);
  }

  //Return the nbr of sonic events that are played at the same moments
  int howManyEventsArePlayed()
  {
    int nbrOfPlayersOn = 0;

    for (int i = 0; i<nbrEventPlayers; i++)
    {
      if (eventPlayerIsAvailable[i] == false)nbrOfPlayersOn++;
    }
    return  nbrOfPlayersOn;
  }

  //Print the state of each event sample player
  void getSamplePlayers()
  {
    for (int i = 0; i<nbrEventPlayers; i++)
    {
      print(i +" "+eventPlayerIsAvailable[i]+" ");
    }
    println();
  }

  void masterFadeOut(float vol, int timer, boolean needsABeadMessage)
  {
    if (needsABeadMessage)
    {
    masterFade.addSegment(vol, timer, 
      new Bead() {
      public void messageReceived(Bead message) 
      {
        masterZero = true;
      }
    }
    );
    } else {
      masterFade.addSegment(vol, timer);
    }
  }

  void masterFadeIn(float vol, int timer, boolean needsABeadMessage)
  {
    if (needsABeadMessage)
    {
    masterFade.addSegment(vol, timer, 
      new Bead() {
      public void messageReceived(Bead message) 
      {
        masterZero = false;
      }
    }  
    );
    } else {
      masterFade.addSegment(vol, timer);
    }
  }

  void reset() {

    //Unloading every sampleplayer
    //Loop players
    for (int i = 0; i< nbrLoopPlayers; i++)
    {
      loopPlayers[i].setSample(SampleManager.sample(sketchPath()+"/data/blank.wav"));
      EnvelopeIsAvailable[i] = true;
      loopEnvelopes[i].clear();
      loopEnvelopes[i].setValue(1.0);
    }

    //Events players 
    for (int i = 0; i< nbrEventPlayers; i++)
    {
      eventPlayers[i].setSample(SampleManager.sample(sketchPath()+"/data/blank.wav"));
    }

    masterFade.setValue(0.0);
    panner.setPos(0.0);
  }
}
