/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.data.SequentialData;
import com.jsyn.data.SequentialDataCommon;

class SequentialDataCrossfade
extends SequentialDataCommon {
    private SequentialData source;
    private int sourceStartIndex;
    private SequentialData target;
    private int targetStartIndex;
    private int crossFadeFrames;
    private double frameScaler;

    SequentialDataCrossfade() {
    }

    public void setup(SequentialData sequentialData, int n, int n2, SequentialData sequentialData2, int n3, int n4) {
        SequentialDataCrossfade sequentialDataCrossfade;
        assert (n + n2 <= sequentialData.getNumFrames());
        assert (n3 + n4 <= sequentialData2.getNumFrames());
        if (sequentialData instanceof SequentialDataCrossfade) {
            sequentialDataCrossfade = (SequentialDataCrossfade)sequentialData;
            if (n >= sequentialDataCrossfade.crossFadeFrames) {
                sequentialData = sequentialDataCrossfade.target;
                n += sequentialDataCrossfade.targetStartIndex / sequentialData.getChannelsPerFrame();
            }
        }
        if (sequentialData2 instanceof SequentialDataCrossfade) {
            sequentialDataCrossfade = (SequentialDataCrossfade)sequentialData2;
            sequentialData2 = sequentialDataCrossfade.target;
            n3 += sequentialDataCrossfade.targetStartIndex / sequentialData2.getChannelsPerFrame();
        }
        this.source = sequentialData;
        this.target = sequentialData2;
        this.sourceStartIndex = n * sequentialData.getChannelsPerFrame();
        this.crossFadeFrames = n2;
        this.targetStartIndex = n3 * sequentialData2.getChannelsPerFrame();
        this.frameScaler = n2 == 0 ? 1.0 : 1.0 / (double)n2;
        this.numFrames = n4;
    }

    @Override
    public void writeDouble(int n, double d) {
    }

    @Override
    public double readDouble(int n) {
        int n2 = n / this.source.getChannelsPerFrame();
        if (n2 < this.crossFadeFrames) {
            double d = (double)n2 * this.frameScaler;
            double d2 = (1.0 - d) * this.source.readDouble(n + this.sourceStartIndex);
            return d2 += d * this.target.readDouble(n + this.targetStartIndex);
        }
        return this.target.readDouble(n + this.targetStartIndex);
    }

    @Override
    public double getRateScaler(int n, double d) {
        return this.target.getRateScaler(n, d);
    }

    @Override
    public int getChannelsPerFrame() {
        return this.target.getChannelsPerFrame();
    }
}

