/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PVector;
import processing.data.IntList;
import processing.sound.SoundFile;

public class LDQR_Monitoring
extends PApplet {
    final int LINEAR = 0;
    final int QUADRATIC = 1;
    final int CUBIC = 2;
    final int QUARTIC = 3;
    final int QUINTIC = 4;
    final int SINUSOIDAL = 5;
    final int EXPONENTIAL = 6;
    final int CIRCULAR = 7;
    final int SQRT = 8;
    final int EASE_IN = 0;
    final int EASE_OUT = 1;
    final int EASE_IN_OUT = 2;
    int state = 10;
    Page1 page1;
    Page2 page2;
    Page3 page3;
    Page4 page4;

    public void setup() {
        this.background(255.0f, 248.0f, 196.0f);
        this.page1 = new Page1(this);
        this.page2 = new Page2(this);
        this.page3 = new Page3(this);
        this.page4 = new Page4(this);
    }

    public void draw() {
        this.background(255.0f, 248.0f, 196.0f);
        switch (this.state) {
            case 0: {
                break;
            }
            case 10: {
                this.page1.draw(false);
                break;
            }
            case 20: {
                this.page1.draw(true);
                this.page2.draw(false);
                break;
            }
            case 30: {
                this.page2.draw(true);
                this.page3.draw(false);
                break;
            }
            case 40: {
                this.page3.draw(true);
                this.page4.draw();
            }
        }
    }

    public void keyPressed() {
        switch (PApplet.parseInt((char)this.key) - 48) {
            case 0: {
                break;
            }
            case 1: {
                LDQR_Monitoring.println((String)"Page 1");
                this.state = 10;
                break;
            }
            case 2: {
                LDQR_Monitoring.println((String)"Page 2");
                this.state = 20;
                break;
            }
            case 3: {
                LDQR_Monitoring.println((String)"Page 3");
                this.state = 30;
                break;
            }
            case 4: {
                LDQR_Monitoring.println((String)"Page 4");
                this.state = 40;
            }
        }
    }

    public float map2(float value, float start1, float stop1, float start2, float stop2, int type, int when) {
        float b = start2;
        float c = stop2 - start2;
        float t = value - start1;
        float d = stop1 - start1;
        float p = 0.5f;
        switch (type) {
            case 0: {
                return c * t / d + b;
            }
            case 8: {
                if (when == 0) {
                    return c * LDQR_Monitoring.pow((float)(t /= d), (float)p) + b;
                }
                if (when == 1) {
                    return c * (1.0f - LDQR_Monitoring.pow((float)(1.0f - (t /= d)), (float)p)) + b;
                }
                if (when != 2) break;
                if ((t /= d / 2.0f) < 1.0f) {
                    return c / 2.0f * LDQR_Monitoring.pow((float)t, (float)p) + b;
                }
                return c / 2.0f * (2.0f - LDQR_Monitoring.pow((float)(2.0f - t), (float)p)) + b;
            }
            case 1: {
                if (when == 0) {
                    return c * (t /= d) * t + b;
                }
                if (when == 1) {
                    return -c * (t /= d) * (t - 2.0f) + b;
                }
                if (when != 2) break;
                if ((t /= d / 2.0f) < 1.0f) {
                    return c / 2.0f * t * t + b;
                }
                return -c / 2.0f * ((t -= 1.0f) * (t - 2.0f) - 1.0f) + b;
            }
            case 2: {
                if (when == 0) {
                    return c * (t /= d) * t * t + b;
                }
                if (when == 1) {
                    t /= d;
                    return c * ((t -= 1.0f) * t * t + 1.0f) + b;
                }
                if (when != 2) break;
                if ((t /= d / 2.0f) < 1.0f) {
                    return c / 2.0f * t * t * t + b;
                }
                return c / 2.0f * ((t -= 2.0f) * t * t + 2.0f) + b;
            }
            case 3: {
                if (when == 0) {
                    return c * (t /= d) * t * t * t + b;
                }
                if (when == 1) {
                    t /= d;
                    return -c * ((t -= 1.0f) * t * t * t - 1.0f) + b;
                }
                if (when != 2) break;
                if ((t /= d / 2.0f) < 1.0f) {
                    return c / 2.0f * t * t * t * t + b;
                }
                return -c / 2.0f * ((t -= 2.0f) * t * t * t - 2.0f) + b;
            }
            case 4: {
                if (when == 0) {
                    return c * (t /= d) * t * t * t * t + b;
                }
                if (when == 1) {
                    t /= d;
                    return c * ((t -= 1.0f) * t * t * t * t + 1.0f) + b;
                }
                if (when != 2) break;
                if ((t /= d / 2.0f) < 1.0f) {
                    return c / 2.0f * t * t * t * t * t + b;
                }
                return c / 2.0f * ((t -= 2.0f) * t * t * t * t + 2.0f) + b;
            }
            case 5: {
                if (when == 0) {
                    return -c * LDQR_Monitoring.cos((float)(t / d * 1.5707964f)) + c + b;
                }
                if (when == 1) {
                    return c * LDQR_Monitoring.sin((float)(t / d * 1.5707964f)) + b;
                }
                if (when != 2) break;
                return -c / 2.0f * (LDQR_Monitoring.cos((float)((float)Math.PI * t / d)) - 1.0f) + b;
            }
            case 6: {
                if (when == 0) {
                    return c * LDQR_Monitoring.pow((float)2.0f, (float)(10.0f * (t / d - 1.0f))) + b;
                }
                if (when == 1) {
                    return c * (-LDQR_Monitoring.pow((float)2.0f, (float)(-10.0f * t / d)) + 1.0f) + b;
                }
                if (when != 2) break;
                if ((t /= d / 2.0f) < 1.0f) {
                    return c / 2.0f * LDQR_Monitoring.pow((float)2.0f, (float)(10.0f * (t - 1.0f))) + b;
                }
                return c / 2.0f * (-LDQR_Monitoring.pow((float)2.0f, (float)(-10.0f * (t -= 1.0f))) + 2.0f) + b;
            }
            case 7: {
                if (when == 0) {
                    return -c * (LDQR_Monitoring.sqrt((float)(1.0f - (t /= d) * t)) - 1.0f) + b;
                }
                if (when == 1) {
                    t /= d;
                    return c * LDQR_Monitoring.sqrt((float)(1.0f - (t -= 1.0f) * t)) + b;
                }
                if (when != 2) break;
                if ((t /= d / 2.0f) < 1.0f) {
                    return -c / 2.0f * (LDQR_Monitoring.sqrt((float)(1.0f - t * t)) - 1.0f) + b;
                }
                return c / 2.0f * (LDQR_Monitoring.sqrt((float)(1.0f - (t -= 2.0f) * t)) + 1.0f) + b;
            }
        }
        return 0.0f;
    }

    public float map3(float value, float start1, float stop1, float start2, float stop2, float v, int when) {
        float b = start2;
        float c = stop2 - start2;
        float t = value - start1;
        float d = stop1 - start1;
        float p = v;
        float out = 0.0f;
        if (when == 0) {
            out = c * LDQR_Monitoring.pow((float)(t /= d), (float)p) + b;
        } else if (when == 1) {
            out = c * (1.0f - LDQR_Monitoring.pow((float)(1.0f - (t /= d)), (float)p)) + b;
        } else if (when == 2) {
            if ((t /= d / 2.0f) < 1.0f) {
                return c / 2.0f * LDQR_Monitoring.pow((float)t, (float)p) + b;
            }
            out = c / 2.0f * (2.0f - LDQR_Monitoring.pow((float)(2.0f - t), (float)p)) + b;
        }
        return out;
    }

    public void settings() {
        this.size(800, 800);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#4D4B4B", "--stop-color=#cccccc", "LDQR_Monitoring"};
        if (passedArgs != null) {
            PApplet.main((String[])LDQR_Monitoring.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Page1 {
        Square[] squares = new Square[16];
        SoundFile loop1;
        SoundFile loop2;
        SoundFile[] sun;
        SoundFile[] birds;
        int numsounds_sun = 3;
        int numsounds_birds = 10;
        IntList birds_Order;
        int indexSun = 0;
        int indexBirds = 0;
        float volLoop1 = 0.0f;
        float volLoop2 = 0.0f;
        float objLoop1 = 0.0f;
        float objLoop2 = 0.0f;
        float mappedVol1 = 0.0f;
        float nextTimer = 0.0f;
        float lastUpdate = 0.0f;
        int scoreTouched;
        int lastScoreTouched;
        int lastMove = 0;
        int delta = 1500;
        int fadein_timer = 1000;
        int fadeout_timer = 2000;
        boolean fadeIn = false;
        boolean moving = false;
        boolean sunPressed = false;
        boolean sunIsPlaying = false;
        boolean quit = false;

        Page1(PApplet p) {
            float r = LDQR_Monitoring.this.width / 3;
            int numDots = 15;
            float theta = (float)Math.PI * 2 / (float)numDots;
            int widthDots = 120;
            int i = 0;
            while (i < 15) {
                float myTheta = (float)i * theta;
                float x = r * LDQR_Monitoring.cos((float)myTheta) + (float)(LDQR_Monitoring.this.width / 2);
                float y = r * LDQR_Monitoring.sin((float)myTheta) + (float)(LDQR_Monitoring.this.height / 2);
                this.squares[i] = new Square(x - (float)(widthDots / 2), y - (float)(widthDots / 2), widthDots, i + 1);
                ++i;
            }
            this.squares[15] = new Square(LDQR_Monitoring.this.width / 2 - 40, LDQR_Monitoring.this.height / 2 - 40, 80.0f, 16);
            this.loop1 = new SoundFile(p, "P1/Planche01_Boucle Riviere.wav");
            this.loop2 = new SoundFile(p, "P1/PLANCHE01_Boucle Gigales.wav");
            this.sun = new SoundFile[this.numsounds_sun];
            this.sun[0] = new SoundFile(p, "P1/SOLEIL/SOLEIL1(4824).wav");
            this.sun[1] = new SoundFile(p, "P1/SOLEIL/SOLEIL2(4824).wav");
            this.sun[2] = new SoundFile(p, "P1/SOLEIL/SOLEIL3(4824).wav");
            this.birds = new SoundFile[this.numsounds_birds];
            this.birds[0] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle01.wav");
            this.birds[1] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle02.wav");
            this.birds[2] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle03.wav");
            this.birds[3] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle04.wav");
            this.birds[4] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette01.wav");
            this.birds[5] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette02.wav");
            this.birds[6] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette03.wav");
            this.birds[7] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol02.wav");
            this.birds[8] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol03.wav");
            this.birds[9] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol04.wav");
            this.birds_Order = new IntList();
            i = 0;
            while (i < this.numsounds_birds) {
                this.birds_Order.append(i);
                ++i;
            }
            this.birds_Order.shuffle();
            this.startSoundFiles();
        }

        public void draw(boolean _quit) {
            this.quit = _quit;
            if (!this.quit) {
                this.scoreTouched = 0;
                int i = 0;
                while (i < this.squares.length - 1) {
                    this.squares[i].draw();
                    if (this.squares[i].checkMouseOver() != 0) {
                        this.scoreTouched += this.squares[i].checkMouseOver();
                    }
                    ++i;
                }
                this.squares[15].draw();
                this.sunIsPlaying = false;
                i = 0;
                while (i < this.numsounds_sun) {
                    if (this.sun[i].isPlaying()) {
                        this.sunIsPlaying = true;
                    }
                    ++i;
                }
                int j = 0;
                while (j < this.numsounds_birds) {
                    if (this.birds[j].isPlaying()) {
                        this.sunIsPlaying = true;
                    }
                    ++j;
                }
                if (this.squares[15].checkMouseOver() == 16 && !this.sunPressed) {
                    this.sunPressed = true;
                    this.playSunSound();
                    LDQR_Monitoring.println((String)"Sun pressed");
                } else if (this.squares[15].checkMouseOver() == 0 && this.sunPressed) {
                    this.sunPressed = false;
                }
                if (this.lastScoreTouched != this.scoreTouched && this.scoreTouched > 0) {
                    this.fadeIn = true;
                    this.lastMove = LDQR_Monitoring.this.millis();
                    this.moving = true;
                    if ((float)LDQR_Monitoring.this.millis() > this.nextTimer) {
                        this.lastUpdate = LDQR_Monitoring.this.millis();
                        this.nextTimer = LDQR_Monitoring.this.millis() + this.fadein_timer;
                    }
                }
                if (LDQR_Monitoring.this.millis() - this.lastMove > this.delta && this.moving) {
                    this.fadeIn = false;
                    this.moving = false;
                    if ((float)LDQR_Monitoring.this.millis() > this.nextTimer) {
                        this.nextTimer = LDQR_Monitoring.this.millis() + this.fadeout_timer;
                        this.lastUpdate = LDQR_Monitoring.this.millis();
                    }
                }
                this.lastScoreTouched = this.scoreTouched;
                this.objLoop1 = this.fadeIn ? 100.0f : 0.0f;
                if (this.nextTimer > (float)LDQR_Monitoring.this.millis()) {
                    this.updateVolLoop();
                }
                this.mappedVol1 = LDQR_Monitoring.this.map2(this.volLoop1, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.loop1.amp(this.mappedVol1);
                this.loop2.amp(this.mappedVol1);
            }
            if (this.quit) {
                this.loop1.amp(0.0f);
                this.loop2.amp(0.0f);
            }
        }

        public void updateVolLoop() {
            float diff = LDQR_Monitoring.abs((float)(this.volLoop1 - this.objLoop1));
            float timeToReachObj = this.nextTimer - (float)LDQR_Monitoring.this.millis();
            float incrementByMs = diff / timeToReachObj;
            float deltaUpdate = (float)LDQR_Monitoring.this.millis() - this.lastUpdate;
            float update = incrementByMs * deltaUpdate;
            if (diff > 0.1f) {
                if (this.objLoop1 > this.volLoop1) {
                    this.volLoop1 += update;
                    if (this.volLoop1 > 100.0f) {
                        this.volLoop1 = 100.0f;
                    }
                } else if (this.objLoop1 < this.volLoop1) {
                    this.volLoop1 -= update;
                    if (this.volLoop1 < 0.0f) {
                        this.volLoop1 = 0.0f;
                    }
                }
            }
            this.lastUpdate = LDQR_Monitoring.this.millis();
        }

        public void startSoundFiles() {
            this.loop1.amp(0.0f);
            this.loop2.amp(0.0f);
            this.loop1.loop();
            this.loop2.loop();
        }

        public void playSunSound() {
            if (!this.sunIsPlaying) {
                switch (this.indexSun) {
                    case 1: {
                        this.sun[0].play(1.0f, 1.0f);
                        ++this.indexSun;
                        break;
                    }
                    case 3: {
                        this.sun[1].play(1.0f, 1.0f);
                        ++this.indexSun;
                        break;
                    }
                    case 6: {
                        this.sun[2].play(1.0f, 1.0f);
                        ++this.indexSun;
                        break;
                    }
                    default: {
                        this.birds[this.birds_Order.get(this.indexBirds)].play(1.0f, 1.0f);
                        ++this.indexBirds;
                        if (this.indexBirds == this.numsounds_birds) {
                            this.birds_Order.shuffle();
                            this.indexBirds = 0;
                        }
                        ++this.indexSun;
                    }
                }
            }
        }

        public void quitPage() {
        }
    }

    class Page2 {
        Square[] squares = new Square[2];
        SoundFile Ocean1;
        SoundFile Ocean2;
        SoundFile Kids;
        SoundFile Birds;
        PVector volLoopOcean1 = new PVector(0.0f, 0.0f);
        PVector volLoopOcean2 = new PVector(0.0f, 0.0f);
        PVector volLoopKids = new PVector(0.0f, 0.0f);
        PVector volLoopBirds = new PVector(0.0f, 0.0f);
        PVector timerOcean1 = new PVector(0.0f, 0.0f);
        PVector timerOcean2 = new PVector(0.0f, 0.0f);
        PVector timerKids = new PVector(0.0f, 0.0f);
        PVector timerBirds = new PVector(0.0f, 0.0f);
        boolean updatingOcean = false;
        boolean updatingOcean2 = false;
        boolean updatingKids = false;
        boolean updatingBirds = false;
        boolean windowOpened = false;
        boolean lastWindowState = false;
        boolean fadeIn;
        boolean fadeOut;
        SoundFile[] Chien;
        SoundFile[] Train;
        IntList dog_Order;
        IntList train_Order;
        int indexChien = 0;
        int indexTrain = 0;
        int nextChienTimer;
        int nextTrainTimer;
        boolean quit;

        Page2(PApplet p) {
            this.squares[0] = new Square(LDQR_Monitoring.this.width / 2 - 80, LDQR_Monitoring.this.height / 2 - 100, 70.0f, 1);
            this.squares[1] = new Square(LDQR_Monitoring.this.width / 2 + 10, LDQR_Monitoring.this.height / 2 - 100, 70.0f, 2);
            this.Ocean1 = new SoundFile(p, "P2/PLANCHE02_BoucleOcean.wav");
            this.Ocean2 = new SoundFile(p, "P2/PLANCHE02_BoucleOcean2.wav");
            this.Birds = new SoundFile(p, "P2/PLANCHE02_boucleoiseauxdemer.wav");
            this.Kids = new SoundFile(p, "P2/PLANCHE02_ambianceenfants.wav");
            this.Chien = new SoundFile[3];
            this.Chien[0] = new SoundFile(p, "P2/PLANCHE02_chien1.wav");
            this.Chien[1] = new SoundFile(p, "P2/PLANCHE02_chien2.wav");
            this.Chien[2] = new SoundFile(p, "P2/PLANCHE02_chien3.wav");
            this.Train = new SoundFile[2];
            this.Train[0] = new SoundFile(p, "P2/PLANCHE02_Train.wav");
            this.Train[1] = new SoundFile(p, "P2/PLANCHE02_Train2.wav");
            this.dog_Order = new IntList();
            int i = 0;
            while (i < this.Chien.length) {
                this.dog_Order.append(i);
                ++i;
            }
            this.dog_Order.shuffle();
            this.train_Order = new IntList();
            i = 0;
            while (i < this.Train.length) {
                this.train_Order.append(i);
                ++i;
            }
            this.train_Order.shuffle();
            this.nextChienTimer = LDQR_Monitoring.this.millis() + PApplet.parseInt((float)LDQR_Monitoring.this.random(15000.0f, 20000.0f));
            this.nextTrainTimer = LDQR_Monitoring.this.millis() + PApplet.parseInt((float)LDQR_Monitoring.this.random(20000.0f, 35000.0f));
            this.startSoundFiles();
        }

        public void draw(boolean _quit) {
            this.quit = _quit;
            if (!this.quit) {
                int score = 0;
                int i = 0;
                while (i < this.squares.length) {
                    this.squares[i].draw();
                    if (this.squares[i].checkMouseOver() > 0) {
                        ++score;
                    }
                    ++i;
                }
                this.windowOpened = score > 0;
                if (this.windowOpened) {
                    if (!this.lastWindowState) {
                        LDQR_Monitoring.println((String)"Fade in");
                        this.fadeIn = true;
                        this.volLoopOcean1.y = 50.0f;
                        this.timerOcean1.x = LDQR_Monitoring.this.millis();
                        this.timerOcean1.y = LDQR_Monitoring.this.millis() + 2000;
                        this.volLoopOcean2.y = 70.0f;
                        this.timerOcean2.x = LDQR_Monitoring.this.millis();
                        this.timerOcean2.y = LDQR_Monitoring.this.millis() + 2000;
                        this.volLoopKids.y = 80.0f;
                        this.timerKids.x = LDQR_Monitoring.this.millis();
                        this.timerKids.y = LDQR_Monitoring.this.millis() + 2000;
                        this.volLoopBirds.y = 50.0f;
                        this.timerBirds.x = LDQR_Monitoring.this.millis();
                        this.timerBirds.y = LDQR_Monitoring.this.millis() + 2000;
                        this.nextChienTimer = LDQR_Monitoring.this.millis() + PApplet.parseInt((float)LDQR_Monitoring.this.random(15000.0f, 20000.0f));
                        this.nextTrainTimer = LDQR_Monitoring.this.millis() + PApplet.parseInt((float)LDQR_Monitoring.this.random(20000.0f, 35000.0f));
                        this.lastWindowState = this.windowOpened;
                    } else {
                        if (!(this.updatingOcean || this.fadeIn || this.fadeOut)) {
                            this.volLoopOcean1.y = LDQR_Monitoring.this.random(20.0f, 65.0f);
                            this.timerOcean1.x = LDQR_Monitoring.this.millis();
                            this.timerOcean1.y = (float)LDQR_Monitoring.this.millis() + LDQR_Monitoring.this.random(5000.0f, 7000.0f);
                            this.updatingOcean = true;
                        }
                        if (!(this.updatingOcean2 || this.fadeIn || this.fadeOut)) {
                            this.volLoopOcean2.y = LDQR_Monitoring.this.random(40.0f, 80.0f);
                            this.timerOcean2.x = LDQR_Monitoring.this.millis();
                            this.timerOcean2.y = (float)LDQR_Monitoring.this.millis() + LDQR_Monitoring.this.random(5000.0f, 7000.0f);
                            this.updatingOcean2 = true;
                        }
                        if (!(this.updatingKids || this.fadeIn || this.fadeOut)) {
                            this.volLoopKids.y = LDQR_Monitoring.this.random(75.0f, 100.0f);
                            this.timerKids.x = LDQR_Monitoring.this.millis();
                            this.timerKids.y = (float)LDQR_Monitoring.this.millis() + LDQR_Monitoring.this.random(5000.0f, 7000.0f);
                            this.updatingKids = true;
                        }
                        if (!(this.updatingBirds || this.fadeIn || this.fadeOut)) {
                            this.volLoopBirds.y = LDQR_Monitoring.this.random(20.0f, 50.0f);
                            this.timerBirds.x = LDQR_Monitoring.this.millis();
                            this.timerBirds.y = (float)LDQR_Monitoring.this.millis() + LDQR_Monitoring.this.random(5000.0f, 7000.0f);
                            this.updatingBirds = true;
                        }
                    }
                } else if (!this.windowOpened && this.lastWindowState) {
                    LDQR_Monitoring.println((String)"Fade out");
                    this.fadeOut = true;
                    this.volLoopOcean1.y = 0.0f;
                    this.timerOcean1.x = LDQR_Monitoring.this.millis();
                    this.timerOcean1.y = LDQR_Monitoring.this.millis() + 2000;
                    this.volLoopOcean2.y = 0.0f;
                    this.timerOcean2.x = LDQR_Monitoring.this.millis();
                    this.timerOcean2.y = LDQR_Monitoring.this.millis() + 2000;
                    this.volLoopKids.y = 0.0f;
                    this.timerKids.x = LDQR_Monitoring.this.millis();
                    this.timerKids.y = LDQR_Monitoring.this.millis() + 2000;
                    this.volLoopBirds.y = 0.0f;
                    this.timerBirds.x = LDQR_Monitoring.this.millis();
                    this.timerBirds.y = LDQR_Monitoring.this.millis() + 2000;
                    this.lastWindowState = this.windowOpened;
                }
                if (this.fadeIn && (float)LDQR_Monitoring.this.millis() > this.timerOcean1.y) {
                    this.fadeIn = false;
                }
                if (this.fadeOut && (float)LDQR_Monitoring.this.millis() > this.timerOcean1.y) {
                    this.fadeOut = false;
                }
                if ((float)LDQR_Monitoring.this.millis() > this.timerOcean1.y) {
                    this.updatingOcean = false;
                }
                if ((float)LDQR_Monitoring.this.millis() > this.timerOcean2.y) {
                    this.updatingOcean2 = false;
                }
                if ((float)LDQR_Monitoring.this.millis() > this.timerKids.y) {
                    this.updatingKids = false;
                }
                if ((float)LDQR_Monitoring.this.millis() > this.timerBirds.y) {
                    this.updatingBirds = false;
                }
                this.updateVolLoop(this.volLoopOcean1, this.timerOcean1);
                this.updateVolLoop(this.volLoopOcean2, this.timerOcean2);
                this.updateVolLoop(this.volLoopKids, this.timerKids);
                this.updateVolLoop(this.volLoopBirds, this.timerBirds);
                float mappedVol1 = LDQR_Monitoring.this.map2(this.volLoopOcean1.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.Ocean1.amp(mappedVol1);
                float mappedVol2 = LDQR_Monitoring.this.map2(this.volLoopOcean2.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.Ocean2.amp(mappedVol2);
                float mappedVol3 = LDQR_Monitoring.this.map2(this.volLoopKids.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.Kids.amp(mappedVol3);
                float mappedVol4 = LDQR_Monitoring.this.map2(this.volLoopBirds.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.Birds.amp(mappedVol4);
                if (this.windowOpened) {
                    if (LDQR_Monitoring.this.millis() > this.nextChienTimer) {
                        this.nextChienTimer = LDQR_Monitoring.this.millis() + PApplet.parseInt((float)LDQR_Monitoring.this.random(2000.0f, 25000.0f));
                        this.Chien[this.dog_Order.get(this.indexChien)].play();
                        LDQR_Monitoring.println((Object[])new Object[]{"Play Chien ", this.dog_Order.get(this.indexChien)});
                        ++this.indexChien;
                        if (this.indexChien == this.Chien.length) {
                            this.dog_Order.shuffle();
                        }
                        this.indexChien %= this.Chien.length;
                    }
                    if (LDQR_Monitoring.this.millis() > this.nextTrainTimer) {
                        this.nextTrainTimer = LDQR_Monitoring.this.millis() + PApplet.parseInt((float)LDQR_Monitoring.this.random(40000.0f, 60000.0f));
                        this.Train[this.train_Order.get(this.indexTrain)].play();
                        LDQR_Monitoring.println((Object[])new Object[]{"Play Train ", this.train_Order.get(this.indexTrain)});
                        ++this.indexTrain;
                        if (this.indexTrain == this.Train.length) {
                            this.train_Order.shuffle();
                        }
                        this.indexTrain %= this.Train.length;
                    }
                }
            }
            if (this.quit) {
                this.Ocean1.amp(0.0f);
                this.Ocean2.amp(0.0f);
                this.Kids.amp(0.0f);
                this.Birds.amp(0.0f);
            }
        }

        public void updateVolLoop(PVector volLoopFile, PVector timer) {
            float volLoop = volLoopFile.x;
            float objLoop = volLoopFile.y;
            float lastUpdate = timer.x;
            float nextTimer = timer.y;
            if ((float)LDQR_Monitoring.this.millis() < nextTimer) {
                float diff = LDQR_Monitoring.abs((float)(volLoop - objLoop));
                float timeToReachObj = nextTimer - (float)LDQR_Monitoring.this.millis();
                float incrementByMs = diff / timeToReachObj;
                float deltaUpdate = (float)LDQR_Monitoring.this.millis() - lastUpdate;
                float update = incrementByMs * deltaUpdate;
                if (diff > 0.1f) {
                    if (objLoop > volLoop) {
                        if ((volLoop += update) > 100.0f) {
                            volLoop = 100.0f;
                        }
                    } else if (objLoop < volLoop && (volLoop -= update) < 0.0f) {
                        volLoop = 0.0f;
                    }
                }
            }
            timer.x = LDQR_Monitoring.this.millis();
            volLoopFile.x = volLoop;
        }

        public void startSoundFiles() {
            this.Ocean1.amp(0.0f);
            this.Ocean2.amp(0.0f);
            this.Kids.amp(0.0f);
            this.Birds.amp(0.0f);
            this.Ocean1.loop();
            this.Ocean2.loop();
            this.Kids.loop();
            this.Birds.loop();
        }
    }

    class Page3 {
        Square[] squares = new Square[2];
        SoundFile[] sonsCourt;
        SoundFile[] sonsLongs;
        int numsounds_courts = 12;
        int numsounds_longs = 12;
        SoundFile song;
        boolean songStarted = false;
        int nberJumps = 0;
        boolean pressed = false;
        boolean lastPressed = false;
        int panning = 0;
        PVector volLoopSong = new PVector(0.0f, 0.0f);
        PVector timerSong = new PVector(0.0f, 0.0f);
        int delta = 2000;
        boolean halfway = false;
        boolean quit = false;

        Page3(PApplet p) {
            this.squares[0] = new Square(LDQR_Monitoring.this.width / 2 - 150, LDQR_Monitoring.this.height / 2 - 80, 140.0f, 1);
            this.squares[1] = new Square(LDQR_Monitoring.this.width / 2 + 10, LDQR_Monitoring.this.height / 2 - 80, 140.0f, 2);
            this.sonsCourt = new SoundFile[this.numsounds_courts];
            this.sonsCourt[0] = new SoundFile(p, "P3/COURT/CLAVEMONO-01.wav");
            this.sonsCourt[1] = new SoundFile(p, "P3/COURT/CLOCHE1MONO-01.wav");
            this.sonsCourt[2] = new SoundFile(p, "P3/COURT/CLOCHE2MONO.wav");
            this.sonsCourt[3] = new SoundFile(p, "P3/COURT/CONGASMONO-01.wav");
            this.sonsCourt[4] = new SoundFile(p, "P3/COURT/CRESSELLEMONO-01.wav");
            this.sonsCourt[5] = new SoundFile(p, "P3/COURT/GUITARE.wav");
            this.sonsCourt[6] = new SoundFile(p, "P3/COURT/SIFFLET.wav");
            this.sonsCourt[7] = new SoundFile(p, "P3/COURT/SNAP.wav");
            this.sonsCourt[8] = new SoundFile(p, "P3/COURT/STOMP.wav");
            this.sonsCourt[9] = new SoundFile(p, "P3/COURT/TAMBOURINMONO-01.wav");
            this.sonsCourt[10] = new SoundFile(p, "P3/COURT/TRIANGLEMONO-01.wav");
            this.sonsCourt[11] = new SoundFile(p, "P3/COURT/TRIANGLEMONO2.wav");
            this.sonsLongs = new SoundFile[this.numsounds_courts];
            this.sonsLongs[0] = new SoundFile(p, "P3/LONG/BASSE1MONO-01.wav");
            this.sonsLongs[1] = new SoundFile(p, "P3/LONG/BASSE2MONO.wav");
            this.sonsLongs[2] = new SoundFile(p, "P3/LONG/CLAVE2MONO-01.wav");
            this.sonsLongs[3] = new SoundFile(p, "P3/LONG/CLAVIER.wav");
            this.sonsLongs[4] = new SoundFile(p, "P3/LONG/CLAVIERPERCU.wav");
            this.sonsLongs[5] = new SoundFile(p, "P3/LONG/GUITARE2.wav");
            this.sonsLongs[6] = new SoundFile(p, "P3/LONG/PATTERN1.wav");
            this.sonsLongs[7] = new SoundFile(p, "P3/LONG/PATTERN1B.wav");
            this.sonsLongs[8] = new SoundFile(p, "P3/LONG/PATTERNC.wav");
            this.sonsLongs[9] = new SoundFile(p, "P3/LONG/PATTERND.wav");
            this.sonsLongs[10] = new SoundFile(p, "P3/LONG/SIFFLETPERCU.wav");
            this.sonsLongs[11] = new SoundFile(p, "P3/LONG/PATTERNE.wav");
            this.song = new SoundFile(p, "P3/KAPI.wav");
        }

        public void draw(boolean _quit) {
            this.quit = _quit;
            if (!this.quit) {
                int score = 0;
                int i = 0;
                while (i < this.squares.length) {
                    this.squares[i].draw();
                    if (this.squares[i].checkMouseOver() != 0) {
                        score = this.squares[i].checkMouseOver();
                    }
                    ++i;
                }
                if (score > 0) {
                    this.pressed = true;
                    if (score == 1) {
                        this.panning = -1;
                    } else if (score == 2) {
                        this.panning = 1;
                    }
                } else {
                    this.pressed = false;
                    if (this.lastPressed) {
                        this.lastPressed = false;
                    }
                }
                if (this.pressed && !this.lastPressed) {
                    int randomSound;
                    LDQR_Monitoring.print((String)("Jump!" + this.nberJumps + " "));
                    LDQR_Monitoring.print((String)("panning " + this.panning + " "));
                    ++this.nberJumps;
                    this.halfway = false;
                    if (this.nberJumps < 11) {
                        randomSound = PApplet.parseInt((float)LDQR_Monitoring.this.random(0.0f, this.numsounds_courts));
                        this.sonsCourt[randomSound].pan((float)this.panning);
                        this.sonsCourt[randomSound].play();
                        LDQR_Monitoring.print((String)("played short " + randomSound + " "));
                    } else if (this.nberJumps > 10 && this.nberJumps < 20) {
                        randomSound = PApplet.parseInt((float)LDQR_Monitoring.this.random(0.0f, this.numsounds_longs));
                        this.sonsLongs[randomSound].pan((float)this.panning);
                        this.sonsLongs[randomSound].play();
                        LDQR_Monitoring.print((String)("played long " + randomSound + " "));
                    } else {
                        if (!this.songStarted) {
                            this.startSong();
                            this.songStarted = true;
                        }
                        this.volLoopSong.y = 100.0f;
                        this.timerSong.x = LDQR_Monitoring.this.millis();
                        this.timerSong.y = LDQR_Monitoring.this.millis() + 3000;
                    }
                    this.song.pan((float)this.panning);
                    this.lastPressed = true;
                    LDQR_Monitoring.println();
                }
            }
            if (this.songStarted) {
                this.updateVolLoop(this.volLoopSong, this.timerSong);
                float mappedVol1 = LDQR_Monitoring.this.map2(this.volLoopSong.x, 0.0f, 100.0f, 0.0f, 1.0f, 1, 2);
                this.song.amp(mappedVol1);
                if ((float)LDQR_Monitoring.this.millis() - this.timerSong.y > (float)(this.delta * 2) && this.halfway || this.quit) {
                    this.volLoopSong.y = 0.0f;
                    this.timerSong.x = LDQR_Monitoring.this.millis();
                    this.timerSong.y = LDQR_Monitoring.this.millis() + 2000;
                } else if ((float)LDQR_Monitoring.this.millis() - this.timerSong.y > (float)this.delta && !this.halfway) {
                    this.volLoopSong.y = 50.0f;
                    this.timerSong.x = LDQR_Monitoring.this.millis();
                    this.timerSong.y = LDQR_Monitoring.this.millis() + 2000;
                    this.halfway = true;
                }
            }
        }

        public void updateVolLoop(PVector volLoopFile, PVector timer) {
            float volLoop = volLoopFile.x;
            float objLoop = volLoopFile.y;
            float lastUpdate = timer.x;
            float nextTimer = timer.y;
            if ((float)LDQR_Monitoring.this.millis() < nextTimer) {
                float diff = LDQR_Monitoring.abs((float)(volLoop - objLoop));
                float timeToReachObj = nextTimer - (float)LDQR_Monitoring.this.millis();
                float incrementByMs = diff / timeToReachObj;
                float deltaUpdate = (float)LDQR_Monitoring.this.millis() - lastUpdate;
                float update = incrementByMs * deltaUpdate;
                if (diff > 0.1f) {
                    if (objLoop > volLoop) {
                        if ((volLoop += update) > 100.0f) {
                            volLoop = 100.0f;
                        }
                    } else if (objLoop < volLoop && (volLoop -= update) < 0.0f) {
                        volLoop = 0.0f;
                    }
                }
            }
            timer.x = LDQR_Monitoring.this.millis();
            volLoopFile.x = volLoop;
        }

        public void startSong() {
            this.song.amp(0.1f);
            this.song.pan(0.0f);
            this.song.play();
        }
    }

    class Page4 {
        Square[] squares = new Square[3];
        SoundFile[] splotchs;
        SoundFile[] frog;
        int numsounds_splotchs = 9;
        int numsounds_frog = 3;
        IntList splotchs_Order;
        IntList frog_Order;
        int indexSplotchs = 0;
        int indexFrog = 0;
        boolean isPressed = false;
        boolean lastPressed = false;

        Page4(PApplet p) {
            this.squares[0] = new Square(LDQR_Monitoring.this.width / 2 - 150, LDQR_Monitoring.this.height / 2 + 50, 150.0f, 1);
            this.squares[1] = new Square(LDQR_Monitoring.this.width / 2 - 50, LDQR_Monitoring.this.height / 2 - 100, 75.0f, 2);
            this.squares[2] = new Square(LDQR_Monitoring.this.width / 2 + 20, LDQR_Monitoring.this.height / 2 - 200, 35.0f, 3);
            this.splotchs = new SoundFile[this.numsounds_splotchs];
            this.splotchs[0] = new SoundFile(p, "P4/PLANCEH04_Boue3.wav");
            this.splotchs[1] = new SoundFile(p, "P4/PLANCHE04_boue1.wav");
            this.splotchs[2] = new SoundFile(p, "P4/PLANCHE04_boue5.wav");
            this.splotchs[3] = new SoundFile(p, "P4/PLANCHE04_boue7.wav");
            this.splotchs[4] = new SoundFile(p, "P4/PLANCHE04_boue8.wav");
            this.splotchs[5] = new SoundFile(p, "P4/PLANCHE04_boue9.wav");
            this.splotchs[6] = new SoundFile(p, "P4/PLANCHE04_Boue2.wav");
            this.splotchs[7] = new SoundFile(p, "P4/PLANCHE04_Boue4.wav");
            this.splotchs[8] = new SoundFile(p, "P4/PLANCHE04_boue10.wav");
            this.frog = new SoundFile[this.numsounds_frog];
            this.frog[0] = new SoundFile(p, "P4/PLANCHE04_grenouille1.wav");
            this.frog[1] = new SoundFile(p, "P4/PLANCHE04_grenouille2.wav");
            this.frog[2] = new SoundFile(p, "P4/PLANCHE04_grenouille plonge.wav");
            this.splotchs_Order = new IntList();
            int i = 0;
            while (i < this.splotchs.length) {
                this.splotchs_Order.append(i);
                ++i;
            }
            this.splotchs_Order.shuffle();
            this.frog_Order = new IntList();
            i = 0;
            while (i < this.frog.length) {
                this.frog_Order.append(i);
                ++i;
            }
            this.frog_Order.shuffle();
        }

        public void draw() {
            int score = 0;
            int i = 0;
            while (i < this.squares.length) {
                this.squares[i].draw();
                if (this.squares[i].checkMouseOver() != 0) {
                    ++score;
                }
                ++i;
            }
            if (score > 0) {
                this.isPressed = true;
            } else {
                this.isPressed = false;
                if (this.lastPressed) {
                    this.lastPressed = false;
                }
            }
            if (this.isPressed && !this.lastPressed) {
                ++this.indexSplotchs;
                if (this.indexSplotchs == this.numsounds_splotchs) {
                    this.indexSplotchs = 0;
                    this.splotchs_Order.shuffle();
                    this.frog[this.frog_Order.get(this.indexFrog)].play();
                    LDQR_Monitoring.println((String)("Frog n\u00b0 " + this.frog_Order.get(this.indexFrog)));
                    ++this.indexFrog;
                    if (this.indexFrog == this.numsounds_frog) {
                        this.indexFrog = 0;
                        this.frog_Order.shuffle();
                    }
                }
                this.splotchs[this.splotchs_Order.get(this.indexSplotchs)].play();
                this.lastPressed = true;
                LDQR_Monitoring.println((String)("Splotch n\u00b0 " + this.splotchs_Order.get(this.indexSplotchs)));
            }
        }
    }

    class Page5 {
        Square[] squares = new Square[3];

        Page5() {
            this.squares[0] = new Square(LDQR_Monitoring.this.width / 2 - 100, LDQR_Monitoring.this.height / 2 + 100, 200.0f, 1);
            this.squares[1] = new Square(LDQR_Monitoring.this.width / 2 - 70, LDQR_Monitoring.this.height / 2 - 90, 140.0f, 2);
            this.squares[2] = new Square(LDQR_Monitoring.this.width / 2 - 30, LDQR_Monitoring.this.height / 2 - 200, 60.0f, 3);
        }

        public void draw() {
            int i = 0;
            while (i < this.squares.length) {
                this.squares[i].draw();
                if (this.squares[i].checkMouseOver() != 0) {
                    LDQR_Monitoring.println((int)this.squares[i].checkMouseOver());
                }
                ++i;
            }
        }
    }

    class Page6 {
        int rows = 7;
        int cols = 6;
        int square_Width;
        int offset;
        Square[][] squares;

        Page6() {
            this.square_Width = LDQR_Monitoring.this.width / 8;
            this.offset = LDQR_Monitoring.this.width / 8;
            this.squares = new Square[this.cols][this.rows];
            int i = 0;
            while (i < this.cols) {
                int j = 0;
                while (j < this.rows) {
                    this.squares[i][j] = new Square(this.offset + i * this.square_Width, this.offset / 2 + j * this.square_Width, this.square_Width, 1 + (i + j * this.cols));
                    ++j;
                }
                ++i;
            }
        }

        public void draw() {
            int i = 0;
            while (i < this.cols) {
                int j = 0;
                while (j < this.rows) {
                    this.squares[i][j].draw();
                    if (this.squares[i][j].checkMouseOver() != 0) {
                        LDQR_Monitoring.println((int)this.squares[i][j].checkMouseOver());
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    class Square {
        float square_x;
        float square_y;
        float square_width;
        boolean mouseOver;
        int id;

        Square(float _x, float _y, float _width, int _id) {
            this.square_x = _x;
            this.square_y = _y;
            this.square_width = _width;
            this.id = _id;
        }

        public void draw() {
            if (this.mouseOver) {
                LDQR_Monitoring.this.fill(125);
            } else {
                LDQR_Monitoring.this.fill(220);
            }
            LDQR_Monitoring.this.stroke(255);
            LDQR_Monitoring.this.strokeWeight(1.0f);
            LDQR_Monitoring.this.rect(this.square_x, this.square_y, this.square_width, this.square_width);
        }

        public int checkMouseOver() {
            if ((float)LDQR_Monitoring.this.mouseX > this.square_x && (float)LDQR_Monitoring.this.mouseX < this.square_x + this.square_width && (float)LDQR_Monitoring.this.mouseY > this.square_y && (float)LDQR_Monitoring.this.mouseY < this.square_y + this.square_width) {
                this.mouseOver = true;
                return this.id;
            }
            this.mouseOver = false;
            return 0;
        }
    }
}

