import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import processing.sound.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class LDQR_Monitoring extends PApplet {



/* The map2() function supports the following easing types */
final int LINEAR = 0;
final int QUADRATIC = 1;
final int CUBIC = 2;
final int QUARTIC = 3;
final int QUINTIC = 4;
final int SINUSOIDAL = 5;
final int EXPONENTIAL = 6;
final int CIRCULAR = 7;
final int SQRT = 8;

/* When the easing is applied (in, out, or both) */
final int EASE_IN = 0;
final int EASE_OUT = 1;
final int EASE_IN_OUT = 2;

int state = 10;
Page1 page1;
Page2 page2;
Page3 page3;
Page4 page4;
/*
Page5 page5;
Page6 page6;
*/

public void setup()
{
  
  background(255,248,196);
  page1 = new Page1(this);
  page2 = new Page2(this);
  page3 = new Page3(this);
  page4 = new Page4(this);
   /*
  page5 = new Page5();
  page6 = new Page6();
  */
}





public void draw()
{
  background(255,248,196);
  switch (state)
  {
    case 0:
    break;
    
    
    //PAGE 1
    case 10:
    page1.draw(false);
    break;
    
    
    //PAGE 2
    case 20:
    page1.draw(true);
    page2.draw(false);
    break;

    
    //PAGE 3
    case 30:
    page2.draw(true);
    page3.draw(false);
    break;
    
    
    //PAGE 4
    case 40:
    page3.draw(true);
    page4.draw();
    break;
    /*
    
   //PAGE 5
    case 50:
    page5.draw();
    break;
    
    
    //PAGE 6
    case 60:
    page6.draw();
    break;
        */
  }
      
}


public void keyPressed()
{
  switch (PApplet.parseInt(key)-48)
  {
    case 0:
    break;
   
    //PAGE 1
    case 1:
    println("Page 1");
    state = 10;
    break;
    
    
    //PAGE 2
    case 2:
    println("Page 2");
    state = 20;
    break;
    
   
    //PAGE 3
    case 3:
    println("Page 3");
    state = 30;
    break;
    
    
    //PAGE 4
    case 4:
    println("Page 4");
    state = 40;
    break;
    
    /*
   //PAGE 5
    case 5:
    println("Page 5");
    state = 50;
    break;
    
    
    //PAGE 6
    case 6:
    println("Page 6");
    state = 60;
    break;
    */
  }
    
}




/*
 * A map() replacement that allows for specifying easing curves
 * with arbitrary exponents.
 *
 * value :   The value to map
 * start1:   The lower limit of the input range
 * stop1 :   The upper limit of the input range
 * start2:   The lower limit of the output range
 * stop2 :   The upper limit of the output range
 * type  :   The type of easing (see above)
 * when  :   One of EASE_IN, EASE_OUT, or EASE_IN_OUT
 */
public float map2(float value, float start1, float stop1, float start2, float stop2, int type, int when) {
  float b = start2;
  float c = stop2 - start2;
  float t = value - start1;
  float d = stop1 - start1;
  float p = 0.5f;
  switch (type) {
  case LINEAR:
    return c*t/d + b;
  case SQRT:
    if (when == EASE_IN) {
      t /= d;
      return c*pow(t, p) + b;
    } else if (when == EASE_OUT) {
      t /= d;
      return c * (1 - pow(1 - t, p)) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*pow(t, p) + b;
      return c/2 * (2 - pow(2 - t, p)) + b;
    }
    break;
  case QUADRATIC:
    if (when == EASE_IN) {
      t /= d;
      return c*t*t + b;
    } else if (when == EASE_OUT) {
      t /= d;
      return -c * t*(t-2) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*t*t + b;
      t--;
      return -c/2 * (t*(t-2) - 1) + b;
    }
    break;
  case CUBIC:
    if (when == EASE_IN) {
      t /= d;
      return c*t*t*t + b;
    } else if (when == EASE_OUT) {
      t /= d;
      t--;
      return c*(t*t*t + 1) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*t*t*t + b;
      t -= 2;
      return c/2*(t*t*t + 2) + b;
    }
    break;
  case QUARTIC:
    if (when == EASE_IN) {
      t /= d;
      return c*t*t*t*t + b;
    } else if (when == EASE_OUT) {
      t /= d;
      t--;
      return -c * (t*t*t*t - 1) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*t*t*t*t + b;
      t -= 2;
      return -c/2 * (t*t*t*t - 2) + b;
    }
    break;
  case QUINTIC:
    if (when == EASE_IN) {
      t /= d;
      return c*t*t*t*t*t + b;
    } else if (when == EASE_OUT) {
      t /= d;
      t--;
      return c*(t*t*t*t*t + 1) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2*t*t*t*t*t + b;
      t -= 2;
      return c/2*(t*t*t*t*t + 2) + b;
    }
    break;
  case SINUSOIDAL:
    if (when == EASE_IN) {
      return -c * cos(t/d * (PI/2)) + c + b;
    } else if (when == EASE_OUT) {
      return c * sin(t/d * (PI/2)) + b;
    } else if (when == EASE_IN_OUT) {
      return -c/2 * (cos(PI*t/d) - 1) + b;
    }
    break;
  case EXPONENTIAL:
    if (when == EASE_IN) {
      return c * pow( 2, 10 * (t/d - 1) ) + b;
    } else if (when == EASE_OUT) {
      return c * ( -pow( 2, -10 * t/d ) + 1 ) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return c/2 * pow( 2, 10 * (t - 1) ) + b;
      t--;
      return c/2 * ( -pow( 2, -10 * t) + 2 ) + b;
    }
    break;
  case CIRCULAR:
    if (when == EASE_IN) {
      t /= d;
      return -c * (sqrt(1 - t*t) - 1) + b;
    } else if (when == EASE_OUT) {
      t /= d;
      t--;
      return c * sqrt(1 - t*t) + b;
    } else if (when == EASE_IN_OUT) {
      t /= d/2;
      if (t < 1) return -c/2 * (sqrt(1 - t*t) - 1) + b;
      t -= 2;
      return c/2 * (sqrt(1 - t*t) + 1) + b;
    }
    break;
  };
  return 0;
}

/*
 * A map() replacement that allows for specifying easing curves
 * with arbitrary exponents.
 *
 * value :   The value to map
 * start1:   The lower limit of the input range
 * stop1 :   The upper limit of the input range
 * start2:   The lower limit of the output range
 * stop2 :   The upper limit of the output range
 * v     :   The exponent value (e.g., 0.5, 0.1, 0.3)
 * when  :   One of EASE_IN, EASE_OUT, or EASE_IN_OUT
 */
public float map3(float value, float start1, float stop1, float start2, float stop2, float v, int when) {
  float b = start2;
  float c = stop2 - start2;
  float t = value - start1;
  float d = stop1 - start1;
  float p = v;
  float out = 0;
  if (when == EASE_IN) {
    t /= d;
    out = c*pow(t, p) + b;
  } else if (when == EASE_OUT) {
    t /= d;
    out = c * (1 - pow(1 - t, p)) + b;
  } else if (when == EASE_IN_OUT) {
    t /= d/2;
    if (t < 1) return c/2*pow(t, p) + b;
    out = c/2 * (2 - pow(2 - t, p)) + b;
  }
  return out;
}
class Page1 {

  // Aroud planet -> nber 1-15
  //Planet -> 16

  Square[] squares= new Square [16];

  SoundFile loop1;
  SoundFile loop2;
  SoundFile[] sun;
  SoundFile[] birds;
  // Define the number of samples 
  int numsounds_sun = 3;
  int numsounds_birds = 10;
  IntList birds_Order;
  int indexSun = 0;
  int indexBirds = 0;

  float volLoop1 = 0.0f;
  float volLoop2 = 0.0f;
  float objLoop1 = 0.0f;
  float objLoop2 = 0.0f;

  float mappedVol1 = 0.0f;

  float nextTimer = 0;
  float lastUpdate = 0;

  int scoreTouched;
  int lastScoreTouched;
  int lastMove = 0;

  //timers
  int delta = 1500;
  int fadein_timer = 1000;
  int fadeout_timer = 2000;

  boolean fadeIn = false;
  boolean moving = false;
  boolean sunPressed = false;
  boolean sunIsPlaying = false;

  boolean quit = false;


  Page1(PApplet p)
  { 
    //init

    //GUI
    //circle
    float r = width/3; //radius of circle
    int numDots = 15;
    // Calculate angle between two ellipses
    float theta = TWO_PI / numDots;
    int widthDots = 120;
    //create squares
    for (int i =0; i<15; i++)
    {
      float myTheta = i*theta; //calculate current angle
      float x = r*cos(myTheta) + width/2 ; //calculate xPos
      float y = r*sin(myTheta) + height/2 ; //calculate yPos
      squares[i] = new Square( x-widthDots/2, y-widthDots/2, widthDots, i+1);
    }
    squares[15] = new Square (width/2-40, height/2-40, 80, 16);

    //SOUNDS
    //WHEEL
    // Load soundfiles
    loop1 = new SoundFile(p, "P1/Planche01_Boucle Riviere.wav");
    // Load a soundfile
    loop2 = new SoundFile(p, "P1/PLANCHE01_Boucle Gigales.wav");

    //SUN
    // Create an array of soundfiles
    sun = new SoundFile[numsounds_sun];
    sun[0] = new SoundFile(p, "P1/SOLEIL/SOLEIL1(4824).wav");
    sun[1] = new SoundFile(p, "P1/SOLEIL/SOLEIL2(4824).wav");
    sun[2] = new SoundFile(p, "P1/SOLEIL/SOLEIL3(4824).wav");

    birds = new SoundFile[numsounds_birds];
    birds[0] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle01.wav");
    birds[1] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle02.wav");
    birds[2] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle03.wav");
    birds[3] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Merle04.wav");
    birds[4] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette01.wav");
    birds[5] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette02.wav");
    birds[6] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Mouette03.wav");
    birds[7] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol02.wav");
    birds[8] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol03.wav");
    birds[9] = new SoundFile(p, "P1/SOLEIL/PLANCHE01_Rossignol04.wav");

    birds_Order = new IntList();
    for (int i=0; i<numsounds_birds; i++)
    {
      birds_Order.append(i);
    }
    birds_Order.shuffle();

    startSoundFiles();
  }

  public void draw(boolean _quit)
  {
    quit = _quit;
    if (!quit)
    {
      scoreTouched=0;

      //draw interactive areas
      //check if they're touched
      for (int i =0; i<squares.length-1; i++)
      {
        squares[i].draw();
        if (squares[i].checkMouseOver() != 0)
        {
          //println(squares[i].checkMouseOver());
          //wheel
          scoreTouched+=squares[i].checkMouseOver();
        }
      }

      //SUN
      squares[15].draw();
      // check if sun is already playing
      sunIsPlaying = false;
      for (int i=0; i<numsounds_sun; i++)
      {
        if (sun[i].isPlaying())
        { 
          sunIsPlaying = true;
        }
      }
      for (int j=0; j<numsounds_birds; j++)
      {
        if (birds[j].isPlaying())
        {
          sunIsPlaying = true;
        }
      }


      if (squares[15].checkMouseOver()==16 && sunPressed == false)
      {
        sunPressed = true;
        playSunSound();
        println("Sun pressed");
      } else if (squares[15].checkMouseOver()== 0 && sunPressed == true) 
      {
        sunPressed = false;
      }


      //Check for movement by additioning every id. If Id change, they're is a movement
      if (lastScoreTouched != scoreTouched && scoreTouched>0)
      {
        //println("moved");
        fadeIn = true;
        lastMove = millis();
        moving = true;
        if (millis()>nextTimer) {
          lastUpdate = millis();
          nextTimer = millis()+fadein_timer;
        }
      }

      // if no change since a while, it's stopped
      if (millis()-lastMove>delta && moving == true)
      {
        //println("stopped");
        fadeIn = false;
        moving = false;
        if (millis()>nextTimer) {
          nextTimer = millis()+fadeout_timer;
          lastUpdate = millis();
        }
      }

      //println (scoreTouched);
      lastScoreTouched = scoreTouched;

      if (fadeIn)
      {
        objLoop1 = 100;
      } else {
        objLoop1 = 0;
      }
   
   
    
    if (nextTimer> millis())
    {
      updateVolLoop();
    }

    // On applique une interpolation à la valeur, pour que ce soit plus amorti en entrée et en sortie.
    mappedVol1 = map2(volLoop1, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
    loop1.amp(mappedVol1);
    loop2.amp(mappedVol1);
    }
    
    if (quit)
    {
      loop1.amp(0.0f);
      loop2.amp(0.0f);
    }
    
  }  



  public void updateVolLoop()
  {
    // difference entre objectif et valeur
    float diff = abs( volLoop1-objLoop1);
    //le temps qu'il reste avant la fin de la transition
    float timeToReachObj = nextTimer-millis();
    // de combien il faut bouger à chaque milliseconde
    float incrementByMs = diff/timeToReachObj;
    // combien de ms dure un cycle
    float deltaUpdate = millis()-lastUpdate;
    // de combien il faut bouger pour un cycle
    float update = incrementByMs*deltaUpdate;
    // on s'arrête lorsque l'on est proche de la cible à 0.1 près
    if ( diff>0.1f)
    {
      if (objLoop1>volLoop1)
      {
        volLoop1+=update;
        // on contraint pour être sûr de ne pas dépasser.
        if (volLoop1>100.0f)volLoop1=100.0f;
      } else if (objLoop1<volLoop1) {
        volLoop1-=update;
        if (volLoop1<0.0f)volLoop1=0.0f;
      }
    }
    lastUpdate = millis();
    //println(volLoop1);
  }


  public void startSoundFiles()
  {
    loop1.amp(0.0f);
    loop2.amp(0.0f);
    loop1.loop();
    loop2.loop();
  }

  public void playSunSound()
  {
    if (sunIsPlaying == false)
    {
      switch (indexSun)
      {
        //2nd hit on sun
      case 1:
        sun[0].play(1.0f, 1.0f);
        indexSun++;
        break;
        //4th hit on sun  
      case 3:
        sun[1].play(1.0f, 1.0f);
        indexSun++;
        break;
        //7th hit on sun  
      case 6:
        sun[2].play(1.0f, 1.0f);
        indexSun++;
        break;
      default:
        birds[birds_Order.get(indexBirds)].play(1.0f, 1.0f);
        indexBirds++;
        if (indexBirds == numsounds_birds)
        {
          birds_Order.shuffle();
          indexBirds = 0;
        }
        indexSun++;
        break;
      }
    }
  }


  public void quitPage()
  {
  }
}

class Page2 {
  Square[] squares= new Square [2];

  //LOOP
  SoundFile Ocean1;
  SoundFile Ocean2;
  SoundFile Kids;
  SoundFile Birds;

  // We store the volume in X and the objectif tpo reach in Y
  PVector volLoopOcean1 = new PVector (0.0f, 0.0f);
  PVector volLoopOcean2 =  new PVector (0.0f, 0.0f);
  PVector volLoopKids =  new PVector (0.0f, 0.0f);
  PVector volLoopBirds =  new PVector (0.0f, 0.0f);

  PVector timerOcean1 = new PVector (0.0f, 0.0f);
  PVector timerOcean2 = new PVector (0.0f, 0.0f);
  PVector timerKids = new PVector (0.0f, 0.0f);
  PVector timerBirds = new PVector (0.0f, 0.0f);

  boolean updatingOcean = false;
  boolean updatingOcean2 = false;
  boolean updatingKids = false;
  boolean updatingBirds = false;

  boolean windowOpened = false;
  boolean lastWindowState = false;
  boolean fadeIn, fadeOut;

  //EVENTS
  SoundFile[] Chien;
  SoundFile[] Train;
  IntList dog_Order;
  IntList train_Order;

  int indexChien =0;
  int indexTrain = 0;
  int nextChienTimer;
  int nextTrainTimer;

  boolean quit;

  Page2(PApplet p)
  { 
    //init
    //GUI
    //WindowLeft
    squares[0] = new Square (width/2-80, height/2-100, 70, 1);
    //Window Right
    squares[1] = new Square (width/2+10, height/2-100, 70, 2);

    // Load soundfiles
    //LOOP
    Ocean1 = new SoundFile(p, "P2/PLANCHE02_BoucleOcean.wav");
    Ocean2 = new SoundFile(p, "P2/PLANCHE02_BoucleOcean2.wav");
    Birds = new SoundFile(p, "P2/PLANCHE02_boucleoiseauxdemer.wav");
    Kids = new SoundFile(p, "P2/PLANCHE02_ambianceenfants.wav");

    //EVENTS
    Chien = new SoundFile[3];
    Chien[0] = new SoundFile(p, "P2/PLANCHE02_chien1.wav");
    Chien[1] = new SoundFile(p, "P2/PLANCHE02_chien2.wav");
    Chien[2] = new SoundFile(p, "P2/PLANCHE02_chien3.wav");
    Train = new SoundFile[2];
    Train[0] = new SoundFile(p, "P2/PLANCHE02_Train.wav");
    Train[1] = new SoundFile(p, "P2/PLANCHE02_Train2.wav");

    dog_Order = new IntList();
    for (int i=0; i<Chien.length; i++)
    {
      dog_Order.append(i);
    }
    dog_Order.shuffle();

    train_Order = new IntList();
    for (int i=0; i<Train.length; i++)
    {
      train_Order.append(i);
    }
    train_Order.shuffle();

    nextChienTimer = millis()+PApplet.parseInt(random(15000, 20000));
    nextTrainTimer = millis()+PApplet.parseInt(random(20000, 35000));

    startSoundFiles();
  }

  public void draw(boolean _quit)
  {
    quit = _quit;
    if (!quit)
    {
      //draw interactive areas
      int score = 0;
      for (int i =0; i<squares.length; i++)
      {
        squares[i].draw();

        if (squares[i].checkMouseOver() > 0)
        {
          score ++;
        }
      }

      if (score >0)
      {
        windowOpened = true;
      } else {
        windowOpened = false;
      }

      if (windowOpened)
      {
        if (lastWindowState == false)
        {
          //FadeIn
          println("Fade in");
          fadeIn = true;
          //objectif
          volLoopOcean1.y = 50;
          timerOcean1.x = millis();
          timerOcean1.y = millis()+2000;
          //
          //objectif
          volLoopOcean2.y = 70;
          timerOcean2.x = millis();
          timerOcean2.y = millis()+2000;
          //
          //objectif
          volLoopKids.y = 80;
          timerKids.x = millis();
          timerKids.y = millis()+2000;
          //
          //objectif
          volLoopBirds.y = 50;
          timerBirds.x = millis();
          timerBirds.y = millis()+2000;
          //
          nextChienTimer = millis()+PApplet.parseInt(random(15000, 20000));
          nextTrainTimer = millis()+PApplet.parseInt(random(20000, 35000));
          lastWindowState = windowOpened;
        } else
        {
          // Random variations along time
          if (updatingOcean == false && fadeIn == false && fadeOut == false)
          {
            //objectif
            volLoopOcean1.y = random(20, 65);
            timerOcean1.x = millis();
            timerOcean1.y = millis()+random(5000, 7000);
            updatingOcean = true;
          }

          if (updatingOcean2 == false && fadeIn == false && fadeOut == false)
          {
            //objectif
            volLoopOcean2.y = random(40, 80);
            timerOcean2.x = millis();
            timerOcean2.y = millis()+random(5000, 7000);
            updatingOcean2 = true;
          }

          if (updatingKids == false && fadeIn == false && fadeOut == false)
          {
            //objectif
            volLoopKids.y = random(75, 100);
            timerKids.x = millis();
            timerKids.y = millis()+random(5000, 7000);
            updatingKids = true;
          }

          if (updatingBirds == false && fadeIn == false && fadeOut == false)
          {
            //objectif
            volLoopBirds.y = random(20, 50);
            timerBirds.x = millis();
            timerBirds.y = millis()+random(5000, 7000);
            updatingBirds = true;
          }
        }
      } else if (windowOpened == false)
      {
        if (lastWindowState == true)
        {
          //FadeIn
          println("Fade out");
          fadeOut = true;
          //objectif
          volLoopOcean1.y = 0.0f;
          timerOcean1.x = millis();
          timerOcean1.y = millis()+2000;
          //objectif
          volLoopOcean2.y = 0.0f;
          timerOcean2.x = millis();
          timerOcean2.y = millis()+2000;
          //
          //objectif
          volLoopKids.y = 0.0f;
          timerKids.x = millis();
          timerKids.y = millis()+2000;
          //
          //objectif
          volLoopBirds.y = 0.0f;
          timerBirds.x = millis();
          timerBirds.y = millis()+2000;
          //
          lastWindowState = windowOpened;
        }
      }
      // For fading, as it's always the same timer, we just watch ocean1
      if (fadeIn && millis()>timerOcean1.y)fadeIn = false;
      if (fadeOut && millis()>timerOcean1.y)fadeOut = false;

      if (millis()>timerOcean1.y)updatingOcean=false;
      if (millis()>timerOcean2.y)updatingOcean2=false;
      if (millis()>timerKids.y)updatingKids=false;
      if (millis()>timerBirds.y)updatingBirds=false;

      updateVolLoop(volLoopOcean1, timerOcean1);
      updateVolLoop(volLoopOcean2, timerOcean2);
      updateVolLoop(volLoopKids, timerKids);
      updateVolLoop(volLoopBirds, timerBirds);

      float mappedVol1 = map2(volLoopOcean1.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      Ocean1.amp(mappedVol1);

      float mappedVol2 = map2(volLoopOcean2.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      Ocean2.amp(mappedVol2);

      float mappedVol3 = map2(volLoopKids.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      Kids.amp(mappedVol3);

      float mappedVol4 = map2(volLoopBirds.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      Birds.amp(mappedVol4);

      //println("Volumes LOOP", volLoopOcean1.x, volLoopOcean2.x, volLoopKids.x, volLoopBirds.x);

      if (windowOpened == true)
      {
        // RandomEvents
        if (millis()>nextChienTimer) {
          nextChienTimer = millis()+ PApplet.parseInt(random(2000, 25000));
          Chien[dog_Order.get(indexChien)].play();
          println("Play Chien ", dog_Order.get(indexChien));
          indexChien++;
          if (indexChien == Chien.length)dog_Order.shuffle();
          indexChien %= Chien.length;
        }

        if (millis()>nextTrainTimer) {
          nextTrainTimer = millis()+ PApplet.parseInt(random(40000, 60000));
          Train[train_Order.get(indexTrain)].play();
          println("Play Train ", train_Order.get(indexTrain));
          indexTrain++;
          if (indexTrain == Train.length)train_Order.shuffle();
          indexTrain %= Train.length;
        }
      }
    }
    
    if (quit)
    {
      Ocean1.amp(0.0f);
      Ocean2.amp(0.0f);
      Kids.amp(0.0f);
      Birds.amp(0.0f);
      
    }
  }  


  public void updateVolLoop(PVector volLoopFile, PVector timer)
  {

    float volLoop = volLoopFile.x;
    float objLoop = volLoopFile.y;

    float lastUpdate = timer.x;
    float nextTimer = timer.y;

    if (millis()<nextTimer) {

      // difference entre objectif et valeur
      float diff = abs( volLoop-objLoop);
      //le temps qu'il reste avant la fin de la transition
      float timeToReachObj = nextTimer-millis();
      // de combien il faut bouger à chaque milliseconde
      float incrementByMs = diff/timeToReachObj;
      // combien de ms dure un cycle
      float deltaUpdate = millis()-lastUpdate;
      // de combien il faut bouger pour un cycle
      float update = incrementByMs*deltaUpdate;
      // on s'arrête lorsque l'on est proche de la cible à 0.1 près
      if ( diff>0.1f)
      {
        if (objLoop>volLoop)
        {
          volLoop+=update;
          // on contraint pour être sûr de ne pas dépasser.
          if (volLoop>100.0f)volLoop=100.0f;
        } else if (objLoop<volLoop) {
          volLoop-=update;
          if (volLoop<0.0f)volLoop=0.0f;
        }
      }
    }
    timer.x = millis();
    volLoopFile.x = volLoop;
    //println(volLoopFile.x, volLoopFile.y, timer.x, timer.y);
  }



  public void startSoundFiles()
  {
    //Background
    Ocean1.amp(0.0f);
    Ocean2.amp(0.0f);
    Kids.amp(0.0f);
    Birds.amp(0.0f);
    Ocean1.loop();
    Ocean2.loop();
    Kids.loop();
    Birds.loop();
  }
}

class Page3 {
  Square[] squares= new Square [2];

  SoundFile[] sonsCourt;
  SoundFile[] sonsLongs;
  int numsounds_courts = 12;
  int numsounds_longs = 12;

  SoundFile song;
  boolean songStarted = false;
  //
  int nberJumps=0;

  boolean pressed = false;
  boolean lastPressed = false;
  int panning = 0;

  PVector volLoopSong = new PVector (0.0f, 0.0f);
  PVector timerSong = new PVector (0.0f, 0.0f);

  int delta = 2000;
  boolean halfway = false;

  boolean quit = false;

  Page3(PApplet p)
  { 
    //init
    //Carpet Top Left
    squares[0] = new Square (width/2-150, height/2-80, 140, 1);
    //Carpet Top Right
    squares[1] = new Square (width/2+10, height/2-80, 140, 2);

    //COURTS
    // Create an array of soundfiles
    sonsCourt = new SoundFile[numsounds_courts];
    sonsCourt[0] = new SoundFile(p, "P3/COURT/CLAVEMONO-01.wav");
    sonsCourt[1] = new SoundFile(p, "P3/COURT/CLOCHE1MONO-01.wav");
    sonsCourt[2] = new SoundFile(p, "P3/COURT/CLOCHE2MONO.wav");
    sonsCourt[3] = new SoundFile(p, "P3/COURT/CONGASMONO-01.wav");
    sonsCourt[4] = new SoundFile(p, "P3/COURT/CRESSELLEMONO-01.wav");
    sonsCourt[5] = new SoundFile(p, "P3/COURT/GUITARE.wav");
    sonsCourt[6] = new SoundFile(p, "P3/COURT/SIFFLET.wav");
    sonsCourt[7] = new SoundFile(p, "P3/COURT/SNAP.wav");
    sonsCourt[8] = new SoundFile(p, "P3/COURT/STOMP.wav");
    sonsCourt[9] = new SoundFile(p, "P3/COURT/TAMBOURINMONO-01.wav");
    sonsCourt[10] = new SoundFile(p, "P3/COURT/TRIANGLEMONO-01.wav");
    sonsCourt[11] = new SoundFile(p, "P3/COURT/TRIANGLEMONO2.wav");

    //LONGS
    // Create an array of soundfiles
    sonsLongs = new SoundFile[numsounds_courts];
    sonsLongs[0] = new SoundFile(p, "P3/LONG/BASSE1MONO-01.wav");
    sonsLongs[1] = new SoundFile(p, "P3/LONG/BASSE2MONO.wav");
    sonsLongs[2] = new SoundFile(p, "P3/LONG/CLAVE2MONO-01.wav");
    sonsLongs[3] = new SoundFile(p, "P3/LONG/CLAVIER.wav");
    sonsLongs[4] = new SoundFile(p, "P3/LONG/CLAVIERPERCU.wav");
    sonsLongs[5] = new SoundFile(p, "P3/LONG/GUITARE2.wav");
    sonsLongs[6] = new SoundFile(p, "P3/LONG/PATTERN1.wav");
    sonsLongs[7] = new SoundFile(p, "P3/LONG/PATTERN1B.wav");
    sonsLongs[8] = new SoundFile(p, "P3/LONG/PATTERNC.wav");
    sonsLongs[9] = new SoundFile(p, "P3/LONG/PATTERND.wav");
    sonsLongs[10] = new SoundFile(p, "P3/LONG/SIFFLETPERCU.wav");
    sonsLongs[11] = new SoundFile(p, "P3/LONG/PATTERNE.wav");

    song = new SoundFile(p, "P3/KAPI.wav");
  }

  public void draw(boolean _quit)
  {
    quit = _quit;
    if (!quit)
    {
      //draw interactive areas
      int score = 0;
      for (int i =0; i<squares.length; i++)
      {
        squares[i].draw();
        if (squares[i].checkMouseOver() != 0)
        {
          //println(squares[i].checkMouseOver());
          score = squares[i].checkMouseOver();
        }
      }

      if (score >0)
      {
        pressed = true;
        if (score == 1) panning = -1;
        else if (score == 2) panning = 1;
      } else {
        pressed = false;
        if (lastPressed == true)lastPressed = false;
      }

      if (pressed == true && lastPressed == false)
      {
        print ("Jump!"+nberJumps+" ");
        print ("panning "+panning+" ");
        nberJumps ++;
        halfway = false;
        //COURTS
        if (nberJumps<11)
        {
          int randomSound = PApplet.parseInt(random(0, numsounds_courts));
          sonsCourt[randomSound].pan(panning);
          sonsCourt[randomSound].play();
          print ("played short "+randomSound+" ");
        }
        //LONGS
        else if (nberJumps>10 && nberJumps<20)
        {
          int randomSound = PApplet.parseInt(random(0, numsounds_longs));
          sonsLongs[randomSound].pan(panning);
          sonsLongs[randomSound].play();
          print ("played long "+randomSound+" ");
        } else
        {
          //SONG
          if (songStarted == false)
          {
            startSong();
            songStarted = true;
          }
          volLoopSong.y = 100;
          timerSong.x = millis();
          timerSong.y = millis()+3000;
        }

        song.pan(panning);
        lastPressed = true;
        println();
      }
    }
    if (songStarted == true)
    {
      updateVolLoop(volLoopSong, timerSong);
      float mappedVol1 = map2(volLoopSong.x, 0, 100, 0.0f, 1.0f, QUADRATIC, EASE_IN_OUT);
      song.amp(mappedVol1);
      //halfway = false;

      //Nothing since delta
      if (millis()-timerSong.y>(delta*2) && halfway == true || quit)
      {
        volLoopSong.y = 0.0f;
        timerSong.x = millis();
        timerSong.y = millis()+2000;
      } else if (millis()-timerSong.y>delta && halfway==false)
      {
        volLoopSong.y = 50;
        timerSong.x = millis();
        timerSong.y = millis()+2000;
        halfway = true;
      }
    }
    //println(millis(), timerSong.y, millis()-timerSong.y, volLoopSong.x);
    
    
    
  } 

  public void updateVolLoop(PVector volLoopFile, PVector timer)
  {

    float volLoop = volLoopFile.x;
    float objLoop = volLoopFile.y;

    float lastUpdate = timer.x;
    float nextTimer = timer.y;

    if (millis()<nextTimer) {

      // difference entre objectif et valeur
      float diff = abs( volLoop-objLoop);
      //le temps qu'il reste avant la fin de la transition
      float timeToReachObj = nextTimer-millis();
      // de combien il faut bouger à chaque milliseconde
      float incrementByMs = diff/timeToReachObj;
      // combien de ms dure un cycle
      float deltaUpdate = millis()-lastUpdate;
      // de combien il faut bouger pour un cycle
      float update = incrementByMs*deltaUpdate;
      // on s'arrête lorsque l'on est proche de la cible à 0.1 près
      if ( diff>0.1f)
      {
        if (objLoop>volLoop)
        {
          volLoop+=update;
          // on contraint pour être sûr de ne pas dépasser.
          if (volLoop>100.0f)volLoop=100.0f;
        } else if (objLoop<volLoop) {
          volLoop-=update;
          if (volLoop<0.0f)volLoop=0.0f;
        }
      }
    }
    timer.x = millis();
    volLoopFile.x = volLoop;
    //println(volLoopFile.x, volLoopFile.y, timer.x, timer.y);
  }

  public void startSong() 
  {
    song.amp(0.10f);
    song.pan(0);
    song.play();
  }

}

class Page4 {
  Square[] squares= new Square [3];

  SoundFile[] splotchs;
  SoundFile[] frog;
  int numsounds_splotchs = 9;
  int numsounds_frog = 3;

  IntList splotchs_Order;
  IntList frog_Order;

  int indexSplotchs =0;
  int indexFrog = 0;

  boolean isPressed = false;
  boolean lastPressed = false;


  Page4(PApplet p)
  { 
    //init
    //Bottom Puddle
    squares[0] = new Square (width/2-150, height/2+50, 150, 1);
    //Middle Puddle
    squares[1] = new Square (width/2-50, height/2-100, 75, 2);
    //Top Puddle
    squares[2] = new Square (width/2+20, height/2-200, 35, 3);


    //EVENTS
    splotchs = new SoundFile[numsounds_splotchs];
    splotchs[0] = new SoundFile(p, "P4/PLANCEH04_Boue3.wav");
    splotchs[1] = new SoundFile(p, "P4/PLANCHE04_boue1.wav");
    splotchs[2] = new SoundFile(p, "P4/PLANCHE04_boue5.wav");
    splotchs[3] = new SoundFile(p, "P4/PLANCHE04_boue7.wav");
    splotchs[4] = new SoundFile(p, "P4/PLANCHE04_boue8.wav");
    splotchs[5] = new SoundFile(p, "P4/PLANCHE04_boue9.wav");
    splotchs[6] = new SoundFile(p, "P4/PLANCHE04_Boue2.wav");
    splotchs[7] = new SoundFile(p, "P4/PLANCHE04_Boue4.wav");
    splotchs[8] = new SoundFile(p, "P4/PLANCHE04_boue10.wav");

    frog = new SoundFile[numsounds_frog];
    frog[0] = new SoundFile(p, "P4/PLANCHE04_grenouille1.wav");
    frog[1] = new SoundFile(p, "P4/PLANCHE04_grenouille2.wav");
    frog[2] = new SoundFile(p, "P4/PLANCHE04_grenouille plonge.wav");

    splotchs_Order = new IntList();
    for (int i=0; i<splotchs.length; i++)
    {
      splotchs_Order.append(i);
    }
    splotchs_Order.shuffle();

    frog_Order = new IntList();
    for (int i=0; i<frog.length; i++)
    {
      frog_Order.append(i);
    }
    frog_Order.shuffle();
  }

  public void draw()
  {
    int score = 0;
    //draw interactive areas
    for (int i =0; i<squares.length; i++)
    {
      squares[i].draw();
      if (squares[i].checkMouseOver() != 0)
      {
        score ++;
        //println(squares[i].checkMouseOver());
      }
    }

    if (score>0)
    {
      isPressed = true;
    } else {
      isPressed = false;
      if (lastPressed == true)lastPressed = false;
    }
    
    if (isPressed == true && lastPressed == false)
    {
      //Splotch
      indexSplotchs ++;
      if (indexSplotchs == numsounds_splotchs)
      {
       indexSplotchs = 0;
       splotchs_Order.shuffle();
       frog[frog_Order.get(indexFrog)].play();
       println("Frog n° "+frog_Order.get(indexFrog));
       indexFrog++;
       
       if (indexFrog == numsounds_frog)
       {
         indexFrog = 0;
         frog_Order.shuffle();
         
       }
       
      }
      splotchs[splotchs_Order.get(indexSplotchs)].play();
      lastPressed = true;
      println("Splotch n° "+splotchs_Order.get(indexSplotchs));
      
      
      
    }
  }
}





class Page5 {
  Square[] squares= new Square [3];
  
  Page5()
  { 
    //init
    //Under the sea
    squares[0] = new Square (width/2-100, height/2+100, 200, 1);
    //Island
    squares[1] = new Square (width/2-70, height/2-90, 140, 2);
    //Mountain
    squares[2] = new Square (width/2-30, height/2-200, 60, 3);
  }
  
  public void draw()
  {
    //draw interactive areas
    for (int i =0; i<squares.length; i++)
    {
      squares[i].draw();
      if (squares[i].checkMouseOver() != 0)
      {
        println(squares[i].checkMouseOver());
      }
    }
  }  
  
}
class Page6 {
  
  int rows =7;
  int cols =6;
  int square_Width = width/8;
  int offset = width/8;
  Square[][] squares= new Square [cols][rows];
  
  Page6()
  { 
    //init
    //create squares
    for (int i =0; i<cols; i++)
    {
      for (int j=0; j<rows; j++)
      {
        squares[i][j] = new Square( offset + i*square_Width, offset/2 + j*square_Width , square_Width, 1+(i+j*cols));
      }
    }
  }  

  
  public void draw()
  {
    //draw interactive areas
    for (int i = 0; i < cols; i++) {
      for (int j = 0; j < rows; j++) {

      squares[i][j].draw();
      if (squares[i][j].checkMouseOver() != 0)
      {
        println(squares[i][j].checkMouseOver());
      }
      
    }
    
    }
  }
  
}
class Square
{
  // interactive square, bonded to mouse & OSC events
  float square_x, square_y, square_width;
  boolean mouseOver;
  int id;
  
  Square(float _x, float _y, float _width, int _id)
  {
    square_x = _x;
    square_y = _y;
    square_width = _width;
    id = _id;
  }
  
  
  public void draw()
  {
    if (mouseOver)
    {
      fill(125);
    } else {
      fill(220);
    }
    stroke(255);
    strokeWeight(1);
    rect(square_x, square_y, square_width, square_width);
  }
  
  public int checkMouseOver()
  {
    if (mouseX > square_x && mouseX < square_x+square_width && mouseY>square_y && mouseY<square_y+square_width)
    {
      mouseOver = true;
      return id;
    }else{
      mouseOver = false;
      return 0;
    }
  }

}
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  public void settings() {  size(800,800); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--present", "--window-color=#4D4B4B", "--stop-color=#cccccc", "LDQR_Monitoring" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
