class Page2 {
  Square[] squares= new Square [2];

  //LOOP
  SoundFile Ocean1;
  SoundFile Ocean2;
  SoundFile Kids;
  SoundFile Birds;

  // We store the volume in X and the objectif tpo reach in Y
  PVector volLoopOcean1 = new PVector (0.0, 0.0);
  PVector volLoopOcean2 =  new PVector (0.0, 0.0);
  PVector volLoopKids =  new PVector (0.0, 0.0);
  PVector volLoopBirds =  new PVector (0.0, 0.0);

  PVector timerOcean1 = new PVector (0.0, 0.0);
  PVector timerOcean2 = new PVector (0.0, 0.0);
  PVector timerKids = new PVector (0.0, 0.0);
  PVector timerBirds = new PVector (0.0, 0.0);

  boolean updatingOcean = false;
  boolean updatingOcean2 = false;
  boolean updatingKids = false;
  boolean updatingBirds = false;

  boolean windowOpened = false;
  boolean lastWindowState = false;
  boolean fadeIn, fadeOut;

  //EVENTS
  SoundFile[] Chien;
  SoundFile[] Train;
  IntList dog_Order;
  IntList train_Order;

  int indexChien =0;
  int indexTrain = 0;
  int nextChienTimer;
  int nextTrainTimer;

  boolean quit;

  Page2(PApplet p)
  { 
    //init
    //GUI
    //WindowLeft
    squares[0] = new Square (width/2-80, height/2-100, 70, 1);
    //Window Right
    squares[1] = new Square (width/2+10, height/2-100, 70, 2);

    // Load soundfiles
    //LOOP
    Ocean1 = new SoundFile(p, "P2/PLANCHE02_BoucleOcean.wav");
    Ocean2 = new SoundFile(p, "P2/PLANCHE02_BoucleOcean2.wav");
    Birds = new SoundFile(p, "P2/PLANCHE02_boucleoiseauxdemer.wav");
    Kids = new SoundFile(p, "P2/PLANCHE02_ambianceenfants.wav");

    //EVENTS
    Chien = new SoundFile[3];
    Chien[0] = new SoundFile(p, "P2/PLANCHE02_chien1.wav");
    Chien[1] = new SoundFile(p, "P2/PLANCHE02_chien2.wav");
    Chien[2] = new SoundFile(p, "P2/PLANCHE02_chien3.wav");
    Train = new SoundFile[2];
    Train[0] = new SoundFile(p, "P2/PLANCHE02_Train.wav");
    Train[1] = new SoundFile(p, "P2/PLANCHE02_Train2.wav");

    dog_Order = new IntList();
    for (int i=0; i<Chien.length; i++)
    {
      dog_Order.append(i);
    }
    dog_Order.shuffle();

    train_Order = new IntList();
    for (int i=0; i<Train.length; i++)
    {
      train_Order.append(i);
    }
    train_Order.shuffle();

    nextChienTimer = millis()+int(random(15000, 20000));
    nextTrainTimer = millis()+int(random(20000, 35000));

    startSoundFiles();
  }

  void draw(boolean _quit)
  {
    quit = _quit;
    if (!quit)
    {
      //draw interactive areas
      int score = 0;
      for (int i =0; i<squares.length; i++)
      {
        squares[i].draw();

        if (squares[i].checkMouseOver() > 0)
        {
          score ++;
        }
      }

      if (score >0)
      {
        windowOpened = true;
      } else {
        windowOpened = false;
      }

      if (windowOpened)
      {
        if (lastWindowState == false)
        {
          //FadeIn
          println("Fade in");
          fadeIn = true;
          //objectif
          volLoopOcean1.y = 50;
          timerOcean1.x = millis();
          timerOcean1.y = millis()+2000;
          //
          //objectif
          volLoopOcean2.y = 70;
          timerOcean2.x = millis();
          timerOcean2.y = millis()+2000;
          //
          //objectif
          volLoopKids.y = 80;
          timerKids.x = millis();
          timerKids.y = millis()+2000;
          //
          //objectif
          volLoopBirds.y = 50;
          timerBirds.x = millis();
          timerBirds.y = millis()+2000;
          //
          nextChienTimer = millis()+int(random(15000, 20000));
          nextTrainTimer = millis()+int(random(20000, 35000));
          lastWindowState = windowOpened;
        } else
        {
          // Random variations along time
          if (updatingOcean == false && fadeIn == false && fadeOut == false)
          {
            //objectif
            volLoopOcean1.y = random(20, 65);
            timerOcean1.x = millis();
            timerOcean1.y = millis()+random(5000, 7000);
            updatingOcean = true;
          }

          if (updatingOcean2 == false && fadeIn == false && fadeOut == false)
          {
            //objectif
            volLoopOcean2.y = random(40, 80);
            timerOcean2.x = millis();
            timerOcean2.y = millis()+random(5000, 7000);
            updatingOcean2 = true;
          }

          if (updatingKids == false && fadeIn == false && fadeOut == false)
          {
            //objectif
            volLoopKids.y = random(75, 100);
            timerKids.x = millis();
            timerKids.y = millis()+random(5000, 7000);
            updatingKids = true;
          }

          if (updatingBirds == false && fadeIn == false && fadeOut == false)
          {
            //objectif
            volLoopBirds.y = random(20, 50);
            timerBirds.x = millis();
            timerBirds.y = millis()+random(5000, 7000);
            updatingBirds = true;
          }
        }
      } else if (windowOpened == false)
      {
        if (lastWindowState == true)
        {
          //FadeIn
          println("Fade out");
          fadeOut = true;
          //objectif
          volLoopOcean1.y = 0.0;
          timerOcean1.x = millis();
          timerOcean1.y = millis()+2000;
          //objectif
          volLoopOcean2.y = 0.0;
          timerOcean2.x = millis();
          timerOcean2.y = millis()+2000;
          //
          //objectif
          volLoopKids.y = 0.0;
          timerKids.x = millis();
          timerKids.y = millis()+2000;
          //
          //objectif
          volLoopBirds.y = 0.0;
          timerBirds.x = millis();
          timerBirds.y = millis()+2000;
          //
          lastWindowState = windowOpened;
        }
      }
      // For fading, as it's always the same timer, we just watch ocean1
      if (fadeIn && millis()>timerOcean1.y)fadeIn = false;
      if (fadeOut && millis()>timerOcean1.y)fadeOut = false;

      if (millis()>timerOcean1.y)updatingOcean=false;
      if (millis()>timerOcean2.y)updatingOcean2=false;
      if (millis()>timerKids.y)updatingKids=false;
      if (millis()>timerBirds.y)updatingBirds=false;

      updateVolLoop(volLoopOcean1, timerOcean1);
      updateVolLoop(volLoopOcean2, timerOcean2);
      updateVolLoop(volLoopKids, timerKids);
      updateVolLoop(volLoopBirds, timerBirds);

      float mappedVol1 = map2(volLoopOcean1.x, 0, 100, 0.0, 1.0, QUADRATIC, EASE_IN_OUT);
      Ocean1.amp(mappedVol1);

      float mappedVol2 = map2(volLoopOcean2.x, 0, 100, 0.0, 1.0, QUADRATIC, EASE_IN_OUT);
      Ocean2.amp(mappedVol2);

      float mappedVol3 = map2(volLoopKids.x, 0, 100, 0.0, 1.0, QUADRATIC, EASE_IN_OUT);
      Kids.amp(mappedVol3);

      float mappedVol4 = map2(volLoopBirds.x, 0, 100, 0.0, 1.0, QUADRATIC, EASE_IN_OUT);
      Birds.amp(mappedVol4);

      //println("Volumes LOOP", volLoopOcean1.x, volLoopOcean2.x, volLoopKids.x, volLoopBirds.x);

      if (windowOpened == true)
      {
        // RandomEvents
        if (millis()>nextChienTimer) {
          nextChienTimer = millis()+ int(random(2000, 25000));
          Chien[dog_Order.get(indexChien)].play();
          println("Play Chien ", dog_Order.get(indexChien));
          indexChien++;
          if (indexChien == Chien.length)dog_Order.shuffle();
          indexChien %= Chien.length;
        }

        if (millis()>nextTrainTimer) {
          nextTrainTimer = millis()+ int(random(40000, 60000));
          Train[train_Order.get(indexTrain)].play();
          println("Play Train ", train_Order.get(indexTrain));
          indexTrain++;
          if (indexTrain == Train.length)train_Order.shuffle();
          indexTrain %= Train.length;
        }
      }
    }
    
    if (quit)
    {
      Ocean1.amp(0.0);
      Ocean2.amp(0.0);
      Kids.amp(0.0);
      Birds.amp(0.0);
      
    }
  }  


  void updateVolLoop(PVector volLoopFile, PVector timer)
  {

    float volLoop = volLoopFile.x;
    float objLoop = volLoopFile.y;

    float lastUpdate = timer.x;
    float nextTimer = timer.y;

    if (millis()<nextTimer) {

      // difference entre objectif et valeur
      float diff = abs( volLoop-objLoop);
      //le temps qu'il reste avant la fin de la transition
      float timeToReachObj = nextTimer-millis();
      // de combien il faut bouger à chaque milliseconde
      float incrementByMs = diff/timeToReachObj;
      // combien de ms dure un cycle
      float deltaUpdate = millis()-lastUpdate;
      // de combien il faut bouger pour un cycle
      float update = incrementByMs*deltaUpdate;
      // on s'arrête lorsque l'on est proche de la cible à 0.1 près
      if ( diff>0.1)
      {
        if (objLoop>volLoop)
        {
          volLoop+=update;
          // on contraint pour être sûr de ne pas dépasser.
          if (volLoop>100.0)volLoop=100.0;
        } else if (objLoop<volLoop) {
          volLoop-=update;
          if (volLoop<0.0)volLoop=0.0;
        }
      }
    }
    timer.x = millis();
    volLoopFile.x = volLoop;
    //println(volLoopFile.x, volLoopFile.y, timer.x, timer.y);
  }



  void startSoundFiles()
  {
    //Background
    Ocean1.amp(0.0);
    Ocean2.amp(0.0);
    Kids.amp(0.0);
    Birds.amp(0.0);
    Ocean1.loop();
    Ocean2.loop();
    Kids.loop();
    Birds.loop();
  }
}
