class Page3 {
  Square[] squares= new Square [2];

  SoundFile[] sonsCourt;
  SoundFile[] sonsLongs;
  int numsounds_courts = 12;
  int numsounds_longs = 12;

  SoundFile song;
  boolean songStarted = false;
  //
  int nberJumps=0;

  boolean pressed = false;
  boolean lastPressed = false;
  int panning = 0;

  PVector volLoopSong = new PVector (0.0, 0.0);
  PVector timerSong = new PVector (0.0, 0.0);

  int delta = 2000;
  boolean halfway = false;

  boolean quit = false;

  Page3(PApplet p)
  { 
    //init
    //Carpet Top Left
    squares[0] = new Square (width/2-150, height/2-80, 140, 1);
    //Carpet Top Right
    squares[1] = new Square (width/2+10, height/2-80, 140, 2);

    //COURTS
    // Create an array of soundfiles
    sonsCourt = new SoundFile[numsounds_courts];
    sonsCourt[0] = new SoundFile(p, "P3/COURT/CLAVEMONO-01.wav");
    sonsCourt[1] = new SoundFile(p, "P3/COURT/CLOCHE1MONO-01.wav");
    sonsCourt[2] = new SoundFile(p, "P3/COURT/CLOCHE2MONO.wav");
    sonsCourt[3] = new SoundFile(p, "P3/COURT/CONGASMONO-01.wav");
    sonsCourt[4] = new SoundFile(p, "P3/COURT/CRESSELLEMONO-01.wav");
    sonsCourt[5] = new SoundFile(p, "P3/COURT/GUITARE.wav");
    sonsCourt[6] = new SoundFile(p, "P3/COURT/SIFFLET.wav");
    sonsCourt[7] = new SoundFile(p, "P3/COURT/SNAP.wav");
    sonsCourt[8] = new SoundFile(p, "P3/COURT/STOMP.wav");
    sonsCourt[9] = new SoundFile(p, "P3/COURT/TAMBOURINMONO-01.wav");
    sonsCourt[10] = new SoundFile(p, "P3/COURT/TRIANGLEMONO-01.wav");
    sonsCourt[11] = new SoundFile(p, "P3/COURT/TRIANGLEMONO2.wav");

    //LONGS
    // Create an array of soundfiles
    sonsLongs = new SoundFile[numsounds_courts];
    sonsLongs[0] = new SoundFile(p, "P3/LONG/BASSE1MONO-01.wav");
    sonsLongs[1] = new SoundFile(p, "P3/LONG/BASSE2MONO.wav");
    sonsLongs[2] = new SoundFile(p, "P3/LONG/CLAVE2MONO-01.wav");
    sonsLongs[3] = new SoundFile(p, "P3/LONG/CLAVIER.wav");
    sonsLongs[4] = new SoundFile(p, "P3/LONG/CLAVIERPERCU.wav");
    sonsLongs[5] = new SoundFile(p, "P3/LONG/GUITARE2.wav");
    sonsLongs[6] = new SoundFile(p, "P3/LONG/PATTERN1.wav");
    sonsLongs[7] = new SoundFile(p, "P3/LONG/PATTERN1B.wav");
    sonsLongs[8] = new SoundFile(p, "P3/LONG/PATTERNC.wav");
    sonsLongs[9] = new SoundFile(p, "P3/LONG/PATTERND.wav");
    sonsLongs[10] = new SoundFile(p, "P3/LONG/SIFFLETPERCU.wav");
    sonsLongs[11] = new SoundFile(p, "P3/LONG/PATTERNE.wav");

    song = new SoundFile(p, "P3/KAPI.wav");
  }

  void draw(boolean _quit)
  {
    quit = _quit;
    if (!quit)
    {
      //draw interactive areas
      int score = 0;
      for (int i =0; i<squares.length; i++)
      {
        squares[i].draw();
        if (squares[i].checkMouseOver() != 0)
        {
          //println(squares[i].checkMouseOver());
          score = squares[i].checkMouseOver();
        }
      }

      if (score >0)
      {
        pressed = true;
        if (score == 1) panning = -1;
        else if (score == 2) panning = 1;
      } else {
        pressed = false;
        if (lastPressed == true)lastPressed = false;
      }

      if (pressed == true && lastPressed == false)
      {
        print ("Jump!"+nberJumps+" ");
        print ("panning "+panning+" ");
        nberJumps ++;
        halfway = false;
        //COURTS
        if (nberJumps<11)
        {
          int randomSound = int(random(0, numsounds_courts));
          sonsCourt[randomSound].pan(panning);
          sonsCourt[randomSound].play();
          print ("played short "+randomSound+" ");
        }
        //LONGS
        else if (nberJumps>10 && nberJumps<20)
        {
          int randomSound = int(random(0, numsounds_longs));
          sonsLongs[randomSound].pan(panning);
          sonsLongs[randomSound].play();
          print ("played long "+randomSound+" ");
        } else
        {
          //SONG
          if (songStarted == false)
          {
            startSong();
            songStarted = true;
          }
          volLoopSong.y = 100;
          timerSong.x = millis();
          timerSong.y = millis()+3000;
        }

        song.pan(panning);
        lastPressed = true;
        println();
      }
    }
    if (songStarted == true)
    {
      updateVolLoop(volLoopSong, timerSong);
      float mappedVol1 = map2(volLoopSong.x, 0, 100, 0.0, 1.0, QUADRATIC, EASE_IN_OUT);
      song.amp(mappedVol1);
      //halfway = false;

      //Nothing since delta
      if (millis()-timerSong.y>(delta*2) && halfway == true || quit)
      {
        volLoopSong.y = 0.0;
        timerSong.x = millis();
        timerSong.y = millis()+2000;
      } else if (millis()-timerSong.y>delta && halfway==false)
      {
        volLoopSong.y = 50;
        timerSong.x = millis();
        timerSong.y = millis()+2000;
        halfway = true;
      }
    }
    //println(millis(), timerSong.y, millis()-timerSong.y, volLoopSong.x);
    
    
    
  } 

  void updateVolLoop(PVector volLoopFile, PVector timer)
  {

    float volLoop = volLoopFile.x;
    float objLoop = volLoopFile.y;

    float lastUpdate = timer.x;
    float nextTimer = timer.y;

    if (millis()<nextTimer) {

      // difference entre objectif et valeur
      float diff = abs( volLoop-objLoop);
      //le temps qu'il reste avant la fin de la transition
      float timeToReachObj = nextTimer-millis();
      // de combien il faut bouger à chaque milliseconde
      float incrementByMs = diff/timeToReachObj;
      // combien de ms dure un cycle
      float deltaUpdate = millis()-lastUpdate;
      // de combien il faut bouger pour un cycle
      float update = incrementByMs*deltaUpdate;
      // on s'arrête lorsque l'on est proche de la cible à 0.1 près
      if ( diff>0.1)
      {
        if (objLoop>volLoop)
        {
          volLoop+=update;
          // on contraint pour être sûr de ne pas dépasser.
          if (volLoop>100.0)volLoop=100.0;
        } else if (objLoop<volLoop) {
          volLoop-=update;
          if (volLoop<0.0)volLoop=0.0;
        }
      }
    }
    timer.x = millis();
    volLoopFile.x = volLoop;
    //println(volLoopFile.x, volLoopFile.y, timer.x, timer.y);
  }

  void startSong() 
  {
    song.amp(0.10);
    song.pan(0);
    song.play();
  }

}
