class Page6 {

  int rows =7;
  int cols =6;
  int square_Width = width/8;
  int offset = width/8;
  Square[][] squares= new Square [cols][rows];


  SoundFile[] events;
  SoundFile start;
  SoundFile stop;
  SoundFile loop;

  float nextTimer = 0;
  float lastUpdate = 0;

  int scoreTouched;
  int lastScoreTouched;
  int lastMove = 0;

  //timers
  int delta = 2000;
  int deltaEvent = 3000;
  int lastEvent = 0;
  int indexEvent = 0;
  boolean moving;
  boolean lastStateMoving;

  Page6(PApplet p)
  { 
    //init
    //create squares
    for (int i =0; i<cols; i++)
    {
      for (int j=0; j<rows; j++)
      {
        squares[i][j] = new Square( offset + i*square_Width, offset/2 + j*square_Width, square_Width, 1+(i+j*cols));
      }
    }



    //Sounds
    start = new SoundFile(p, "P6/PLANCHE06Bateaudemarre.wav");
    stop = new SoundFile(p, "P6/PLANCHE06Bateauarret.wav");
    loop = new SoundFile(p, "P6/PLANCHE06BOUCLEBateauavance.wav");

    events = new SoundFile[10];
    events[0] = new SoundFile (p, "P6/PLANCHE06avion.wav");
    events[1] = new SoundFile (p, "P6/PLANCHE06Baleines.wav");
    events[2] = new SoundFile (p, "P6/PLANCHE06Cormorants.wav");
    events[3] = new SoundFile (p, "P6/PLANCHE06Dauphins.wav");
    events[4] = new SoundFile (p, "P6/PLANCHE06Fousdebassan.wav");
    events[5] = new SoundFile (p, "P6/PLANCHE06Grossevague.wav");
    events[6] = new SoundFile (p, "P6/PLANCHE06Paquebot.wav");
    events[7] = new SoundFile (p, "P6/PLANCHE06Ploufaboiement.wav");
    events[8] = new SoundFile (p, "P6/PLANCHE06ploufgrognement.wav");
    events[9] = new SoundFile (p, "P6/MARINS.wav");
  }  


  void draw()
  {

    scoreTouched=0;

    //draw interactive areas
    for (int i = 0; i < cols; i++) {
      for (int j = 0; j < rows; j++) {

        squares[i][j].draw();
        if (squares[i][j].checkMouseOver() != 0)
        {
          scoreTouched+=squares[i][j].checkMouseOver();
        }
      }
    }
    
     //Check for movement by additioning every id. If Id change, they're is a movement
      if (lastScoreTouched != scoreTouched && scoreTouched>0)
      {
        //println("moved");
        lastMove = millis();
        moving = true;
      }

      // if no change since a while, it's stopped
      if (millis()-lastMove>delta && moving == true)
      {
        //println("stopped");
        moving = false;

      }
     

    playBoat(); 
    
   if (moving && millis() - lastEvent > deltaEvent)
   {
     if ( events[indexEvent].isPlaying() == false)
     {
       events[indexEvent].play();
       deltaEvent = int(random(10000, 15000));
       indexEvent++;
       indexEvent %= events.length;
       lastEvent = millis();
     }
     
   }
      
    
    lastScoreTouched = scoreTouched;
  }
  
  void playBoat()
  {
    if (lastStateMoving == false && moving == true) // The boat was stopped, play "start"
    {
      println("START");
      if (start.isPlaying() == false)
      {
         start.play(); 
      }
      if (stop.isPlaying() == true)
      {
        stop.stop();
      }
      lastStateMoving = true;
    } else if (lastStateMoving == true && moving == true){ // the boat is moving
     println("LOOP");
      if (start.isPlaying() == false && loop.isPlaying()==false)
      {
         loop.loop(); 
      }
     lastStateMoving = true;
      
    } else if (moving == false && lastStateMoving == true) // the boats has stopped
    {
      if (loop.isPlaying())
      {
        loop.stop();
      }
      if (stop.isPlaying()==false)
      {
        stop.play();
      }
      println("STOP");
      lastStateMoving = false;
    }
    
    
    
  }
}
