/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import netP5.AbstractTcpServer;
import netP5.Bytes;
import netP5.Logger;
import netP5.NetAddress;
import netP5.NetStatus;
import netP5.TcpClient;
import netP5.TcpPacketListener;

public abstract class AbstractTcpClient
implements Runnable {
    private Socket _mySocket;
    protected TcpPacketListener _myTcpPacketListener;
    private PrintWriter _myOutput = null;
    private BufferedReader _myInput = null;
    private OutputStream _myOutputStream = null;
    protected byte[] _myBytes = new byte[0];
    protected StringBuffer _myStringBuffer = new StringBuffer(0);
    protected AbstractTcpServer _myTcpServer;
    protected NetAddress _myNetAddress;
    protected int _myServerPort;
    private Thread _myThread;
    private char TERMINATOR = '\u0000';
    public static final int MODE_READLINE = 0;
    public static final int MODE_TERMINATED = 1;
    public static final int MODE_NEWLINE = 2;
    public static final int MODE_STREAM = 3;
    private final int _myMode;

    public AbstractTcpClient(TcpPacketListener tcpPacketListener, String string, int n) {
        this(tcpPacketListener, string, n, 0);
    }

    public AbstractTcpClient(String string, int n) {
        this(null, string, n, 0);
    }

    public AbstractTcpClient(TcpPacketListener tcpPacketListener, String string, int n, int n2) {
        this._myTcpPacketListener = tcpPacketListener;
        this._myNetAddress = new NetAddress(string, n);
        this._myMode = n2;
        this.startSocket();
    }

    public AbstractTcpClient(String string, int n, int n2) {
        this(null, string, n, n2);
    }

    public AbstractTcpClient(AbstractTcpServer abstractTcpServer, Socket socket, TcpPacketListener tcpPacketListener, int n, int n2) {
        this._myTcpServer = abstractTcpServer;
        this._mySocket = socket;
        this._myTcpPacketListener = tcpPacketListener;
        this._myServerPort = n;
        this._myMode = n2;
        this.startSocket();
    }

    private void startSocket() {
        try {
            if (this._mySocket == null) {
                this._mySocket = new Socket(this._myNetAddress.address(), this._myNetAddress.port());
            } else {
                this._myNetAddress = new NetAddress(this._mySocket.getInetAddress().getHostAddress(), this._mySocket.getPort());
            }
            Logger.printProcess("TcpClient", "### starting new TcpClient " + this._myNetAddress);
            if (this._myMode == 3) {
                this._myOutputStream = this._mySocket.getOutputStream();
            }
            this.init();
        }
        catch (IOException iOException) {
            Logger.printError("TcpClient", "IOException while trying to create a new socket.");
        }
    }

    public void reconnect() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startSocket();
    }

    private void init() {
        this._myThread = new Thread(this);
        this._myThread.start();
    }

    public void setTerminator(char c) {
        this.TERMINATOR = c;
    }

    public void dispose() {
        try {
            if (this._myInput != null) {
                this._myInput.close();
            }
            if (this._myOutput != null) {
                this._myOutput.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._myInput = null;
        this._myOutput = null;
        try {
            if (this._mySocket != null) {
                this._mySocket.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this._myThread == null) {
            return;
        }
        this._mySocket = null;
        this._myThread = null;
        this.handleStatus(NetStatus.CONNECTION_CLOSED);
        Logger.printProcess("TcpClient.dispose", "TcpClient closed.");
    }

    public void run() {
        if (this._myMode == 3) {
            try {
                int n;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                InputStream inputStream = this._mySocket.getInputStream();
                while (!this._mySocket.isClosed() && this._mySocket != null && (n = Bytes.toIntBigEndian(inputStream)) >= 0) {
                    this._myBytes = Bytes.toByteArray(inputStream, n);
                    this.handleInput();
                }
            }
            catch (SocketException socketException) {
                System.out.println("Connection reset.");
            }
            catch (Exception exception) {
                System.out.println("### EXCEPTION " + exception);
            }
            try {
                this.handleStatus(NetStatus.SERVER_CLOSED);
                this.handleStatus(NetStatus.CONNECTION_TERMINATED);
                this.dispose();
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("### nullpointer while calling handleStatus.");
            }
        } else if (Thread.currentThread() == this._myThread) {
            switch (this._myMode) {
                case 1: {
                    this.read();
                    break;
                }
                default: {
                    this.readline();
                }
            }
        }
        if (this._myTcpServer != null) {
            this._mySocket = null;
            this._myTcpServer.remove(this);
        }
    }

    private void read() {
        try {
            this._myInput = new BufferedReader(new InputStreamReader(this._mySocket.getInputStream()));
            char[] cArray = new char[1];
            while (this._myInput.read(cArray, 0, 1) != -1) {
                this._myStringBuffer = new StringBuffer(4096);
                while (cArray[0] != this.TERMINATOR && cArray[0] != '\u0003') {
                    this._myStringBuffer.append(cArray[0]);
                    this._myInput.read(cArray, 0, 1);
                }
                this._myBytes = this._myStringBuffer.toString().getBytes();
                this.handleInput();
            }
        }
        catch (IOException iOException) {
            Logger.printProcess("TcpClient.read()", "connection has been terminated.");
            if (this._myTcpServer == null) {
                this.handleStatus(NetStatus.SERVER_CLOSED);
            }
            this.handleStatus(NetStatus.CONNECTION_TERMINATED);
        }
    }

    private void readline() {
        block3: {
            try {
                String string;
                this._myOutput = new PrintWriter(this._mySocket.getOutputStream(), true);
                this._myInput = new BufferedReader(new InputStreamReader(this._mySocket.getInputStream()));
                while ((string = this._myInput.readLine()) != null) {
                    this._myStringBuffer = new StringBuffer(string);
                    this._myBytes = this._myStringBuffer.toString().getBytes();
                    this.handleInput();
                }
            }
            catch (IOException iOException) {
                Logger.printProcess("TcpClient.readline()", "connection has been terminated.");
                this.handleStatus(NetStatus.CONNECTION_TERMINATED);
                if (this._myTcpServer != null) break block3;
                this.handleStatus(NetStatus.SERVER_CLOSED);
            }
        }
    }

    public abstract void handleInput();

    public abstract void handleStatus(int var1);

    public TcpPacketListener listener() {
        return this._myTcpPacketListener;
    }

    public int serverport() {
        return this._myServerPort;
    }

    public Socket socket() {
        return this._mySocket;
    }

    public int mode() {
        return this._myMode;
    }

    public String getString() {
        return this._myStringBuffer.toString();
    }

    public StringBuffer getStringBuffer() {
        return this._myStringBuffer;
    }

    public void send(byte[] byArray) {
        if (this._myMode == 3) {
            try {
                Bytes.toStream(this._myOutputStream, byArray);
            }
            catch (Exception exception) {
                this.handleStatus(NetStatus.SEND_FAILED);
            }
        } else {
            System.out.println("### sending bytes is only supported for STREAMs");
        }
    }

    public void send(byte[][] byArray) {
        if (this._myMode == 3) {
            try {
                for (int i = 0; i < byArray.length; ++i) {
                    Bytes.toStream(this._myOutputStream, byArray[i]);
                }
            }
            catch (Exception exception) {
                this.handleStatus(NetStatus.SEND_FAILED);
            }
        } else {
            System.out.println("### sending bytes is only supported for STREAMs");
        }
    }

    public void send(String string) {
        if (this._myMode == 3) {
            this.send(string.getBytes());
        } else {
            switch (this._myMode) {
                case 1: {
                    this._myOutput.write(string + this.TERMINATOR);
                    break;
                }
                case 2: {
                    this._myOutput.write(string + "\n");
                    break;
                }
                default: {
                    this._myOutput.println(string);
                }
            }
            this._myOutput.flush();
        }
    }

    public NetAddress netAddress() {
        return this._myNetAddress;
    }

    public NetAddress netaddress() {
        return this._myNetAddress;
    }

    public boolean equals(NetAddress netAddress) {
        return netAddress.address().equals(this._myNetAddress.address()) && netAddress.port() == this._myNetAddress.port();
    }

    public boolean equals(TcpClient tcpClient) {
        return this.equals(tcpClient.netAddress());
    }
}

