import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import oscP5.*; 
import netP5.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class LDQR_testFab extends PApplet {

/**
 * oscP5oscArgument by andreas schlegel
 * example shows how to parse incoming osc messages "by hand".
 * it is recommended to take a look at oscP5plug for an alternative way to parse messages.
 * oscP5 website at http://www.sojamo.de/oscP5
 */




OscP5 oscP5;
NetAddress myRemoteLocation;

//Hall effect, 1/page
int hallPage1, hallPage2, hallPage3, hallPage4, hallPage5, hallPage6;

//Page 1, planète et whell
int[] page1 = new int[16];

//Page 2, fenetres
int[] page2 = new int[4];

//Page 3, tapis
int[] page3 = new int[4];

//Page4, flaques
int[] page4 = new int[3];

//Page5, iles
int[] page5 = new int[3];

//Page6, ocean
int[] page6 = new int[13];

PFont f;

public void setup() {
  
  frameRate(25);
  /* start oscP5, listening for incoming messages at port 12000 */
  oscP5 = new OscP5(this, 12000);
  /* send an OSC message to this sketch */
  hallPage1 = 3;
  hallPage2 = 3;
  hallPage3 = 3;
  hallPage4 = 3;
  hallPage5 = 3;
  hallPage6 = 3;

  f = createFont("SourceCodePro-Regular.ttf", 12);
  textFont(f);
}

public void draw() {
  //println(hallPage2);
  background(0);
  stroke(255);
  fill(fillHall(hallPage1));
  rect(20, 20, 10, 10);
  fill(fillHall(hallPage2));
  rect(40, 20, 10, 10);
  fill(fillHall(hallPage3));
  rect(60, 20, 10, 10);
  fill(fillHall(hallPage4));
  rect(80, 20, 10, 10);
  fill(fillHall(hallPage5));
  rect(100, 20, 10, 10);
  fill(fillHall(hallPage6));
  rect(120, 20, 10, 10);
  fill(255);
  text("Capteurs effet hall", 140, 30);

  //Page 1
  String sensorsPage1 = "";
  for (int i =0; i<page1.length; i++)
  {
    sensorsPage1 += page1[i];
    sensorsPage1 += " ";
  }
  text("Page 1: "+sensorsPage1, 20, 60);

  //Page 2
  String sensorsPage2 = "";
  for (int i =0; i<page2.length; i++)
  {
    sensorsPage2 += page2[i];
    sensorsPage2 += " ";
  }
  text("Page 2: "+sensorsPage2, 20, 90);

  //Page 3
  String sensorsPage3 = "";
  for (int i =0; i<page3.length; i++)
  {
    sensorsPage3 += page3[i];
    sensorsPage3 += " ";
  }
  text("Page 3: "+sensorsPage3, 20, 120);

  //Page 4
  String sensorsPage4 = "";
  for (int i =0; i<page4.length; i++)
  {
    sensorsPage4 += page4[i];
    sensorsPage4 += " ";
  }
  text("Page 4: "+sensorsPage4, 20, 150);

  //Page 5
  String sensorsPage5 = "";
  for (int i =0; i<page5.length; i++)
  {
    sensorsPage5 += page5[i];
    sensorsPage5 += " ";
  }
  text("Page 5: "+sensorsPage5, 20, 180);

  //Page 6
  String sensorsPage6 = "";
  for (int i =0; i<page6.length; i++)
  {
    sensorsPage6 += page6[i];
    sensorsPage6 += " ";
  }
  text("Page 6: "+sensorsPage6, 20, 210);
}

public int fillHall(int hallState) {
  int theColor = 0;
  switch (hallState)
  {
  case 0:
    theColor = 255;
    break;

  case 1:
    theColor = 125;
    break;

  default:
    theColor = 0;
    break;
  }
  return theColor;
}


public void oscEvent(OscMessage theOscMessage) {
  println(theOscMessage);
  if (theOscMessage.checkAddrPattern("/page1")==true) {
    hallPage1 = theOscMessage.get(0).intValue();  // get the first osc argument
    for (int i =0; i<page1.length; i++)
    {
      page1[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page2")==true) {
    for (int i =0; i<page2.length; i++)
    {
      page2[i] = theOscMessage.get(i+1).intValue();
    }
    hallPage2 = theOscMessage.get(0).intValue();  // get the first osc argument
    return;
  } else if (theOscMessage.checkAddrPattern("/page3")==true) {
    hallPage3 = theOscMessage.get(0).intValue();  // get the first osc argument
    for (int i =0; i<page3.length; i++)
    {
      page3[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page4")==true) {
    hallPage4 = theOscMessage.get(0).intValue();  // get the first osc argument
    for (int i =0; i<page4.length; i++)
    {
      page4[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page5")==true) {
    hallPage5 = theOscMessage.get(0).intValue();  // get the first osc argument
    for (int i =0; i<page5.length; i++)
    {
      page5[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  } else if (theOscMessage.checkAddrPattern("/page6")==true) {
    hallPage6 = theOscMessage.get(0).intValue();  // get the first osc argument
    for (int i =0; i<page6.length; i++)
    {
      page6[i] = theOscMessage.get(i+1).intValue();
    }
    return;
  }
}
  public void settings() {  size(600, 250); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--present", "--window-color=#000000", "--stop-color=#cccccc", "LDQR_testFab" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
